/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.memory.ISynchronizedMemoryBlockView;
import org.eclipse.swt.widgets.Display;

public class SynchronizeInfo {
    private Hashtable fPropertyListeners;
    private IMemoryBlock fBlock;
    private Hashtable fProperties;

    public SynchronizeInfo(IMemoryBlock block) {
        this.fBlock = block;
        this.fProperties = new Hashtable();
        this.fPropertyListeners = new Hashtable();
    }

    public void addSynchronizedView(ISynchronizedMemoryBlockView view, String[] propertyIds) {
        PropertyListener listener = new PropertyListener(view, propertyIds);
        if (!this.fPropertyListeners.contains(listener)) {
            this.fPropertyListeners.put(view, listener);
        }
    }

    public void removeSynchronizedView(ISynchronizedMemoryBlockView view) {
        if (this.fPropertyListeners.containsKey(view)) {
            this.fPropertyListeners.remove(view);
        }
    }

    public void setProperty(String propertyId, Object value) {
        if (propertyId == null) {
            return;
        }
        if (value == null) {
            return;
        }
        this.fProperties.put(propertyId, value);
    }

    public Object getProperty(String propertyId) {
        if (propertyId == null) {
            return null;
        }
        Object value = this.fProperties.get(propertyId);
        return value;
    }

    public void firePropertyChanged(final String propertyId) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (propertyId == null) {
                    return;
                }
                Object value = SynchronizeInfo.this.fProperties.get(propertyId);
                if (value != null) {
                    Enumeration enumeration = SynchronizeInfo.this.fPropertyListeners.elements();
                    while (enumeration.hasMoreElements()) {
                        PropertyListener listener = (PropertyListener)enumeration.nextElement();
                        ISynchronizedMemoryBlockView view = listener.getView();
                        if (!view.isEnabled() || !listener.isValidProperty(propertyId)) continue;
                        PropertyChangeNotifier notifier = new PropertyChangeNotifier(view, propertyId, value);
                        Platform.run((ISafeRunnable)notifier);
                    }
                }
            }
        });
    }

    public int getNumberOfSynchronizedViews() {
        if (this.fPropertyListeners == null) {
            return 0;
        }
        return this.fPropertyListeners.size();
    }

    public void setPropertyFilters(ISynchronizedMemoryBlockView view, String[] filters) {
        PropertyListener listener = (PropertyListener)this.fPropertyListeners.get(view);
        if (listener != null) {
            listener.setPropertyFilters(filters);
        }
    }

    public void delete() {
        if (this.fPropertyListeners != null) {
            this.fPropertyListeners.clear();
            this.fPropertyListeners = null;
        }
        if (this.fProperties != null) {
            this.fProperties.clear();
            this.fProperties = null;
        }
        if (this.fBlock != null) {
            this.fBlock = null;
        }
    }

    class PropertyChangeNotifier
    implements ISafeRunnable {
        ISynchronizedMemoryBlockView fView;
        String fPropertyId;
        Object fValue;

        PropertyChangeNotifier(ISynchronizedMemoryBlockView view, String propertyId, Object value) {
            this.fView = view;
            this.fPropertyId = propertyId;
            this.fValue = value;
        }

        public void handleException(Throwable exception) {
            DebugUIPlugin.log(exception);
        }

        public void run() throws Exception {
            this.fView.propertyChanged(this.fPropertyId, this.fValue);
        }
    }

    class PropertyListener {
        ISynchronizedMemoryBlockView fView;
        String[] fFilters;

        public PropertyListener(ISynchronizedMemoryBlockView view, String[] properties) {
            this.fView = view;
            if (properties != null) {
                this.fFilters = properties;
            }
        }

        public boolean isValidProperty(String property) {
            if (this.fFilters == null) {
                return true;
            }
            int i = 0;
            while (i < this.fFilters.length) {
                if (this.fFilters[i].equals(property)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public void setPropertyFilters(String[] filters) {
            this.fFilters = filters;
        }

        public ISynchronizedMemoryBlockView getView() {
            return this.fView;
        }
    }
}

