/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import java.util.ArrayList;
import org.eclipse.debug.internal.core.memory.MemoryByte;
import org.eclipse.debug.internal.ui.views.memory.HexRenderer;

public class MemoryViewLine {
    private String fAddress;
    private String fStrRep;
    private MemoryByte[] fBytes;
    private byte[] fByteArray;
    private int fTableIndex = -1;
    private String fPaddedString;
    public boolean isMonitored;
    public static final String P_ADDRESS = "address";
    private static final int numCharPerByteForHex = 2;

    public MemoryViewLine(String address, MemoryByte[] bytes, int tableIndex, String paddedString) {
        this.fAddress = address;
        this.fBytes = bytes;
        this.fTableIndex = tableIndex;
        this.fPaddedString = paddedString;
    }

    public String getAddress() {
        return this.fAddress;
    }

    public void setAddress(String address) {
        this.fAddress = address;
    }

    public MemoryByte[] getBytes() {
        return this.fBytes;
    }

    public MemoryByte getByte(int offset) {
        if (this.fBytes == null) {
            return null;
        }
        if (offset < this.fBytes.length) {
            return this.fBytes[offset];
        }
        return null;
    }

    public MemoryByte[] getBytes(int start, int end) {
        ArrayList<MemoryByte> ret = new ArrayList<MemoryByte>();
        int i = start;
        while (i < end) {
            ret.add(this.fBytes[i]);
            ++i;
        }
        return ret.toArray(new MemoryByte[ret.size()]);
    }

    public String getRawMemoryString() {
        if (this.fStrRep == null) {
            StringBuffer buffer = new StringBuffer();
            this.fStrRep = HexRenderer.convertByteArrayToHexString(this.getByteArray());
            this.fStrRep = this.fStrRep.toUpperCase();
            buffer = buffer.append(this.fStrRep);
            String paddedString = null;
            int bufferCounter = 0;
            int i = 0;
            while (i < this.fBytes.length) {
                if ((this.fBytes[i].flags & 2) != 2) {
                    if (paddedString == null && (paddedString = this.fPaddedString).length() > 2) {
                        paddedString = paddedString.substring(0, 2);
                    }
                    buffer.replace(bufferCounter, bufferCounter + 2, paddedString);
                    bufferCounter += 2;
                }
                ++i;
            }
            this.fStrRep = buffer.toString();
        }
        return this.fStrRep;
    }

    public String getPaddedString(int start, int end) {
        StringBuffer buf = new StringBuffer();
        int i = start;
        while (i < end) {
            buf.append(this.fPaddedString);
            ++i;
        }
        return buf.toString();
    }

    public String getPaddedString() {
        return this.fPaddedString;
    }

    public boolean isAvailable(int start, int end) {
        boolean available = true;
        int i = start;
        while (i < end) {
            if ((this.fBytes[i].flags & 2) != 2) {
                available = false;
                break;
            }
            ++i;
        }
        return available;
    }

    public byte[] getByteArray() {
        if (this.fByteArray == null) {
            this.fByteArray = new byte[this.fBytes.length];
            int i = 0;
            while (i < this.fBytes.length) {
                this.fByteArray[i] = this.fBytes[i].value;
                ++i;
            }
        }
        return this.fByteArray;
    }

    public byte[] getByteArray(int start, int end) {
        byte[] ret = new byte[end - start];
        int j = 0;
        int i = start;
        while (i < end) {
            ret[j] = this.fBytes[i].value;
            ++j;
            ++i;
        }
        return ret;
    }

    public void markDeltas(MemoryViewLine oldData) {
        if (oldData == null) {
            return;
        }
        if (!oldData.getAddress().equals(this.getAddress())) {
            return;
        }
        if (oldData.getRawMemoryString().equals(this.getRawMemoryString())) {
            return;
        }
        MemoryByte[] oldMemory = oldData.getBytes();
        if (oldMemory.length != this.fBytes.length) {
            return;
        }
        int i = 0;
        while (i < this.fBytes.length) {
            if ((this.fBytes[i].flags & 2) != (oldMemory[i].flags & 2)) {
                this.fBytes[i].flags = (byte)(this.fBytes[i].flags | 4);
            } else if ((this.fBytes[i].flags & 2) == 2 && (oldMemory[i].flags & 2) == 2 && this.fBytes[i].value != oldMemory[i].value) {
                this.fBytes[i].flags = (byte)(this.fBytes[i].flags | 4);
            }
            ++i;
        }
    }

    public void copyDeltas(MemoryViewLine oldData) {
        if (oldData == null) {
            return;
        }
        if (!oldData.getAddress().equals(this.getAddress())) {
            return;
        }
        MemoryByte[] oldMemory = oldData.getBytes();
        if (oldMemory.length != this.fBytes.length) {
            return;
        }
        int i = 0;
        while (i < this.fBytes.length) {
            this.fBytes[i].flags = oldMemory[i].flags;
            ++i;
        }
    }

    public boolean isLineChanged(MemoryViewLine oldData) {
        if (oldData == null) {
            return false;
        }
        if (!oldData.getAddress().equals(this.getAddress())) {
            return false;
        }
        return !oldData.getRawMemoryString().equals(this.getRawMemoryString());
    }

    public boolean isRangeChange(int offset, int endOffset) {
        byte ret = this.fBytes[offset].flags;
        int i = offset;
        while (i <= endOffset) {
            ret = (byte)(ret | this.fBytes[i].flags);
            ++i;
        }
        return (ret & 4) == 4;
    }

    public void unmarkDeltas() {
        int i = 0;
        while (i < this.fBytes.length) {
            if ((this.fBytes[i].flags & 4) == 4) {
                this.fBytes[i].flags = (byte)(this.fBytes[i].flags ^ 4);
            }
            ++i;
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getAddress());
        buf.append(": ");
        buf.append(this.getRawMemoryString());
        return buf.toString();
    }

    public int getTableIndex() {
        return this.fTableIndex;
    }
}

