/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.preferences;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.debug.internal.ui.IInternalDebugUIConstants;
import org.eclipse.debug.internal.ui.SWTUtil;
import org.eclipse.debug.internal.ui.preferences.DebugPreferencesMessages;
import org.eclipse.debug.internal.ui.views.launch.LaunchViewContextListener;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class ViewManagementPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private CheckboxTableViewer fPerspectiveViewer;
    private Button fTrackViewsButton;
    private Button fResetViewsButton;
    private boolean fResetPressed = false;

    public ViewManagementPreferencePage() {
        this.setTitle(DebugPreferencesMessages.getString("ViewManagementPreferencePage.1"));
        this.setDescription(DebugPreferencesMessages.getString("ViewManagementPreferencePage.0"));
        this.setPreferenceStore(DebugUITools.getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        this.createPerspectiveViewer(composite);
        this.createViewTrackingOptions(composite);
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void createViewTrackingOptions(Composite composite) {
        this.fTrackViewsButton = new Button(composite, 32);
        this.fTrackViewsButton.setLayoutData((Object)new GridData(768));
        this.fTrackViewsButton.setText(DebugPreferencesMessages.getString("ViewManagementPreferencePage.3"));
        this.fTrackViewsButton.setSelection(DebugUITools.getPreferenceStore().getBoolean(IInternalDebugUIConstants.PREF_TRACK_VIEWS));
        Label label = new Label(composite, 64);
        label.setText(DebugPreferencesMessages.getString("ViewManagementPreferencePage.4"));
        label.setLayoutData((Object)new GridData(768));
        this.fResetViewsButton = SWTUtil.createPushButton(composite, DebugPreferencesMessages.getString("ViewManagementPreferencePage.5"), null);
        ((GridData)this.fResetViewsButton.getLayoutData()).horizontalAlignment = 1;
        this.fResetViewsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ViewManagementPreferencePage.this.fResetPressed = true;
                ViewManagementPreferencePage.this.fResetViewsButton.setEnabled(false);
            }
        });
        this.updateResetButton();
    }

    private void createPerspectiveViewer(Composite parent) {
        Label label = new Label(parent, 64);
        label.setText(DebugPreferencesMessages.getString("ViewManagementPreferencePage.2"));
        label.setLayoutData((Object)new GridData(768));
        Table table = new Table(parent, 67618);
        table.setLayout((Layout)new GridLayout());
        table.setLayoutData((Object)new GridData(1808));
        this.fPerspectiveViewer = new CheckboxTableViewer(table);
        PerspectiveProvider provider = new PerspectiveProvider();
        this.fPerspectiveViewer.setContentProvider((IContentProvider)provider);
        this.fPerspectiveViewer.setLabelProvider((IBaseLabelProvider)provider);
        this.fPerspectiveViewer.setInput((Object)this);
        this.checkPerspectives(this.getPreferenceStore().getString(IDebugUIConstants.PREF_MANAGE_VIEW_PERSPECTIVES));
    }

    private void checkPerspectives(String perspectiveList) {
        this.fPerspectiveViewer.setAllChecked(false);
        IPerspectiveRegistry registry = PlatformUI.getWorkbench().getPerspectiveRegistry();
        Iterator perspectiveIds = LaunchViewContextListener.parseList(perspectiveList).iterator();
        while (perspectiveIds.hasNext()) {
            IPerspectiveDescriptor descriptor = registry.findPerspectiveWithId((String)perspectiveIds.next());
            this.fPerspectiveViewer.setChecked((Object)descriptor, true);
        }
    }

    public boolean performOk() {
        StringBuffer buffer = new StringBuffer();
        Object[] descriptors = this.fPerspectiveViewer.getCheckedElements();
        int i = 0;
        while (i < descriptors.length) {
            buffer.append(((IPerspectiveDescriptor)descriptors[i]).getId()).append(',');
            ++i;
        }
        this.getPreferenceStore().setValue(IDebugUIConstants.PREF_MANAGE_VIEW_PERSPECTIVES, buffer.toString());
        this.getPreferenceStore().setValue(IInternalDebugUIConstants.PREF_TRACK_VIEWS, this.fTrackViewsButton.getSelection());
        if (this.fResetPressed) {
            this.getPreferenceStore().setValue(LaunchViewContextListener.PREF_VIEWS_TO_NOT_OPEN, "");
            this.getPreferenceStore().setValue(LaunchViewContextListener.PREF_OPENED_VIEWS, "");
        }
        return super.performOk();
    }

    protected void performDefaults() {
        this.checkPerspectives(this.getPreferenceStore().getDefaultString(IDebugUIConstants.PREF_MANAGE_VIEW_PERSPECTIVES));
        this.fTrackViewsButton.setSelection(this.getPreferenceStore().getDefaultBoolean(IInternalDebugUIConstants.PREF_TRACK_VIEWS));
        this.fResetPressed = false;
        this.updateResetButton();
        super.performDefaults();
    }

    public void init(IWorkbench workbench) {
    }

    private void updateResetButton() {
        boolean enableReset = !"".equals(this.getPreferenceStore().getString(LaunchViewContextListener.PREF_VIEWS_TO_NOT_OPEN)) || !"".equals(this.getPreferenceStore().getString(LaunchViewContextListener.PREF_OPENED_VIEWS));
        this.fResetViewsButton.setEnabled(enableReset);
    }

    private class PerspectiveProvider
    implements IStructuredContentProvider,
    ILabelProvider {
        private List fImages = new ArrayList();

        PerspectiveProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return PlatformUI.getWorkbench().getPerspectiveRegistry().getPerspectives();
        }

        public void dispose() {
            Iterator images = this.fImages.iterator();
            while (images.hasNext()) {
                ((Image)images.next()).dispose();
            }
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Image getImage(Object element) {
            Image image = null;
            if (element instanceof IPerspectiveDescriptor) {
                image = ((IPerspectiveDescriptor)element).getImageDescriptor().createImage();
                this.fImages.add(image);
            }
            return image;
        }

        public String getText(Object element) {
            String text = null;
            if (element instanceof IPerspectiveDescriptor) {
                IPerspectiveDescriptor descriptor = (IPerspectiveDescriptor)element;
                text = descriptor.getLabel();
            }
            return text;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

