/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.AbstractListenerActionDelegate;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchWindow;

public class TerminateAllAction
extends AbstractListenerActionDelegate {
    protected void doAction(Object element) {
    }

    protected void update() {
        ILaunchManager lManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunch[] launches = lManager.getLaunches();
        int i = 0;
        while (i < launches.length) {
            ILaunch launch = launches[i];
            if (!launch.isTerminated()) {
                this.getAction().setEnabled(true);
                return;
            }
            ++i;
        }
        this.getAction().setEnabled(false);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.setAction(action);
    }

    public void run(IAction action) {
        ILaunchManager lManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunch[] launches = lManager.getLaunches();
        MultiStatus ms = new MultiStatus(DebugPlugin.getUniqueIdentifier(), 5012, ActionMessages.getString("TerminateAllAction.Terminate_all_failed_3"), null);
        int i = 0;
        while (i < launches.length) {
            ILaunch launch = launches[i];
            if (!launch.isTerminated()) {
                try {
                    launch.terminate();
                }
                catch (DebugException de) {
                    ms.merge(de.getStatus());
                }
            }
            ++i;
        }
        if (!ms.isOK()) {
            IWorkbenchWindow window = DebugUIPlugin.getActiveWorkbenchWindow();
            if (window != null) {
                DebugUIPlugin.errorDialog(window.getShell(), ActionMessages.getString("TerminateAllAction.Terminate_All_2"), ActionMessages.getString("TerminateAllAction.Exceptions_occurred_attempting_to_terminate_all._5"), (IStatus)ms);
            } else {
                DebugUIPlugin.log((IStatus)ms);
            }
        }
    }

    protected void doHandleDebugEvent(DebugEvent event) {
        switch (event.getKind()) {
            case 8: {
                this.update();
                break;
            }
            case 4: {
                this.update();
            }
        }
    }
}

