/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.subscriber;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Commit;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.operations.AddOperation;
import org.eclipse.team.internal.ccvs.ui.operations.CommitOperation;
import org.eclipse.team.internal.ccvs.ui.repo.RepositoryManager;
import org.eclipse.team.internal.ccvs.ui.subscriber.CVSSubscriberOperation;
import org.eclipse.team.internal.ccvs.ui.sync.ToolTipMessageDialog;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public class WorkspaceCommitOperation
extends CVSSubscriberOperation {
    private String comment;
    private SyncInfoSet syncSet;
    private boolean override;

    public WorkspaceCommitOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements, boolean override) {
        super(configuration, elements);
        this.override = override;
    }

    protected String getErrorTitle() {
        return Policy.bind("CommitAction.commitFailed");
    }

    protected String getJobName() {
        SyncInfoSet syncSet = this.getSyncInfoSet();
        return Policy.bind("CommitAction.jobName", new Integer(syncSet.size()).toString());
    }

    public boolean shouldRun() {
        SyncInfoSet set = this.getSyncInfoSet();
        return !set.isEmpty();
    }

    protected SyncInfoSet getSyncInfoSet() {
        if (this.syncSet == null) {
            this.syncSet = super.getSyncInfoSet();
            if (!this.promptForConflictHandling(this.syncSet)) {
                this.syncSet.clear();
                return this.syncSet;
            }
            try {
                if (!this.promptForUnaddedHandling(this.syncSet)) {
                    this.syncSet.clear();
                    return this.syncSet;
                }
            }
            catch (CVSException e) {
                Utils.handle((Throwable)e);
                this.syncSet.clear();
            }
        }
        return this.syncSet;
    }

    protected boolean promptForConflictHandling(SyncInfoSet syncSet) {
        block4: {
            block5: {
                if (!syncSet.hasConflicts() && !syncSet.hasIncomingChanges()) break block4;
                if (!this.override) break block5;
                switch (this.promptForConflicts(syncSet)) {
                    case 0: {
                        break block4;
                    }
                    case 1: {
                        return false;
                    }
                    default: {
                        return false;
                    }
                }
            }
            syncSet.removeConflictingNodes();
            syncSet.removeIncomingNodes();
        }
        return true;
    }

    public void run(SyncInfoSet syncSet, IProgressMonitor monitor) throws TeamException {
        SyncInfo[] changed = syncSet.getSyncInfos();
        if (changed.length == 0) {
            return;
        }
        ArrayList<IResource> commits = new ArrayList<IResource>();
        ArrayList<IResource> additions = new ArrayList<IResource>();
        ArrayList<SyncInfo> makeOutgoing = new ArrayList<SyncInfo>();
        ArrayList<SyncInfo> makeInSync = new ArrayList<SyncInfo>();
        int i = 0;
        while (i < changed.length) {
            SyncInfo changedNode = changed[i];
            int kind = changedNode.getKind();
            IResource resource = changedNode.getLocal();
            SyncInfo parent = this.getParent(changedNode);
            if (parent != null && this.isOutOfSync(parent)) {
                makeInSync.add(parent);
            }
            if (resource.getType() == 1) {
                commits.add(resource);
                block0 : switch (kind & 0xC) {
                    case 8: {
                        makeOutgoing.add(changedNode);
                        break;
                    }
                    case 4: {
                        switch (kind & 3) {
                            case 1: {
                                if (this.isAdded(resource)) break;
                                additions.add(resource);
                                break block0;
                            }
                            case 2: {
                                break block0;
                            }
                        }
                        break;
                    }
                    case 12: {
                        makeOutgoing.add(changedNode);
                    }
                }
            } else if ((kind & 0xC) == 4 && (kind & 3) == 1) {
                additions.add(changedNode.getLocal());
            } else if (this.isOutOfSync(changedNode)) {
                makeInSync.add(changedNode);
            }
            ++i;
        }
        monitor.beginTask(null, 200);
        if (makeInSync.size() > 0) {
            this.makeInSync(makeInSync.toArray(new SyncInfo[makeInSync.size()]), Policy.subMonitorFor(monitor, 25));
        }
        if (makeOutgoing.size() > 0) {
            this.makeOutgoing(makeOutgoing.toArray(new SyncInfo[makeInSync.size()]), Policy.subMonitorFor(monitor, 25));
        }
        if (additions.size() != 0) {
            this.add(additions.toArray(new IResource[0]), Policy.subMonitorFor(monitor, 50));
        }
        this.commit(commits.toArray(new IResource[commits.size()]), Policy.subMonitorFor(monitor, 100));
    }

    private void commit(IResource[] commits, IProgressMonitor monitor) throws TeamException {
        try {
            new CommitOperation(this.getPart(), commits, new Command.LocalOption[]{Commit.makeArgumentOption((Command.LocalOption)Command.MESSAGE_OPTION, (String)this.comment)}).run(monitor);
        }
        catch (InvocationTargetException e) {
            throw TeamException.asTeamException((InvocationTargetException)e);
        }
        catch (InterruptedException interruptedException) {
            throw new OperationCanceledException();
        }
    }

    private void add(IResource[] additions, IProgressMonitor monitor) throws TeamException {
        try {
            new AddOperation(this.getPart(), additions).run(monitor);
        }
        catch (InvocationTargetException e1) {
            throw TeamException.asTeamException((InvocationTargetException)e1);
        }
        catch (InterruptedException interruptedException) {
            throw new OperationCanceledException();
        }
    }

    protected int promptForConflicts(SyncInfoSet syncSet) {
        String[] buttons = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
        String question = Policy.bind("CommitSyncAction.questionRelease");
        String title = Policy.bind("CommitSyncAction.titleRelease");
        String[] tips = new String[]{Policy.bind("CommitSyncAction.releaseAll"), Policy.bind("CommitSyncAction.releasePart"), Policy.bind("CommitSyncAction.cancelRelease")};
        Shell shell = this.getShell();
        final ToolTipMessageDialog dialog = new ToolTipMessageDialog(shell, title, null, question, 3, buttons, tips, 0);
        shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                dialog.open();
            }
        });
        return dialog.getReturnCode();
    }

    protected String promptForComment(RepositoryManager manager, IResource[] resourcesToCommit) {
        return manager.promptForComment(this.getShell(), resourcesToCommit);
    }

    protected IResource[] promptForResourcesToBeAdded(RepositoryManager manager, IResource[] unadded) {
        return manager.promptForResourcesToBeAdded(this.getShell(), unadded);
    }

    private boolean promptForUnaddedHandling(SyncInfoSet syncSet) throws CVSException {
        if (syncSet.isEmpty()) {
            return false;
        }
        IResource[] unadded = this.getUnaddedResources(syncSet);
        RepositoryManager manager = CVSUIPlugin.getPlugin().getRepositoryManager();
        IResource[] toBeAdded = this.promptForResourcesToBeAdded(manager, unadded);
        if (toBeAdded == null) {
            return false;
        }
        this.comment = this.promptForComment(manager, syncSet.getResources());
        if (this.comment == null) {
            return false;
        }
        if (unadded != null && unadded.length > 0) {
            ArrayList<IResource> resourcesToRemove = new ArrayList<IResource>(unadded.length);
            int i = 0;
            while (i < unadded.length) {
                IResource unaddedResource = unadded[i];
                boolean included = false;
                int j = 0;
                while (j < toBeAdded.length) {
                    IResource resourceToAdd = toBeAdded[j];
                    if (unaddedResource.equals((Object)resourceToAdd)) {
                        included = true;
                        break;
                    }
                    ++j;
                }
                if (!included) {
                    resourcesToRemove.add(unaddedResource);
                }
                ++i;
            }
            syncSet.removeAll(resourcesToRemove.toArray(new IResource[resourcesToRemove.size()]));
        }
        return true;
    }

    private IResource[] getUnaddedResources(SyncInfoSet syncSet) throws CVSException {
        IResource[] resources = syncSet.getResources();
        ArrayList<IResource> result = new ArrayList<IResource>();
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (!this.isAdded(resource)) {
                result.add(resource);
            }
            ++i;
        }
        return result.toArray(new IResource[result.size()]);
    }

    private boolean isAdded(IResource resource) throws CVSException {
        ICVSResource cvsResource = CVSWorkspaceRoot.getCVSResourceFor((IResource)resource);
        if (cvsResource.isFolder()) {
            return ((ICVSFolder)cvsResource).isCVSFolder();
        }
        return cvsResource.isManaged();
    }
}

