/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.repo;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.actions.OpenRemoteFileAction;
import org.eclipse.team.internal.ccvs.ui.model.RemoteContentProvider;
import org.eclipse.team.internal.ccvs.ui.repo.RepositorySorter;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.IWorkingSetEditWizard;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.part.ViewPart;

public abstract class RemoteViewPart
extends ViewPart
implements ISelectionListener {
    protected TreeViewer viewer;
    private DrillDownAdapter drillPart;
    private Action refreshAction;
    private Action collapseAllAction;
    private Action selectWorkingSetAction;
    private Action deselectWorkingSetAction;
    private Action editWorkingSetAction;
    private OpenRemoteFileAction openAction;
    private RemoteContentProvider contentProvider;
    private IDialogSettings settings;
    private static final String SELECTED_WORKING_SET = "SelectedWorkingSet";

    protected RemoteViewPart(String partName) {
        IDialogSettings workbenchSettings = CVSUIPlugin.getPlugin().getDialogSettings();
        this.settings = workbenchSettings.getSection(partName);
        if (this.settings == null) {
            this.settings = workbenchSettings.addNewSection(partName);
        }
        String name = this.settings.get(SELECTED_WORKING_SET);
        IWorkingSet set = null;
        if (name != null) {
            set = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSet(name);
        }
        this.setWorkingSet(set, false);
    }

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 770);
        this.viewer.setContentProvider((IContentProvider)this.getContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.viewer.setInput(this.getTreeInput());
        this.viewer.setSorter((ViewerSorter)new RepositorySorter());
        this.viewer.getControl().addKeyListener((KeyListener)this.getKeyListener());
        this.drillPart = new DrillDownAdapter(this.viewer);
        this.contributeActions();
        this.initializeListeners();
        String helpID = this.getHelpContextId();
        if (helpID != null) {
            WorkbenchHelp.setHelp((Control)this.viewer.getControl(), (String)helpID);
        }
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    protected String getHelpContextId() {
        return null;
    }

    protected abstract Object getTreeInput();

    protected RemoteContentProvider getContentProvider() {
        if (this.contentProvider == null) {
            this.contentProvider = new RemoteContentProvider();
        }
        return this.contentProvider;
    }

    protected KeyAdapter getKeyListener() {
        return new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 0x100000E) {
                    RemoteViewPart.this.refreshAction.run();
                }
            }
        };
    }

    protected void initializeListeners() {
        this.getSite().getWorkbenchWindow().getSelectionService().addPostSelectionListener((ISelectionListener)this);
    }

    protected IWorkingSet getWorkingSet() {
        return this.getContentProvider().getWorkingSet();
    }

    protected void setWorkingSet(IWorkingSet workingSet, boolean refreshViewer) {
        if (this.settings != null) {
            String name = null;
            if (workingSet != null) {
                name = workingSet.getName();
            }
            this.settings.put(SELECTED_WORKING_SET, name);
        }
        this.getContentProvider().setWorkingSet(workingSet);
        String toolTip = workingSet == null ? null : Policy.bind("RemoteViewPart.workingSetToolTip", workingSet.getName());
        this.setTitleToolTip(toolTip);
        if (refreshViewer) {
            this.refreshViewer();
        }
    }

    protected void contributeActions() {
        final Shell shell = this.getShell();
        CVSUIPlugin plugin = CVSUIPlugin.getPlugin();
        this.refreshAction = new Action(Policy.bind("RepositoriesView.refresh"), CVSUIPlugin.getPlugin().getImageDescriptor("elcl16/refresh.gif")){

            public void run() {
                RemoteViewPart.this.refreshAll();
            }
        };
        this.refreshAction.setToolTipText(Policy.bind("RepositoriesView.refreshTooltip"));
        this.refreshAction.setDisabledImageDescriptor(plugin.getImageDescriptor("dlcl16/refresh.gif"));
        this.refreshAction.setHoverImageDescriptor(plugin.getImageDescriptor("elcl16/refresh.gif"));
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)this.refreshAction);
        this.collapseAllAction = new Action(Policy.bind("RepositoriesView.collapseAll"), CVSUIPlugin.getPlugin().getImageDescriptor("elcl16/collapseall.gif")){

            public void run() {
                RemoteViewPart.this.collapseAll();
            }
        };
        this.collapseAllAction.setToolTipText(Policy.bind("RepositoriesView.collapseAllTooltip"));
        this.collapseAllAction.setHoverImageDescriptor(plugin.getImageDescriptor("elcl16/collapseall.gif"));
        this.selectWorkingSetAction = new Action(Policy.bind("RepositoriesView.newWorkingSet")){

            public void run() {
                IWorkingSetManager manager = PlatformUI.getWorkbench().getWorkingSetManager();
                IWorkingSetSelectionDialog dialog = manager.createWorkingSetSelectionDialog(shell, false);
                Object workingSet = null;
                if (workingSet != null) {
                    dialog.setSelection(new IWorkingSet[]{workingSet});
                }
                if (dialog.open() == 0) {
                    IWorkingSet[] result = dialog.getSelection();
                    if (result != null && result.length > 0) {
                        RemoteViewPart.this.setWorkingSet(result[0], true);
                        manager.addRecentWorkingSet(result[0]);
                    } else {
                        RemoteViewPart.this.setWorkingSet(null, true);
                    }
                }
            }
        };
        WorkbenchHelp.setHelp((IAction)this.selectWorkingSetAction, (String)"org.eclipse.team.cvs.ui.select_working_set_action_context");
        this.deselectWorkingSetAction = new Action(Policy.bind("RepositoriesView.deselectWorkingSet")){

            public void run() {
                RemoteViewPart.this.setWorkingSet(null, true);
            }
        };
        WorkbenchHelp.setHelp((IAction)this.deselectWorkingSetAction, (String)"org.eclipse.team.cvs.ui.deselect_working_set_action_context");
        this.editWorkingSetAction = new Action(Policy.bind("RepositoriesView.editWorkingSet")){

            public void run() {
                IWorkingSetManager manager = PlatformUI.getWorkbench().getWorkingSetManager();
                IWorkingSet workingSet = RemoteViewPart.this.getWorkingSet();
                if (workingSet == null) {
                    this.setEnabled(false);
                    return;
                }
                IWorkingSetEditWizard wizard = manager.createWorkingSetEditWizard(workingSet);
                if (wizard == null) {
                    String title = Policy.bind("EditWorkingSetAction.error.nowizard.title");
                    String message = Policy.bind("EditWorkingSetAction.error.nowizard.message");
                    CVSUIPlugin.openError(shell, title, message, null);
                    return;
                }
                WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
                dialog.create();
                if (dialog.open() == 0) {
                    RemoteViewPart.this.setWorkingSet(wizard.getSelection(), true);
                }
            }
        };
        WorkbenchHelp.setHelp((IAction)this.editWorkingSetAction, (String)"org.eclipse.team.cvs.ui.edit_working_set_action_context");
        MenuManager menuMgr = new MenuManager();
        Tree tree = this.viewer.getTree();
        Menu menu = menuMgr.createContextMenu((Control)tree);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                RemoteViewPart.this.addWorkbenchActions(manager);
            }
        });
        menuMgr.setRemoveAllWhenShown(true);
        tree.setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager tbm = bars.getToolBarManager();
        this.drillPart.addNavigationActions(tbm);
        tbm.add((IAction)this.refreshAction);
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)this.collapseAllAction);
        tbm.update(false);
        this.openAction = new OpenRemoteFileAction();
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
                RemoteViewPart.this.handleDoubleClick(e);
            }
        });
        this.updateWorkingSetMenu();
        bars.updateActionBars();
    }

    protected void addWorkbenchActions(IMenuManager manager) {
        manager.add((IContributionItem)new Separator("group.file"));
        manager.add((IContributionItem)new Separator("checkoutGroup"));
        manager.add((IContributionItem)new Separator("tagGroup"));
        manager.add((IContributionItem)new Separator("miscGroup"));
        manager.add((IContributionItem)new Separator("additions"));
        manager.add((IAction)this.refreshAction);
    }

    protected Shell getShell() {
        return this.viewer.getTree().getShell();
    }

    public void updateWorkingSetMenu() {
        IActionBars bars = this.getViewSite().getActionBars();
        IMenuManager mgr = bars.getMenuManager();
        mgr.removeAll();
        mgr.add((IAction)this.selectWorkingSetAction);
        mgr.add((IAction)this.deselectWorkingSetAction);
        this.deselectWorkingSetAction.setEnabled(this.getWorkingSet() != null);
        mgr.add((IAction)this.editWorkingSetAction);
        this.editWorkingSetAction.setEnabled(this.getWorkingSet() != null);
        mgr.add((IContributionItem)new Separator());
        IWorkingSetManager manager = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSet[] workingSets = manager.getWorkingSets();
        int i = 0;
        while (i < workingSets.length) {
            String name = workingSets[i].getName();
            ChangeWorkingSetAction action = new ChangeWorkingSetAction(name, i + 1);
            mgr.add((IAction)action);
            action.setChecked(this.getWorkingSet() != null && this.getWorkingSet().getName().equals(name));
            ++i;
        }
        bars.updateActionBars();
    }

    protected void refreshAll() {
        this.refreshViewer();
    }

    protected void refreshViewer() {
        if (this.viewer == null) {
            return;
        }
        ((RemoteContentProvider)this.viewer.getContentProvider()).cancelJobs(CVSUIPlugin.getPlugin().getRepositoryManager().getKnownRepositoryRoots());
        CVSUIPlugin.getPlugin().getRepositoryManager().purgeCache();
        this.updateWorkingSetMenu();
        this.viewer.refresh();
    }

    public void collapseAll() {
        if (this.viewer == null) {
            return;
        }
        this.viewer.getControl().setRedraw(false);
        this.viewer.collapseToLevel(this.viewer.getInput(), -1);
        this.viewer.getControl().setRedraw(true);
    }

    private void handleDoubleClick(DoubleClickEvent e) {
        IStructuredSelection structured;
        ISelection selection = e.getSelection();
        if (selection instanceof IStructuredSelection && (structured = (IStructuredSelection)selection).size() == 1) {
            Object first = structured.getFirstElement();
            if (first instanceof ICVSRemoteFile) {
                this.openAction.selectionChanged(null, selection);
                this.openAction.run(null);
            } else {
                this.viewer.setExpandedState(first, !this.viewer.getExpandedState(first));
            }
        }
    }

    protected TreeViewer getViewer() {
        return this.viewer;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
    }

    public void dispose() {
        this.getSite().getWorkbenchWindow().getSelectionService().removePostSelectionListener((ISelectionListener)this);
        super.dispose();
        this.viewer = null;
    }

    private class ChangeWorkingSetAction
    extends Action {
        String name;

        public ChangeWorkingSetAction(String name, int index) {
            super(Policy.bind("RepositoriesView.workingSetMenuItem", new Integer(index).toString(), name));
            this.name = name;
        }

        public void run() {
            IWorkingSetManager manager = PlatformUI.getWorkbench().getWorkingSetManager();
            RemoteViewPart.this.setWorkingSet(manager.getWorkingSet(this.name), true);
        }
    }
}

