/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.ProjectSetSerializationContext;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.dialogs.IPromptCondition;
import org.eclipse.team.internal.ui.dialogs.PromptingDialog;

public class UIProjectSetSerializationContext
extends ProjectSetSerializationContext {
    private final Shell shell;

    public UIProjectSetSerializationContext(Shell shell, String filename) {
        super(filename);
        Assert.isNotNull((Object)shell);
        this.shell = shell;
    }

    public Object getShell() {
        return this.shell;
    }

    public IProject[] confirmOverwrite(IProject[] projects) throws TeamException {
        IResource[] resourcesToOverwrite;
        IPromptCondition prompt = new IPromptCondition(projects){
            List resources;
            {
                this.resources = Arrays.asList(iProjectArray);
            }

            public boolean needsPrompt(IResource resource) {
                return this.resources.contains(resource);
            }

            public String promptMessage(IResource resource) {
                return Policy.bind("UIProjectSetSerializationContext.0", resource.getName());
            }
        };
        PromptingDialog dialog = new PromptingDialog((Shell)this.getShell(), (IResource[])projects, prompt, Policy.bind("UIProjectSetSerializationContext.1"));
        try {
            resourcesToOverwrite = dialog.promptForMultiple();
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        IProject[] projectsToOverwrite = new IProject[resourcesToOverwrite.length];
        System.arraycopy(resourcesToOverwrite, 0, projectsToOverwrite, 0, resourcesToOverwrite.length);
        return projectsToOverwrite;
    }
}

