/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui;

import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.TeamAdapterFactory;
import org.eclipse.team.internal.ui.TeamCapabilityHelper;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.synchronize.SynchronizeManager;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class TeamUIPlugin
extends AbstractUIPlugin {
    private static TeamUIPlugin instance;
    public static final String ICON_PATH = "icons/full/";
    public static final String ID = "org.eclipse.team.ui";
    public static final String PLUGIN_ID = "org.eclipse.team.ui";
    private static List propertyChangeListeners;
    private Hashtable imageDescriptors = new Hashtable(20);
    static /* synthetic */ Class class$0;

    static {
        propertyChangeListeners = new ArrayList(5);
    }

    public TeamUIPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        this.initializeImages(this);
        this.initializePreferences();
        instance = this;
    }

    public static Object createExtension(final IConfigurationElement element, final String classAttribute) throws CoreException {
        IPluginDescriptor plugin = element.getDeclaringExtension().getDeclaringPluginDescriptor();
        if (plugin.isPluginActivated()) {
            return element.createExecutableExtension(classAttribute);
        }
        final Object[] ret = new Object[1];
        final CoreException[] exc = new CoreException[1];
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            public void run() {
                try {
                    ret[0] = element.createExecutableExtension(classAttribute);
                }
                catch (CoreException e) {
                    exc[0] = e;
                }
            }
        });
        if (exc[0] != null) {
            throw exc[0];
        }
        return ret[0];
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow window = TeamUIPlugin.getPlugin().getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return window.getActivePage();
    }

    public static TeamUIPlugin getPlugin() {
        return instance;
    }

    protected void initializePreferences() {
        IPreferenceStore store = this.getPreferenceStore();
        store.setDefault("org.eclipse.team.ui.view_syncinfo_in_label", false);
        store.setDefault("org.eclipse.team.ui.compress_folders", true);
        store.setDefault("org.eclipse.team.ui.syncview_default_perspective", "org.eclipse.team.ui.TeamSynchronizingPerspective");
        store.setDefault("org.eclipse.team.ui.sychronizing_default_participant", "none");
        store.setDefault("org.eclipse.team.ui.sychronizing_default_participant_sec_id", "none");
        store.setDefault("org.eclipse.team.ui.sychronizing_default_perspective_to_show", "prompt");
        store.setDefault("org.eclipse.team.ui.remove_from_view_without_prompt", false);
        store.setDefault("org.eclipse.team.ui.first_time", true);
    }

    public static void log(IStatus status) {
        TeamUIPlugin.getPlugin().getLog().log(status);
    }

    public static void log(CoreException e) {
        IStatus status = e.getStatus();
        TeamUIPlugin.log(status.getSeverity(), status.getMessage(), e);
    }

    public static void log(int severity, String message, Throwable e) {
        TeamUIPlugin.log((IStatus)new Status(severity, "org.eclipse.team.ui", 0, message, e));
    }

    public void startup() throws CoreException {
        Policy.localize("org.eclipse.team.internal.ui.messages");
        this.initializePreferences();
        TeamAdapterFactory factory = new TeamAdapterFactory();
        IAdapterManager iAdapterManager = Platform.getAdapterManager();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.compare.structuremergeviewer.DiffNode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        iAdapterManager.registerAdapters((IAdapterFactory)factory, (Class)clazz);
        IPreferenceStore store = this.getPreferenceStore();
        if (store.getBoolean("org.eclipse.team.ui.first_time")) {
            Job capabilityInitializer = new Job(""){

                protected IStatus run(IProgressMonitor monitor) {
                    TeamCapabilityHelper.getInstance();
                    TeamUIPlugin.this.getPreferenceStore().setValue("org.eclipse.team.ui.first_time", false);
                    return Status.OK_STATUS;
                }
            };
            capabilityInitializer.setSystem(true);
            capabilityInitializer.setPriority(50);
            capabilityInitializer.schedule(1000L);
        }
    }

    public void shutdown() throws CoreException {
        super.shutdown();
        ((SynchronizeManager)TeamUI.getSynchronizeManager()).dispose();
    }

    public static void addPropertyChangeListener(IPropertyChangeListener listener) {
        propertyChangeListeners.add(listener);
    }

    public static void removePropertyChangeListener(IPropertyChangeListener listener) {
        propertyChangeListeners.remove(listener);
    }

    public static void broadcastPropertyChange(PropertyChangeEvent event) {
        Iterator it = propertyChangeListeners.iterator();
        while (it.hasNext()) {
            IPropertyChangeListener listener = (IPropertyChangeListener)it.next();
            listener.propertyChange(event);
        }
    }

    protected static void createImageDescriptor(TeamUIPlugin plugin, String id, URL baseURL) {
        plugin.privateCreateImageDescriptor(id, baseURL);
    }

    private void privateCreateImageDescriptor(String id, URL baseURL) {
        URL url = null;
        try {
            url = new URL(baseURL, ICON_PATH + id);
        }
        catch (MalformedURLException malformedURLException) {}
        ImageDescriptor desc = ImageDescriptor.createFromURL(url);
        this.imageDescriptors.put(id, desc);
    }

    public static ImageDescriptor getImageDescriptor(String id) {
        return TeamUIPlugin.getPlugin().privateGetImageDescriptor(id);
    }

    private ImageDescriptor privateGetImageDescriptor(String id) {
        if (!this.imageDescriptors.containsKey(id)) {
            URL baseURL = TeamUIPlugin.getPlugin().getDescriptor().getInstallURL();
            TeamUIPlugin.createImageDescriptor(TeamUIPlugin.getPlugin(), id, baseURL);
        }
        return (ImageDescriptor)this.imageDescriptors.get(id);
    }

    public static ImageDescriptor getImageDescriptorFromExtension(IExtension extension, String subdirectoryAndFilename) {
        IPluginDescriptor pluginDescriptor = extension.getDeclaringPluginDescriptor();
        URL path = pluginDescriptor.getInstallURL();
        URL fullPathString = null;
        try {
            fullPathString = new URL(path, subdirectoryAndFilename);
            return ImageDescriptor.createFromURL((URL)fullPathString);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private void initializeImages(TeamUIPlugin plugin) {
        URL baseURL = plugin.getDescriptor().getInstallURL();
        TeamUIPlugin.createImageDescriptor(plugin, "ovr/dirty_ov.gif", baseURL);
        TeamUIPlugin.createImageDescriptor(plugin, "ovr/confchg_ov.gif", baseURL);
        TeamUIPlugin.createImageDescriptor(plugin, "ovr/version_controlled.gif", baseURL);
        TeamUIPlugin.createImageDescriptor(plugin, "ovr/checkedout_ov.gif", baseURL);
        TeamUIPlugin.createImageDescriptor(plugin, "ovr/error_co.gif", baseURL);
        TeamUIPlugin.createImageDescriptor(plugin, "ovr/warning_co.gif", baseURL);
        TeamUIPlugin.createImageDescriptor(plugin, "ovr/waiting_ovr.gif", baseURL);
        TeamUIPlugin.createImageDescriptor(plugin, "elcl16/site_element.gif", baseURL);
        TeamUIPlugin.createImageDescriptor(plugin, "elcl16/incom_synch.gif", baseURL);
        TeamUIPlugin.createImageDescriptor(plugin, "elcl16/outgo_synch.gif", baseURL);
        TeamUIPlugin.createImageDescriptor(plugin, "elcl16/conflict_synch.gif", baseURL);
        TeamUIPlugin.createImageDescriptor(plugin, "elcl16/refresh.gif", baseURL);
        TeamUIPlugin.createImageDescriptor(plugin, "elcl16/change_filter.gif", baseURL);
        TeamUIPlugin.createImageDescriptor(plugin, "elcl16/ignorews_edit.gif", baseURL);
        TeamUIPlugin.createImageDescriptor(plugin, "elcl16/collapseall.gif", baseURL);
        TeamUIPlugin.createImageDescriptor(plugin, "elcl16/collapseall.gif", baseURL);
        TeamUIPlugin.createImageDescriptor(plugin, "dlcl16/incom_synch.gif", baseURL);
        TeamUIPlugin.createImageDescriptor(plugin, "dlcl16/outgo_synch.gif", baseURL);
        TeamUIPlugin.createImageDescriptor(plugin, "dlcl16/conflict_synch.gif", baseURL);
        TeamUIPlugin.createImageDescriptor(plugin, "dlcl16/refresh.gif", baseURL);
        TeamUIPlugin.createImageDescriptor(plugin, "dlcl16/ignorews_edit.gif", baseURL);
        TeamUIPlugin.createImageDescriptor(plugin, "elcl16/catchup_rls.gif", baseURL);
        TeamUIPlugin.createImageDescriptor(plugin, "elcl16/release_rls.gif", baseURL);
        TeamUIPlugin.createImageDescriptor(plugin, "elcl16/catchuprelease_rls.gif", baseURL);
        TeamUIPlugin.createImageDescriptor(plugin, "dlcl16/catchup_rls.gif", baseURL);
        TeamUIPlugin.createImageDescriptor(plugin, "dlcl16/release_rls.gif", baseURL);
        TeamUIPlugin.createImageDescriptor(plugin, "dlcl16/catchuprelease_rls.gif", baseURL);
        TeamUIPlugin.createImageDescriptor(plugin, "elcl16/catchup_rls.gif", baseURL);
        TeamUIPlugin.createImageDescriptor(plugin, "elcl16/release_rls.gif", baseURL);
        TeamUIPlugin.createImageDescriptor(plugin, "elcl16/catchuprelease_rls.gif", baseURL);
        TeamUIPlugin.createImageDescriptor(plugin, "wizban/import_projectset_wizban.gif", baseURL);
        TeamUIPlugin.createImageDescriptor(plugin, "wizban/export_projectset_wizban.gif", baseURL);
        TeamUIPlugin.createImageDescriptor(plugin, "wizban/share_wizban.gif", baseURL);
        TeamUIPlugin.createImageDescriptor(plugin, "obj/compressed_folder_obj.gif", baseURL);
        TeamUIPlugin.createImageDescriptor(plugin, "eview16/synch_synch.gif", baseURL);
        TeamUIPlugin.createImageDescriptor(plugin, "elcl16/hierarchicalLayout.gif", baseURL);
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public Image getImage(String key) {
        Image image = this.getImageRegistry().get(key);
        if (image == null) {
            ImageDescriptor d = TeamUIPlugin.getImageDescriptor(key);
            image = d.createImage();
            this.getImageRegistry().put(key, image);
        }
        return image;
    }

    public static void run(IRunnableWithProgress runnable) {
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().run(true, true, runnable);
        }
        catch (InvocationTargetException e) {
            Utils.handleError(TeamUIPlugin.getStandardDisplay().getActiveShell(), e, null, null);
        }
        catch (InterruptedException interruptedException) {}
    }
}

