/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.core.streams;

import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import org.eclipse.team.internal.core.Policy;

public class TimeoutOutputStream
extends FilterOutputStream {
    private final long writeTimeout;
    private final long closeTimeout;
    private byte[] iobuffer;
    private int head = 0;
    private int length = 0;
    private boolean closeRequested = false;
    private boolean flushRequested = false;
    private Thread thread;
    private boolean waitingForClose = false;
    private IOException ioe = null;

    public TimeoutOutputStream(OutputStream out, int bufferSize, long writeTimeout, long closeTimeout) {
        super(new BufferedOutputStream(out, bufferSize));
        this.writeTimeout = writeTimeout;
        this.closeTimeout = closeTimeout;
        this.iobuffer = new byte[bufferSize];
        this.thread = new Thread(new Runnable(){

            public void run() {
                TimeoutOutputStream.this.runThread();
            }
        }, "TimeoutOutputStream");
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public void close() throws IOException {
        Thread oldThread;
        TimeoutOutputStream timeoutOutputStream = this;
        synchronized (timeoutOutputStream) {
            if (this.thread == null) {
                return;
            }
            oldThread = this.thread;
            this.closeRequested = true;
            this.thread.interrupt();
            this.checkError();
        }
        if (this.closeTimeout == -1L) {
            return;
        }
        try {
            oldThread.join(this.closeTimeout);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        timeoutOutputStream = this;
        synchronized (timeoutOutputStream) {
            this.checkError();
            if (this.thread != null) {
                throw new InterruptedIOException();
            }
        }
    }

    public synchronized void write(int b) throws IOException {
        this.syncCommit(true);
        this.iobuffer[(this.head + this.length) % this.iobuffer.length] = (byte)b;
        ++this.length;
        this.notify();
    }

    public synchronized void write(byte[] buffer, int off, int len) throws IOException {
        int amount = 0;
        try {
            do {
                this.syncCommit(true);
                while (amount < len && this.length != this.iobuffer.length) {
                    this.iobuffer[(this.head + this.length) % this.iobuffer.length] = buffer[off++];
                    ++this.length;
                    ++amount;
                }
            } while (amount < len);
        }
        catch (InterruptedIOException e) {
            e.bytesTransferred = amount;
            throw e;
        }
        this.notify();
    }

    public synchronized void flush() throws IOException {
        int oldLength = this.length;
        this.flushRequested = true;
        try {
            this.syncCommit(false);
        }
        catch (InterruptedIOException e) {
            e.bytesTransferred = oldLength - this.length;
            throw e;
        }
        this.notify();
    }

    private void syncCommit(boolean partial) throws IOException {
        this.checkError();
        if (partial && this.length != this.iobuffer.length || this.length == 0) {
            return;
        }
        if (this.waitingForClose) {
            throw new IOException(Policy.bind("TimeoutOutputStream.cannotWriteToStream"));
        }
        this.notify();
        try {
            this.wait(this.writeTimeout);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        this.checkError();
        if (partial && this.length != this.iobuffer.length || this.length == 0) {
            return;
        }
        throw new InterruptedIOException();
    }

    private void checkError() throws IOException {
        if (this.ioe != null) {
            IOException e = this.ioe;
            this.ioe = null;
            throw e;
        }
    }

    /*
     * Exception decompiling
     */
    private void runThread() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 7[TRYBLOCK] [7 : 113->116)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private synchronized void waitUntilClosed() {
        this.waitingForClose = true;
        this.notify();
        while (!this.closeRequested) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                this.closeRequested = true;
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeUntilDone() throws IOException {
        bytesUntilFlush = -1;
        while (true) {
            var4_4 = this;
            synchronized (var4_4) {
                while (true) lbl-1000:
                // 3 sources

                {
                    if (this.closeRequested && this.length == 0) {
                        return;
                    }
                    if (this.length != 0 || this.flushRequested) ** break;
                    try {
                        this.wait();
                    }
                    catch (InterruptedException v0) {
                        this.closeRequested = true;
                        continue;
                    }
                    break;
                }
                ** GOTO lbl-1000
                off = this.head;
                len = this.iobuffer.length - this.head;
                if (len > this.length) {
                    len = this.length;
                }
                if (this.flushRequested && bytesUntilFlush < 0) {
                    this.flushRequested = false;
                    bytesUntilFlush = this.length;
                }
            }
            if (len != 0) {
                try {
                    this.out.write(this.iobuffer, off, len);
                }
                catch (InterruptedIOException e) {
                    len = e.bytesTransferred;
                }
            }
            if (bytesUntilFlush >= 0 && (bytesUntilFlush -= len) <= 0) {
                try {
                    this.out.flush();
                }
                catch (InterruptedIOException v2) {}
                bytesUntilFlush = -1;
            }
            if (len == 0) continue;
            var4_4 = this;
            synchronized (var4_4) {
                this.head = (this.head + len) % this.iobuffer.length;
                this.length -= len;
                this.notify();
            }
        }
    }
}

