/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.core.streams;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import org.eclipse.team.internal.core.Policy;

public class TimeoutInputStream
extends FilterInputStream {
    private final long readTimeout;
    private final long closeTimeout;
    private boolean closeRequested = false;
    private Thread thread;
    private byte[] iobuffer;
    private int head = 0;
    private int length = 0;
    private IOException ioe = null;
    private boolean waitingForClose = false;
    private boolean growWhenFull = false;

    public TimeoutInputStream(InputStream in, int bufferSize, long readTimeout, long closeTimeout) {
        super(in);
        this.readTimeout = readTimeout;
        this.closeTimeout = closeTimeout;
        this.iobuffer = new byte[bufferSize];
        this.thread = new Thread(new Runnable(){

            public void run() {
                TimeoutInputStream.this.runThread();
            }
        }, "TimeoutInputStream");
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public TimeoutInputStream(InputStream in, int bufferSize, long readTimeout, long closeTimeout, boolean growWhenFull) {
        this(in, bufferSize, readTimeout, closeTimeout);
        this.growWhenFull = growWhenFull;
    }

    public void close() throws IOException {
        Thread oldThread;
        TimeoutInputStream timeoutInputStream = this;
        synchronized (timeoutInputStream) {
            if (this.thread == null) {
                return;
            }
            oldThread = this.thread;
            this.closeRequested = true;
            this.thread.interrupt();
            this.checkError();
        }
        if (this.closeTimeout == -1L) {
            return;
        }
        try {
            oldThread.join(this.closeTimeout);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        timeoutInputStream = this;
        synchronized (timeoutInputStream) {
            this.checkError();
            if (this.thread != null) {
                throw new InterruptedIOException();
            }
        }
    }

    public synchronized int available() throws IOException {
        if (this.length == 0) {
            this.checkError();
        }
        return this.length > 0 ? this.length : 0;
    }

    public synchronized int read() throws IOException {
        if (!this.syncFill()) {
            return -1;
        }
        int b = this.iobuffer[this.head++] & 0xFF;
        if (this.head == this.iobuffer.length) {
            this.head = 0;
        }
        --this.length;
        this.notify();
        return b;
    }

    public synchronized int read(byte[] buffer, int off, int len) throws IOException {
        if (!this.syncFill()) {
            return -1;
        }
        int pos = off;
        if (len > this.length) {
            len = this.length;
        }
        while (len-- > 0) {
            buffer[pos++] = this.iobuffer[this.head++];
            if (this.head == this.iobuffer.length) {
                this.head = 0;
            }
            --this.length;
        }
        this.notify();
        return pos - off;
    }

    public synchronized long skip(long count) throws IOException {
        long amount = 0L;
        try {
            while (this.syncFill()) {
                int skip = (int)Math.min(count - amount, (long)this.length);
                this.head = (this.head + skip) % this.iobuffer.length;
                this.length -= skip;
                if ((amount += (long)skip) < count) continue;
                break;
            }
        }
        catch (InterruptedIOException e) {
            e.bytesTransferred = (int)amount;
            throw e;
        }
        this.notify();
        return amount;
    }

    public boolean markSupported() {
        return false;
    }

    private boolean syncFill() throws IOException {
        if (this.length != 0) {
            return true;
        }
        this.checkError();
        if (this.waitingForClose) {
            return false;
        }
        this.notify();
        try {
            this.wait(this.readTimeout);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        if (this.length != 0) {
            return true;
        }
        this.checkError();
        if (this.waitingForClose) {
            return false;
        }
        throw new InterruptedIOException();
    }

    private void checkError() throws IOException {
        if (this.ioe != null) {
            IOException e = this.ioe;
            this.ioe = null;
            throw e;
        }
    }

    /*
     * Exception decompiling
     */
    private void runThread() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 7[TRYBLOCK] [7 : 113->116)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private synchronized void waitUntilClosed() {
        this.waitingForClose = true;
        this.notify();
        while (!this.closeRequested) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                this.closeRequested = true;
            }
        }
    }

    private void readUntilDone() throws IOException {
        while (true) {
            int count;
            int len;
            int off;
            TimeoutInputStream timeoutInputStream = this;
            synchronized (timeoutInputStream) {
                while (this.isBufferFull()) {
                    if (this.closeRequested) {
                        return;
                    }
                    this.waitForRead();
                }
                off = (this.head + this.length) % this.iobuffer.length;
                len = (this.head > off ? this.head : this.iobuffer.length) - off;
            }
            try {
                count = this.in.read(this.iobuffer, off, len);
                if (count == -1) {
                    return;
                }
            }
            catch (InterruptedIOException e) {
                count = e.bytesTransferred;
            }
            TimeoutInputStream timeoutInputStream2 = this;
            synchronized (timeoutInputStream2) {
                this.length += count;
                this.notify();
            }
        }
    }

    private synchronized void waitForRead() {
        try {
            if (this.growWhenFull) {
                this.wait(this.readTimeout);
            } else {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            this.closeRequested = true;
        }
        if (this.growWhenFull && this.isBufferFull()) {
            this.growBuffer();
        }
    }

    private synchronized void growBuffer() {
        int newSize = 2 * this.iobuffer.length;
        if (newSize > this.iobuffer.length) {
            if (Policy.DEBUG_STREAMS) {
                System.out.println("InputStream growing to " + newSize + " bytes");
            }
            byte[] newBuffer = new byte[newSize];
            int pos = 0;
            int len = this.length;
            while (len-- > 0) {
                newBuffer[pos++] = this.iobuffer[this.head++];
                if (this.head != this.iobuffer.length) continue;
                this.head = 0;
            }
            this.iobuffer = newBuffer;
            this.head = 0;
        }
    }

    private boolean isBufferFull() {
        return this.length == this.iobuffer.length;
    }
}

