/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core;

import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ICompletionRequestor;
import org.eclipse.jdt.core.ICorrectionRequestor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReasons;
import org.eclipse.jdt.internal.compiler.parser.Scanner;
import org.eclipse.jdt.internal.core.util.Util;

public class CorrectionEngine
implements ProblemReasons {
    protected int correctionStart;
    protected int correctionEnd;
    protected int prefixLength;
    protected ICompilationUnit compilationUnit;
    protected ICorrectionRequestor correctionRequestor;
    protected static final int CLASSES = 1;
    protected static final int INTERFACES = 2;
    protected static final int IMPORT = 4;
    protected static final int METHOD = 8;
    protected static final int FIELD = 16;
    protected static final int LOCAL = 32;
    protected int filter;
    protected ICompletionRequestor completionRequestor = new ICompletionRequestor(){

        public void acceptAnonymousType(char[] superTypePackageName, char[] superTypeName, char[][] parameterPackageNames, char[][] parameterTypeNames, char[][] parameterNames, char[] completionName, int modifiers, int completionStart, int completionEnd, int relevance) {
        }

        public void acceptClass(char[] packageName, char[] className, char[] completionName, int modifiers, int completionStart, int completionEnd, int relevance) {
            if ((CorrectionEngine.this.filter & 3) != 0) {
                CorrectionEngine.this.correctionRequestor.acceptClass(packageName, className, CharOperation.subarray(completionName, CorrectionEngine.this.prefixLength, completionName.length), modifiers, CorrectionEngine.this.correctionStart, CorrectionEngine.this.correctionEnd);
            } else if ((CorrectionEngine.this.filter & 4) != 0) {
                char[] fullName = CharOperation.concat(packageName, className, '.');
                CorrectionEngine.this.correctionRequestor.acceptClass(packageName, className, CharOperation.subarray(fullName, CorrectionEngine.this.prefixLength, fullName.length), modifiers, CorrectionEngine.this.correctionStart, CorrectionEngine.this.correctionEnd);
            }
        }

        public void acceptError(IProblem error) {
        }

        public void acceptField(char[] declaringTypePackageName, char[] declaringTypeName, char[] name, char[] typePackageName, char[] typeName, char[] completionName, int modifiers, int completionStart, int completionEnd, int relevance) {
            if ((CorrectionEngine.this.filter & 0x10) != 0) {
                CorrectionEngine.this.correctionRequestor.acceptField(declaringTypePackageName, declaringTypeName, name, typePackageName, typeName, name, modifiers, CorrectionEngine.this.correctionStart, CorrectionEngine.this.correctionEnd);
            }
        }

        public void acceptInterface(char[] packageName, char[] interfaceName, char[] completionName, int modifiers, int completionStart, int completionEnd, int relevance) {
            if ((CorrectionEngine.this.filter & 3) != 0) {
                CorrectionEngine.this.correctionRequestor.acceptInterface(packageName, interfaceName, CharOperation.subarray(completionName, CorrectionEngine.this.prefixLength, completionName.length), modifiers, CorrectionEngine.this.correctionStart, CorrectionEngine.this.correctionEnd);
            } else if ((CorrectionEngine.this.filter & 4) != 0) {
                char[] fullName = CharOperation.concat(packageName, interfaceName, '.');
                CorrectionEngine.this.correctionRequestor.acceptInterface(packageName, interfaceName, CharOperation.subarray(fullName, CorrectionEngine.this.prefixLength, fullName.length), modifiers, CorrectionEngine.this.correctionStart, CorrectionEngine.this.correctionEnd);
            }
        }

        public void acceptKeyword(char[] keywordName, int completionStart, int completionEnd, int relevance) {
        }

        public void acceptLabel(char[] labelName, int completionStart, int completionEnd, int relevance) {
        }

        public void acceptLocalVariable(char[] name, char[] typePackageName, char[] typeName, int modifiers, int completionStart, int completionEnd, int relevance) {
            if ((CorrectionEngine.this.filter & 0x20) != 0) {
                CorrectionEngine.this.correctionRequestor.acceptLocalVariable(name, typePackageName, typeName, modifiers, CorrectionEngine.this.correctionStart, CorrectionEngine.this.correctionEnd);
            }
        }

        public void acceptMethod(char[] declaringTypePackageName, char[] declaringTypeName, char[] selector, char[][] parameterPackageNames, char[][] parameterTypeNames, char[][] parameterNames, char[] returnTypePackageName, char[] returnTypeName, char[] completionName, int modifiers, int completionStart, int completionEnd, int relevance) {
            if ((CorrectionEngine.this.filter & 8) != 0) {
                CorrectionEngine.this.correctionRequestor.acceptMethod(declaringTypePackageName, declaringTypeName, selector, parameterPackageNames, parameterTypeNames, parameterNames, returnTypePackageName, returnTypeName, selector, modifiers, CorrectionEngine.this.correctionStart, CorrectionEngine.this.correctionEnd);
            }
        }

        public void acceptMethodDeclaration(char[] declaringTypePackageName, char[] declaringTypeName, char[] selector, char[][] parameterPackageNames, char[][] parameterTypeNames, char[][] parameterNames, char[] returnTypePackageName, char[] returnTypeName, char[] completionName, int modifiers, int completionStart, int completionEnd, int relevance) {
        }

        public void acceptModifier(char[] modifierName, int completionStart, int completionEnd, int relevance) {
        }

        public void acceptPackage(char[] packageName, char[] completionName, int completionStart, int completionEnd, int relevance) {
            if ((CorrectionEngine.this.filter & 7) != 0) {
                CorrectionEngine.this.correctionRequestor.acceptPackage(packageName, CharOperation.subarray(packageName, CorrectionEngine.this.prefixLength, packageName.length), CorrectionEngine.this.correctionStart, CorrectionEngine.this.correctionEnd);
            }
        }

        public void acceptType(char[] packageName, char[] typeName, char[] completionName, int completionStart, int completionEnd, int relevance) {
        }

        public void acceptVariableName(char[] typePackageName, char[] typeName, char[] name, char[] completionName, int completionStart, int completionEnd, int relevance) {
        }
    };

    public CorrectionEngine(Map setting) {
    }

    public void computeCorrections(IMarker marker, ICompilationUnit targetUnit, int positionOffset, ICorrectionRequestor requestor) throws JavaModelException {
        ICompilationUnit element;
        IJavaElement iJavaElement = element = targetUnit == null ? JavaCore.create(marker.getResource()) : targetUnit;
        if (!(element instanceof ICompilationUnit)) {
            return;
        }
        ICompilationUnit unit = element;
        int id = marker.getAttribute("id", -1);
        String[] args = Util.getProblemArgumentsFromMarker(marker.getAttribute("arguments", ""));
        int start = marker.getAttribute("charStart", -1);
        int end = marker.getAttribute("charEnd", -1);
        this.computeCorrections(unit, id, start + positionOffset, end + positionOffset, args, requestor);
    }

    public void computeCorrections(IProblem problem, ICompilationUnit targetUnit, ICorrectionRequestor requestor) throws JavaModelException {
        if (requestor == null) {
            throw new IllegalArgumentException(Util.bind("correction.nullUnit"));
        }
        this.computeCorrections(targetUnit, problem.getID(), problem.getSourceStart(), problem.getSourceEnd(), problem.getArguments(), requestor);
    }

    private void computeCorrections(ICompilationUnit unit, int id, int start, int end, String[] arguments, ICorrectionRequestor requestor) {
        if (id == -1 || arguments == null || start == -1 || end == -1) {
            return;
        }
        if (requestor == null) {
            throw new IllegalArgumentException(Util.bind("correction.nullRequestor"));
        }
        this.correctionRequestor = requestor;
        this.correctionStart = start;
        this.correctionEnd = end;
        this.compilationUnit = unit;
        String argument = null;
        try {
            switch (id) {
                case 33554782: 
                case 67109234: {
                    this.filter = 3;
                    argument = arguments[2];
                    break;
                }
                case 16777546: {
                    this.filter = 1;
                    argument = arguments[0];
                    break;
                }
                case 16777551: {
                    this.filter = 2;
                    argument = arguments[0];
                    break;
                }
                case 67109239: {
                    this.filter = 1;
                    argument = arguments[1];
                    break;
                }
                case 67109244: {
                    this.filter = 3;
                    argument = arguments[1];
                    break;
                }
                case 268435846: {
                    this.filter = 4;
                    argument = arguments[0];
                    break;
                }
                case 0x1000002: {
                    this.filter = 3;
                    argument = arguments[0];
                    break;
                }
                case 0x4000064: {
                    this.filter = 8;
                    argument = arguments[1];
                    break;
                }
                case 33554502: {
                    this.filter = 16;
                    argument = arguments[0];
                    break;
                }
                case 50: {
                    this.filter = 48;
                    argument = arguments[0];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
        if (argument != null) {
            this.correct(argument.toCharArray());
        }
    }

    private void correct(char[] argument) {
        try {
            String source = this.compilationUnit.getSource();
            Scanner scanner = new Scanner();
            scanner.setSource(source.toCharArray());
            scanner.resetTo(this.correctionStart, this.correctionEnd);
            int token = 0;
            char[] argumentSource = CharOperation.NO_CHAR;
            do {
                if ((token = scanner.getNextToken()) == 54) {
                    return;
                }
                char[] tokenSource = scanner.getCurrentTokenSource();
                if (CharOperation.prefixEquals(argumentSource = CharOperation.concat(argumentSource, tokenSource), argument)) continue;
                return;
            } while (!CharOperation.equals(argument, argumentSource));
            this.correctionStart = scanner.startPosition;
            this.correctionEnd = scanner.currentPosition;
            this.prefixLength = CharOperation.lastIndexOf('.', argument) + 1;
            int completionPosition = this.correctionStart;
            scanner.resetTo(completionPosition, this.correctionEnd);
            int position = completionPosition;
            int i = 0;
            while (i < 4) {
                if (!scanner.getNextCharAsJavaIdentifierPart()) break;
                completionPosition = position;
                position = scanner.currentPosition;
                ++i;
            }
            this.compilationUnit.codeComplete(completionPosition, this.completionRequestor);
        }
        catch (JavaModelException javaModelException) {
            return;
        }
        catch (InvalidInputException invalidInputException) {
            return;
        }
    }

    public static String[] getProblemArguments(IMarker problemMarker) {
        String argumentsString = problemMarker.getAttribute("arguments", null);
        return Util.getProblemArgumentsFromMarker(argumentsString);
    }
}

