/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.site;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.PackageSpecification;
import org.eclipse.osgi.service.resolver.StateHelper;
import org.eclipse.osgi.service.resolver.Version;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.pde.internal.build.AbstractScriptGenerator;
import org.eclipse.pde.internal.build.BundleHelper;
import org.eclipse.pde.internal.build.IPDEBuildConstants;
import org.eclipse.pde.internal.build.IXMLConstants;
import org.eclipse.pde.internal.build.Policy;
import org.eclipse.pde.internal.build.site.BuildTimeSiteContentProvider;
import org.eclipse.pde.internal.build.site.PDEState;
import org.eclipse.pde.internal.build.site.PluginRegistryConverter;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteFeatureReference;
import org.eclipse.update.core.Site;
import org.eclipse.update.core.SiteFeatureReference;
import org.eclipse.update.core.SiteFeatureReferenceModel;
import org.eclipse.update.core.model.SiteModel;

public class BuildTimeSite
extends Site
implements ISite,
IPDEBuildConstants,
IXMLConstants {
    private PDEState state;
    private Properties repositoryVersions;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Properties getFeatureVersions() {
        if (this.repositoryVersions != null) return this.repositoryVersions;
        this.repositoryVersions = new Properties();
        try {
            BufferedInputStream input = new BufferedInputStream(new FileInputStream(String.valueOf(AbstractScriptGenerator.getWorkingDirectory()) + '/' + "featureVersions.properties"));
            try {
                this.repositoryVersions.load(input);
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                ((InputStream)input).close();
                throw throwable;
            }
            {
                Object var2_4 = null;
                ((InputStream)input).close();
                return this.repositoryVersions;
            }
        }
        catch (IOException iOException) {}
        return this.repositoryVersions;
    }

    public PDEState getRegistry() throws CoreException {
        if (this.state == null) {
            BuildTimeSiteContentProvider contentProvider = (BuildTimeSiteContentProvider)this.getSiteContentProvider();
            this.state = AbstractScriptGenerator.isBuildingOSGi() ? new PDEState() : new PluginRegistryConverter();
            this.state.addBundles(contentProvider.getPluginPaths());
            this.state.resolveState();
            BundleDescription[] allBundles = this.state.getState().getBundles();
            BundleDescription[] resolvedBundles = this.state.getState().getResolvedBundles();
            if (allBundles.length == resolvedBundles.length) {
                return this.state;
            }
            MultiStatus errors = new MultiStatus("org.eclipse.pde.build", 1, Policy.bind("exception.registryResolution"), null);
            BundleDescription[] all = this.state.getState().getBundles();
            StateHelper helper = Platform.getPlatformAdmin().getStateHelper();
            int i = 0;
            while (i < all.length) {
                if (!all[i].isResolved()) {
                    VersionConstraint[] unsatisfiedConstraints = helper.getUnsatisfiedConstraints(all[i]);
                    int j = 0;
                    while (j < unsatisfiedConstraints.length) {
                        String message = this.getResolutionFailureMessage(unsatisfiedConstraints[j]);
                        errors.add((IStatus)new Status(2, all[i].getSymbolicName(), 2, message, null));
                        ++j;
                    }
                }
                ++i;
            }
            BundleHelper.getDefault().getLog().log((IStatus)errors);
        }
        if (!this.state.getState().isResolved()) {
            this.state.state.resolve(true);
        }
        return this.state;
    }

    public String getResolutionFailureMessage(VersionConstraint unsatisfied) {
        if (unsatisfied.isResolved()) {
            throw new IllegalArgumentException();
        }
        if (unsatisfied instanceof PackageSpecification) {
            return Policy.bind("unsatisfied.import", this.displayVersionConstraint(unsatisfied));
        }
        if (unsatisfied instanceof BundleSpecification) {
            if (((BundleSpecification)unsatisfied).isOptional()) {
                return Policy.bind("unsatisfied.optionalBundle", this.displayVersionConstraint(unsatisfied));
            }
            return Policy.bind("unsatisfied.required", this.displayVersionConstraint(unsatisfied));
        }
        return Policy.bind("unsatisfied.host", this.displayVersionConstraint(unsatisfied));
    }

    private String displayVersionConstraint(VersionConstraint constraint) {
        VersionRange versionSpec = constraint.getVersionRange();
        if (versionSpec == null) {
            return constraint.getName();
        }
        return String.valueOf(constraint.getName()) + '_' + versionSpec;
    }

    public IFeature findFeature(String featureId, String versionId, boolean throwsException) throws CoreException {
        ISiteFeatureReference[] features = this.getFeatureReferences();
        if ("0.0.0".equals(versionId)) {
            versionId = null;
        }
        int i = 0;
        while (i < features.length) {
            if (features[i].getVersionedIdentifier().getIdentifier().equals(featureId) && (versionId == null || features[i].getVersionedIdentifier().getVersion().toString().equals(versionId))) {
                return features[i].getFeature(null);
            }
            ++i;
        }
        int qualifierIdx = -1;
        if (versionId != null && (qualifierIdx = versionId.indexOf(".qualifier")) != -1) {
            Version versionToMatch = new Version(versionId.substring(0, qualifierIdx));
            int i2 = 0;
            while (i2 < features.length) {
                if (features[i2].getVersionedIdentifier().getIdentifier().equals(featureId) && new Version(features[i2].getVersionedIdentifier().getVersion().toString()).matchMinor(versionToMatch)) {
                    return features[i2].getFeature(null);
                }
                ++i2;
            }
        }
        if (throwsException) {
            String message = Policy.bind("exception.missingFeature", featureId);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 1, message, null));
        }
        return null;
    }

    public void addFeatureReferenceModel(File featureXML) {
        if (featureXML.exists()) {
            try {
                URL featureURL = new URL("file:" + featureXML.getAbsolutePath() + '/');
                SiteFeatureReference featureRef = new SiteFeatureReference();
                featureRef.setSiteModel((SiteModel)this);
                featureRef.setURLString(featureURL.toExternalForm());
                featureRef.setType("org.eclipse.pde.build.BuildTimeFeatureFactory");
                this.addFeatureReferenceModel((SiteFeatureReferenceModel)featureRef);
            }
            catch (MalformedURLException e) {
                BundleHelper.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.pde.build", 20, Policy.bind("warning.cannotLocateSource", featureXML.getAbsolutePath()), (Throwable)e));
            }
        }
    }
}

