/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.ui;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jdt.internal.junit.ui.JUnitPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class ProgressImages {
    static final int PROGRESS_STEPS = 9;
    static final String BASE = "prgss/";
    static final String FAILURE = "ff";
    static final String OK = "ss";
    Image[] fOKImages = new Image[9];
    Image[] fFailureImages = new Image[9];
    Image fMissingImage = null;

    void load() {
        if (this.isLoaded()) {
            return;
        }
        int i = 0;
        while (i < 9) {
            String okname = "prgss/ss" + Integer.toString(i + 1) + ".gif";
            this.fOKImages[i] = this.createImage(okname);
            String failurename = "prgss/ff" + Integer.toString(i + 1) + ".gif";
            this.fFailureImages[i] = this.createImage(failurename);
            ++i;
        }
    }

    Image createImage(String name) {
        try {
            ImageDescriptor id = ImageDescriptor.createFromURL((URL)JUnitPlugin.makeIconFileURL(name));
            return id.createImage();
        }
        catch (MalformedURLException malformedURLException) {
            if (this.fMissingImage == null) {
                this.fMissingImage = ImageDescriptor.getMissingImageDescriptor().createImage();
            }
            return this.fMissingImage;
        }
    }

    public void dispose() {
        if (!this.isLoaded()) {
            return;
        }
        if (this.fMissingImage != null) {
            this.fMissingImage.dispose();
        }
        int i = 0;
        while (i < 9) {
            this.fOKImages[i].dispose();
            this.fOKImages[i] = null;
            this.fFailureImages[i].dispose();
            this.fFailureImages[i] = null;
            ++i;
        }
    }

    public Image getImage(int current, int total, int errors, int failures) {
        if (!this.isLoaded()) {
            this.load();
        }
        if (total == 0) {
            return this.fOKImages[0];
        }
        int index = current * 9 / total - 1;
        index = Math.min(Math.max(0, index), 8);
        if (errors + failures == 0) {
            return this.fOKImages[index];
        }
        return this.fFailureImages[index];
    }

    boolean isLoaded() {
        return this.fOKImages[0] != null;
    }
}

