/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.junit.ui.OpenEditorAction;
import org.eclipse.jdt.internal.junit.ui.TestRunnerViewPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.texteditor.ITextEditor;

public class OpenEditorAtLineAction
extends OpenEditorAction {
    private int fLineNumber;
    private String fCUName;

    public OpenEditorAtLineAction(TestRunnerViewPart testRunner, String cuName, String className, int line) {
        super(testRunner, className);
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.junit.open_editor_atline_action_context");
        this.fLineNumber = line;
        this.fCUName = cuName;
    }

    protected void reveal(ITextEditor textEditor) {
        if (this.fLineNumber >= 0) {
            try {
                IDocument document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
                textEditor.selectAndReveal(document.getLineOffset(this.fLineNumber - 1), document.getLineLength(this.fLineNumber - 1));
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    protected IJavaElement findElement(IJavaProject project, String className) throws CoreException {
        IType element = project.findType(className);
        if (element == null) {
            SearchPattern pattern = SearchPattern.createPattern((String)className, (int)0, (int)0, (int)8);
            IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{project}, (boolean)false);
            NonPublicClassInCUCollector requestor = new NonPublicClassInCUCollector();
            SearchEngine searchEngine = new SearchEngine();
            searchEngine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, (SearchRequestor)requestor, (IProgressMonitor)new NullProgressMonitor());
            element = requestor.fFound;
        }
        return element;
    }

    public boolean isEnabled() {
        try {
            return this.getLaunchedProject().findType(this.getClassName()) != null;
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    private class NonPublicClassInCUCollector
    extends SearchRequestor {
        private IJavaElement fFound;

        NonPublicClassInCUCollector() {
        }

        public void acceptSearchMatch(SearchMatch match) throws CoreException {
            IJavaElement enclosingElement = (IJavaElement)match.getElement();
            String resourceName = match.getResource().getName();
            if (enclosingElement instanceof IType && resourceName.equals(OpenEditorAtLineAction.this.fCUName)) {
                this.fFound = enclosingElement;
            }
        }
    }
}

