/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.ui;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareViewerPane;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.internal.junit.ui.JUnitMessages;
import org.eclipse.jdt.internal.junit.ui.JUnitPlugin;
import org.eclipse.jdt.internal.junit.ui.TestRunInfo;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class CompareResultDialog
extends Dialog {
    private TextMergeViewer fViewer;
    private String fExpected;
    private String fActual;
    private String fTestName;
    private static CompareResultDialog fgThis;
    private int fPrefix;
    private int fSuffix;
    private static final String DIALOG_BOUNDS_KEY = "CompareResultDialogBounds";
    private static final String X = "x";
    private static final String Y = "y";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private IDialogSettings fSettings;
    protected Rectangle fNewBounds;

    public CompareResultDialog(Shell parentShell, TestRunInfo failure) {
        super(parentShell);
        fgThis = this;
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.fTestName = failure.getTestName();
        this.fExpected = failure.getExpected();
        this.fActual = failure.getActual();
        this.computePrefixSuffix();
        this.fSettings = JUnitPlugin.getDefault().getDialogSettings();
    }

    protected Point getInitialSize() {
        IDialogSettings bounds;
        int width = 0;
        int height = 0;
        final Shell s = this.getShell();
        if (s != null) {
            s.addControlListener(new ControlListener(){

                public void controlMoved(ControlEvent arg) {
                    CompareResultDialog.this.fNewBounds = s.getBounds();
                }

                public void controlResized(ControlEvent arg) {
                    CompareResultDialog.this.fNewBounds = s.getBounds();
                }
            });
        }
        if ((bounds = this.fSettings.getSection(DIALOG_BOUNDS_KEY)) == null) {
            return super.getInitialSize();
        }
        try {
            width = bounds.getInt(WIDTH);
        }
        catch (NumberFormatException numberFormatException) {
            width = 400;
        }
        try {
            height = bounds.getInt(HEIGHT);
        }
        catch (NumberFormatException numberFormatException) {
            height = 300;
        }
        return new Point(width, height);
    }

    protected Point getInitialLocation(Point initialSize) {
        Point loc = super.getInitialLocation(initialSize);
        IDialogSettings bounds = this.fSettings.getSection(DIALOG_BOUNDS_KEY);
        if (bounds != null) {
            try {
                loc.x = bounds.getInt(X);
            }
            catch (NumberFormatException numberFormatException) {}
            try {
                loc.y = bounds.getInt(Y);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return loc;
    }

    public boolean close() {
        boolean closed = super.close();
        if (closed && this.fNewBounds != null) {
            this.saveBounds(this.fNewBounds);
        }
        return closed;
    }

    private void saveBounds(Rectangle bounds) {
        IDialogSettings dialogBounds = this.fSettings.getSection(DIALOG_BOUNDS_KEY);
        if (dialogBounds == null) {
            dialogBounds = new DialogSettings(DIALOG_BOUNDS_KEY);
            this.fSettings.addSection(dialogBounds);
        }
        dialogBounds.put(X, bounds.x);
        dialogBounds.put(Y, bounds.y);
        dialogBounds.put(WIDTH, bounds.width);
        dialogBounds.put(HEIGHT, bounds.height);
    }

    private void computePrefixSuffix() {
        int end = Math.min(this.fExpected.length(), this.fActual.length());
        int i = 0;
        while (i < end) {
            if (this.fExpected.charAt(i) != this.fActual.charAt(i)) break;
            ++i;
        }
        this.fPrefix = i;
        int j = this.fExpected.length() - 1;
        int k = this.fActual.length() - 1;
        int l = 0;
        while (k >= this.fPrefix && j >= this.fPrefix) {
            if (this.fExpected.charAt(j) != this.fActual.charAt(k)) break;
            ++l;
            --k;
            --j;
        }
        this.fSuffix = l;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(JUnitMessages.getString("CompareResultDialog.title"));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, JUnitMessages.getString("CompareResultDialog.labelOK"), true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        CompareViewerPane pane = new CompareViewerPane(composite, 0x800800);
        pane.setText(this.fTestName);
        GridData data = new GridData(1808);
        data.widthHint = this.convertWidthInCharsToPixels(120);
        data.heightHint = this.convertHeightInCharsToPixels(13);
        pane.setLayoutData((Object)data);
        Control previewer = this.createPreviewer((Composite)pane);
        pane.setContent(previewer);
        GridData gd = new GridData(1808);
        previewer.setLayoutData((Object)gd);
        Dialog.applyDialogFont((Control)parent);
        return composite;
    }

    private Control createPreviewer(Composite parent) {
        final CompareConfiguration compareConfiguration = new CompareConfiguration();
        compareConfiguration.setLeftLabel(JUnitMessages.getString("CompareResultDialog.expectedLabel"));
        compareConfiguration.setLeftEditable(false);
        compareConfiguration.setRightLabel(JUnitMessages.getString("CompareResultDialog.actualLabel"));
        compareConfiguration.setRightEditable(false);
        compareConfiguration.setProperty("IGNORE_WHITESPACE", (Object)new Boolean(false));
        this.fViewer = new CompareResultMergeViewer(parent, 0, compareConfiguration);
        this.fViewer.setInput((Object)new DiffNode((ITypedElement)new CompareElement(this.fExpected), (ITypedElement)new CompareElement(this.fActual)));
        Control control = this.fViewer.getControl();
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (compareConfiguration != null) {
                    compareConfiguration.dispose();
                }
            }
        });
        return control;
    }

    private static class CompareResultMergeViewer
    extends TextMergeViewer {
        CompareResultMergeViewer(Composite parent, int style, CompareConfiguration configuration) {
            super(parent, style, configuration);
        }

        protected void configureTextViewer(TextViewer textViewer) {
            if (textViewer instanceof SourceViewer) {
                ((SourceViewer)textViewer).configure((SourceViewerConfiguration)new CompareResultViewerConfiguration());
            }
        }
    }

    public static class CompareResultViewerConfiguration
    extends SourceViewerConfiguration {
        public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
            PresentationReconciler reconciler = new PresentationReconciler();
            SimpleDamagerRepairer dr = new SimpleDamagerRepairer();
            reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
            reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
            return reconciler;
        }

        public class SimpleDamagerRepairer
        implements IPresentationDamager,
        IPresentationRepairer {
            private IDocument fDocument;

            public void setDocument(IDocument document) {
                this.fDocument = document;
            }

            public IRegion getDamageRegion(ITypedRegion partition, DocumentEvent event, boolean changed) {
                return new Region(0, this.fDocument.getLength());
            }

            public void createPresentation(TextPresentation presentation, ITypedRegion damage) {
                int suffix = fgThis.fSuffix;
                int prefix = fgThis.fPrefix;
                TextAttribute attr = new TextAttribute(Display.getDefault().getSystemColor(3), null, 1);
                presentation.addStyleRange(new StyleRange(prefix, this.fDocument.getLength() - suffix - prefix, attr.getForeground(), attr.getBackground(), attr.getStyle()));
            }
        }
    }

    private static class CompareElement
    implements ITypedElement,
    IEncodedStreamContentAccessor {
        private String fContent;

        public CompareElement(String content) {
            this.fContent = content;
        }

        public String getName() {
            return "<no name>";
        }

        public Image getImage() {
            return null;
        }

        public String getType() {
            return "txt";
        }

        public InputStream getContents() {
            try {
                return new ByteArrayInputStream(this.fContent.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return new ByteArrayInputStream(this.fContent.getBytes());
            }
        }

        public String getCharset() throws CoreException {
            return "UTF-8";
        }
    }
}

