/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.util;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.ICVSResourceVisitor;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.client.Update;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.KnownRepositories;

public class ReplaceWithBaseVisitor
implements ICVSResourceVisitor {
    private IProgressMonitor monitor;
    private int depth;
    private Session session;

    public void visitFile(ICVSFile file) throws CVSException {
        byte[] syncBytes = file.getSyncBytes();
        if (syncBytes == null) {
            if (CVSProviderPlugin.getPlugin().isReplaceUnmanaged()) {
                file.delete();
            }
        } else if (ResourceSyncInfo.isAddition(syncBytes)) {
            file.delete();
            file.unmanage(null);
        } else {
            byte[] tagBytes = ResourceSyncInfo.getTagBytes(syncBytes);
            boolean isModified = file.isModified(null);
            if (ResourceSyncInfo.isDeletion(syncBytes)) {
                syncBytes = ResourceSyncInfo.convertFromDeletion(syncBytes);
                file.setSyncBytes(syncBytes, 0);
                isModified = true;
            }
            if (isModified) {
                ICVSFolder parent = file.getParent();
                parent.getFolderSyncInfo();
                Command.UPDATE.execute(this.session, Command.NO_GLOBAL_OPTIONS, new Command.LocalOption[]{Update.makeTagOption(CVSTag.BASE), Update.IGNORE_LOCAL_CHANGES}, new ICVSResource[]{file}, null, Policy.subMonitorFor(this.monitor, 1));
                syncBytes = file.getSyncBytes();
                syncBytes = ResourceSyncInfo.setTag(syncBytes, tagBytes);
                file.setSyncBytes(syncBytes, 0);
            }
        }
        this.monitor.worked(1);
    }

    public void visitFolder(ICVSFolder folder) throws CVSException {
        int i;
        if (this.depth == 2) {
            folder.acceptChildren(this);
        } else if (this.depth == 1) {
            ICVSResource[] files = folder.members(1);
            i = 0;
            while (i < files.length) {
                files[i].accept(this);
                ++i;
            }
        }
        ICVSResource[] ignoredFiles = folder.members(5);
        i = 0;
        while (i < ignoredFiles.length) {
            ICVSResource cvsResource = ignoredFiles[i];
            if (cvsResource.getName().startsWith(".#")) {
                cvsResource.delete();
            }
            ++i;
        }
        this.monitor.worked(1);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void replaceWithBase(IProject project, IResource[] resources, int depth, IProgressMonitor pm) throws CVSException {
        this.depth = depth;
        ICVSFolder root = CVSWorkspaceRoot.getCVSFolderFor((IContainer)project);
        FolderSyncInfo folderInfo = root.getFolderSyncInfo();
        IProgressMonitor monitor = Policy.monitorFor(pm);
        monitor.beginTask(null, 100);
        this.session = new Session(KnownRepositories.getInstance().getRepository(folderInfo.getRoot()), root, true);
        this.session.open(Policy.subMonitorFor(monitor, 10), false);
        try {
            this.monitor = Policy.infiniteSubMonitorFor(monitor, 90);
            this.monitor.beginTask(null, 512);
            int i = 0;
            while (i < resources.length) {
                this.monitor.subTask(Policy.bind("ReplaceWithBaseVisitor.replacing", resources[i].getFullPath().toString()));
                CVSWorkspaceRoot.getCVSResourceFor(resources[i]).accept(this);
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.session.close();
            monitor.done();
            throw throwable;
        }
        {
            Object var9_11 = null;
            this.session.close();
        }
        monitor.done();
    }
}

