/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.client.listeners;

import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSStatus;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.client.CommandOutputListener;
import org.eclipse.team.internal.ccvs.core.client.listeners.ICommandOutputListener;
import org.eclipse.team.internal.ccvs.core.client.listeners.IUpdateMessageListener;
import org.eclipse.team.internal.ccvs.core.client.listeners.ServerMessageLineMatcher;
import org.eclipse.team.internal.ccvs.core.util.Util;

public class UpdateListener
extends CommandOutputListener {
    private static ServerMessageLineMatcher MERGED_BINARY_FILE_LINE_1;
    private static ServerMessageLineMatcher MERGED_BINARY_FILE_LINE_2;
    private static final String REVISION_VARIABLE_NAME = "revision";
    private static final String LOCAL_FILE_PATH_VARIABLE_NAME = "localFilePath";
    private static final String BACKUP_FILE_VARIABLE_NAME = "backupFile";
    IUpdateMessageListener updateMessageListener;
    boolean merging = false;
    boolean mergingBinary = false;
    String mergedBinaryFileRevision;
    String mergedBinaryFilePath;

    static {
        try {
            String line1 = "revision " + Util.getVariablePattern(".*", REVISION_VARIABLE_NAME) + " from repository is now in " + Util.getVariablePattern(".*", LOCAL_FILE_PATH_VARIABLE_NAME);
            MERGED_BINARY_FILE_LINE_1 = new ServerMessageLineMatcher(line1, new String[]{REVISION_VARIABLE_NAME, LOCAL_FILE_PATH_VARIABLE_NAME});
            String line2 = "file from working directory is now in " + Util.getVariablePattern(".*", BACKUP_FILE_VARIABLE_NAME);
            MERGED_BINARY_FILE_LINE_2 = new ServerMessageLineMatcher(line2, new String[]{BACKUP_FILE_VARIABLE_NAME});
        }
        catch (CVSException e) {
            CVSProviderPlugin.log((CoreException)((Object)e));
        }
    }

    public UpdateListener(IUpdateMessageListener updateMessageListener) {
        this.updateMessageListener = updateMessageListener;
    }

    public IStatus messageLine(String line, ICVSRepositoryLocation location, ICVSFolder commandRoot, IProgressMonitor monitor) {
        this.mergingBinary = false;
        if (this.updateMessageListener == null) {
            return ICommandOutputListener.OK;
        }
        if (line.startsWith("Merging differences")) {
            this.merging = true;
        } else if (line.indexOf(32) == 1) {
            String path = line.substring(2);
            char changeType = line.charAt(0);
            int type = 0;
            switch (changeType) {
                case 'A': {
                    type = 1;
                    break;
                }
                case '?': {
                    type = 2;
                    break;
                }
                case 'U': {
                    type = 3;
                    break;
                }
                case 'R': {
                    type = 4;
                    break;
                }
                case 'M': {
                    type = 5;
                    break;
                }
                case 'C': {
                    type = 6;
                    break;
                }
                case 'D': {
                    type = 4;
                    break;
                }
                default: {
                    type = 0;
                }
            }
            if (this.merging) {
                if (type == 5) {
                    type = 7;
                }
                this.merging = false;
            }
            this.updateMessageListener.fileInformation(type, commandRoot, path);
        }
        return ICommandOutputListener.OK;
    }

    public IStatus errorLine(String line, ICVSRepositoryLocation location, ICVSFolder commandRoot, IProgressMonitor monitor) {
        block28: {
            try {
                boolean wasMergingBinary = this.mergingBinary;
                this.mergingBinary = false;
                String serverMessage = this.getServerMessage(line, location);
                if (serverMessage != null) {
                    String message = serverMessage;
                    if (message.startsWith("Updating")) {
                        if (this.updateMessageListener != null) {
                            String path = message.substring(9);
                            this.updateMessageListener.directoryInformation(commandRoot, path, false);
                        }
                        return ICommandOutputListener.OK;
                    }
                    if (message.startsWith("skipping directory")) {
                        if (this.updateMessageListener != null) {
                            String path = message.substring(18).trim();
                            this.updateMessageListener.directoryDoesNotExist(commandRoot, path);
                        }
                        return ICommandOutputListener.OK;
                    }
                    if (message.startsWith("New directory")) {
                        if (this.updateMessageListener != null) {
                            String path = message.substring(15, message.lastIndexOf(39));
                            this.updateMessageListener.directoryInformation(commandRoot, path, true);
                        }
                        return ICommandOutputListener.OK;
                    }
                    if (message.endsWith("is no longer in the repository")) {
                        if (this.updateMessageListener != null) {
                            String filename = message.substring(0, message.length() - 31);
                            filename = this.stripQuotes(filename);
                            this.updateMessageListener.fileDoesNotExist(commandRoot, filename);
                        }
                        return ICommandOutputListener.OK;
                    }
                    if (message.startsWith("conflict:")) {
                        if (this.updateMessageListener != null && message.endsWith("is modified but no longer in the repository")) {
                            String filename = message.substring(10, message.length() - 44);
                            filename = this.stripQuotes(filename);
                            this.updateMessageListener.fileDoesNotExist(commandRoot, filename);
                        }
                        return new CVSStatus(2, -12, commandRoot, line);
                    }
                    if (message.startsWith("warning:")) {
                        if (this.updateMessageListener != null && message.endsWith("is not (any longer) pertinent")) {
                            String filename = message.substring(9, message.length() - 30);
                            this.updateMessageListener.fileDoesNotExist(commandRoot, filename);
                        }
                        return new CVSStatus(2, -12, commandRoot, line);
                    }
                    if (message.startsWith("conflicts")) {
                        return new CVSStatus(1, -12, commandRoot, line);
                    }
                    if (message.startsWith("nonmergeable file needs merge")) {
                        this.mergingBinary = true;
                        this.mergedBinaryFileRevision = null;
                        this.mergedBinaryFilePath = null;
                        return ICommandOutputListener.OK;
                    }
                    if (wasMergingBinary) {
                        Map variables = MERGED_BINARY_FILE_LINE_1.processServerMessage(message);
                        if (variables != null) {
                            this.mergedBinaryFileRevision = (String)variables.get(REVISION_VARIABLE_NAME);
                            this.mergedBinaryFilePath = (String)variables.get(LOCAL_FILE_PATH_VARIABLE_NAME);
                            this.mergingBinary = true;
                            return ICommandOutputListener.OK;
                        }
                        variables = MERGED_BINARY_FILE_LINE_2.processServerMessage(message);
                        if (variables != null) {
                            String backupFile = (String)variables.get(BACKUP_FILE_VARIABLE_NAME);
                            try {
                                ICVSFile file;
                                IResource resource;
                                if (this.mergedBinaryFileRevision != null && this.mergedBinaryFilePath != null && (resource = (file = commandRoot.getFile(this.mergedBinaryFilePath)).getIResource()) != null) {
                                    return new CVSStatus(4, -26, Policy.bind("UpdateListener.0", new Object[]{resource.getFullPath().toString(), this.mergedBinaryFileRevision, resource.getFullPath().removeLastSegments(1).append(backupFile).toString()}));
                                }
                            }
                            catch (CVSException e1) {
                                CVSProviderPlugin.log((CoreException)((Object)e1));
                            }
                            return ICommandOutputListener.OK;
                        }
                    }
                    if (!message.startsWith("cannot open directory") && !message.startsWith("nothing known about")) {
                        return super.errorLine(line, location, commandRoot, monitor);
                    }
                    break block28;
                }
                String serverAbortedMessage = this.getServerAbortedMessage(line, location);
                if (serverAbortedMessage != null) {
                    String message = serverAbortedMessage;
                    if (message.startsWith("no such tag")) {
                        return new CVSStatus(2, -11, commandRoot, line);
                    }
                    return super.errorLine(line, location, commandRoot, monitor);
                }
                if (line.equals("rcsmerge: warning: conflicts during merge")) {
                    return new CVSStatus(2, -12, commandRoot, line);
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                if (CVSProviderPlugin.getPlugin().isDebugging()) {
                    System.out.println("Error parsing E line: " + line);
                }
                return new CVSStatus(4, -24, commandRoot, line);
            }
        }
        return super.errorLine(line, location, commandRoot, monitor);
    }

    private String stripQuotes(String filename) {
        if (filename.startsWith("`") && filename.endsWith("'")) {
            filename = filename.substring(1, filename.length() - 1);
        }
        return filename;
    }
}

