/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tomcat.internal;

import java.util.Hashtable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.tomcat.internal.JndiURLHandler;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class TomcatPlugin
extends Plugin
implements BundleActivator {
    public static final String PLUGIN_ID = "org.eclipse.tomcat";
    public static final String PREF_ACCEPT_COUNT = "acceptCount";
    public static final String PREF_MAX_PROCESSORS = "maxProcessors";
    public static final String PREF_MIN_PROCESSORS = "minProcessors";
    private static TomcatPlugin plugin;
    private static BundleContext bundleContext;
    private ServiceRegistration jndiURLServiceRegistration;
    static /* synthetic */ Class class$0;

    public static synchronized void logError(String message, Throwable ex) {
        if (message == null) {
            message = "";
        }
        Status errorStatus = new Status(4, PLUGIN_ID, 0, message, ex);
        TomcatPlugin.getDefault().getLog().log((IStatus)errorStatus);
    }

    public static TomcatPlugin getDefault() {
        return plugin;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        bundleContext = context;
        this.registerJndiURL(context);
    }

    public void stop(BundleContext context) throws Exception {
        this.unregisterJndiURL();
        plugin = null;
        bundleContext = null;
        super.stop(context);
    }

    private void registerJndiURL(BundleContext context) {
        Hashtable<String, String[]> properties = new Hashtable<String, String[]>();
        properties.put("url.handler.protocol", new String[]{"jndi"});
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.osgi.service.url.URLStreamHandlerService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.jndiURLServiceRegistration = context.registerService(clazz.getName(), (Object)new JndiURLHandler(), properties);
        }
        catch (Error t) {
            TomcatPlugin.logError(t.getMessage(), t);
            throw t;
        }
    }

    private void unregisterJndiURL() {
        if (this.jndiURLServiceRegistration != null) {
            this.jndiURLServiceRegistration.unregister();
        }
    }
}

