/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.builders;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.pde.core.ISourceObject;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.internal.PDE;
import org.eclipse.pde.internal.builders.CompilerFlags;
import org.eclipse.pde.internal.builders.PluginErrorReporter;
import org.eclipse.pde.internal.builders.ValidatingSAXParser;
import org.eclipse.pde.internal.core.ModelEntry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.core.feature.WorkspaceFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureChild;
import org.eclipse.pde.internal.core.ifeature.IFeatureData;
import org.eclipse.pde.internal.core.ifeature.IFeatureImport;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeatureObject;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;

public class FeatureConsistencyChecker
extends IncrementalProjectBuilder {
    public static final String BUILDERS_VERIFYING = "Builders.verifying";
    public static final String BUILDERS_FEATURE_REFERENCE = "Builders.Feature.reference";
    public static final String BUILDERS_FEATURE_FREFERENCE = "Builders.Feature.freference";
    public static final String BUILDERS_UPDATING = "Builders.updating";

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        if (PDECore.getDefault().getBundle().getState() != 32 || monitor.isCanceled()) {
            return new IProject[0];
        }
        IResourceDelta delta = null;
        IProject project = this.getProject();
        if (kind != 6) {
            delta = this.getDelta(project);
        }
        if (delta == null || kind == 6) {
            this.checkProject(project, monitor);
        } else {
            delta.accept((IResourceDeltaVisitor)new DeltaVisitor(monitor));
        }
        return new IProject[0];
    }

    private void checkProject(IProject project, IProgressMonitor monitor) {
        IFile file = project.getFile("feature.xml");
        if (file.exists()) {
            this.checkFile(file, monitor);
        }
    }

    private void checkFile(IFile file, IProgressMonitor monitor) {
        String message = PDE.getFormattedMessage(BUILDERS_VERIFYING, file.getFullPath().toString());
        monitor.subTask(message);
        PluginErrorReporter reporter = new PluginErrorReporter(file);
        ValidatingSAXParser.parse(file, reporter, true);
        if (reporter.getErrorCount() == 0) {
            this.validateFeature(file, reporter);
        }
        monitor.subTask(PDE.getResourceString(BUILDERS_UPDATING));
        monitor.done();
    }

    private boolean isManifestFile(IFile file) {
        return file.getParent().equals((Object)file.getProject()) && file.getName().toLowerCase().equals("feature.xml");
    }

    private boolean isValidReference(IFeaturePlugin plugin) {
        ModelEntry entry;
        String id = plugin.getId();
        if (id != null && id.trim().length() > 0 && (entry = PDECore.getDefault().getModelManager().findEntry(id)) != null) {
            if (plugin.isFragment()) {
                return entry.getActiveModel() instanceof IFragmentModel;
            }
            return entry.getActiveModel() instanceof IPluginModel;
        }
        return false;
    }

    private boolean isValidReference(IFeatureChild child) {
        WorkspaceModelManager manager = PDECore.getDefault().getWorkspaceModelManager();
        IFeatureModel[] models = manager.getFeatureModels();
        int i = 0;
        while (i < models.length) {
            IFeatureModel model = models[i];
            if (model.getFeature().getId().equals(child.getId())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void validateFeature(IFile file, PluginErrorReporter reporter) {
        WorkspaceFeatureModel model = new WorkspaceFeatureModel(file);
        model.load();
        if (model.isLoaded()) {
            IFeature feature = model.getFeature();
            this.validateRequiredAttributes(feature, reporter);
            if (reporter.getErrorCount() > 0) {
                return;
            }
            this.testPluginReferences(feature, reporter);
            this.testFeatureReferences(feature, reporter);
        }
    }

    private void testPluginReferences(IFeature feature, PluginErrorReporter reporter) {
        IFeaturePlugin[] plugins = feature.getPlugins();
        int flag = CompilerFlags.getFlag("compilers.f.unresolved-plugins");
        if (flag == 2) {
            return;
        }
        int i = 0;
        while (i < plugins.length) {
            IFeaturePlugin plugin = plugins[i];
            if (!this.isValidReference(plugin)) {
                String message = PDE.getFormattedMessage(BUILDERS_FEATURE_REFERENCE, plugin.getLabel());
                reporter.report(message, FeatureConsistencyChecker.getLine((IFeatureObject)plugin), flag);
            }
            ++i;
        }
    }

    private void testFeatureReferences(IFeature feature, PluginErrorReporter reporter) {
        IFeatureChild[] included = feature.getIncludedFeatures();
        int flag = CompilerFlags.getFlag("compilers.f.unresolved-features");
        if (flag == 2) {
            return;
        }
        int i = 0;
        while (i < included.length) {
            IFeatureChild child = included[i];
            if (!this.isValidReference(child)) {
                String message = PDE.getFormattedMessage(BUILDERS_FEATURE_FREFERENCE, child.getId());
                reporter.report(message, FeatureConsistencyChecker.getLine((IFeatureObject)child), flag);
            }
            ++i;
        }
    }

    private void validateRequiredAttributes(IFeature feature, PluginErrorReporter reporter) {
        FeatureConsistencyChecker.assertNotNull("id", "feature", FeatureConsistencyChecker.getLine((IFeatureObject)feature), feature.getId(), reporter);
        FeatureConsistencyChecker.assertNotNull("version", "feature", FeatureConsistencyChecker.getLine((IFeatureObject)feature), feature.getVersion(), reporter);
        IFeatureChild[] children = feature.getIncludedFeatures();
        int i = 0;
        while (i < children.length) {
            IFeatureChild child = children[i];
            FeatureConsistencyChecker.assertNotNull("id", "includes", FeatureConsistencyChecker.getLine((IFeatureObject)child), child.getId(), reporter);
            FeatureConsistencyChecker.assertNotNull("version", "includes", FeatureConsistencyChecker.getLine((IFeatureObject)child), child.getVersion(), reporter);
            ++i;
        }
        IFeaturePlugin[] plugins = feature.getPlugins();
        int i2 = 0;
        while (i2 < plugins.length) {
            IFeaturePlugin plugin = plugins[i2];
            FeatureConsistencyChecker.assertNotNull("id", "plugin", FeatureConsistencyChecker.getLine((IFeatureObject)plugin), plugin.getId(), reporter);
            FeatureConsistencyChecker.assertNotNull("version", "plugin", FeatureConsistencyChecker.getLine((IFeatureObject)plugin), plugin.getVersion(), reporter);
            ++i2;
        }
        IFeatureData[] data = feature.getData();
        int i3 = 0;
        while (i3 < data.length) {
            IFeatureData entry = data[i3];
            FeatureConsistencyChecker.assertNotNull("id", "data", FeatureConsistencyChecker.getLine((IFeatureObject)entry), entry.getId(), reporter);
            ++i3;
        }
        IFeatureImport[] fimports = feature.getImports();
        int i4 = 0;
        while (i4 < fimports.length) {
            IFeatureImport fimport = fimports[i4];
            if (fimport.getType() == 0) {
                FeatureConsistencyChecker.assertNotNull("plugin", "import", FeatureConsistencyChecker.getLine((IFeatureObject)fimport), fimport.getId(), reporter);
            }
            ++i4;
        }
    }

    private static int getLine(IFeatureObject object) {
        int line = -1;
        if (object instanceof ISourceObject) {
            line = ((ISourceObject)object).getStartLine();
        }
        return line;
    }

    private static void assertNotNull(String att, String el, int line, String value, PluginErrorReporter reporter) {
        if (value == null) {
            String message = PDE.getFormattedMessage("Builders.manifest.missingRequired", new String[]{att, el});
            reporter.reportError(message, line);
        }
    }

    class DeltaVisitor
    implements IResourceDeltaVisitor {
        private IProgressMonitor monitor;

        public DeltaVisitor(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public boolean visit(IResourceDelta delta) {
            IFile candidate;
            IResource resource = delta.getResource();
            if (resource instanceof IProject) {
                IProject project = (IProject)resource;
                try {
                    return project.hasNature("org.eclipse.pde.FeatureNature");
                }
                catch (CoreException e) {
                    PDE.logException(e);
                    return false;
                }
            }
            if (resource instanceof IFile && FeatureConsistencyChecker.this.isManifestFile(candidate = (IFile)resource) && delta.getKind() != 2) {
                FeatureConsistencyChecker.this.checkFile(candidate, this.monitor);
                return true;
            }
            return true;
        }
    }

    class ReferenceDeltaVisitor
    implements IResourceDeltaVisitor {
        private boolean interestingChange;

        public boolean isInterestingChange() {
            return this.interestingChange;
        }

        public boolean visit(IResourceDelta delta) {
            IFile candidate;
            IResource resource = delta.getResource();
            if (resource instanceof IProject) {
                IProject project = (IProject)resource;
                return PDE.hasFeatureNature(project);
            }
            if (resource instanceof IFile && FeatureConsistencyChecker.this.isManifestFile(candidate = (IFile)resource)) {
                this.interestingChange = true;
                return false;
            }
            return true;
        }
    }
}

