/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.indexing;

import java.util.HashMap;
import java.util.Map;

public class Reservation {
    protected int freeSlots = 0;
    protected int freeSpace = 0;
    protected int reservedSpace = 0;
    protected int initialEntry = 0;
    protected Map reservedItems = new HashMap();

    public Reservation(int freeSpace, int freeSlots, int initialEntry) {
        this.freeSlots = freeSlots;
        this.freeSpace = freeSpace;
        this.initialEntry = initialEntry;
    }

    public void add(int slot, int bytes) {
        this.reservedSpace += bytes;
        this.reservedItems.put(new Integer(slot), new Integer(bytes));
    }

    public void remove(int slot) {
        Integer bytes = (Integer)this.reservedItems.remove(new Integer(slot));
        if (bytes == null) {
            return;
        }
        this.reservedSpace -= bytes.intValue();
    }

    boolean contains(int slot) {
        return this.reservedItems.containsKey(new Integer(slot));
    }

    int getFreeSpace() {
        if (this.reservedItems.size() >= this.freeSlots) {
            return 0;
        }
        return Math.max(0, this.freeSpace - this.reservedSpace);
    }

    public int getInitialEntry() {
        return this.initialEntry;
    }

    public void setInitialEntry(int n) {
        this.initialEntry = n;
    }
}

