/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.launching;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.ExternalArchiveSourceContainer;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.launching.LaunchingPlugin;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.sourcelookup.containers.JavaProjectSourceContainer;
import org.eclipse.jdt.launching.sourcelookup.containers.PackageFragmentRootSourceContainer;

public class JavaSourceLookupUtil {
    public static ISourceContainer[] translate(IRuntimeClasspathEntry[] entries, boolean considerSourceAttachments) throws CoreException {
        ArrayList<Object> containers = new ArrayList<Object>(entries.length);
        int i = 0;
        while (i < entries.length) {
            IRuntimeClasspathEntry entry = entries[i];
            switch (entry.getType()) {
                case 2: {
                    PackageFragmentRootSourceContainer container;
                    IPackageFragmentRoot root = JavaSourceLookupUtil.getPackageFragmentRoot(entry, considerSourceAttachments);
                    String path = entry.getSourceAttachmentLocation();
                    if (root == null && path == null && considerSourceAttachments) {
                        root = JavaSourceLookupUtil.getPackageFragmentRoot(entry, false);
                    }
                    if (root == null) {
                        container = null;
                        container = path == null ? new ExternalArchiveSourceContainer(entry.getLocation(), true) : new ExternalArchiveSourceContainer(path, true);
                        if (containers.contains((Object)container)) break;
                        containers.add((Object)container);
                        break;
                    }
                    container = new PackageFragmentRootSourceContainer(root);
                    if (containers.contains((Object)container)) break;
                    containers.add((Object)container);
                    break;
                }
                case 1: {
                    JavaProjectSourceContainer container;
                    IResource resource = entry.getResource();
                    if (resource == null || resource.getType() != 4 || containers.contains((Object)(container = new JavaProjectSourceContainer(JavaCore.create((IProject)((IProject)resource)))))) break;
                    containers.add((Object)container);
                    break;
                }
            }
            ++i;
        }
        return containers.toArray(new ISourceContainer[containers.size()]);
    }

    private static boolean equalOrNull(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        return a.equals(b);
    }

    private static boolean isSourceAttachmentEqual(IPackageFragmentRoot root, IRuntimeClasspathEntry entry) throws JavaModelException {
        return JavaSourceLookupUtil.equalOrNull(root.getSourceAttachmentPath(), entry.getSourceAttachmentPath());
    }

    private static IPackageFragmentRoot getPackageFragmentRoot(IRuntimeClasspathEntry entry, boolean considerSourceAttachment) {
        IResource resource = entry.getResource();
        if (resource == null) {
            IJavaModel model = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
            try {
                IJavaProject[] jps = model.getJavaProjects();
                int i = 0;
                while (i < jps.length) {
                    IJavaProject jp = jps[i];
                    IProject p = jp.getProject();
                    if (p.isOpen()) {
                        IPackageFragmentRoot[] allRoots = jp.getPackageFragmentRoots();
                        int j = 0;
                        while (j < allRoots.length) {
                            IPackageFragmentRoot root = allRoots[j];
                            if (root.isExternal() && root.getPath().equals((Object)new Path(entry.getLocation())) && (!considerSourceAttachment || JavaSourceLookupUtil.isSourceAttachmentEqual(root, entry))) {
                                return root;
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            catch (JavaModelException e) {
                LaunchingPlugin.log(e);
            }
        } else {
            IProject project = resource.getProject();
            IJavaProject jp = JavaCore.create((IProject)project);
            try {
                if (project.isOpen() && jp.exists()) {
                    IPackageFragmentRoot root = jp.getPackageFragmentRoot(resource);
                    IPackageFragmentRoot[] allRoots = jp.getPackageFragmentRoots();
                    int j = 0;
                    while (j < allRoots.length) {
                        if (allRoots[j].equals(root) && (!considerSourceAttachment || JavaSourceLookupUtil.isSourceAttachmentEqual(root, entry))) {
                            return root;
                        }
                        ++j;
                    }
                }
                IJavaModel model = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
                IJavaProject[] jps = model.getJavaProjects();
                int i = 0;
                while (i < jps.length) {
                    IJavaProject jp1 = jps[i];
                    IProject p = jp1.getProject();
                    if (p.isOpen()) {
                        IPackageFragmentRoot[] allRoots = jp1.getPackageFragmentRoots();
                        int j = 0;
                        while (j < allRoots.length) {
                            IPackageFragmentRoot root = allRoots[j];
                            if (!root.isExternal() && root.getPath().equals((Object)entry.getPath()) && (!considerSourceAttachment || JavaSourceLookupUtil.isSourceAttachmentEqual(root, entry))) {
                                return root;
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            catch (JavaModelException e) {
                LaunchingPlugin.log(e);
            }
        }
        return null;
    }
}

