/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.viewsupport;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.internal.ui.viewsupport.ResourceToItemsMapper;
import org.eclipse.jdt.ui.IWorkingCopyProvider;
import org.eclipse.jdt.ui.ProblemsLabelDecorator;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class ProblemTreeViewer
extends TreeViewer {
    protected ResourceToItemsMapper fResourceToItemsMapper;

    public ProblemTreeViewer(Composite parent) {
        super(parent);
        this.initMapper();
    }

    public ProblemTreeViewer(Composite parent, int style) {
        super(parent, style);
        this.initMapper();
    }

    public ProblemTreeViewer(Tree tree) {
        super(tree);
        this.initMapper();
    }

    private void initMapper() {
        this.fResourceToItemsMapper = new ResourceToItemsMapper((ContentViewer)this);
    }

    protected void mapElement(Object element, Widget item) {
        super.mapElement(element, item);
        if (item instanceof Item) {
            this.fResourceToItemsMapper.addToMap(element, (Item)item);
        }
    }

    protected void unmapElement(Object element, Widget item) {
        if (item instanceof Item) {
            this.fResourceToItemsMapper.removeFromMap(element, (Item)item);
        }
        super.unmapElement(element, item);
    }

    protected void unmapAllElements() {
        this.fResourceToItemsMapper.clearMap();
        super.unmapAllElements();
    }

    protected void handleLabelProviderChanged(LabelProviderChangedEvent event) {
        ProblemsLabelDecorator.ProblemsLabelChangedEvent e;
        if (event instanceof ProblemsLabelDecorator.ProblemsLabelChangedEvent && !(e = (ProblemsLabelDecorator.ProblemsLabelChangedEvent)event).isMarkerChange() && this.canIgnoreChangesFromAnnotionModel()) {
            return;
        }
        Object[] changed = event.getElements();
        if (changed != null && !this.fResourceToItemsMapper.isEmpty()) {
            ArrayList<Object> others = new ArrayList<Object>();
            int i = 0;
            while (i < changed.length) {
                Object curr = changed[i];
                if (curr instanceof IResource) {
                    this.fResourceToItemsMapper.resourceChanged((IResource)curr);
                } else {
                    others.add(curr);
                }
                ++i;
            }
            if (others.isEmpty()) {
                return;
            }
            event = new LabelProviderChangedEvent((IBaseLabelProvider)event.getSource(), others.toArray());
        }
        super.handleLabelProviderChanged(event);
    }

    private boolean canIgnoreChangesFromAnnotionModel() {
        IContentProvider contentProvider = this.getContentProvider();
        return contentProvider instanceof IWorkingCopyProvider && !((IWorkingCopyProvider)contentProvider).providesWorkingCopies();
    }

    public boolean isExpandable(Object element) {
        if (this.hasFilters() && element instanceof IMember) {
            return this.getFilteredChildren(element).length > 0;
        }
        return super.isExpandable(element);
    }
}

