/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import java.text.MessageFormat;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.search.JavaSearchResultPage;
import org.eclipse.jdt.internal.ui.search.SearchLabelProvider;
import org.eclipse.jdt.internal.ui.search.SearchMessages;
import org.eclipse.jdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.swt.graphics.Image;

public class SortingLabelProvider
extends SearchLabelProvider
implements IColorProvider {
    public static final int SHOW_ELEMENT_CONTAINER = 1;
    public static final int SHOW_CONTAINER_ELEMENT = 2;
    public static final int SHOW_PATH = 3;

    public SortingLabelProvider(JavaSearchResultPage page) {
        super(page, new AppearanceAwareLabelProvider());
    }

    public Image getImage(Object element) {
        Image image = null;
        if (element instanceof IJavaElement || element instanceof IResource) {
            image = this.getLabelProvider().getImage(element);
        }
        if (image != null) {
            return image;
        }
        return this.getParticipantImage(element);
    }

    public final String getText(Object element) {
        int matchCount = this.fPage.getDisplayedMatchCount(element);
        String text = this.internalGetText(element);
        if (matchCount < 2) {
            String label = this.getSingularLabel(element);
            return MessageFormat.format(label, text);
        }
        String label = this.getPluralLabel(element);
        return MessageFormat.format(label, text, new Integer(matchCount));
    }

    private String getSingularLabel(Object element) {
        if (this.hasPotentialMatches(element)) {
            return SearchMessages.getString("SortingLabelProvider.potential_singular");
        }
        return SearchMessages.getString("SortingLabelProvider.exact_singular");
    }

    private String getPluralLabel(Object element) {
        if (this.hasPotentialMatches(element)) {
            return SearchMessages.getString("SortingLabelProvider.potential_plural");
        }
        return SearchMessages.getString("SortingLabelProvider.exact_plural");
    }

    private String internalGetText(Object o) {
        String text;
        if (o instanceof IImportDeclaration) {
            o = ((IImportDeclaration)o).getParent().getParent();
        }
        if ((text = this.getLabelProvider().getText(o)) != null && !"".equals(text)) {
            return text;
        }
        return this.getParticipantText(o);
    }

    public void setOrder(int orderFlag) {
        int flags = 1627389961;
        if (orderFlag == 1) {
            flags |= 0x2A9141;
        } else if (orderFlag == 2) {
            flags |= 0x1528A1;
        } else if (orderFlag == 3) {
            flags |= 0x1528A1;
            flags |= 0x10000000;
        }
        this.getLabelProvider().setTextFlags(flags);
    }
}

