/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.StatusDialog;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.help.WorkbenchHelp;

public class ImportOrganizeInputDialog
extends StatusDialog {
    private StringButtonDialogField fNameDialogField;
    private List fExistingEntries;

    public ImportOrganizeInputDialog(Shell parent, List existingEntries) {
        super(parent);
        this.fExistingEntries = existingEntries;
        this.setTitle(PreferencesMessages.getString("ImportOrganizeInputDialog.title"));
        ImportOrganizeInputAdapter adapter = new ImportOrganizeInputAdapter();
        this.fNameDialogField = new StringButtonDialogField(adapter);
        this.fNameDialogField.setLabelText(PreferencesMessages.getString("ImportOrganizeInputDialog.message"));
        this.fNameDialogField.setButtonLabel(PreferencesMessages.getString("ImportOrganizeInputDialog.browse.button"));
        this.fNameDialogField.setDialogFieldListener(adapter);
        this.fNameDialogField.setText("");
    }

    public void setInitialString(String input) {
        Assert.isNotNull((Object)input);
        this.fNameDialogField.setText(input);
    }

    public Object getResult() {
        return this.fNameDialogField.getText();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite inner = new Composite(composite, 0);
        LayoutUtil.doDefaultLayout(inner, new DialogField[]{this.fNameDialogField}, true, 0, 0);
        int fieldWidthHint = this.convertWidthInCharsToPixels(60);
        LayoutUtil.setWidthHint((Control)this.fNameDialogField.getTextControl(null), fieldWidthHint);
        LayoutUtil.setHorizontalGrabbing((Control)this.fNameDialogField.getTextControl(null));
        this.fNameDialogField.postSetFocusOnDialogField(parent.getDisplay());
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void doButtonPressed() {
        HashMap<String, IPackageFragment> allPackages = new HashMap<String, IPackageFragment>();
        try {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IJavaProject[] projects = JavaCore.create((IWorkspaceRoot)root).getJavaProjects();
            int i = 0;
            while (i < projects.length) {
                IPackageFragment[] packs = projects[i].getPackageFragments();
                int k = 0;
                while (k < packs.length) {
                    IPackageFragment curr = packs[k];
                    if (!curr.isDefaultPackage() && (curr.hasChildren() || curr.getNonJavaResources().length == 0)) {
                        allPackages.put(curr.getElementName(), curr);
                    }
                    ++k;
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e.getStatus());
        }
        Object initialSelection = allPackages.get(this.fNameDialogField.getText());
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT));
        dialog.setIgnoreCase(false);
        dialog.setTitle(PreferencesMessages.getString("ImportOrganizeInputDialog.ChoosePackageDialog.title"));
        dialog.setMessage(PreferencesMessages.getString("ImportOrganizeInputDialog.ChoosePackageDialog.description"));
        dialog.setEmptyListMessage(PreferencesMessages.getString("ImportOrganizeInputDialog.ChoosePackageDialog.empty"));
        dialog.setElements(allPackages.values().toArray());
        if (initialSelection != null) {
            dialog.setInitialSelections(new Object[]{initialSelection});
        }
        if (dialog.open() == 0) {
            IPackageFragment res = (IPackageFragment)dialog.getFirstResult();
            this.fNameDialogField.setText(res.getElementName());
        }
    }

    private void doValidation() {
        StatusInfo status = new StatusInfo();
        String newText = this.fNameDialogField.getText();
        if (newText.length() == 0) {
            status.setError(PreferencesMessages.getString("ImportOrganizeInputDialog.error.enterName"));
        } else {
            IStatus val = JavaConventions.validatePackageName((String)newText);
            if (val.matches(4)) {
                status.setError(PreferencesMessages.getFormattedString("ImportOrganizeInputDialog.error.invalidName", val.getMessage()));
            } else if (this.fExistingEntries.contains(newText)) {
                status.setError(PreferencesMessages.getString("ImportOrganizeInputDialog.error.entryExists"));
            }
        }
        this.updateStatus(status);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        WorkbenchHelp.setHelp((Control)newShell, (String)"org.eclipse.jdt.ui.import_organize_input_dialog_context");
    }

    private class ImportOrganizeInputAdapter
    implements IDialogFieldListener,
    IStringButtonAdapter {
        ImportOrganizeInputAdapter() {
        }

        public void dialogFieldChanged(DialogField field) {
            ImportOrganizeInputDialog.this.doValidation();
        }

        public void changeControlPressed(DialogField field) {
            ImportOrganizeInputDialog.this.doButtonPressed();
        }
    }
}

