/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jface.text.Assert;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public final class ASTProvider {
    private static final boolean DEBUG = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.jdt.ui/debug/ASTProvider"));
    private static final String AST_DISPOSED = "org.eclipse.jdt.internal.ui.astDisposed";
    private static final String DEBUG_PREFIX = "ASTProvider > ";
    private IJavaElement fReconcilingJavaElement;
    private IJavaElement fActiveJavaElement;
    private CompilationUnit fAST;
    private ActivationListener fActivationListener;
    private Object fReconcileLock = new Object();
    private Object fWaitLock = new Object();
    private boolean fIsReconciling;
    private IWorkbench fWorkbench;
    private IWorkbenchPart fActiveEditor;

    public ASTProvider() {
        this.install();
    }

    void install() {
        this.fActivationListener = new ActivationListener();
        this.fWorkbench = PlatformUI.getWorkbench();
        this.fWorkbench.addWindowListener((IWindowListener)this.fActivationListener);
        IWorkbenchWindow[] windows = this.fWorkbench.getWorkbenchWindows();
        int i = 0;
        int length = windows.length;
        while (i < length) {
            windows[i].getPartService().addPartListener((IPartListener2)this.fActivationListener);
            ++i;
        }
    }

    private void activeJavaEditorChanged(IWorkbenchPart editor) {
        this.fActiveEditor = editor;
        IJavaElement javaElement = null;
        if (editor != null) {
            javaElement = ((JavaEditor)editor).getInputJavaElement();
        }
        if (DEBUG) {
            System.out.println("ASTProvider > active editor is: " + this.toString(javaElement));
        }
        Object object = this.fReconcileLock;
        synchronized (object) {
            if (this.fIsReconciling && !this.fReconcilingJavaElement.equals(javaElement)) {
                this.fIsReconciling = false;
                this.fReconcilingJavaElement = null;
            }
        }
        this.cache(null, javaElement);
    }

    public boolean isCached(CompilationUnit ast) {
        return ast != null && this.fAST == ast;
    }

    void aboutToBeReconciled(IJavaElement javaElement) {
        if (DEBUG) {
            System.out.println("ASTProvider > about to reconcile: " + this.toString(javaElement));
        }
        if (javaElement == null) {
            return;
        }
        Object object = this.fReconcileLock;
        synchronized (object) {
            this.fIsReconciling = true;
            this.fReconcilingJavaElement = javaElement;
        }
        this.cache(null, javaElement);
    }

    private synchronized void disposeAST() {
        if (this.fAST == null) {
            return;
        }
        if (DEBUG) {
            System.out.println("ASTProvider > disposing AST: " + this.toString(this.fAST));
        }
        this.fAST.setProperty(AST_DISPOSED, (Object)Boolean.TRUE);
        this.fAST = null;
        this.cache(null, null);
    }

    private String toString(IJavaElement javaElement) {
        if (javaElement == null) {
            return "null";
        }
        return javaElement.getElementName();
    }

    private String toString(CompilationUnit ast) {
        if (ast == null) {
            return "null";
        }
        List types = ast.types();
        if (types != null && types.size() > 0) {
            return ((AbstractTypeDeclaration)types.get(0)).getName().getIdentifier();
        }
        return "AST without any type";
    }

    private synchronized void cache(CompilationUnit ast, IJavaElement javaElement) {
        if (DEBUG && (javaElement != null || ast != null)) {
            System.out.println("ASTProvider > caching AST:" + this.toString(ast) + " for: " + this.toString(javaElement));
        }
        if (this.fAST != null) {
            this.disposeAST();
        }
        this.fAST = ast;
        this.fActiveJavaElement = javaElement;
        Object object = this.fWaitLock;
        synchronized (object) {
            this.fWaitLock.notifyAll();
        }
    }

    public CompilationUnit getAST(IJavaElement je, boolean wait, IProgressMonitor progressMonitor) {
        Assert.isTrue((je != null && (je.getElementType() == 6 || je.getElementType() == 5) ? 1 : 0) != 0);
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return null;
        }
        ASTProvider aSTProvider = this;
        synchronized (aSTProvider) {
            if (je.equals(this.fActiveJavaElement) && (this.fAST != null || !wait)) {
                return this.fAST;
            }
        }
        if (this.isReconciling(je)) {
            try {
                IJavaElement activeElement = this.fReconcilingJavaElement;
                Object object = this.fWaitLock;
                synchronized (object) {
                    if (DEBUG) {
                        System.out.println("ASTProvider > waiting for AST for: " + je.getElementName());
                    }
                    this.fWaitLock.wait();
                }
                object = this;
                synchronized (object) {
                    if (activeElement == this.fActiveJavaElement) {
                        if (DEBUG) {
                            System.out.println("ASTProvider > ...got AST for: " + je.getElementName());
                        }
                        return this.fAST;
                    }
                }
                return this.getAST(je, wait, progressMonitor);
            }
            catch (InterruptedException interruptedException) {}
        } else if (!wait) {
            return null;
        }
        CompilationUnit ast = this.createAST(je, progressMonitor);
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return null;
        }
        if (DEBUG) {
            System.out.println("ASTProvider > created AST for: " + je.getElementName());
        }
        if (ast != null && je.equals(this.fActiveJavaElement)) {
            this.cache(ast, je);
        }
        return ast;
    }

    private boolean isReconciling(IJavaElement javaElement) {
        Object object = this.fReconcileLock;
        synchronized (object) {
            return javaElement.equals(this.fReconcilingJavaElement) && this.fIsReconciling;
        }
    }

    private CompilationUnit createAST(IJavaElement je, IProgressMonitor progressMonitor) {
        ASTParser parser = ASTParser.newParser((int)2);
        parser.setResolveBindings(true);
        if (je.getElementType() == 5) {
            parser.setSource((ICompilationUnit)je);
        } else if (je.getElementType() == 6) {
            parser.setSource((IClassFile)je);
        }
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return null;
        }
        try {
            CompilationUnit root = (CompilationUnit)parser.createAST(progressMonitor);
            ASTNodes.setFlagsToAST((ASTNode)root, 4);
            return root;
        }
        catch (IllegalStateException illegalStateException) {
            return null;
        }
    }

    public void dispose() {
        this.fWorkbench.removeWindowListener((IWindowListener)this.fActivationListener);
        this.fActivationListener = null;
        this.disposeAST();
        Object object = this.fWaitLock;
        synchronized (object) {
            this.fWaitLock.notify();
        }
    }

    void reconciled(CompilationUnit ast, IJavaElement javaElement) {
        if (DEBUG) {
            System.out.println("ASTProvider > reconciled AST: " + this.toString(ast));
        }
        Object object = this.fReconcileLock;
        synchronized (object) {
            this.fIsReconciling = false;
            if (javaElement == null || !javaElement.equals(this.fReconcilingJavaElement)) {
                if (DEBUG) {
                    System.out.println("ASTProvider >   ignoring AST of out-dated editor");
                }
                Object object2 = this.fWaitLock;
                synchronized (object2) {
                    this.fWaitLock.notifyAll();
                }
                return;
            }
            this.cache(ast, javaElement);
        }
    }

    private class ActivationListener
    implements IPartListener2,
    IWindowListener {
        ActivationListener() {
        }

        public void partActivated(IWorkbenchPartReference ref) {
            if (this.isJavaEditor(ref) && !this.isActiveEditor(ref)) {
                ASTProvider.this.activeJavaEditorChanged(ref.getPart(true));
            }
        }

        public void partBroughtToTop(IWorkbenchPartReference ref) {
            if (this.isJavaEditor(ref) && !this.isActiveEditor(ref)) {
                ASTProvider.this.activeJavaEditorChanged(ref.getPart(true));
            }
        }

        public void partClosed(IWorkbenchPartReference ref) {
            if (this.isActiveEditor(ref)) {
                ASTProvider.this.activeJavaEditorChanged(null);
            }
        }

        public void partDeactivated(IWorkbenchPartReference ref) {
        }

        public void partOpened(IWorkbenchPartReference ref) {
            if (this.isJavaEditor(ref) && !this.isActiveEditor(ref)) {
                ASTProvider.this.activeJavaEditorChanged(ref.getPart(true));
            }
        }

        public void partHidden(IWorkbenchPartReference ref) {
        }

        public void partVisible(IWorkbenchPartReference ref) {
            if (this.isJavaEditor(ref) && !this.isActiveEditor(ref)) {
                ASTProvider.this.activeJavaEditorChanged(ref.getPart(true));
            }
        }

        public void partInputChanged(IWorkbenchPartReference ref) {
        }

        public void windowActivated(IWorkbenchWindow window) {
            IWorkbenchPartReference ref = window.getPartService().getActivePartReference();
            if (this.isJavaEditor(ref) && !this.isActiveEditor(ref)) {
                ASTProvider.this.activeJavaEditorChanged(ref.getPart(true));
            }
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowClosed(IWorkbenchWindow window) {
            if (ASTProvider.this.fActiveEditor != null && ASTProvider.this.fActiveEditor.getSite() != null && window == ASTProvider.this.fActiveEditor.getSite().getWorkbenchWindow()) {
                ASTProvider.this.activeJavaEditorChanged(null);
            }
            window.getPartService().removePartListener((IPartListener2)this);
        }

        public void windowOpened(IWorkbenchWindow window) {
            window.getPartService().addPartListener((IPartListener2)this);
        }

        private boolean isActiveEditor(IWorkbenchPartReference ref) {
            return ref != null && this.isActiveEditor(ref.getPart(false));
        }

        private boolean isActiveEditor(IWorkbenchPart part) {
            return part != null && part == ASTProvider.this.fActiveEditor;
        }

        private boolean isJavaEditor(IWorkbenchPartReference ref) {
            if (ref == null) {
                return false;
            }
            String id = ref.getId();
            return "org.eclipse.jdt.ui.ClassFileEditor".equals(id) || "org.eclipse.jdt.ui.CompilationUnitEditor".equals(id);
        }
    }
}

