/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.template.java;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.template.java.CompilationUnitContext;
import org.eclipse.jdt.internal.corext.template.java.CompilationUnitContextType;
import org.eclipse.jdt.internal.corext.template.java.JavaContext;
import org.eclipse.jdt.internal.corext.template.java.JavaTemplateMessages;
import org.eclipse.jdt.internal.ui.text.template.contentassist.MultiVariable;
import org.eclipse.jdt.internal.ui.text.template.contentassist.MultiVariableGuess;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.templates.GlobalTemplateVariables;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.text.templates.TemplateVariableResolver;

public class JavaContextType
extends CompilationUnitContextType {
    public static final String NAME = "java";

    public JavaContextType() {
        super(NAME);
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Cursor());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.WordSelection());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.LineSelection());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Dollar());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Date());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Year());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Time());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.User());
        this.addResolver(new CompilationUnitContextType.File());
        this.addResolver(new CompilationUnitContextType.PrimaryTypeName());
        this.addResolver(new CompilationUnitContextType.ReturnType());
        this.addResolver(new CompilationUnitContextType.Method());
        this.addResolver(new CompilationUnitContextType.Type());
        this.addResolver(new CompilationUnitContextType.Package());
        this.addResolver(new CompilationUnitContextType.Project());
        this.addResolver(new CompilationUnitContextType.Arguments());
        this.addResolver(new Array());
        this.addResolver(new ArrayType());
        this.addResolver(new ArrayElement());
        this.addResolver(new Index());
        this.addResolver(new Iterator());
        this.addResolver(new Collection());
        this.addResolver(new Todo());
    }

    public CompilationUnitContext createContext(IDocument document, int offset, int length, ICompilationUnit compilationUnit) {
        return new JavaContext(this, document, offset, length, compilationUnit);
    }

    protected static class Array
    extends TemplateVariableResolver {
        public Array() {
            super("array", JavaTemplateMessages.getString("JavaContextType.variable.description.array"));
        }

        protected String[] resolveAll(TemplateContext context) {
            return ((JavaContext)context).guessArrays();
        }

        public void resolve(TemplateVariable variable, TemplateContext context) {
            if (variable instanceof MultiVariable) {
                JavaContext jc = (JavaContext)context;
                MultiVariable mv = (MultiVariable)variable;
                String[] bindings = this.resolveAll(context);
                if (bindings.length > 0) {
                    mv.setValues(bindings);
                    MultiVariableGuess guess = jc.getMultiVariableGuess();
                    if (guess == null) {
                        guess = new MultiVariableGuess(mv);
                        jc.setMultiVariableGuess(guess);
                    }
                }
                if (bindings.length > 1) {
                    variable.setUnambiguous(false);
                } else {
                    variable.setUnambiguous(this.isUnambiguous(context));
                }
            } else {
                super.resolve(variable, context);
            }
        }
    }

    protected static class ArrayType
    extends TemplateVariableResolver {
        public ArrayType() {
            super("array_type", JavaTemplateMessages.getString("JavaContextType.variable.description.array.type"));
        }

        protected String[] resolveAll(TemplateContext context) {
            String[] arrayTypes = ((JavaContext)context).guessArrayTypes();
            if (arrayTypes != null) {
                return arrayTypes;
            }
            return super.resolveAll(context);
        }

        public void resolve(TemplateVariable variable, TemplateContext context) {
            if (variable instanceof MultiVariable) {
                MultiVariable mv = (MultiVariable)variable;
                String[] arrays = ((JavaContext)context).guessArrays();
                String[][] types = ((JavaContext)context).guessGroupedArrayTypes();
                int i = 0;
                while (i < arrays.length) {
                    mv.setValues(arrays[i], types[i]);
                    ++i;
                }
                if (arrays.length > 1 || types.length == 1 && types[0].length > 1) {
                    variable.setUnambiguous(false);
                } else {
                    variable.setUnambiguous(this.isUnambiguous(context));
                }
            } else {
                super.resolve(variable, context);
            }
        }
    }

    protected static class ArrayElement
    extends TemplateVariableResolver {
        public ArrayElement() {
            super("array_element", JavaTemplateMessages.getString("JavaContextType.variable.description.array.element"));
        }

        protected String[] resolveAll(TemplateContext context) {
            return ((JavaContext)context).guessArrayElements();
        }

        public void resolve(TemplateVariable variable, TemplateContext context) {
            if (variable instanceof MultiVariable) {
                MultiVariable mv = (MultiVariable)variable;
                String[] arrays = ((JavaContext)context).guessArrays();
                String[][] elems = ((JavaContext)context).guessGroupedArrayElements();
                int i = 0;
                while (i < arrays.length) {
                    mv.setValues(arrays[i], elems[i]);
                    ++i;
                }
                if (arrays.length > 1 || elems.length == 1 && elems[0].length > 1) {
                    variable.setUnambiguous(false);
                } else {
                    variable.setUnambiguous(this.isUnambiguous(context));
                }
            } else {
                super.resolve(variable, context);
            }
        }
    }

    protected static class Index
    extends TemplateVariableResolver {
        public Index() {
            super("index", JavaTemplateMessages.getString("JavaContextType.variable.description.index"));
        }

        protected String resolve(TemplateContext context) {
            return ((JavaContext)context).getIndex();
        }
    }

    protected static class Collection
    extends TemplateVariableResolver {
        public Collection() {
            super("collection", JavaTemplateMessages.getString("JavaContextType.variable.description.collection"));
        }

        protected String[] resolveAll(TemplateContext context) {
            String[] collections = ((JavaContext)context).guessCollections();
            if (collections.length > 0) {
                return collections;
            }
            return super.resolveAll(context);
        }
    }

    protected static class Iterator
    extends TemplateVariableResolver {
        public Iterator() {
            super("iterator", JavaTemplateMessages.getString("JavaContextType.variable.description.iterator"));
        }

        protected String resolve(TemplateContext context) {
            JavaContext javaContext = (JavaContext)context;
            if (!context.isReadOnly()) {
                javaContext.addIteratorImport();
            }
            return javaContext.getIterator();
        }
    }

    protected static class Todo
    extends TemplateVariableResolver {
        public Todo() {
            super("todo", JavaTemplateMessages.getString("JavaContextType.variable.description.todo"));
        }

        protected String resolve(TemplateContext context) {
            JavaContext javaContext = (JavaContext)context;
            ICompilationUnit compilationUnit = javaContext.getCompilationUnit();
            if (compilationUnit == null) {
                return "XXX";
            }
            IJavaProject javaProject = compilationUnit.getJavaProject();
            String todoTaskTag = StubUtility.getTodoTaskTag(javaProject);
            if (todoTaskTag == null) {
                return "XXX";
            }
            return todoTaskTag;
        }
    }
}

