/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.surround;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.Selection;
import org.eclipse.jdt.internal.corext.refactoring.util.AbstractExceptionAnalyzer;

public class ExceptionAnalyzer
extends AbstractExceptionAnalyzer {
    private Selection fSelection;

    private ExceptionAnalyzer(Selection selection) {
        Assert.isNotNull(selection);
        this.fSelection = selection;
    }

    public static ITypeBinding[] perform(BodyDeclaration enclosingNode, Selection selection) {
        ExceptionAnalyzer analyzer = new ExceptionAnalyzer(selection);
        enclosingNode.accept((ASTVisitor)analyzer);
        List exceptions = analyzer.getCurrentExceptions();
        Collections.sort(exceptions, new ExceptionComparator());
        return exceptions.toArray(new ITypeBinding[exceptions.size()]);
    }

    public boolean visit(ThrowStatement node) {
        ITypeBinding exception = node.getExpression().resolveTypeBinding();
        if (!this.isSelected((ASTNode)node) || exception == null || Bindings.isRuntimeException(exception)) {
            return true;
        }
        this.addException(exception);
        return true;
    }

    public boolean visit(MethodInvocation node) {
        if (!this.isSelected((ASTNode)node)) {
            return false;
        }
        return this.handleExceptions(node.resolveMethodBinding(), node.getAST());
    }

    public boolean visit(SuperMethodInvocation node) {
        if (!this.isSelected((ASTNode)node)) {
            return false;
        }
        return this.handleExceptions(node.resolveMethodBinding(), node.getAST());
    }

    public boolean visit(ClassInstanceCreation node) {
        if (!this.isSelected((ASTNode)node)) {
            return false;
        }
        return this.handleExceptions(node.resolveConstructorBinding(), node.getAST());
    }

    public boolean visit(ConstructorInvocation node) {
        if (!this.isSelected((ASTNode)node)) {
            return false;
        }
        return this.handleExceptions(node.resolveConstructorBinding(), node.getAST());
    }

    public boolean visit(SuperConstructorInvocation node) {
        if (!this.isSelected((ASTNode)node)) {
            return false;
        }
        return this.handleExceptions(node.resolveConstructorBinding(), node.getAST());
    }

    private boolean handleExceptions(IMethodBinding binding, AST ast) {
        if (binding == null) {
            return true;
        }
        ITypeBinding[] exceptions = binding.getExceptionTypes();
        int i = 0;
        while (i < exceptions.length) {
            this.addException(exceptions[i]);
            ++i;
        }
        return true;
    }

    private boolean isSelected(ASTNode node) {
        return this.fSelection.getVisitSelectionMode(node) == 2;
    }

    private static class ExceptionComparator
    implements Comparator {
        ExceptionComparator() {
        }

        public int compare(Object o1, Object o2) {
            int d2;
            int d1 = this.getDepth((ITypeBinding)o1);
            if (d1 < (d2 = this.getDepth((ITypeBinding)o2))) {
                return 1;
            }
            if (d1 > d2) {
                return -1;
            }
            return 0;
        }

        private int getDepth(ITypeBinding binding) {
            int result = 0;
            while (binding != null) {
                binding = binding.getSuperclass();
                ++result;
            }
            return result;
        }
    }
}

