/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportRewrite;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.corext.dom.OldASTRewrite;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.jdt.internal.corext.refactoring.rename.MethodChecks;
import org.eclipse.jdt.internal.corext.refactoring.rename.RefactoringScopeFactory;
import org.eclipse.jdt.internal.corext.refactoring.rename.RippleMethodFinder;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ASTCreator;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.CompositeOrTypeConstraint;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ConstraintCollector;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ConstraintOperator;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ConstraintVariable;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ConstraintVariableFactory;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ExpressionVariable;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.FullConstraintCreator;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ITypeConstraint;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ParameterTypeVariable;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ReturnTypeVariable;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.SimpleTypeConstraint;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.TypeBindings;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.TypeConstraintFactory;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.TypeVariable;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.WorkingCopyUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class ChangeTypeRefactoring
extends Refactoring {
    private final Map fConstraintCache;
    private final int fSelectionStart;
    private final int fSelectionLength;
    private int fEffectiveSelectionStart;
    private int fEffectiveSelectionLength;
    private ICompilationUnit fCu;
    private IMethodBinding fMethodBinding;
    private int fParamIndex;
    private IVariableBinding fFieldBinding;
    private ICompilationUnit[] fAffectedUnits;
    private Collection fRelevantVars;
    private final Collection fValidTypes;
    private Collection fRelevantConstraints;
    private Collection fAllConstraints;
    private IType fSelectedType;
    private Map fCuToSearchResultGroup = new HashMap();
    private ITypeHierarchy fTypeHierarchy;
    private IType fOriginalTypeOfSelection;
    private static final boolean DEBUG = false;
    private ConstraintVariable fCv;
    private IBinding fSelectionBinding;
    private ITypeBinding fSelectionTypeBinding;
    private ConstraintCollector fCollector;

    public static boolean isAvailable(IJavaElement element) throws JavaModelException {
        if (element == null || !element.exists()) {
            return false;
        }
        String returnType = null;
        if (element instanceof IMethod) {
            returnType = ((IMethod)element).getReturnType();
        } else if (element instanceof IField) {
            returnType = ((IField)element).getTypeSignature();
        } else {
            if (element instanceof ILocalVariable) {
                return true;
            }
            if (element instanceof IType) {
                return true;
            }
        }
        return returnType != null && PrimitiveType.toCode((String)Signature.toString((String)returnType)) == null;
    }

    public static ChangeTypeRefactoring create(ICompilationUnit cu, int selectionStart, int selectionLength) {
        return new ChangeTypeRefactoring(cu, selectionStart, selectionLength);
    }

    public static ChangeTypeRefactoring create(ICompilationUnit cu, int selectionStart, int selectionLength, IType selectedType) {
        return new ChangeTypeRefactoring(cu, selectionStart, selectionLength, selectedType);
    }

    private ChangeTypeRefactoring(ICompilationUnit cu, int selectionStart, int selectionLength) {
        this(cu, selectionStart, selectionLength, null);
    }

    private ChangeTypeRefactoring(ICompilationUnit cu, int selectionStart, int selectionLength, IType selectedType) {
        Assert.isTrue(selectionStart >= 0);
        Assert.isTrue(selectionLength >= 0);
        Assert.isTrue(cu.exists());
        this.fSelectionStart = selectionStart;
        this.fSelectionLength = selectionLength;
        this.fEffectiveSelectionStart = selectionStart;
        this.fEffectiveSelectionLength = selectionLength;
        this.fCu = cu;
        if (selectedType != null) {
            this.setSelectedType(selectedType);
        }
        this.fConstraintCache = new HashMap();
        this.fValidTypes = new HashSet();
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        if (this.fCu == null || !this.fCu.isStructureKnown()) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("ChangeTypeRefactoring.invalidSelection"));
        }
        return this.checkSelection((IProgressMonitor)new SubProgressMonitor(pm, 1));
    }

    private void setSelectionRanges(SimpleName name) {
        this.fEffectiveSelectionStart = name.getStartPosition();
        this.fEffectiveSelectionLength = name.getLength();
        this.fSelectionBinding = ExpressionVariable.resolveBinding((Expression)name);
        this.fSelectionTypeBinding = name.resolveTypeBinding();
    }

    private RefactoringStatus checkSelection(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus result;
        block16: {
            block15: {
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                IMethod selectedMethod;
                                block10: {
                                    RefactoringStatus refactoringStatus;
                                    try {
                                        pm.beginTask("", 5);
                                        ASTNode node = this.getTargetNode(this.fCu, this.fSelectionStart, this.fSelectionLength);
                                        TypeConstraintFactory typeConstraintFactory = new TypeConstraintFactory(){

                                            public boolean filter(ConstraintVariable v1, ConstraintVariable v2, ConstraintOperator o) {
                                                if (o.isStrictSubtypeOperator()) {
                                                    return true;
                                                }
                                                if (v1.getBinding() != null && v2.getBinding() != null && !TypeBindings.isEqualTo(v1.getBinding(), ChangeTypeRefactoring.this.fSelectionTypeBinding) && !TypeBindings.isEqualTo(v2.getBinding(), ChangeTypeRefactoring.this.fSelectionTypeBinding)) {
                                                    return true;
                                                }
                                                return super.filter(v1, v2, o);
                                            }
                                        };
                                        this.fCollector = new ConstraintCollector(new FullConstraintCreator(new ConstraintVariableFactory(), typeConstraintFactory));
                                        String selectionValid = this.determineSelection(node);
                                        if (selectionValid == null) break block10;
                                        refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)selectionValid);
                                        Object var6_13 = null;
                                    }
                                    catch (Throwable throwable) {
                                        Object var6_21 = null;
                                        pm.done();
                                        throw throwable;
                                    }
                                    pm.done();
                                    return refactoringStatus;
                                }
                                if (this.fMethodBinding == null || (selectedMethod = Bindings.findMethod(this.fMethodBinding, this.fCu.getJavaProject())) != null) break block11;
                                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("ChangeTypeRefactoring.insideLocalTypesNotSupported"));
                                Object var6_14 = null;
                                pm.done();
                                return refactoringStatus;
                            }
                            pm.worked(1);
                            result = new RefactoringStatus();
                            if (!this.fSelectionTypeBinding.isArray()) break block12;
                            RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("ChangeTypeRefactoring.arraysNotSupported"));
                            Object var6_15 = null;
                            pm.done();
                            return refactoringStatus;
                        }
                        if (!this.fSelectionTypeBinding.isPrimitive()) break block13;
                        RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("ChangeTypeRefactoring.primitivesNotSupported"));
                        Object var6_16 = null;
                        pm.done();
                        return refactoringStatus;
                    }
                    if (!this.checkOverriddenBinaryMethods()) break block14;
                    RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("ChangeTypeRefactoring.notSupportedOnBinary"));
                    Object var6_17 = null;
                    pm.done();
                    return refactoringStatus;
                }
                if (!this.fSelectionTypeBinding.isLocal()) break block15;
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("ChangeTypeRefactoring.localTypesNotSupported"));
                Object var6_18 = null;
                pm.done();
                return refactoringStatus;
            }
            if (this.fFieldBinding == null || !this.fFieldBinding.getDeclaringClass().isLocal()) break block16;
            RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("ChangeTypeRefactoring.insideLocalTypesNotSupported"));
            Object var6_19 = null;
            pm.done();
            return refactoringStatus;
        }
        this.fOriginalTypeOfSelection = Bindings.findType(this.fSelectionTypeBinding, this.fCu.getJavaProject());
        this.fTypeHierarchy = this.getTypeHierarchy(this.fOriginalTypeOfSelection, pm, this.fCu.getJavaProject());
        pm.worked(1);
        if (this.fSelectedType != null) {
            this.computeValidTypes((IProgressMonitor)new NullProgressMonitor());
        }
        RefactoringStatus refactoringStatus = result;
        Object var6_20 = null;
        pm.done();
        return refactoringStatus;
    }

    private boolean checkOverriddenBinaryMethods() throws JavaModelException {
        if (this.fMethodBinding != null) {
            Set declaringSupertypes = ChangeTypeRefactoring.getDeclaringSuperTypes(this.fMethodBinding);
            Iterator iter = declaringSupertypes.iterator();
            while (iter.hasNext()) {
                ITypeBinding superType = (ITypeBinding)iter.next();
                IMethodBinding overriddenMethod = ChangeTypeRefactoring.findMethod(this.fMethodBinding, superType);
                Assert.isNotNull(overriddenMethod);
                IMethod iMethod = Bindings.findMethod(overriddenMethod, this.fCu.getJavaProject());
                if (!iMethod.isBinary()) continue;
                return true;
            }
        }
        return false;
    }

    private static IMethodBinding findMethod(IMethodBinding methodBinding, ITypeBinding type) {
        if (methodBinding.getDeclaringClass().equals((Object)type)) {
            return methodBinding;
        }
        return Bindings.findMethodInType(type, methodBinding.getName(), methodBinding.getParameterTypes());
    }

    private static Set getDeclaringSuperTypes(IMethodBinding methodBinding) {
        Set allSuperTypes = TypeBindings.getSuperTypes(methodBinding.getDeclaringClass());
        HashSet<ITypeBinding> result = new HashSet<ITypeBinding>();
        Iterator iter = allSuperTypes.iterator();
        while (iter.hasNext()) {
            ITypeBinding type = (ITypeBinding)iter.next();
            if (ChangeTypeRefactoring.findMethod(methodBinding, type) == null) continue;
            result.add(type);
        }
        return result;
    }

    public Collection computeValidTypes(IProgressMonitor pm) {
        pm.beginTask(RefactoringCoreMessages.getString("ChangeTypeRefactoring.checking_preconditions"), 100);
        try {
            this.fCv = this.findConstraintVariableForSelectedNode((IProgressMonitor)new SubProgressMonitor(pm, 3));
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.fRelevantVars = this.findRelevantConstraintVars(this.fCv, (IProgressMonitor)new SubProgressMonitor(pm, 50));
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.fRelevantConstraints = this.findRelevantConstraints(this.fRelevantVars, (IProgressMonitor)new SubProgressMonitor(pm, 30));
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.fValidTypes.addAll(this.computeValidTypes(this.fOriginalTypeOfSelection, this.fRelevantVars, this.fRelevantConstraints, (IProgressMonitor)new SubProgressMonitor(pm, 20)));
        }
        catch (JavaModelException e) {
            JavaPlugin.logErrorMessage("Error occurred during computation of valid types: " + e.toString());
            this.fValidTypes.clear();
        }
        pm.done();
        return this.fValidTypes;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        pm.beginTask(RefactoringCoreMessages.getString("ChangeTypeRefactoring.checking_preconditions"), 1);
        RefactoringStatus result = Checks.validateModifiesFiles(ResourceUtil.getFiles(this.fAffectedUnits), this.getValidationContext());
        pm.done();
        return result;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        DynamicValidationStateChange dynamicValidationStateChange;
        pm.beginTask(RefactoringCoreMessages.getString("ChangeTypeMessages.CreateChangesForChangeType"), 1);
        try {
            HashMap relevantVarsByUnit = new HashMap();
            this.groupChangesByCompilationUnit(relevantVarsByUnit);
            DynamicValidationStateChange result = new DynamicValidationStateChange(RefactoringCoreMessages.getString("ChangeTypeRefactoring.allChanges"));
            Iterator it = relevantVarsByUnit.keySet().iterator();
            while (it.hasNext()) {
                ICompilationUnit icu = (ICompilationUnit)it.next();
                Set cVars = (Set)relevantVarsByUnit.get(icu);
                CompilationUnitChange cuChange = new CompilationUnitChange(this.getName(), icu);
                this.addAllChangesFor(icu, cVars, cuChange);
                result.add((Change)cuChange);
                pm.worked(1);
                if (!pm.isCanceled()) continue;
                throw new OperationCanceledException();
            }
            dynamicValidationStateChange = result;
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return dynamicValidationStateChange;
    }

    /*
     * Exception decompiling
     */
    private void addAllChangesFor(ICompilationUnit icu, Set vars, CompilationUnitChange unitChange) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 107->111)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void updateCu(CompilationUnit unit, Set vars, CompilationUnitChange unitChange, OldASTRewrite unitRewriter, String typeName) throws JavaModelException {
        Iterator it = vars.iterator();
        while (it.hasNext()) {
            ConstraintVariable cv = (ConstraintVariable)it.next();
            ASTNode decl = this.findDeclaration(unit, cv);
            if (decl instanceof SimpleName && cv instanceof ExpressionVariable) {
                ASTNode gp = decl.getParent().getParent();
                this.updateType(unit, ChangeTypeRefactoring.getType(gp), unitChange, unitRewriter, typeName);
                continue;
            }
            if (!(decl instanceof MethodDeclaration) && !(decl instanceof FieldDeclaration)) continue;
            this.updateType(unit, ChangeTypeRefactoring.getType(decl), unitChange, unitRewriter, typeName);
        }
    }

    private void updateType(CompilationUnit cu, Type oldType, CompilationUnitChange unitChange, OldASTRewrite unitRewriter, String typeName) {
        String oldName = oldType.resolveBinding().getName();
        String description = String.valueOf(RefactoringCoreMessages.getString("ChangeTypeRefactoring.typeChange")) + oldName + RefactoringCoreMessages.getString("ChangeTypeRefactoring.to") + typeName;
        TextEditGroup gd = new TextEditGroup(description);
        AST ast = cu.getAST();
        SimpleType newType = ast.newSimpleType((Name)ast.newSimpleName(typeName));
        unitRewriter.replace((ASTNode)oldType, (ASTNode)newType, gd);
        unitChange.addTextEditGroup(gd);
    }

    private void groupChangesByCompilationUnit(Map relevantVarsByUnit) throws JavaModelException {
        Iterator it = this.fRelevantVars.iterator();
        while (it.hasNext()) {
            ConstraintVariable cv = (ConstraintVariable)it.next();
            if (!(cv instanceof ExpressionVariable) && !(cv instanceof ReturnTypeVariable)) continue;
            ICompilationUnit icu = null;
            if (cv instanceof ExpressionVariable) {
                ExpressionVariable ev = (ExpressionVariable)cv;
                icu = ev.getCompilationUnitRange().getCompilationUnit();
            } else if (cv instanceof ReturnTypeVariable) {
                ReturnTypeVariable rtv = (ReturnTypeVariable)cv;
                IMethodBinding mb = rtv.getMethodBinding();
                icu = Bindings.findMethod(mb, this.fCu.getJavaProject()).getCompilationUnit();
            }
            if (!relevantVarsByUnit.containsKey(icu)) {
                relevantVarsByUnit.put(icu, new HashSet());
            }
            ((Set)relevantVarsByUnit.get(icu)).add(cv);
        }
    }

    private ASTNode findDeclaration(CompilationUnit root, ConstraintVariable cv) throws JavaModelException {
        if (this.fFieldBinding != null) {
            IField f = Bindings.findField(this.fFieldBinding, this.fCu.getJavaProject());
            return ASTNodeSearchUtil.getFieldDeclarationNode(f, root);
        }
        if (cv instanceof ExpressionVariable) {
            Iterator iter = this.fAllConstraints.iterator();
            while (iter.hasNext()) {
                ConstraintVariable right;
                SimpleTypeConstraint stc;
                ITypeConstraint constraint = (ITypeConstraint)iter.next();
                if (!constraint.isSimpleTypeConstraint() || !(stc = (SimpleTypeConstraint)constraint).isDefinesConstraint() || !stc.getLeft().equals(cv) || !((right = stc.getRight()) instanceof TypeVariable)) continue;
                TypeVariable typeVariable = (TypeVariable)right;
                return NodeFinder.perform((ASTNode)root, typeVariable.getCompilationUnitRange().getSourceRange());
            }
        } else if (cv instanceof ReturnTypeVariable) {
            ReturnTypeVariable rtv = (ReturnTypeVariable)cv;
            IMethodBinding mb = rtv.getMethodBinding();
            IMethod im = Bindings.findMethod(mb, this.fCu.getJavaProject());
            return ASTNodeSearchUtil.getMethodDeclarationNode(im, root);
        }
        return null;
    }

    private static Type getType(ASTNode node) {
        switch (node.getNodeType()) {
            case 44: {
                return ((SingleVariableDeclaration)node).getType();
            }
            case 23: {
                return ((FieldDeclaration)node).getType();
            }
            case 60: {
                return ((VariableDeclarationStatement)node).getType();
            }
            case 31: {
                return ((MethodDeclaration)node).getReturnType();
            }
        }
        Assert.isTrue(false);
        return null;
    }

    public String getName() {
        return RefactoringCoreMessages.getString("ChangeTypeRefactoring.name");
    }

    private String determineSelection(ASTNode node) {
        if (node == null) {
            return RefactoringCoreMessages.getString("ChangeTypeRefactoring.invalidSelection");
        }
        switch (node.getNodeType()) {
            case 42: {
                return this.simpleNameSelected((SimpleName)node);
            }
            case 60: {
                return this.variableDeclarationStatementSelected((VariableDeclarationStatement)node);
            }
            case 23: {
                return this.fieldDeclarationSelected((FieldDeclaration)node);
            }
            case 44: {
                return this.singleVariableDeclarationSelected((SingleVariableDeclaration)node);
            }
        }
        return ChangeTypeRefactoring.nodeTypeNotSupported();
    }

    private static String nodeTypeNotSupported() {
        return RefactoringCoreMessages.getString("ChangeTypeRefactoring.notSupportedOnNodeType");
    }

    private String singleVariableDeclarationSelected(SingleVariableDeclaration svd) {
        SimpleName name = svd.getName();
        this.setSelectionRanges(name);
        return this.simpleNameSelected(name);
    }

    private String variableDeclarationStatementSelected(VariableDeclarationStatement vds) {
        if (vds.fragments().size() != 1) {
            return RefactoringCoreMessages.getString("ChangeTypeRefactoring.multiDeclarationsNotSupported");
        }
        VariableDeclarationFragment elem = (VariableDeclarationFragment)vds.fragments().iterator().next();
        SimpleName name = elem.getName();
        this.setSelectionRanges(name);
        return this.simpleNameSelected(name);
    }

    private String fieldDeclarationSelected(FieldDeclaration fieldDeclaration) {
        if (fieldDeclaration.fragments().size() != 1) {
            return RefactoringCoreMessages.getString("ChangeTypeRefactoring.multiDeclarationsNotSupported");
        }
        VariableDeclarationFragment elem = (VariableDeclarationFragment)fieldDeclaration.fragments().iterator().next();
        this.fFieldBinding = elem.resolveBinding();
        SimpleName name = elem.getName();
        this.setSelectionRanges(name);
        return this.simpleNameSelected(name);
    }

    private String simpleNameSelected(SimpleName simpleName) {
        ASTNode parent = simpleName.getParent();
        ASTNode grandParent = parent.getParent();
        if (parent.getNodeType() == 60) {
            VariableDeclarationStatement vds = (VariableDeclarationStatement)parent;
            if (vds.fragments().size() > 1) {
                return RefactoringCoreMessages.getString("ChangeTypeRefactoring.multiDeclarationsNotSupported");
            }
        } else if (parent.getNodeType() == 59) {
            if (grandParent.getNodeType() == 60) {
                VariableDeclarationStatement vds = (VariableDeclarationStatement)grandParent;
                if (vds.fragments().size() > 1) {
                    return RefactoringCoreMessages.getString("ChangeTypeRefactoring.multiDeclarationsNotSupported");
                }
                this.setSelectionRanges(simpleName);
            } else if (grandParent.getNodeType() == 58) {
                VariableDeclarationExpression vde = (VariableDeclarationExpression)grandParent;
                if (vde.fragments().size() > 1) {
                    return RefactoringCoreMessages.getString("ChangeTypeRefactoring.multiDeclarationsNotSupported");
                }
                this.setSelectionRanges(simpleName);
            } else if (grandParent.getNodeType() == 23) {
                FieldDeclaration fd = (FieldDeclaration)grandParent;
                if (fd.fragments().size() > 1) {
                    return RefactoringCoreMessages.getString("ChangeTypeRefactoring.multiDeclarationsNotSupported");
                }
                VariableDeclarationFragment fragment = (VariableDeclarationFragment)parent;
                this.fFieldBinding = fragment.resolveBinding();
                this.setSelectionRanges(fragment.getName());
            }
        } else if (parent.getNodeType() == 44 || parent.getNodeType() == 59) {
            if (grandParent.getNodeType() == 31) {
                this.fMethodBinding = ((MethodDeclaration)grandParent).resolveBinding();
                this.fSelectionTypeBinding = simpleName.resolveTypeBinding();
                this.fParamIndex = ((MethodDeclaration)grandParent).parameters().indexOf(parent);
            }
        } else if (parent.getNodeType() == 43 && grandParent.getNodeType() == 44) {
            ASTNode greatGrandParent = grandParent.getParent();
            if (greatGrandParent != null && greatGrandParent.getNodeType() == 31) {
                this.fMethodBinding = ((MethodDeclaration)greatGrandParent).resolveBinding();
                this.fParamIndex = ((MethodDeclaration)greatGrandParent).parameters().indexOf(grandParent);
            }
            this.setSelectionRanges(simpleName);
        } else if (parent.getNodeType() == 43 && grandParent.getNodeType() == 31) {
            this.fMethodBinding = ((MethodDeclaration)grandParent).resolveBinding();
            this.fSelectionTypeBinding = this.fMethodBinding.getReturnType();
            this.fParamIndex = -1;
        } else if (parent.getNodeType() == 31 && grandParent.getNodeType() == 55) {
            MethodDeclaration methodDeclaration = (MethodDeclaration)parent;
            if (methodDeclaration.getName().equals((Object)simpleName)) {
                return RefactoringCoreMessages.getString("ChangeTypeRefactoring.notSupportedOnNodeType");
            }
            this.fMethodBinding = ((MethodDeclaration)parent).resolveBinding();
            this.fParamIndex = -1;
        } else {
            if (parent.getNodeType() == 43 && grandParent.getNodeType() == 60) {
                return this.variableDeclarationStatementSelected((VariableDeclarationStatement)grandParent);
            }
            if (parent.getNodeType() == 11) {
                ASTNode decl = ChangeTypeRefactoring.findDeclaration(parent.getRoot(), this.fSelectionStart, this.fSelectionLength + 1);
                VariableDeclarationFragment fragment = (VariableDeclarationFragment)decl;
                SimpleName name = fragment.getName();
                this.setSelectionRanges(name);
            } else {
                if (parent.getNodeType() == 43 && grandParent.getNodeType() == 23) {
                    return this.fieldDeclarationSelected((FieldDeclaration)grandParent);
                }
                if (parent.getNodeType() == 43 && grandParent.getNodeType() == 5) {
                    return RefactoringCoreMessages.getString("ChangeTypeRefactoring.arraysNotSupported");
                }
                if (parent.getNodeType() == 40) {
                    this.setSelectionRanges(simpleName);
                } else {
                    return RefactoringCoreMessages.getString("ChangeTypeRefactoring.notSupportedOnNodeType");
                }
            }
        }
        return null;
    }

    private ConstraintVariable findConstraintVariableForSelectedNode(IProgressMonitor pm) {
        pm.beginTask(RefactoringCoreMessages.getString("ChangeTypeRefactoring.analyzingMessage"), 100);
        ICompilationUnit[] cus = new ICompilationUnit[]{this.fCu};
        Collection allConstraints = this.getConstraints(cus, (IProgressMonitor)new SubProgressMonitor(pm, 50));
        SubProgressMonitor subMonitor = new SubProgressMonitor(pm, 50);
        subMonitor.beginTask(RefactoringCoreMessages.getString("ChangeTypeRefactoring.analyzingMessage"), allConstraints.size());
        Iterator it = allConstraints.iterator();
        while (it.hasNext()) {
            subMonitor.worked(1);
            ITypeConstraint tc = (ITypeConstraint)it.next();
            if (!(tc instanceof SimpleTypeConstraint)) continue;
            SimpleTypeConstraint stc = (SimpleTypeConstraint)tc;
            if (this.matchesSelection(stc.getLeft())) {
                return stc.getLeft();
            }
            if (!this.matchesSelection(stc.getRight())) continue;
            return stc.getRight();
        }
        subMonitor.done();
        pm.done();
        Assert.isTrue(false, RefactoringCoreMessages.getString("ChangeTypeRefactoring.noMatchingConstraintVariable"));
        return null;
    }

    private boolean matchesSelection(ConstraintVariable cv) {
        if (cv instanceof ExpressionVariable) {
            ExpressionVariable ev = (ExpressionVariable)cv;
            return this.fSelectionBinding != null && Bindings.equals(this.fSelectionBinding, ev.getExpressionBinding());
        }
        if (cv instanceof ParameterTypeVariable) {
            ParameterTypeVariable ptv = (ParameterTypeVariable)cv;
            if (this.fMethodBinding != null && Bindings.equals((IBinding)ptv.getMethodBinding(), (IBinding)this.fMethodBinding) && ptv.getParameterIndex() == this.fParamIndex) {
                return true;
            }
        } else if (cv instanceof ReturnTypeVariable) {
            ReturnTypeVariable rtv = (ReturnTypeVariable)cv;
            if (this.fMethodBinding != null && Bindings.equals((IBinding)rtv.getMethodBinding(), (IBinding)this.fMethodBinding) && this.fParamIndex == -1) {
                return true;
            }
        }
        return false;
    }

    private Collection findRelevantConstraintVars(ConstraintVariable cv, IProgressMonitor pm) throws JavaModelException {
        pm.beginTask(RefactoringCoreMessages.getString("ChangeTypeRefactoring.analyzingMessage"), 150);
        HashSet<ConstraintVariable> result = new HashSet<ConstraintVariable>();
        result.add(cv);
        ICompilationUnit[] cus = this.collectAffectedUnits((IProgressMonitor)new SubProgressMonitor(pm, 50));
        Collection allConstraints = this.getConstraints(cus, (IProgressMonitor)new SubProgressMonitor(pm, 50));
        ArrayList<ConstraintVariable> workList = new ArrayList<ConstraintVariable>(result);
        while (!workList.isEmpty()) {
            pm.worked(10);
            ConstraintVariable first = (ConstraintVariable)workList.remove(0);
            Iterator iter = allConstraints.iterator();
            while (iter.hasNext()) {
                ConstraintVariable match;
                SimpleTypeConstraint stc;
                pm.worked(1);
                ITypeConstraint typeConstraint = (ITypeConstraint)iter.next();
                if (!typeConstraint.isSimpleTypeConstraint() || !(stc = (SimpleTypeConstraint)typeConstraint).isDefinesConstraint() && !stc.isEqualsConstraint() || !((match = ChangeTypeRefactoring.match(first, stc.getLeft(), stc.getRight())) instanceof ExpressionVariable) && !(match instanceof ParameterTypeVariable) && !(match instanceof ReturnTypeVariable) || result.contains(match)) continue;
                workList.add(match);
                result.add(match);
            }
        }
        pm.done();
        return result;
    }

    private static ConstraintVariable match(ConstraintVariable matchee, ConstraintVariable left, ConstraintVariable right) {
        if (matchee.equals(left)) {
            return right;
        }
        if (matchee.equals(right)) {
            return left;
        }
        return null;
    }

    private Collection findRelevantConstraints(Collection relevantConstraintVars, IProgressMonitor pm) throws JavaModelException {
        ICompilationUnit[] cus = this.collectAffectedUnits((IProgressMonitor)new SubProgressMonitor(pm, 100));
        this.fAllConstraints = this.getConstraints(cus, (IProgressMonitor)new SubProgressMonitor(pm, 900));
        pm.beginTask(RefactoringCoreMessages.getString("ChangeTypeRefactoring.analyzingMessage"), 1000 + this.fAllConstraints.size());
        ArrayList<ITypeConstraint> result = new ArrayList<ITypeConstraint>();
        Iterator it = this.fAllConstraints.iterator();
        while (it.hasNext()) {
            ITypeConstraint tc = (ITypeConstraint)it.next();
            if (tc.isSimpleTypeConstraint()) {
                SimpleTypeConstraint stc = (SimpleTypeConstraint)tc;
                if (stc.isDefinesConstraint() || stc.isEqualsConstraint() || stc.getLeft().equals(stc.getRight()) || ChangeTypeRefactoring.isNull(stc.getLeft())) continue;
                if (relevantConstraintVars.contains(stc.getLeft()) || relevantConstraintVars.contains(stc.getRight())) {
                    result.add(tc);
                }
            } else {
                CompositeOrTypeConstraint cotc = (CompositeOrTypeConstraint)tc;
                ITypeConstraint[] components = cotc.getConstraints();
                int i = 0;
                while (i < components.length) {
                    ITypeConstraint component = components[i];
                    SimpleTypeConstraint simpleComponent = (SimpleTypeConstraint)component;
                    if (relevantConstraintVars.contains(simpleComponent.getLeft())) {
                        result.add(tc);
                    }
                    ++i;
                }
            }
            pm.worked(1);
        }
        pm.done();
        return result;
    }

    private static ASTNode findDeclaration(ASTNode root, int start, int length) {
        ASTNode node = NodeFinder.perform(root, start, length);
        Assert.isTrue(node instanceof SimpleName, String.valueOf(node.getNodeType()));
        Assert.isTrue(root instanceof CompilationUnit, String.valueOf(root.getNodeType()));
        return ((CompilationUnit)root).findDeclaringNode(((SimpleName)node).resolveBinding());
    }

    private Collection computeValidTypes(IType originalType, Collection relevantVars, Collection relevantConstraints, IProgressMonitor pm) throws JavaModelException {
        HashSet<IType> result = new HashSet<IType>();
        IJavaProject project = this.fCu.getJavaProject();
        HashSet<IType> allTypes = new HashSet<IType>();
        allTypes.addAll(Arrays.asList(this.fTypeHierarchy.getAllSupertypes(originalType)));
        if (this.fOriginalTypeOfSelection.isInterface()) {
            IType object = JavaModelUtil.findType(this.fCu.getJavaProject(), "java.lang.Object");
            allTypes.add(object);
        }
        pm.beginTask(RefactoringCoreMessages.getString("ChangeTypeRefactoring.analyzingMessage"), allTypes.size());
        Iterator it = allTypes.iterator();
        while (it.hasNext()) {
            IType type = (IType)it.next();
            if (!this.isValid(project, type, relevantVars, relevantConstraints, (IProgressMonitor)new SubProgressMonitor(pm, 1))) continue;
            result.add(type);
        }
        result.remove(originalType);
        pm.done();
        return result;
    }

    private ITypeHierarchy getTypeHierarchy(IType originalType, IProgressMonitor pm, IJavaProject project) throws JavaModelException {
        return originalType.newSupertypeHierarchy(pm);
    }

    private boolean isValid(IJavaProject project, IType type, Collection relevantVars, Collection constraints, IProgressMonitor pm) throws JavaModelException {
        pm.beginTask(RefactoringCoreMessages.getString("ChangeTypeRefactoring.analyzingMessage"), constraints.size());
        Iterator it = constraints.iterator();
        while (it.hasNext()) {
            ITypeConstraint tc = (ITypeConstraint)it.next();
            if (tc instanceof SimpleTypeConstraint ? !this.isValidSimpleConstraint(project, type, relevantVars, (SimpleTypeConstraint)tc) : tc instanceof CompositeOrTypeConstraint && !this.isValidOrConstraint(project, type, relevantVars, (CompositeOrTypeConstraint)tc)) {
                return false;
            }
            pm.worked(1);
        }
        pm.done();
        return true;
    }

    private boolean isValidSimpleConstraint(IJavaProject project, IType type, Collection relevantVars, SimpleTypeConstraint stc) throws JavaModelException {
        return !relevantVars.contains(stc.getLeft()) || this.isSubTypeOf(type, this.findType(project, stc.getRight()));
    }

    private boolean isValidOrConstraint(IJavaProject project, IType type, Collection relevantVars, CompositeOrTypeConstraint cotc) throws JavaModelException {
        ITypeConstraint[] components = cotc.getConstraints();
        int i = 0;
        while (i < components.length) {
            SimpleTypeConstraint sc;
            if (components[i] instanceof SimpleTypeConstraint && (relevantVars.contains((sc = (SimpleTypeConstraint)components[i]).getLeft()) ? this.isSubTypeOf(type, this.findType(project, sc.getRight())) : relevantVars.contains(sc.getRight()) && this.isSubTypeOf(this.findType(project, sc.getLeft()), type))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private IType findType(IJavaProject project, ConstraintVariable cv) throws JavaModelException {
        return JavaModelUtil.findType(project, cv.getBinding().getQualifiedName());
    }

    private Collection getConstraints(ICompilationUnit[] referringCus, IProgressMonitor pm) {
        pm.beginTask(RefactoringCoreMessages.getString("ChangeTypeRefactoring.analyzingMessage"), referringCus.length);
        ArrayList result = new ArrayList();
        int i = 0;
        while (i < referringCus.length) {
            result.addAll(this.getConstraints(referringCus[i]));
            pm.worked(1);
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            ++i;
        }
        pm.done();
        return result;
    }

    private List getConstraints(ICompilationUnit unit) {
        if (this.fConstraintCache.containsKey(unit)) {
            return (List)this.fConstraintCache.get(unit);
        }
        CompilationUnit cu = ASTCreator.createAST(unit, null);
        if (this.fMethodBinding != null && this.fCuToSearchResultGroup.containsKey(unit)) {
            SearchResultGroup group = (SearchResultGroup)this.fCuToSearchResultGroup.get(unit);
            ASTNode[] nodes = ASTNodeSearchUtil.getAstNodes(group.getSearchResults(), cu);
            int i = 0;
            while (i < nodes.length) {
                ASTNode node = nodes[i];
                if (this.fMethodBinding != null) {
                    ASTNode n = node;
                    while (!(n instanceof MethodDeclaration)) {
                        n = n.getParent();
                    }
                    MethodDeclaration md = (MethodDeclaration)n;
                    md.accept((ASTVisitor)this.fCollector);
                }
                ++i;
            }
        } else {
            cu.accept((ASTVisitor)this.fCollector);
        }
        List<ITypeConstraint> constraints = Arrays.asList(this.fCollector.getConstraints());
        this.fConstraintCache.put(unit, constraints);
        return constraints;
    }

    private String updateImports(ICompilationUnit icu, TextBuffer buffer, MultiTextEdit rootEdit) throws CoreException {
        ImportRewrite rewrite = new ImportRewrite(icu);
        String typeName = rewrite.addImport(this.fSelectedType.getFullyQualifiedName());
        rootEdit.addChild(rewrite.createEdit(buffer.getDocument()));
        return typeName;
    }

    public Collection getValidTypes() {
        return this.fValidTypes;
    }

    public IType getOriginalType() {
        return this.fOriginalTypeOfSelection;
    }

    public ITypeHierarchy getTypeHierarchy() {
        return this.fTypeHierarchy;
    }

    public Collection getValidTypeNames() {
        ArrayList<String> typeNames = new ArrayList<String>();
        Iterator it = this.fValidTypes.iterator();
        while (it.hasNext()) {
            IType type = (IType)it.next();
            typeNames.add(type.getFullyQualifiedName());
        }
        return typeNames;
    }

    private ASTNode getTargetNode(ICompilationUnit unit, int offset, int length) {
        CompilationUnit root = ASTCreator.createAST(unit, null);
        ASTNode node = NodeFinder.perform((ASTNode)root, offset, length);
        return node;
    }

    private ICompilationUnit[] collectAffectedUnits(IProgressMonitor pm) throws JavaModelException {
        pm.beginTask(RefactoringCoreMessages.getString("ChangeTypeRefactoring.analyzingMessage"), 100);
        if (this.fAffectedUnits != null) {
            pm.worked(100);
            return this.fAffectedUnits;
        }
        if (this.fMethodBinding != null) {
            IJavaProject project = this.fCu.getJavaProject();
            if (this.fMethodBinding != null) {
                IMethod inInterface;
                IMethod root;
                IMethod selectedMethod = Bindings.findMethod(this.fMethodBinding, project);
                if (selectedMethod == null) {
                    Assert.isTrue(false, RefactoringCoreMessages.getString("ChangeTypeRefactoring.no_method"));
                }
                if (!(root = selectedMethod).getDeclaringType().isInterface() && MethodChecks.isVirtual(root) && (inInterface = MethodChecks.isDeclaredInInterface(root, (IProgressMonitor)new SubProgressMonitor(pm, 5))) != null && !inInterface.equals(root)) {
                    root = inInterface;
                }
                IMethod[] rippleMethods = RippleMethodFinder.getRelatedMethods(root, (IProgressMonitor)new SubProgressMonitor(pm, 15), null);
                SearchPattern pattern = RefactoringSearchEngine.createOrPattern((IJavaElement[])rippleMethods, 3);
                IJavaSearchScope scope = RefactoringScopeFactory.create((IJavaElement)selectedMethod);
                ICompilationUnit[] workingCopies = null;
                SearchResultGroup[] groups = RefactoringSearchEngine.search(pattern, scope, (IProgressMonitor)new SubProgressMonitor(pm, 80), workingCopies, new RefactoringStatus());
                this.fAffectedUnits = this.getCus(groups);
            }
        } else if (this.fFieldBinding != null) {
            IField iField = Bindings.findField(this.fFieldBinding, this.fCu.getJavaProject());
            if (iField == null) {
                Assert.isTrue(false, RefactoringCoreMessages.getString("ChangeTypeRefactoring.no_filed"));
            }
            SearchPattern pattern = SearchPattern.createPattern((IJavaElement)iField, (int)3);
            IJavaSearchScope scope = RefactoringScopeFactory.create((IJavaElement)iField);
            ICompilationUnit[] workingCopies = null;
            SearchResultGroup[] groups = RefactoringSearchEngine.search(pattern, scope, (IProgressMonitor)new SubProgressMonitor(pm, 100), workingCopies, new RefactoringStatus());
            this.fAffectedUnits = this.getCus(groups);
        } else {
            this.fAffectedUnits = new ICompilationUnit[]{this.fCu};
        }
        pm.done();
        return this.fAffectedUnits;
    }

    public void setSelectedType(IType type) {
        this.fSelectedType = type;
    }

    private static boolean isNull(ConstraintVariable cv) {
        return cv instanceof ExpressionVariable && ((ExpressionVariable)cv).getExpressionType() == 33;
    }

    void printCollection(String title, Collection l) {
        System.out.println(String.valueOf(l.size()) + " " + title);
        Iterator it = l.iterator();
        while (it.hasNext()) {
            System.out.println("  " + it.next());
        }
    }

    private ICompilationUnit[] getCus(SearchResultGroup[] groups) {
        ArrayList<ICompilationUnit> result = new ArrayList<ICompilationUnit>(groups.length);
        int i = 0;
        while (i < groups.length) {
            SearchResultGroup group = groups[i];
            ICompilationUnit cu = group.getCompilationUnit();
            if (cu != null) {
                result.add(WorkingCopyUtil.getWorkingCopyIfExists(cu));
            }
            this.fCuToSearchResultGroup.put(cu, group);
            ++i;
        }
        return result.toArray(new ICompilationUnit[result.size()]);
    }

    public boolean isSubTypeOf(IType type1, IType type2) {
        if (type2.getFullyQualifiedName().equals("java.lang.Object")) {
            return true;
        }
        if (type1.equals(type2)) {
            return true;
        }
        IType[] superTypes = this.fTypeHierarchy.getAllSupertypes(type1);
        int i = 0;
        while (i < superTypes.length) {
            if (superTypes[i].equals(type2)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public IJavaProject getProject() {
        return this.fCu.getJavaProject();
    }
}

