/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.changes;

import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.ISourceManipulation;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.changes.AbstractDeleteChange;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringFileBuffers;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class DeleteSourceManipulationChange
extends AbstractDeleteChange {
    private String fHandle;

    public DeleteSourceManipulationChange(ISourceManipulation sm) {
        Assert.isNotNull(sm);
        this.fHandle = DeleteSourceManipulationChange.getJavaElement(sm).getHandleIdentifier();
    }

    public String getName() {
        return RefactoringCoreMessages.getFormattedString("DeleteSourceManipulationChange.0", this.getElementName());
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        ISourceManipulation element = this.getSourceModification();
        if (element instanceof ICompilationUnit) {
            return super.isValid(pm, false, false);
        }
        return super.isValid(pm, false, true);
    }

    private String getElementName() {
        IJavaElement javaElement = DeleteSourceManipulationChange.getJavaElement(this.getSourceModification());
        if (JavaElementUtil.isDefaultPackage(javaElement)) {
            return RefactoringCoreMessages.getString("DeleteSourceManipulationChange.1");
        }
        return javaElement.getElementName();
    }

    public Object getModifiedElement() {
        return JavaCore.create((String)this.fHandle);
    }

    protected void doDelete(IProgressMonitor pm) throws CoreException {
        ISourceManipulation element = this.getSourceModification();
        if (element instanceof ICompilationUnit) {
            pm.beginTask("", 2);
            ICompilationUnit unit = (ICompilationUnit)element;
            DeleteSourceManipulationChange.saveCUnitIfNeeded(unit, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            element.delete(false, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        } else if (element instanceof IPackageFragment) {
            ICompilationUnit[] units = ((IPackageFragment)element).getCompilationUnits();
            pm.beginTask("", units.length + 1);
            int i = 0;
            while (i < units.length) {
                DeleteSourceManipulationChange.saveCUnitIfNeeded(units[i], (IProgressMonitor)new SubProgressMonitor(pm, 1));
                ++i;
            }
            element.delete(false, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        } else {
            element.delete(false, pm);
        }
    }

    private ISourceManipulation getSourceModification() {
        return (ISourceManipulation)this.getModifiedElement();
    }

    private static IJavaElement getJavaElement(ISourceManipulation sm) {
        return (IJavaElement)sm;
    }

    private static void saveCUnitIfNeeded(ICompilationUnit unit, IProgressMonitor pm) throws CoreException {
        ITextFileBuffer buffer = RefactoringFileBuffers.getTextFileBuffer(unit);
        if (buffer != null && buffer.isDirty() && buffer.isStateValidated() && buffer.isSynchronized()) {
            buffer.commit(pm, false);
        } else {
            pm.beginTask("", 1);
            pm.worked(1);
            pm.done();
        }
    }
}

