/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.base;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public abstract class JDTChange
extends Change {
    static /* synthetic */ Class class$0;

    public void initializeValidationData(IProgressMonitor pm) {
    }

    protected RefactoringStatus isValid(IProgressMonitor pm, boolean checkReadOnly, boolean checkDirty) throws CoreException {
        pm.beginTask("", 1);
        RefactoringStatus result = new RefactoringStatus();
        IResource resource = JDTChange.getResource(this.getModifiedElement());
        if (resource != null) {
            JDTChange.checkIfModifiable(result, resource, checkReadOnly, checkDirty);
        }
        pm.worked(1);
        return result;
    }

    public String toString() {
        return this.getName();
    }

    protected static void checkIfModifiable(RefactoringStatus status, Object element, boolean checkReadOnly, boolean checkDirty) {
        IResource resource = JDTChange.getResource(element);
        if (resource != null) {
            JDTChange.checkIfModifiable(status, resource, checkReadOnly, checkDirty);
        }
    }

    protected static void checkIfModifiable(RefactoringStatus status, IResource resource, boolean checkReadOnly, boolean checkDirty) {
        if (checkReadOnly) {
            JDTChange.checkReadOnly(status, resource);
        }
        if (checkDirty) {
            JDTChange.checkIfDirty(status, resource);
        }
    }

    protected static void checkReadOnly(RefactoringStatus status, IResource resource) {
        if (resource.isReadOnly()) {
            status.addFatalError(RefactoringCoreMessages.getFormattedString("Change.is_read_only", resource.getFullPath().toString()));
        }
    }

    protected static void checkIfDirty(RefactoringStatus status, IResource resource) {
        ITextFileBufferManager manager;
        ITextFileBuffer buffer;
        IFile file;
        if (resource instanceof IFile && (file = (IFile)resource).exists() && (buffer = (manager = FileBuffers.getTextFileBufferManager()).getTextFileBuffer(file.getFullPath())) != null && buffer.isDirty()) {
            status.addFatalError(RefactoringCoreMessages.getFormattedString("Change.is_unsaved", file.getFullPath().toString()));
        }
    }

    private static IResource getResource(Object element) {
        if (element instanceof IResource) {
            return (IResource)element;
        }
        if (element instanceof ICompilationUnit) {
            return JavaModelUtil.toOriginal((ICompilationUnit)element).getResource();
        }
        if (element instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)element;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (IResource)iAdaptable.getAdapter((Class)clazz);
        }
        return null;
    }
}

