/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.monitors;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.monitors.DeadLocksViewContentProvider;
import org.eclipse.jdt.internal.debug.ui.monitors.ThreadWrapper;

public class MonitorManager {
    private Map fThreadToOwnedMonitors = new Hashtable(4);
    private Map fThreadToContendedMonitor = new Hashtable(4);
    private Map fMonitorToOwningThread = new Hashtable();
    private Map fMonitorToContendingThreads = new Hashtable();
    private static MonitorManager fgDefault = null;
    private DeadLocksViewContentProvider fDeadlockUpdateListener;
    private List fDeadLockLists = new ArrayList();

    private MonitorManager() {
    }

    public static MonitorManager getDefault() {
        if (fgDefault == null) {
            fgDefault = new MonitorManager();
        }
        return fgDefault;
    }

    protected void addThreadWithOwnedMonitors(IJavaThread thread, IJavaObject[] monitors) {
        if (monitors == null) {
            this.fThreadToOwnedMonitors.remove(thread);
        } else {
            this.fThreadToOwnedMonitors.put(thread, monitors);
        }
    }

    protected void addThreadWithContendedMonitor(IJavaThread thread, IJavaObject monitor) {
        if (monitor == null) {
            this.fThreadToContendedMonitor.remove(thread);
        } else {
            this.fThreadToContendedMonitor.put(thread, monitor);
        }
    }

    protected void addMonitorWithOwningThread(IJavaObject monitor, IJavaThread thread) {
        if (monitor == null) {
            this.fMonitorToOwningThread.remove(monitor);
        } else {
            this.fMonitorToOwningThread.put(monitor, thread);
        }
    }

    protected void addMonitorWithContendedThread(IJavaObject monitor, IJavaThread thread) {
        if (monitor == null) {
            this.fMonitorToContendingThreads.remove(monitor);
        } else {
            ArrayList<IJavaThread> threads = (ArrayList<IJavaThread>)this.fMonitorToContendingThreads.get(monitor);
            if (threads == null) {
                threads = new ArrayList<IJavaThread>();
                this.fMonitorToContendingThreads.put(monitor, threads);
            }
            threads.add(thread);
        }
    }

    public IJavaObject[] getOwnedMonitors(IJavaThread thread) {
        return (IJavaObject[])this.fThreadToOwnedMonitors.get(thread);
    }

    public IJavaObject getContendedMonitor(IJavaThread thread) {
        return (IJavaObject)this.fThreadToContendedMonitor.get(thread);
    }

    public IJavaThread getOwningThread(IJavaObject monitor) {
        return (IJavaThread)this.fMonitorToOwningThread.get(monitor);
    }

    public List getContendingThreads(IJavaObject monitor) {
        Object obj = this.fMonitorToContendingThreads.get(monitor);
        return (List)obj;
    }

    public IJavaThread[] getThreads() {
        HashSet all = new HashSet();
        all.addAll(this.fThreadToContendedMonitor.keySet());
        all.addAll(this.fThreadToOwnedMonitors.keySet());
        return all.toArray(new IJavaThread[all.size()]);
    }

    public IJavaObject[] getMonitors() {
        HashSet all = new HashSet();
        all.addAll(this.fMonitorToContendingThreads.keySet());
        all.addAll(this.fMonitorToOwningThread.keySet());
        return all.toArray(new IJavaObject[all.size()]);
    }

    public void update(IJavaDebugTarget target) {
        this.removeMonitorInformation(target);
        if (!target.supportsMonitorInformation()) {
            return;
        }
        if (this.fDeadlockUpdateListener != null) {
            this.fDeadlockUpdateListener.clearDeadlockInformation();
        }
        this.update(target, true);
    }

    public void updatePartial(IJavaDebugTarget target) {
        this.removeMonitorInformation(target);
        if (!target.supportsMonitorInformation()) {
            return;
        }
        if (this.fDeadlockUpdateListener != null) {
            this.fDeadlockUpdateListener.clearDeadlockInformation();
        }
        this.update(target, false);
    }

    private void update(IJavaDebugTarget target, boolean suspendThreads) {
        try {
            IJavaThread thread;
            IThread[] threadResult = target.getThreads();
            ArrayList<IJavaThread> threadsList = new ArrayList<IJavaThread>(threadResult.length);
            int i = 0;
            while (i < threadResult.length) {
                thread = (IJavaThread)threadResult[i];
                threadsList.add(thread);
                ++i;
            }
            IJavaThread[] threads = threadsList.toArray(new IJavaThread[threadsList.size()]);
            if (suspendThreads) {
                this.suspend(threads);
            }
            int i2 = 0;
            while (i2 < threads.length) {
                thread = threads[i2];
                this.updateMonitors(thread);
                ++i2;
            }
            i2 = 0;
            while (i2 < threads.length) {
                thread = threads[i2];
                this.updateDeadlock(thread);
                ++i2;
            }
        }
        catch (DebugException debugException) {}
    }

    private void updateDeadlock(IJavaThread thread) {
        List l = this.listToDeadlock(thread, new ArrayList(4));
        if (l != null) {
            ThreadWrapper tw = new ThreadWrapper(thread, l);
            this.fDeadLockLists.add(tw);
        }
    }

    private void updateMonitors(IJavaThread thread) throws DebugException {
        IJavaObject[] ownedMonitors = thread.getOwnedMonitors();
        IJavaObject currentContendedMonitor = thread.getContendedMonitor();
        if (thread.hasOwnedMonitors()) {
            this.addThreadWithOwnedMonitors(thread, ownedMonitors);
            int j = 0;
            while (j < ownedMonitors.length) {
                IJavaObject monitor = ownedMonitors[j];
                this.addMonitorWithOwningThread(monitor, thread);
                ++j;
            }
        }
        if (currentContendedMonitor != null) {
            this.addThreadWithContendedMonitor(thread, currentContendedMonitor);
            this.addMonitorWithContendedThread(currentContendedMonitor, thread);
        }
    }

    private void suspend(IJavaThread[] threads) {
        try {
            int i = 0;
            while (i < threads.length) {
                IJavaThread thread = threads[i];
                if (!thread.isSuspended()) {
                    thread.suspend();
                    while (!thread.isSuspended()) {
                        Thread.sleep(100L);
                    }
                }
                ++i;
            }
        }
        catch (DebugException e) {
            JDIDebugUIPlugin.log(e);
        }
        catch (InterruptedException e) {
            JDIDebugUIPlugin.log(e);
        }
    }

    public void removeMonitorInformation(IJavaDebugTarget target) {
        this.fThreadToOwnedMonitors.clear();
        this.fThreadToContendedMonitor.clear();
        this.fMonitorToOwningThread.clear();
        this.fMonitorToContendingThreads.clear();
        this.fDeadLockLists.clear();
        if (this.fDeadlockUpdateListener != null) {
            this.fDeadlockUpdateListener.clearDeadlockInformation();
        }
    }

    private List listToDeadlock(IJavaThread thread, List usedThreadsList) {
        ArrayList<Object> res = new ArrayList<Object>();
        IJavaObject contendedMonitor = (IJavaObject)this.fThreadToContendedMonitor.get(thread);
        if (contendedMonitor != null) {
            IJavaThread owningThread = (IJavaThread)this.fMonitorToOwningThread.get(contendedMonitor);
            if (usedThreadsList.contains(owningThread)) {
                res.add(thread);
                res.add(contendedMonitor);
                res.add(owningThread);
                return res;
            }
            ArrayList<IJavaThread> newUsedThreadsList = new ArrayList<IJavaThread>(usedThreadsList);
            newUsedThreadsList.add(thread);
            if (owningThread == null) {
                return null;
            }
            List newRes = this.listToDeadlock(owningThread, newUsedThreadsList);
            if (newRes != null) {
                res.add(thread);
                res.add(contendedMonitor);
                res.addAll(newRes);
                return res;
            }
        } else {
            return null;
        }
        return null;
    }

    public int getNumberOfDeadlocks() {
        return this.fDeadLockLists.size();
    }

    public List getDeadlockList(int index) {
        if (index >= this.fDeadLockLists.size()) {
            return null;
        }
        return ((ThreadWrapper)this.fDeadLockLists.get(index)).getDeadLockList();
    }

    public IJavaThread getStartThread(int index) {
        if (index >= this.fDeadLockLists.size()) {
            return null;
        }
        return ((ThreadWrapper)this.fDeadLockLists.get(index)).getStartThread();
    }

    public boolean isCaughtInDeadlock(IJavaThread thread) {
        int i = 0;
        while (i < this.fDeadLockLists.size()) {
            if (((ThreadWrapper)this.fDeadLockLists.get(i)).getStartThread().equals(thread)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void addDeadlockUpdateListener(DeadLocksViewContentProvider provider) {
        this.fDeadlockUpdateListener = provider;
    }

    protected void removeDeadlockUpdateListener() {
        this.fDeadlockUpdateListener = null;
    }
}

