/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.console;

import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.debug.ui.console.IConsoleHyperlink;
import org.eclipse.debug.ui.console.IConsoleLineTracker;
import org.eclipse.jdt.internal.debug.ui.console.J9StackTraceHyperlink;
import org.eclipse.jdt.internal.debug.ui.console.StringMatcher;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;

public class J9ConsoleTracker
implements IConsoleLineTracker {
    private IConsole fConsole;
    private StringMatcher fJ9Matcher;

    public void init(IConsole console) {
        this.fConsole = console;
        this.fJ9Matcher = new StringMatcher("*.*(*)*", false, false);
    }

    public void lineAppended(IRegion line) {
        try {
            int offset = line.getOffset();
            int length = line.getLength();
            String text = this.fConsole.getDocument().get(offset, length);
            int index = -1;
            if (this.fJ9Matcher.match(text) && (index = text.lastIndexOf(32)) >= 0) {
                int linkOffset = offset + index + 1;
                int linkLength = length - index - 1;
                J9StackTraceHyperlink link = null;
                link = new J9StackTraceHyperlink(this.fConsole);
                this.fConsole.addLink((IConsoleHyperlink)link, linkOffset, linkLength);
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    public void dispose() {
        this.fConsole = null;
        this.fJ9Matcher = null;
    }
}

