/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ssh;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.eclipse.team.internal.ccvs.ssh.Policy;

class Misc {
    private static MessageDigest md5 = null;
    private static SecureRandom random = null;
    private static long[] crc32_tab;

    static {
        long[] lArray = new long[256];
        lArray[1] = 1996959894L;
        lArray[2] = 3993919788L;
        lArray[3] = 2567524794L;
        lArray[4] = 124634137L;
        lArray[5] = 1886057615L;
        lArray[6] = 3915621685L;
        lArray[7] = 2657392035L;
        lArray[8] = 249268274L;
        lArray[9] = 2044508324L;
        lArray[10] = 3772115230L;
        lArray[11] = 2547177864L;
        lArray[12] = 162941995L;
        lArray[13] = 2125561021L;
        lArray[14] = 3887607047L;
        lArray[15] = 2428444049L;
        lArray[16] = 498536548L;
        lArray[17] = 1789927666L;
        lArray[18] = 4089016648L;
        lArray[19] = 2227061214L;
        lArray[20] = 450548861L;
        lArray[21] = 1843258603L;
        lArray[22] = 4107580753L;
        lArray[23] = 2211677639L;
        lArray[24] = 325883990L;
        lArray[25] = 1684777152L;
        lArray[26] = 4251122042L;
        lArray[27] = 2321926636L;
        lArray[28] = 335633487L;
        lArray[29] = 1661365465L;
        lArray[30] = 4195302755L;
        lArray[31] = 2366115317L;
        lArray[32] = 997073096L;
        lArray[33] = 1281953886L;
        lArray[34] = 3579855332L;
        lArray[35] = 2724688242L;
        lArray[36] = 1006888145L;
        lArray[37] = 1258607687L;
        lArray[38] = 3524101629L;
        lArray[39] = 2768942443L;
        lArray[40] = 901097722L;
        lArray[41] = 1119000684L;
        lArray[42] = 3686517206L;
        lArray[43] = 2898065728L;
        lArray[44] = 853044451L;
        lArray[45] = 1172266101L;
        lArray[46] = 3705015759L;
        lArray[47] = 2882616665L;
        lArray[48] = 651767980L;
        lArray[49] = 1373503546L;
        lArray[50] = 3369554304L;
        lArray[51] = 3218104598L;
        lArray[52] = 565507253L;
        lArray[53] = 1454621731L;
        lArray[54] = 3485111705L;
        lArray[55] = 3099436303L;
        lArray[56] = 671266974L;
        lArray[57] = 1594198024L;
        lArray[58] = 3322730930L;
        lArray[59] = 2970347812L;
        lArray[60] = 795835527L;
        lArray[61] = 1483230225L;
        lArray[62] = 3244367275L;
        lArray[63] = 3060149565L;
        lArray[64] = 1994146192L;
        lArray[65] = 31158534L;
        lArray[66] = 2563907772L;
        lArray[67] = 4023717930L;
        lArray[68] = 1907459465L;
        lArray[69] = 112637215L;
        lArray[70] = 2680153253L;
        lArray[71] = 3904427059L;
        lArray[72] = 2013776290L;
        lArray[73] = 251722036L;
        lArray[74] = 2517215374L;
        lArray[75] = 3775830040L;
        lArray[76] = 2137656763L;
        lArray[77] = 141376813L;
        lArray[78] = 2439277719L;
        lArray[79] = 3865271297L;
        lArray[80] = 1802195444L;
        lArray[81] = 476864866L;
        lArray[82] = 2238001368L;
        lArray[83] = 4066508878L;
        lArray[84] = 1812370925L;
        lArray[85] = 453092731L;
        lArray[86] = 2181625025L;
        lArray[87] = 4111451223L;
        lArray[88] = 1706088902L;
        lArray[89] = 314042704L;
        lArray[90] = 2344532202L;
        lArray[91] = 4240017532L;
        lArray[92] = 1658658271L;
        lArray[93] = 366619977L;
        lArray[94] = 2362670323L;
        lArray[95] = 4224994405L;
        lArray[96] = 1303535960L;
        lArray[97] = 984961486L;
        lArray[98] = 2747007092L;
        lArray[99] = 3569037538L;
        lArray[100] = 1256170817L;
        lArray[101] = 1037604311L;
        lArray[102] = 2765210733L;
        lArray[103] = 3554079995L;
        lArray[104] = 1131014506L;
        lArray[105] = 879679996L;
        lArray[106] = 2909243462L;
        lArray[107] = 3663771856L;
        lArray[108] = 1141124467L;
        lArray[109] = 855842277L;
        lArray[110] = 2852801631L;
        lArray[111] = 3708648649L;
        lArray[112] = 1342533948L;
        lArray[113] = 654459306L;
        lArray[114] = 3188396048L;
        lArray[115] = 3373015174L;
        lArray[116] = 1466479909L;
        lArray[117] = 544179635L;
        lArray[118] = 3110523913L;
        lArray[119] = 3462522015L;
        lArray[120] = 1591671054L;
        lArray[121] = 702138776L;
        lArray[122] = 2966460450L;
        lArray[123] = 3352799412L;
        lArray[124] = 1504918807L;
        lArray[125] = 783551873L;
        lArray[126] = 3082640443L;
        lArray[127] = 3233442989L;
        lArray[128] = 3988292384L;
        lArray[129] = 2596254646L;
        lArray[130] = 62317068L;
        lArray[131] = 1957810842L;
        lArray[132] = 3939845945L;
        lArray[133] = 2647816111L;
        lArray[134] = 81470997L;
        lArray[135] = 1943803523L;
        lArray[136] = 3814918930L;
        lArray[137] = 2489596804L;
        lArray[138] = 225274430L;
        lArray[139] = 2053790376L;
        lArray[140] = 3826175755L;
        lArray[141] = 2466906013L;
        lArray[142] = 167816743L;
        lArray[143] = 2097651377L;
        lArray[144] = 4027552580L;
        lArray[145] = 2265490386L;
        lArray[146] = 503444072L;
        lArray[147] = 1762050814L;
        lArray[148] = 4150417245L;
        lArray[149] = 2154129355L;
        lArray[150] = 426522225L;
        lArray[151] = 1852507879L;
        lArray[152] = 4275313526L;
        lArray[153] = 2312317920L;
        lArray[154] = 282753626L;
        lArray[155] = 1742555852L;
        lArray[156] = 4189708143L;
        lArray[157] = 2394877945L;
        lArray[158] = 397917763L;
        lArray[159] = 1622183637L;
        lArray[160] = 3604390888L;
        lArray[161] = 2714866558L;
        lArray[162] = 953729732L;
        lArray[163] = 1340076626L;
        lArray[164] = 3518719985L;
        lArray[165] = 2797360999L;
        lArray[166] = 1068828381L;
        lArray[167] = 1219638859L;
        lArray[168] = 3624741850L;
        lArray[169] = 2936675148L;
        lArray[170] = 906185462L;
        lArray[171] = 1090812512L;
        lArray[172] = 3747672003L;
        lArray[173] = 2825379669L;
        lArray[174] = 829329135L;
        lArray[175] = 1181335161L;
        lArray[176] = 3412177804L;
        lArray[177] = 3160834842L;
        lArray[178] = 628085408L;
        lArray[179] = 1382605366L;
        lArray[180] = 3423369109L;
        lArray[181] = 3138078467L;
        lArray[182] = 570562233L;
        lArray[183] = 1426400815L;
        lArray[184] = 3317316542L;
        lArray[185] = 2998733608L;
        lArray[186] = 733239954L;
        lArray[187] = 1555261956L;
        lArray[188] = 3268935591L;
        lArray[189] = 3050360625L;
        lArray[190] = 752459403L;
        lArray[191] = 1541320221L;
        lArray[192] = 2607071920L;
        lArray[193] = 3965973030L;
        lArray[194] = 1969922972L;
        lArray[195] = 40735498L;
        lArray[196] = 2617837225L;
        lArray[197] = 3943577151L;
        lArray[198] = 1913087877L;
        lArray[199] = 83908371L;
        lArray[200] = 2512341634L;
        lArray[201] = 3803740692L;
        lArray[202] = 2075208622L;
        lArray[203] = 213261112L;
        lArray[204] = 2463272603L;
        lArray[205] = 3855990285L;
        lArray[206] = 2094854071L;
        lArray[207] = 198958881L;
        lArray[208] = 2262029012L;
        lArray[209] = 4057260610L;
        lArray[210] = 1759359992L;
        lArray[211] = 534414190L;
        lArray[212] = 2176718541L;
        lArray[213] = 4139329115L;
        lArray[214] = 1873836001L;
        lArray[215] = 414664567L;
        lArray[216] = 2282248934L;
        lArray[217] = 4279200368L;
        lArray[218] = 1711684554L;
        lArray[219] = 285281116L;
        lArray[220] = 2405801727L;
        lArray[221] = 4167216745L;
        lArray[222] = 1634467795L;
        lArray[223] = 376229701L;
        lArray[224] = 2685067896L;
        lArray[225] = 3608007406L;
        lArray[226] = 1308918612L;
        lArray[227] = 956543938L;
        lArray[228] = 2808555105L;
        lArray[229] = 3495958263L;
        lArray[230] = 1231636301L;
        lArray[231] = 1047427035L;
        lArray[232] = 2932959818L;
        lArray[233] = 3654703836L;
        lArray[234] = 1088359270L;
        lArray[235] = 936918000L;
        lArray[236] = 2847714899L;
        lArray[237] = 3736837829L;
        lArray[238] = 1202900863L;
        lArray[239] = 817233897L;
        lArray[240] = 3183342108L;
        lArray[241] = 3401237130L;
        lArray[242] = 1404277552L;
        lArray[243] = 615818150L;
        lArray[244] = 3134207493L;
        lArray[245] = 3453421203L;
        lArray[246] = 1423857449L;
        lArray[247] = 601450431L;
        lArray[248] = 3009837614L;
        lArray[249] = 3294710456L;
        lArray[250] = 1567103746L;
        lArray[251] = 711928724L;
        lArray[252] = 3020668471L;
        lArray[253] = 3272380065L;
        lArray[254] = 1510334235L;
        lArray[255] = 755167117L;
        crc32_tab = lArray;
    }

    Misc() {
    }

    public static long crc32(byte[] b, int off, int len) {
        return Misc.crc32(b, off, len, 0L);
    }

    public static long crc32(byte[] b, int off, int len, long crc32val) {
        int i = 0;
        while (i < len) {
            crc32val = crc32_tab[(int)((crc32val ^ (long)b[off + i]) & 0xFFL)] ^ crc32val >> 8;
            ++i;
        }
        return crc32val;
    }

    public static byte[] lengthEncode(byte[] b, int off, int len) throws IOException {
        byte[] result = new byte[len + 4];
        Misc.writeInt(len, result, 0);
        System.arraycopy(b, off, result, 4, len);
        return result;
    }

    public static byte[] readMpInt(InputStream is) throws IOException {
        int a = is.read();
        int b = is.read();
        if (a == -1 || b == -1) {
            throw new IOException(Policy.bind("stream"));
        }
        int bits = ((a & 0xFF) << 8) + (b & 0xFF);
        int bytes = (bits + 7) / 8;
        byte[] result = new byte[bytes];
        Misc.readFully(is, result);
        return result;
    }

    public static byte[] md5(byte[] b) throws IOException {
        if (md5 == null) {
            try {
                md5 = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new IOException(Policy.bind("Misc.missingMD5", e.getMessage()));
            }
        }
        return md5.digest(b);
    }

    public static byte[] md5(String s) throws IOException {
        return Misc.md5(s.getBytes());
    }

    public static void readFully(InputStream is, byte[] b) throws IOException {
        Misc.readFully(is, b, 0, b.length);
    }

    public static void readFully(InputStream is, byte[] b, int off, int len) throws IOException {
        int bytesRead = 0;
        int totalBytesRead = 0;
        while (totalBytesRead < len) {
            bytesRead = is.read(b, totalBytesRead + off, len - totalBytesRead);
            if (bytesRead == -1) {
                throw new IOException(Policy.bind("stream"));
            }
            totalBytesRead += bytesRead;
        }
    }

    public static int readInt(byte[] arr, int off) throws IOException {
        int a = arr[off] & 0xFF;
        int b = arr[off + 1] & 0xFF;
        int c = arr[off + 2] & 0xFF;
        int d = arr[off + 3] & 0xFF;
        return (a << 24) + (b << 16) + (c << 8) + d;
    }

    public static int readInt(InputStream is) throws IOException {
        int a = is.read();
        int b = is.read();
        int c = is.read();
        int d = is.read();
        if (a == -1 || b == -1 || c == -1 || d == -1) {
            throw new IOException(Policy.bind("stream"));
        }
        return (a << 24) + (b << 16) + (c << 8) + d;
    }

    public static String readString(InputStream is) throws IOException {
        int size = Misc.readInt(is);
        byte[] buffer = new byte[size];
        int i = 0;
        while (i < buffer.length) {
            int next = is.read();
            if (next == -1) {
                throw new IOException(Policy.bind("stream"));
            }
            buffer[i] = (byte)next;
            ++i;
        }
        return new String(buffer);
    }

    public static void skipFully(InputStream is, long n) throws IOException {
        while (n != 0L) {
            int b = is.read();
            if (b == -1) {
                if (n > 0L) {
                    throw new IOException(Policy.bind("stream"));
                }
                return;
            }
            --n;
        }
    }

    public static void writeInt(int i, byte[] b, int off) {
        b[off] = (byte)(i >> 24 & 0xFF);
        b[off + 1] = (byte)(i >> 16 & 0xFF);
        b[off + 2] = (byte)(i >> 8 & 0xFF);
        b[off + 3] = (byte)(i & 0xFF);
    }

    public static void xor(byte[] src_a, int off_a, byte[] src_b, int off_b, byte[] dst, int dst_off, int len) {
        int i = 0;
        while (i < len) {
            dst[i + dst_off] = (byte)(src_a[i + off_a] ^ src_b[i + off_b]);
            ++i;
        }
    }

    public static void random(byte[] b, int off, int len, boolean allowZeroBytes) {
        if (random == null) {
            try {
                random = SecureRandom.getInstance("SHA1PRNG");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                random = new SecureRandom();
            }
        }
        int i = off;
        while (i < off + len) {
            do {
                b[i] = (byte)random.nextInt();
            } while (!allowZeroBytes && b[i] == 0);
            ++i;
        }
    }

    public static byte[] encryptRSAPkcs1(byte[] data, byte[] public_key_exponent, byte[] public_key_modulus) {
        int offset = 0;
        byte[] block = new byte[public_key_modulus.length];
        block[offset++] = 0;
        block[offset++] = 2;
        Misc.random(block, offset, block.length - data.length - 3, false);
        offset += block.length - data.length - 3;
        block[offset++] = 0;
        int i = 0;
        while (i < data.length) {
            block[offset++] = data[i];
            ++i;
        }
        BigInteger m = new BigInteger(1, public_key_modulus);
        BigInteger e = new BigInteger(1, public_key_exponent);
        BigInteger message = new BigInteger(1, block);
        message = message.modPow(e, m);
        byte[] messageByteTemp = message.toByteArray();
        byte[] messageByte = new byte[public_key_modulus.length];
        int tempOffset = 0;
        while (messageByteTemp[tempOffset] == 0) {
            ++tempOffset;
        }
        int i2 = messageByte.length - messageByteTemp.length + tempOffset;
        while (i2 < messageByte.length) {
            messageByte[i2] = messageByteTemp[tempOffset++];
            ++i2;
        }
        return messageByte;
    }
}

