/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.preferences;

import java.util.List;
import org.eclipse.ant.internal.ui.model.AntUIPlugin;
import org.eclipse.ant.internal.ui.preferences.AntPreferencesMessages;
import org.eclipse.ant.internal.ui.preferences.PropertyFileFilter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.views.navigator.ResourceSorter;

public class AntPropertiesFileSelectionDialog
extends ElementTreeSelectionDialog {
    private ViewerFilter fFilter;
    private boolean fShowAll = false;
    private static final String DIALOG_SETTING = "AntPropertiesFileSelectionDialog.showAll";

    public AntPropertiesFileSelectionDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider, List propertyFiles) {
        super(parent, labelProvider, contentProvider);
        this.setTitle(AntPreferencesMessages.getString("AntPropertiesFileSelectionDialog.12"));
        this.setMessage(AntPreferencesMessages.getString("AntPropertiesFileSelectionDialog.13"));
        this.fFilter = new PropertyFileFilter(propertyFiles);
        this.setInput(ResourcesPlugin.getWorkspace().getRoot());
        this.setSorter((ViewerSorter)new ResourceSorter(1));
        ISelectionStatusValidator validator = new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection.length == 0) {
                    return new Status(4, AntUIPlugin.getUniqueIdentifier(), 0, "", null);
                }
                int i = 0;
                while (i < selection.length) {
                    if (!(selection[i] instanceof IFile)) {
                        return new Status(4, AntUIPlugin.getUniqueIdentifier(), 0, "", null);
                    }
                    ++i;
                }
                return new Status(0, AntUIPlugin.getUniqueIdentifier(), 0, "", null);
            }
        };
        this.setValidator(validator);
    }

    protected Control createDialogArea(Composite parent) {
        Composite result = (Composite)super.createDialogArea(parent);
        final Button button = new Button(result, 32);
        button.setText(AntPreferencesMessages.getString("AntPropertiesFileSelectionDialog.14"));
        button.setFont(parent.getFont());
        GridData data = new GridData();
        data.heightHint = this.convertVerticalDLUsToPixels(14);
        button.setLayoutData((Object)data);
        IDialogSettings settings = AntUIPlugin.getDefault().getDialogSettings();
        this.fShowAll = settings.getBoolean(DIALOG_SETTING);
        if (!this.fShowAll) {
            this.getTreeViewer().addFilter(this.fFilter);
            button.setSelection(true);
        }
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (button.getSelection()) {
                    AntPropertiesFileSelectionDialog.this.fShowAll = false;
                    AntPropertiesFileSelectionDialog.this.getTreeViewer().addFilter(AntPropertiesFileSelectionDialog.this.fFilter);
                } else {
                    AntPropertiesFileSelectionDialog.this.fShowAll = true;
                    AntPropertiesFileSelectionDialog.this.getTreeViewer().removeFilter(AntPropertiesFileSelectionDialog.this.fFilter);
                }
            }
        });
        Dialog.applyDialogFont((Control)result);
        return result;
    }

    public boolean close() {
        IDialogSettings settings = AntUIPlugin.getDefault().getDialogSettings();
        settings.put(DIALOG_SETTING, this.fShowAll);
        return super.close();
    }
}

