/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.editor.text;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.AbstractFileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.PatternSet;
import org.eclipse.ant.internal.ui.editor.AntEditor;
import org.eclipse.ant.internal.ui.editor.derived.HTMLPrinter;
import org.eclipse.ant.internal.ui.editor.derived.HTMLTextPresenter;
import org.eclipse.ant.internal.ui.editor.model.AntElementNode;
import org.eclipse.ant.internal.ui.editor.model.AntPropertyNode;
import org.eclipse.ant.internal.ui.editor.outline.AntModel;
import org.eclipse.ant.internal.ui.editor.text.AntEditorTextMessages;
import org.eclipse.ant.internal.ui.editor.text.FileScanner;
import org.eclipse.ant.internal.ui.editor.text.IXMLAnnotation;
import org.eclipse.ant.internal.ui.editor.text.XMLAnnotationIterator;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.widgets.Shell;

public class XMLTextHover
implements ITextHover,
ITextHoverExtension {
    private AntEditor fEditor;

    public XMLTextHover(AntEditor editor) {
        this.fEditor = editor;
    }

    private String formatMessage(String message) {
        StringBuffer buffer = new StringBuffer();
        HTMLPrinter.addPageProlog(buffer);
        HTMLPrinter.addParagraph(buffer, HTMLPrinter.convertToHTMLContent(message));
        HTMLPrinter.addPageEpilog(buffer);
        return buffer.toString();
    }

    private String formatPathMessage(String[] list) {
        StringBuffer buffer = new StringBuffer();
        HTMLPrinter.addPageProlog(buffer);
        HTMLPrinter.addSmallHeader(buffer, AntEditorTextMessages.getString("XMLTextHover.4"));
        HTMLPrinter.startBulletList(buffer);
        int i = 0;
        while (i < list.length) {
            HTMLPrinter.addBullet(buffer, list[i]);
            ++i;
        }
        HTMLPrinter.endBulletList(buffer);
        HTMLPrinter.addPageEpilog(buffer);
        return buffer.toString();
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        AntModel antModel;
        if (!(textViewer instanceof ISourceViewer)) {
            return null;
        }
        ISourceViewer sourceViewer = (ISourceViewer)textViewer;
        IAnnotationModel model = sourceViewer.getAnnotationModel();
        if (model != null) {
            XMLAnnotationIterator e = new XMLAnnotationIterator(model, true);
            while (e.hasNext()) {
                String msg;
                Annotation a = (Annotation)e.next();
                Position p = model.getPosition(a);
                if (!p.overlapsWith(hoverRegion.getOffset(), hoverRegion.getLength()) || (msg = ((IXMLAnnotation)a).getMessage()) == null || msg.trim().length() <= 0) continue;
                return this.formatMessage(msg);
            }
        }
        if ((antModel = this.fEditor.getAntModel()) == null) {
            return null;
        }
        try {
            String value;
            IDocument document = textViewer.getDocument();
            int offset = hoverRegion.getOffset();
            int length = hoverRegion.getLength();
            String text = document.get(offset, length);
            AntElementNode node = antModel.getNode(offset, false);
            if ((document.get(offset - 2, 2).equals("${") || node instanceof AntPropertyNode) && (value = antModel.getPropertyValue(text)) != null) {
                return this.formatMessage(value);
            }
            value = antModel.getTargetDescription(text);
            if (value != null) {
                return this.formatMessage(value);
            }
            Object referencedObject = antModel.getReferenceObject(text);
            if (referencedObject != null) {
                if (referencedObject instanceof Path) {
                    return this.formatPathMessage(((Path)referencedObject).list());
                }
                if (referencedObject instanceof PatternSet) {
                    return this.formatPatternSetMessage((PatternSet)referencedObject);
                }
                if (referencedObject instanceof AbstractFileSet) {
                    return this.formatFileSetMessage((AbstractFileSet)referencedObject);
                }
            }
        }
        catch (BadLocationException badLocationException) {
        }
        catch (BuildException be) {
            antModel.handleBuildException(be, null);
        }
        return null;
    }

    private String formatFileSetMessage(AbstractFileSet set) {
        FileScanner fileScanner = new FileScanner();
        AntModel antModel = this.fEditor.getAntModel();
        Project project = antModel.getProjectNode().getProject();
        set.setupDirectoryScanner((org.apache.tools.ant.FileScanner)fileScanner, project);
        String[] excludedPatterns = fileScanner.getExcludesPatterns();
        String[] includesPatterns = fileScanner.getIncludePatterns();
        return this.formatSetMessage(includesPatterns, excludedPatterns);
    }

    private String formatPatternSetMessage(PatternSet set) {
        AntModel antModel = this.fEditor.getAntModel();
        Project project = antModel.getProjectNode().getProject();
        String[] includes = set.getIncludePatterns(project);
        String[] excludes = set.getExcludePatterns(project);
        return this.formatSetMessage(includes, excludes);
    }

    private String formatSetMessage(String[] includes, String[] excludes) {
        int i;
        StringBuffer buffer = new StringBuffer();
        HTMLPrinter.addPageProlog(buffer);
        if (includes != null && includes.length > 0) {
            HTMLPrinter.addSmallHeader(buffer, AntEditorTextMessages.getString("XMLTextHover.5"));
            i = 0;
            while (i < includes.length) {
                HTMLPrinter.addBullet(buffer, includes[i]);
                ++i;
            }
        }
        HTMLPrinter.addParagraph(buffer, "");
        HTMLPrinter.addParagraph(buffer, "");
        if (excludes != null && excludes.length > 0) {
            HTMLPrinter.addSmallHeader(buffer, AntEditorTextMessages.getString("XMLTextHover.6"));
            i = 0;
            while (i < excludes.length) {
                HTMLPrinter.addBullet(buffer, excludes[i]);
                ++i;
            }
        }
        HTMLPrinter.addPageEpilog(buffer);
        return buffer.toString();
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        if (textViewer != null) {
            return XMLTextHover.getRegion(textViewer, offset);
        }
        return null;
    }

    public static IRegion getRegion(ITextViewer textViewer, int offset) {
        IDocument document = textViewer.getDocument();
        int start = -1;
        int end = -1;
        try {
            char c;
            int pos = offset;
            while (pos >= 0) {
                c = document.getChar(pos);
                if (c != '.' && c != '-' && c != '/' && c != '\\' && !Character.isJavaIdentifierPart(c)) break;
                --pos;
            }
            start = pos;
            pos = offset;
            int length = document.getLength();
            while (pos < length) {
                c = document.getChar(pos);
                if (c != '.' && c != '-' && !Character.isJavaIdentifierPart(c)) break;
                ++pos;
            }
            end = pos;
        }
        catch (BadLocationException badLocationException) {}
        if (start > -1 && end > -1) {
            if (start == offset && end == offset) {
                return new Region(offset, 0);
            }
            if (start == offset) {
                return new Region(start, end - start);
            }
            return new Region(start + 1, end - start - 1);
        }
        return null;
    }

    public IInformationControlCreator getHoverControlCreator() {
        if (PreferenceConstants.getPreferenceStore().getBoolean("PreferenceConstants.EDITOR_SHOW_TEXT_HOVER_AFFORDANCE")) {
            return new IInformationControlCreator(){

                public IInformationControl createInformationControl(Shell parent) {
                    return new DefaultInformationControl(parent, 0, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(true), AntEditorTextMessages.getString("XMLTextHover.7"));
                }
            };
        }
        return null;
    }
}

