/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.editor.text;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ant.internal.ui.editor.outline.AntModel;
import org.eclipse.ant.internal.ui.editor.outline.IProblem;
import org.eclipse.ant.internal.ui.editor.outline.IProblemRequestor;
import org.eclipse.ant.internal.ui.editor.outline.LocationProvider;
import org.eclipse.ant.internal.ui.editor.outline.XMLCore;
import org.eclipse.ant.internal.ui.editor.text.AntDocumentSetupParticipant;
import org.eclipse.ant.internal.ui.editor.text.AntStorageDocumentProvider;
import org.eclipse.ant.internal.ui.editor.text.XMLMarkerAnnotation;
import org.eclipse.ant.internal.ui.editor.text.XMLProblemAnnotation;
import org.eclipse.ant.internal.ui.model.AntUIPlugin;
import org.eclipse.core.filebuffers.IDocumentSetupParticipant;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModelEvent;
import org.eclipse.jface.text.source.IAnnotationMap;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.ForwardingDocumentProvider;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.ui.texteditor.ResourceMarkerAnnotationModel;

public class AntEditorDocumentProvider
extends TextFileDocumentProvider {
    private XMLCore fCore;

    public AntEditorDocumentProvider(XMLCore core) {
        TextFileDocumentProvider provider = new TextFileDocumentProvider((IDocumentProvider)new AntStorageDocumentProvider());
        provider = new ForwardingDocumentProvider("___ant_partitioning", (IDocumentSetupParticipant)new AntDocumentSetupParticipant(), (IDocumentProvider)provider);
        this.setParentDocumentProvider((IDocumentProvider)provider);
        this.fCore = core;
    }

    public AntModel getAntModel(Object element) {
        TextFileDocumentProvider.FileInfo info = this.getFileInfo(element);
        if (info instanceof AntFileInfo) {
            AntFileInfo xmlInfo = (AntFileInfo)info;
            return xmlInfo.fAntModel;
        }
        return null;
    }

    protected IAnnotationModel createAnnotationModel(IFile file) {
        return new AntAnnotationModel(file);
    }

    protected AntModel createAntModel(Object element, IDocument document, IAnnotationModel annotationModel) {
        IProblemRequestor requestor = annotationModel instanceof IProblemRequestor ? (IProblemRequestor)annotationModel : null;
        return new AntModel(this.fCore, document, requestor, new LocationProvider(element instanceof IEditorInput ? (IEditorInput)element : null));
    }

    protected TextFileDocumentProvider.FileInfo createFileInfo(Object element) throws CoreException {
        TextFileDocumentProvider.FileInfo info = super.createFileInfo(element);
        if (!(info instanceof AntFileInfo)) {
            return null;
        }
        AntFileInfo xmlInfo = (AntFileInfo)info;
        IAnnotationModel model = xmlInfo.fModel;
        AntModel antModel = this.createAntModel(element, xmlInfo.fTextFileBuffer.getDocument(), model);
        antModel.install();
        xmlInfo.fAntModel = antModel;
        this.setUpSynchronization(xmlInfo);
        return xmlInfo;
    }

    protected void disposeFileInfo(Object element, TextFileDocumentProvider.FileInfo info) {
        if (info instanceof AntFileInfo) {
            AntFileInfo xmlInfo = (AntFileInfo)info;
            if (xmlInfo.fAntModel != null) {
                xmlInfo.fAntModel.dispose();
            }
        }
        super.disposeFileInfo(element, info);
    }

    protected TextFileDocumentProvider.FileInfo createEmptyFileInfo() {
        return new AntFileInfo();
    }

    private void setUpSynchronization(AntFileInfo antInfo) {
        IDocument document = antInfo.fTextFileBuffer.getDocument();
        IAnnotationModel model = antInfo.fModel;
        if (document instanceof ISynchronizable && model instanceof ISynchronizable) {
            Object lock = ((ISynchronizable)document).getLockObject();
            ((ISynchronizable)model).setLockObject(lock);
        }
    }

    protected class AntAnnotationModel
    extends ResourceMarkerAnnotationModel
    implements IProblemRequestor {
        private List fGeneratedAnnotations = new ArrayList();
        private List fCollectedProblems = new ArrayList();
        private ReverseMap fReverseMap = new ReverseMap();
        private List fPreviouslyOverlaid = null;
        private List fCurrentlyOverlaid = new ArrayList();

        public AntAnnotationModel(IFile file) {
            super((IResource)file);
        }

        protected MarkerAnnotation createMarkerAnnotation(IMarker marker) {
            String markerType = MarkerUtilities.getMarkerType((IMarker)marker);
            if ("org.eclipse.ant.ui.buildFileProblem".equals(markerType)) {
                return null;
            }
            return new XMLMarkerAnnotation(EditorsUI.getAnnotationTypeLookup().getAnnotationType(marker), marker);
        }

        protected Position createPositionFromProblem(IProblem problem) {
            int length;
            int start = problem.getOffset();
            if (start >= 0 && (length = problem.getLength()) >= 0) {
                return new Position(start, length);
            }
            return null;
        }

        public void acceptProblem(IProblem problem) {
            this.fCollectedProblems.add(problem);
        }

        public void beginReporting() {
        }

        public void endReporting() {
            boolean temporaryProblemsChanged = false;
            this.fPreviouslyOverlaid = this.fCurrentlyOverlaid;
            this.fCurrentlyOverlaid = new ArrayList();
            IAnnotationMap iAnnotationMap = this.getAnnotationMap();
            synchronized (iAnnotationMap) {
                if (this.fGeneratedAnnotations.size() > 0) {
                    temporaryProblemsChanged = true;
                    this.removeAnnotations(this.fGeneratedAnnotations, false, true);
                    this.fGeneratedAnnotations.clear();
                }
                if (this.fCollectedProblems != null && this.fCollectedProblems.size() > 0) {
                    Iterator e = this.fCollectedProblems.iterator();
                    while (e.hasNext()) {
                        IProblem problem = (IProblem)e.next();
                        Position position = this.createPositionFromProblem(problem);
                        if (position == null) continue;
                        XMLProblemAnnotation annotation = new XMLProblemAnnotation(problem);
                        this.overlayMarkers(position, annotation);
                        this.fGeneratedAnnotations.add(annotation);
                        try {
                            this.addAnnotation(annotation, position, false);
                        }
                        catch (BadLocationException ex) {
                            AntUIPlugin.log(ex);
                        }
                        temporaryProblemsChanged = true;
                    }
                    this.fCollectedProblems.clear();
                }
                this.removeMarkerOverlays();
                this.fPreviouslyOverlaid.clear();
                this.fPreviouslyOverlaid = null;
            }
            if (temporaryProblemsChanged) {
                this.fireModelChanged(new AnnotationModelEvent((IAnnotationModel)this));
            }
        }

        private void removeMarkerOverlays() {
            Iterator e = this.fPreviouslyOverlaid.iterator();
            while (e.hasNext()) {
                XMLMarkerAnnotation annotation = (XMLMarkerAnnotation)e.next();
                annotation.setOverlay(null);
            }
        }

        private void setOverlay(Object value, XMLProblemAnnotation problemAnnotation) {
            XMLMarkerAnnotation annotation;
            if (value instanceof XMLMarkerAnnotation && (annotation = (XMLMarkerAnnotation)value).isProblem()) {
                annotation.setOverlay(problemAnnotation);
                this.fPreviouslyOverlaid.remove(annotation);
                this.fCurrentlyOverlaid.add(annotation);
            }
        }

        private void overlayMarkers(Position position, XMLProblemAnnotation problemAnnotation) {
            Object value = this.getAnnotations(position);
            if (value instanceof List) {
                List list = (List)value;
                Iterator e = list.iterator();
                while (e.hasNext()) {
                    this.setOverlay(e.next(), problemAnnotation);
                }
            } else {
                this.setOverlay(value, problemAnnotation);
            }
        }

        private Object getAnnotations(Position position) {
            return this.fReverseMap.get(position);
        }

        protected void addAnnotation(Annotation annotation, Position position, boolean fireModelChanged) throws BadLocationException {
            super.addAnnotation(annotation, position, fireModelChanged);
            Object cached = this.fReverseMap.get(position);
            if (cached == null) {
                this.fReverseMap.put(position, annotation);
            } else if (cached instanceof List) {
                List list = (List)cached;
                list.add(annotation);
            } else if (cached instanceof Annotation) {
                ArrayList<Object> list = new ArrayList<Object>(2);
                list.add(cached);
                list.add(annotation);
                this.fReverseMap.put(position, list);
            }
        }

        protected void removeAllAnnotations(boolean fireModelChanged) {
            super.removeAllAnnotations(fireModelChanged);
            this.fReverseMap.clear();
        }

        protected void removeAnnotation(Annotation annotation, boolean fireModelChanged) {
            Position position = this.getPosition(annotation);
            Object cached = this.fReverseMap.get(position);
            if (cached instanceof List) {
                List list = (List)cached;
                list.remove(annotation);
                if (list.size() == 1) {
                    this.fReverseMap.put(position, list.get(0));
                    list.clear();
                }
            } else if (cached instanceof Annotation) {
                this.fReverseMap.remove(position);
            }
            super.removeAnnotation(annotation, fireModelChanged);
        }
    }

    protected class AntFileInfo
    extends TextFileDocumentProvider.FileInfo {
        public AntModel fAntModel;
    }

    protected static class ReverseMap {
        private List fList = new ArrayList(2);
        private int fAnchor = 0;

        public Object get(Position position) {
            Entry entry;
            int length = this.fList.size();
            int i = this.fAnchor;
            while (i < length) {
                entry = (Entry)this.fList.get(i);
                if (entry.fPosition.equals((Object)position)) {
                    this.fAnchor = i;
                    return entry.fValue;
                }
                ++i;
            }
            i = 0;
            while (i < this.fAnchor) {
                entry = (Entry)this.fList.get(i);
                if (entry.fPosition.equals((Object)position)) {
                    this.fAnchor = i;
                    return entry.fValue;
                }
                ++i;
            }
            return null;
        }

        private int getIndex(Position position) {
            int length = this.fList.size();
            int i = 0;
            while (i < length) {
                Entry entry = (Entry)this.fList.get(i);
                if (entry.fPosition.equals((Object)position)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public void put(Position position, Object value) {
            int index = this.getIndex(position);
            if (index == -1) {
                Entry entry = new Entry();
                entry.fPosition = position;
                entry.fValue = value;
                this.fList.add(entry);
            } else {
                Entry entry = (Entry)this.fList.get(index);
                entry.fValue = value;
            }
        }

        public void remove(Position position) {
            int index = this.getIndex(position);
            if (index > -1) {
                this.fList.remove(index);
            }
        }

        public void clear() {
            this.fList.clear();
        }

        static class Entry {
            Position fPosition;
            Object fValue;

            Entry() {
            }
        }
    }
}

