/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.IFindReplaceTargetExtension;
import org.eclipse.jface.text.IMarkRegionTarget;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ISelectionValidator;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerExtension;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.VerticalRuler;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.INavigationLocation;
import org.eclipse.ui.INavigationLocationProvider;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.EditorPluginAction;
import org.eclipse.ui.internal.texteditor.EditPosition;
import org.eclipse.ui.internal.texteditor.TextEditorPlugin;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.texteditor.CaseAction;
import org.eclipse.ui.texteditor.ConfigurationElementSorter;
import org.eclipse.ui.texteditor.DeleteLineAction;
import org.eclipse.ui.texteditor.DeleteLineTarget;
import org.eclipse.ui.texteditor.EditorMessages;
import org.eclipse.ui.texteditor.EditorStatusLine;
import org.eclipse.ui.texteditor.FindNextAction;
import org.eclipse.ui.texteditor.FindReplaceAction;
import org.eclipse.ui.texteditor.FindReplaceTarget;
import org.eclipse.ui.texteditor.GotoLineAction;
import org.eclipse.ui.texteditor.IAbstractTextEditorHelpContextIds;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IDocumentProviderExtension;
import org.eclipse.ui.texteditor.IDocumentProviderExtension2;
import org.eclipse.ui.texteditor.IDocumentProviderExtension3;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.IElementStateListener;
import org.eclipse.ui.texteditor.IElementStateListenerExtension;
import org.eclipse.ui.texteditor.IReadOnlyDependent;
import org.eclipse.ui.texteditor.IStatusField;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.ITextEditorDropTargetListener;
import org.eclipse.ui.texteditor.ITextEditorExtension;
import org.eclipse.ui.texteditor.ITextEditorExtension2;
import org.eclipse.ui.texteditor.ITextEditorExtension3;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.IncrementalFindAction;
import org.eclipse.ui.texteditor.IncrementalFindTarget;
import org.eclipse.ui.texteditor.InsertLineAction;
import org.eclipse.ui.texteditor.MarkAction;
import org.eclipse.ui.texteditor.MarkRegionTarget;
import org.eclipse.ui.texteditor.MoveLinesAction;
import org.eclipse.ui.texteditor.ResourceAction;
import org.eclipse.ui.texteditor.RevertToSavedAction;
import org.eclipse.ui.texteditor.SaveAction;
import org.eclipse.ui.texteditor.ShiftAction;
import org.eclipse.ui.texteditor.TextNavigationAction;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.eclipse.ui.texteditor.TextSelectionNavigationLocation;
import org.osgi.framework.Bundle;

public abstract class AbstractTextEditor
extends EditorPart
implements ITextEditor,
IReusableEditor,
ITextEditorExtension,
ITextEditorExtension2,
ITextEditorExtension3,
INavigationLocationProvider {
    private static final String TAG_CONTRIBUTION_TYPE = "editorContribution";
    private static final int WIDE_CARET_WIDTH = 2;
    private static final int SINGLE_CARET_WIDTH = 1;
    public static final String PREFERENCE_FONT = "org.eclipse.jface.textfont";
    public static final String PREFERENCE_COLOR_FOREGROUND = "AbstractTextEditor.Color.Foreground";
    public static final String PREFERENCE_COLOR_BACKGROUND = "AbstractTextEditor.Color.Background";
    public static final String PREFERENCE_COLOR_FOREGROUND_SYSTEM_DEFAULT = "AbstractTextEditor.Color.Foreground.SystemDefault";
    public static final String PREFERENCE_COLOR_BACKGROUND_SYSTEM_DEFAULT = "AbstractTextEditor.Color.Background.SystemDefault";
    public static final String PREFERENCE_COLOR_SELECTION_FOREGROUND = "AbstractTextEditor.Color.SelectionForeground";
    public static final String PREFERENCE_COLOR_SELECTION_BACKGROUND = "AbstractTextEditor.Color.SelectionBackground";
    public static final String PREFERENCE_COLOR_SELECTION_FOREGROUND_SYSTEM_DEFAULT = "AbstractTextEditor.Color.SelectionForeground.SystemDefault";
    public static final String PREFERENCE_COLOR_SELECTION_BACKGROUND_SYSTEM_DEFAULT = "AbstractTextEditor.Color.SelectionBackground.SystemDefault";
    public static final String PREFERENCE_COLOR_FIND_SCOPE = "AbstractTextEditor.Color.FindScope";
    public static final String PREFERENCE_NAVIGATION_SMART_HOME_END = "AbstractTextEditor.Navigation.SmartHomeEnd";
    public static final String PREFERENCE_USE_CUSTOM_CARETS = "AbstractTextEditor.Accessibility.UseCustomCarets";
    public static final String PREFERENCE_WIDE_CARET = "AbstractTextEditor.Accessibility.WideCaret";
    public static final String DEFAULT_EDITOR_CONTEXT_MENU_ID = "#EditorContext";
    public static final String DEFAULT_RULER_CONTEXT_MENU_ID = "#RulerContext";
    protected static final int VERTICAL_RULER_WIDTH = 12;
    protected static final IdMapEntry[] ACTION_MAP = new IdMapEntry[]{new IdMapEntry("org.eclipse.ui.edit.text.goto.lineUp", 0x1000001), new IdMapEntry("org.eclipse.ui.edit.text.goto.lineDown", 0x1000002), new IdMapEntry("org.eclipse.ui.edit.text.goto.lineStart", 0x1000007), new IdMapEntry("org.eclipse.ui.edit.text.goto.lineEnd", 0x1000008), new IdMapEntry("org.eclipse.ui.edit.text.goto.columnPrevious", 0x1000003), new IdMapEntry("org.eclipse.ui.edit.text.goto.columnNext", 0x1000004), new IdMapEntry("org.eclipse.ui.edit.text.goto.pageUp", 0x1000005), new IdMapEntry("org.eclipse.ui.edit.text.goto.pageDown", 0x1000006), new IdMapEntry("org.eclipse.ui.edit.text.goto.wordPrevious", 17039363), new IdMapEntry("org.eclipse.ui.edit.text.goto.wordNext", 0x1040004), new IdMapEntry("org.eclipse.ui.edit.text.goto.textStart", 17039367), new IdMapEntry("org.eclipse.ui.edit.text.goto.textEnd", 17039368), new IdMapEntry("org.eclipse.ui.edit.text.goto.windowStart", 17039365), new IdMapEntry("org.eclipse.ui.edit.text.goto.windowEnd", 17039366), new IdMapEntry("org.eclipse.ui.edit.text.select.lineUp", 0x1020001), new IdMapEntry("org.eclipse.ui.edit.text.select.lineDown", 0x1020002), new IdMapEntry("org.eclipse.ui.edit.text.select.lineStart", 16908295), new IdMapEntry("org.eclipse.ui.edit.text.select.lineEnd", 16908296), new IdMapEntry("org.eclipse.ui.edit.text.select.columnPrevious", 16908291), new IdMapEntry("org.eclipse.ui.edit.text.select.columnNext", 16908292), new IdMapEntry("org.eclipse.ui.edit.text.select.pageUp", 16908293), new IdMapEntry("org.eclipse.ui.edit.text.select.pageDown", 16908294), new IdMapEntry("org.eclipse.ui.edit.text.select.wordPrevious", 17170435), new IdMapEntry("org.eclipse.ui.edit.text.select.wordNext", 17170436), new IdMapEntry("org.eclipse.ui.edit.text.select.textStart", 17170439), new IdMapEntry("org.eclipse.ui.edit.text.select.textEnd", 17170440), new IdMapEntry("org.eclipse.ui.edit.text.select.windowStart", 17170437), new IdMapEntry("org.eclipse.ui.edit.text.select.windowEnd", 0x1060006), new IdMapEntry("org.eclipse.ui.edit.cut", 131199), new IdMapEntry("org.eclipse.ui.edit.copy", 17039369), new IdMapEntry("org.eclipse.ui.edit.paste", 16908297), new IdMapEntry("org.eclipse.ui.edit.text.deletePrevious", 8), new IdMapEntry("org.eclipse.ui.edit.text.deleteNext", 127), new IdMapEntry("org.eclipse.ui.edit.text.deletePreviousWord", 262152), new IdMapEntry("org.eclipse.ui.edit.text.deleteNextWord", 262271), new IdMapEntry("org.eclipse.ui.edit.text.toggleOverwrite", 0x1000009)};
    private final String fReadOnlyLabel = EditorMessages.getString("Editor.statusline.state.readonly.label");
    private final String fWritableLabel = EditorMessages.getString("Editor.statusline.state.writable.label");
    private final String fInsertModeLabel = EditorMessages.getString("Editor.statusline.mode.insert.label");
    private final String fOverwriteModeLabel = EditorMessages.getString("Editor.statusline.mode.overwrite.label");
    private final String fSmartInsertModeLabel = EditorMessages.getString("Editor.statusline.mode.smartinsert.label");
    protected final String fErrorLabel = EditorMessages.getString("Editor.statusline.error.label");
    private final String fPositionLabelPattern = EditorMessages.getString("Editor.statusline.position.pattern");
    private final PositionLabelValue fLineLabel = new PositionLabelValue();
    private final PositionLabelValue fColumnLabel = new PositionLabelValue();
    private final Object[] fPositionLabelPatternArguments = new Object[]{this.fLineLabel, this.fColumnLabel};
    private IDocumentProvider fExplicitDocumentProvider;
    private IPreferenceStore fPreferenceStore;
    private Annotation fRangeIndicator;
    private SourceViewerConfiguration fConfiguration;
    private ISourceViewer fSourceViewer;
    private SelectionProvider fSelectionProvider = new SelectionProvider();
    private SelectionListener fSelectionListener;
    private Font fFont;
    private Color fForegroundColor;
    private Color fBackgroundColor;
    private Color fSelectionForegroundColor;
    private Color fSelectionBackgroundColor;
    private Color fFindScopeHighlightColor;
    private IEditorStatusLine fEditorStatusLine;
    private IVerticalRuler fVerticalRuler;
    private String fEditorContextMenuId = null;
    private String fRulerContextMenuId = null;
    private String fHelpContextId = null;
    private boolean fShowHighlightRangeOnly;
    private Map fActions = new HashMap(10);
    private List fSelectionActions = new ArrayList(5);
    private List fContentActions = new ArrayList(5);
    private List fPropertyActions = new ArrayList(5);
    private List fStateActions = new ArrayList(5);
    private List fActivationCodes = new ArrayList(2);
    private ActivationCodeTrigger fActivationCodeTrigger = new ActivationCodeTrigger();
    private IMenuListener fMenuListener;
    private MouseListener fMouseListener;
    private ISelectionChangedListener fSelectionChangedListener;
    private Image fTitleImage;
    private Menu fTextContextMenu;
    private Menu fRulerContextMenu;
    private IElementStateListener fElementStateListener = new ElementStateListener();
    private TextInputListener fTextInputListener = new TextInputListener();
    private TextListener fTextListener = new TextListener();
    private IPropertyChangeListener fPropertyChangeListener = new PropertyChangeListener();
    private IPropertyChangeListener fFontPropertyChangeListener = new FontPropertyChangeListener();
    private ActivationListener fActivationListener = new ActivationListener();
    private Map fStatusFields;
    private ICursorListener fCursorListener;
    private ISelection fRememberedSelection;
    private boolean fCompatibilityMode = true;
    private int fErrorCorrectionOnSave;
    private DeleteLineTarget fDeleteLineTarget;
    private IncrementalFindTarget fIncrementalFindTarget;
    private IMarkRegionTarget fMarkRegionTarget;
    private long fModificationStamp = -1L;
    private List fRulerContextMenuListeners = new ArrayList();
    private boolean fIsSanityCheckEnabled = true;
    private FindReplaceTarget fFindReplaceTarget;
    private boolean fIsStateValidationEnabled = true;
    private String[] fKeyBindingScopes;
    private boolean fIsOverwriteModeEnabled = true;
    private boolean fIsOverwriting = false;
    private ITextEditorExtension3.InsertMode fInsertMode = ITextEditorExtension3.SMART_INSERT;
    private List fLegalInsertModes = null;
    private Caret fNonDefaultCaret;
    private Image fNonDefaultCaretImage;
    private Caret fInitialCaret;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;

    protected AbstractTextEditor() {
    }

    public IDocumentProvider getDocumentProvider() {
        return this.fExplicitDocumentProvider;
    }

    protected final Annotation getRangeIndicator() {
        return this.fRangeIndicator;
    }

    protected final SourceViewerConfiguration getSourceViewerConfiguration() {
        return this.fConfiguration;
    }

    protected final ISourceViewer getSourceViewer() {
        return this.fSourceViewer;
    }

    protected final IVerticalRuler getVerticalRuler() {
        return this.fVerticalRuler;
    }

    protected final String getEditorContextMenuId() {
        return this.fEditorContextMenuId;
    }

    protected final String getRulerContextMenuId() {
        return this.fRulerContextMenuId;
    }

    protected final String getHelpContextId() {
        return this.fHelpContextId;
    }

    protected final IPreferenceStore getPreferenceStore() {
        return this.fPreferenceStore;
    }

    protected void setDocumentProvider(IDocumentProvider provider) {
        Assert.isNotNull((Object)provider);
        this.fExplicitDocumentProvider = provider;
    }

    protected void setSourceViewerConfiguration(SourceViewerConfiguration configuration) {
        Assert.isNotNull((Object)configuration);
        this.fConfiguration = configuration;
    }

    protected void setRangeIndicator(Annotation rangeIndicator) {
        Assert.isNotNull((Object)rangeIndicator);
        this.fRangeIndicator = rangeIndicator;
    }

    protected void setEditorContextMenuId(String contextMenuId) {
        Assert.isNotNull((Object)contextMenuId);
        this.fEditorContextMenuId = contextMenuId;
    }

    protected void setRulerContextMenuId(String contextMenuId) {
        Assert.isNotNull((Object)contextMenuId);
        this.fRulerContextMenuId = contextMenuId;
    }

    protected final void setCompatibilityMode(boolean compatible) {
        this.fCompatibilityMode = compatible;
    }

    protected void setHelpContextId(String helpContextId) {
        Assert.isNotNull((Object)helpContextId);
        this.fHelpContextId = helpContextId;
    }

    protected void setKeyBindingScopes(String[] scopes) {
        Assert.isTrue((scopes != null && scopes.length > 0 ? 1 : 0) != 0);
        this.fKeyBindingScopes = scopes;
    }

    protected void setPreferenceStore(IPreferenceStore store) {
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.removePropertyChangeListener(this.fPropertyChangeListener);
        }
        this.fPreferenceStore = store;
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.addPropertyChangeListener(this.fPropertyChangeListener);
        }
    }

    public boolean isEditable() {
        IDocumentProvider provider = this.getDocumentProvider();
        if (provider instanceof IDocumentProviderExtension) {
            IDocumentProviderExtension extension = (IDocumentProviderExtension)((Object)provider);
            return extension.isModifiable(this.getEditorInput());
        }
        return false;
    }

    public ISelectionProvider getSelectionProvider() {
        return this.fSelectionProvider;
    }

    protected void rememberSelection() {
        this.fRememberedSelection = this.doGetSelection();
    }

    protected ISelection doGetSelection() {
        ISelectionProvider sp = null;
        if (this.fSourceViewer != null) {
            sp = this.fSourceViewer.getSelectionProvider();
        }
        return sp == null ? null : sp.getSelection();
    }

    protected void restoreSelection() {
        ITextSelection textSelection;
        if (this.fRememberedSelection instanceof ITextSelection && this.isValidSelection((textSelection = (ITextSelection)this.fRememberedSelection).getOffset(), textSelection.getLength())) {
            this.doSetSelection(this.fRememberedSelection);
        }
        this.fRememberedSelection = null;
    }

    private boolean isValidSelection(int offset, int length) {
        IDocument document;
        IDocumentProvider provider = this.getDocumentProvider();
        if (provider != null && (document = provider.getDocument(this.getEditorInput())) != null) {
            int end = offset + length;
            int documentLength = document.getLength();
            return offset >= 0 && offset <= documentLength && end >= 0 && end <= documentLength;
        }
        return false;
    }

    protected void doSetSelection(ISelection selection) {
        if (selection instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)selection;
            this.selectAndReveal(textSelection.getOffset(), textSelection.getLength());
        }
    }

    protected final IMenuListener getContextMenuListener() {
        if (this.fMenuListener == null) {
            this.fMenuListener = new IMenuListener(){

                public void menuAboutToShow(IMenuManager menu) {
                    String id = menu.getId();
                    if (AbstractTextEditor.this.getRulerContextMenuId().equals(id)) {
                        AbstractTextEditor.this.setFocus();
                        AbstractTextEditor.this.rulerContextMenuAboutToShow(menu);
                    } else if (AbstractTextEditor.this.getEditorContextMenuId().equals(id)) {
                        AbstractTextEditor.this.setFocus();
                        AbstractTextEditor.this.editorContextMenuAboutToShow(menu);
                    }
                }
            };
        }
        return this.fMenuListener;
    }

    protected final MouseListener getRulerMouseListener() {
        if (this.fMouseListener == null) {
            this.fMouseListener = new MouseListener(){
                private boolean fDoubleClicked = false;

                private void triggerAction(String actionID) {
                    IAction action = AbstractTextEditor.this.getAction(actionID);
                    if (action != null) {
                        if (action instanceof IUpdate) {
                            ((IUpdate)action).update();
                        }
                        if (action.isEnabled()) {
                            action.run();
                        }
                    }
                }

                public void mouseUp(MouseEvent e) {
                    AbstractTextEditor.this.setFocus();
                    if (1 == e.button && !this.fDoubleClicked) {
                        this.triggerAction("RulerClick");
                    }
                    this.fDoubleClicked = false;
                }

                public void mouseDoubleClick(MouseEvent e) {
                    if (1 == e.button) {
                        this.fDoubleClicked = true;
                        this.triggerAction("RulerDoubleClick");
                    }
                }

                public void mouseDown(MouseEvent e) {
                    StyledText text = AbstractTextEditor.this.fSourceViewer.getTextWidget();
                    if (text != null && !text.isDisposed()) {
                        Display display = text.getDisplay();
                        Point location = display.getCursorLocation();
                        AbstractTextEditor.this.fRulerContextMenu.setLocation(location.x, location.y);
                    }
                }
            };
        }
        return this.fMouseListener;
    }

    protected final ISelectionChangedListener getSelectionChangedListener() {
        if (this.fSelectionChangedListener == null) {
            this.fSelectionChangedListener = new ISelectionChangedListener(){
                private Runnable fRunnable = new Runnable(this){
                    final /* synthetic */ 12 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        if (AbstractTextEditor.access$0(12.access$0(this.this$1)) != null && AbstractTextEditor.access$0(12.access$0(this.this$1)).getDocument() != null) {
                            12.access$0(this.this$1).updateSelectionDependentActions();
                        }
                    }
                };
                private Display fDisplay;

                public void selectionChanged(SelectionChangedEvent event) {
                    if (this.fDisplay == null) {
                        this.fDisplay = AbstractTextEditor.this.getSite().getShell().getDisplay();
                    }
                    this.fDisplay.asyncExec(this.fRunnable);
                    AbstractTextEditor.this.handleCursorPositionChanged();
                }

                static /* synthetic */ AbstractTextEditor access$0(12 var0) {
                    return var0.AbstractTextEditor.this;
                }
            };
        }
        return this.fSelectionChangedListener;
    }

    protected final ICursorListener getCursorListener() {
        if (this.fCursorListener == null) {
            this.fCursorListener = new ICursorListener(){

                public void keyPressed(KeyEvent e) {
                    AbstractTextEditor.this.handleCursorPositionChanged();
                }

                public void keyReleased(KeyEvent e) {
                }

                public void mouseDoubleClick(MouseEvent e) {
                }

                public void mouseDown(MouseEvent e) {
                }

                public void mouseUp(MouseEvent e) {
                    AbstractTextEditor.this.handleCursorPositionChanged();
                }
            };
        }
        return this.fCursorListener;
    }

    protected final void internalInit(IWorkbenchWindow window, IEditorSite site, final IEditorInput input) throws PartInitException {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            /*
             * Exception decompiling
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 99->103)] java.lang.Throwable
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
        try {
            window.run(false, true, runnable);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException x) {
            Throwable t = x.getTargetException();
            if (t instanceof CoreException) {
                throw new PartInitException(((CoreException)t).getStatus());
            }
            throw new PartInitException((IStatus)new Status(4, "org.eclipse.ui.workbench.texteditor", 0, EditorMessages.getString("Editor.error.init"), t));
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        this.internalInit(window, site, input);
        window.getPartService().addPartListener((IPartListener)this.fActivationListener);
        window.getShell().addShellListener((ShellListener)this.fActivationListener);
    }

    protected IVerticalRuler createVerticalRuler() {
        return new VerticalRuler(12);
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        return new SourceViewer(parent, ruler, styles);
    }

    protected void initializeDragAndDrop(ISourceViewer viewer) {
        Object object;
        ITextEditorDropTargetListener listener;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.texteditor.ITextEditorDropTargetListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((listener = (ITextEditorDropTargetListener)this.getAdapter(clazz)) == null && (object = Platform.getAdapterManager().loadAdapter((Object)this, "org.eclipse.ui.texteditor.ITextEditorDropTargetListener")) instanceof ITextEditorDropTargetListener) {
            listener = (ITextEditorDropTargetListener)object;
        }
        if (listener != null) {
            DropTarget dropTarget = new DropTarget((Control)viewer.getTextWidget(), 3);
            dropTarget.setTransfer(listener.getTransfers());
            dropTarget.addDropListener((DropTargetListener)listener);
        }
    }

    public void createPartControl(Composite parent) {
        String partId;
        String partId2;
        this.fVerticalRuler = this.createVerticalRuler();
        int styles = 68354;
        this.fSourceViewer = this.createSourceViewer(parent, this.fVerticalRuler, styles);
        if (this.fConfiguration == null) {
            this.fConfiguration = new SourceViewerConfiguration();
        }
        this.fSourceViewer.configure(this.fConfiguration);
        if (this.fRangeIndicator != null) {
            this.fSourceViewer.setRangeIndicator(this.fRangeIndicator);
        }
        this.fSourceViewer.addTextListener((ITextListener)this.fTextListener);
        this.fSourceViewer.addTextInputListener((ITextInputListener)this.fTextListener);
        this.getSelectionProvider().addSelectionChangedListener(this.getSelectionChangedListener());
        this.initializeViewerFont(this.fSourceViewer);
        this.initializeViewerColors(this.fSourceViewer);
        this.initializeFindScopeColor(this.fSourceViewer);
        this.initializeDragAndDrop(this.fSourceViewer);
        StyledText styledText = this.fSourceViewer.getTextWidget();
        styledText.addMouseListener((MouseListener)this.getCursorListener());
        styledText.addKeyListener((KeyListener)this.getCursorListener());
        if (this.getHelpContextId() != null) {
            WorkbenchHelp.setHelp((Control)styledText, (String)this.getHelpContextId());
        }
        String id = this.fEditorContextMenuId != null ? this.fEditorContextMenuId : DEFAULT_EDITOR_CONTEXT_MENU_ID;
        MenuManager manager = new MenuManager(id, id);
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(this.getContextMenuListener());
        this.fTextContextMenu = manager.createContextMenu((Control)styledText);
        styledText.setMenu(this.fTextContextMenu);
        if (this.fEditorContextMenuId != null) {
            this.getSite().registerContextMenu(this.fEditorContextMenuId, manager, this.getSelectionProvider());
        } else if (this.fCompatibilityMode) {
            this.getSite().registerContextMenu(DEFAULT_EDITOR_CONTEXT_MENU_ID, manager, this.getSelectionProvider());
        }
        if ((this.fEditorContextMenuId != null && this.fCompatibilityMode || this.fEditorContextMenuId == null) && (partId2 = this.getSite().getId()) != null) {
            this.getSite().registerContextMenu(String.valueOf(partId2) + ".EditorContext", manager, this.getSelectionProvider());
        }
        if (this.fEditorContextMenuId == null) {
            this.fEditorContextMenuId = DEFAULT_EDITOR_CONTEXT_MENU_ID;
        }
        id = this.fRulerContextMenuId != null ? this.fRulerContextMenuId : DEFAULT_RULER_CONTEXT_MENU_ID;
        manager = new MenuManager(id, id);
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(this.getContextMenuListener());
        Control rulerControl = this.fVerticalRuler.getControl();
        this.fRulerContextMenu = manager.createContextMenu(rulerControl);
        rulerControl.setMenu(this.fRulerContextMenu);
        rulerControl.addMouseListener(this.getRulerMouseListener());
        if (this.fRulerContextMenuId != null) {
            this.getSite().registerContextMenu(this.fRulerContextMenuId, manager, this.getSelectionProvider());
        } else if (this.fCompatibilityMode) {
            this.getSite().registerContextMenu(DEFAULT_RULER_CONTEXT_MENU_ID, manager, this.getSelectionProvider());
        }
        if ((this.fRulerContextMenuId != null && this.fCompatibilityMode || this.fRulerContextMenuId == null) && (partId = this.getSite().getId()) != null) {
            this.getSite().registerContextMenu(String.valueOf(partId) + ".RulerContext", manager, this.getSelectionProvider());
        }
        if (this.fRulerContextMenuId == null) {
            this.fRulerContextMenuId = DEFAULT_RULER_CONTEXT_MENU_ID;
        }
        this.getSite().setSelectionProvider(this.getSelectionProvider());
        this.fSelectionListener = new SelectionListener();
        this.fSelectionListener.install(this.getSelectionProvider());
        this.fSelectionListener.setDocument(this.getDocumentProvider().getDocument(this.getEditorInput()));
        this.initializeActivationCodeTrigger();
        this.createNavigationActions();
        this.createAccessibilityActions();
        this.createActions();
        this.initializeSourceViewer(this.getEditorInput());
        JFaceResources.getFontRegistry().addListener(this.fFontPropertyChangeListener);
    }

    private void initializeActivationCodeTrigger() {
        this.fActivationCodeTrigger.install();
        this.fActivationCodeTrigger.setScopes(this.fKeyBindingScopes);
    }

    private void initializeViewerFont(ISourceViewer viewer) {
        FontData data;
        boolean isSharedFont = true;
        Font font = null;
        String symbolicFontName = this.getSymbolicFontName();
        if (symbolicFontName != null) {
            font = JFaceResources.getFont((String)symbolicFontName);
        } else if (this.fPreferenceStore != null && this.fPreferenceStore.contains(PREFERENCE_FONT) && !this.fPreferenceStore.isDefault(PREFERENCE_FONT) && (data = PreferenceConverter.getFontData((IPreferenceStore)this.fPreferenceStore, (String)PREFERENCE_FONT)) != null) {
            isSharedFont = false;
            font = new Font((Device)viewer.getTextWidget().getDisplay(), data);
        }
        if (font == null) {
            font = JFaceResources.getTextFont();
        }
        this.setFont(viewer, font);
        if (this.fFont != null) {
            this.fFont.dispose();
            this.fFont = null;
        }
        if (!isSharedFont) {
            this.fFont = font;
        }
    }

    private void setFont(ISourceViewer sourceViewer, Font font) {
        if (sourceViewer.getDocument() != null) {
            StyledText styledText;
            Point selection = sourceViewer.getSelectedRange();
            int topIndex = sourceViewer.getTopIndex();
            StyledText parent = styledText = sourceViewer.getTextWidget();
            if (sourceViewer instanceof ITextViewerExtension) {
                ITextViewerExtension extension = (ITextViewerExtension)sourceViewer;
                parent = extension.getControl();
            }
            parent.setRedraw(false);
            styledText.setFont(font);
            if (this.fVerticalRuler instanceof IVerticalRulerExtension) {
                IVerticalRulerExtension e = (IVerticalRulerExtension)this.fVerticalRuler;
                e.setFont(font);
            }
            sourceViewer.setSelectedRange(selection.x, selection.y);
            sourceViewer.setTopIndex(topIndex);
            if (parent instanceof Composite) {
                Composite composite = (Composite)parent;
                composite.layout(true);
            }
            parent.setRedraw(true);
        } else {
            StyledText styledText = sourceViewer.getTextWidget();
            styledText.setFont(font);
            if (this.fVerticalRuler instanceof IVerticalRulerExtension) {
                IVerticalRulerExtension e = (IVerticalRulerExtension)this.fVerticalRuler;
                e.setFont(font);
            }
        }
    }

    private Color createColor(IPreferenceStore store, String key, Display display) {
        RGB rgb = null;
        if (store.contains(key) && (rgb = store.isDefault(key) ? PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)key) : PreferenceConverter.getColor((IPreferenceStore)store, (String)key)) != null) {
            return new Color((Device)display, rgb);
        }
        return null;
    }

    protected void initializeViewerColors(ISourceViewer viewer) {
        IPreferenceStore store = this.getPreferenceStore();
        if (store != null) {
            StyledText styledText = viewer.getTextWidget();
            Color color = store.getBoolean(PREFERENCE_COLOR_FOREGROUND_SYSTEM_DEFAULT) ? null : this.createColor(store, PREFERENCE_COLOR_FOREGROUND, styledText.getDisplay());
            styledText.setForeground(color);
            if (this.fForegroundColor != null) {
                this.fForegroundColor.dispose();
            }
            this.fForegroundColor = color;
            color = store.getBoolean(PREFERENCE_COLOR_BACKGROUND_SYSTEM_DEFAULT) ? null : this.createColor(store, PREFERENCE_COLOR_BACKGROUND, styledText.getDisplay());
            styledText.setBackground(color);
            if (this.fBackgroundColor != null) {
                this.fBackgroundColor.dispose();
            }
            this.fBackgroundColor = color;
            color = store.getBoolean(PREFERENCE_COLOR_SELECTION_FOREGROUND_SYSTEM_DEFAULT) ? null : this.createColor(store, PREFERENCE_COLOR_SELECTION_FOREGROUND, styledText.getDisplay());
            styledText.setSelectionForeground(color);
            if (this.fSelectionForegroundColor != null) {
                this.fSelectionForegroundColor.dispose();
            }
            this.fSelectionForegroundColor = color;
            color = store.getBoolean(PREFERENCE_COLOR_SELECTION_BACKGROUND_SYSTEM_DEFAULT) ? null : this.createColor(store, PREFERENCE_COLOR_SELECTION_BACKGROUND, styledText.getDisplay());
            styledText.setSelectionBackground(color);
            if (this.fSelectionBackgroundColor != null) {
                this.fSelectionBackgroundColor.dispose();
            }
            this.fSelectionBackgroundColor = color;
        }
    }

    private void initializeFindScopeColor(ISourceViewer viewer) {
        IPreferenceStore store = this.getPreferenceStore();
        if (store != null) {
            StyledText styledText = viewer.getTextWidget();
            Color color = this.createColor(store, PREFERENCE_COLOR_FIND_SCOPE, styledText.getDisplay());
            IFindReplaceTarget target = viewer.getFindReplaceTarget();
            if (target != null && target instanceof IFindReplaceTargetExtension) {
                ((IFindReplaceTargetExtension)target).setScopeHighlightColor(color);
            }
            if (this.fFindScopeHighlightColor != null) {
                this.fFindScopeHighlightColor.dispose();
            }
            this.fFindScopeHighlightColor = color;
        }
    }

    private void initializeSourceViewer(IEditorInput input) {
        IAnnotationModel model = this.getDocumentProvider().getAnnotationModel(input);
        IDocument document = this.getDocumentProvider().getDocument(input);
        if (document != null) {
            this.fSourceViewer.setDocument(document, model);
            this.fSourceViewer.setEditable(this.isEditable());
            this.fSourceViewer.showAnnotations(model != null);
        }
        if (this.fElementStateListener instanceof IElementStateListenerExtension) {
            IElementStateListenerExtension extension = (IElementStateListenerExtension)((Object)this.fElementStateListener);
            extension.elementStateValidationChanged(input, false);
        }
        if (this.fInitialCaret == null) {
            this.fInitialCaret = this.getSourceViewer().getTextWidget().getCaret();
        }
        if (this.fIsOverwriting) {
            this.fSourceViewer.getTextWidget().invokeAction(0x1000009);
        }
        this.handleInsertModeChanged();
    }

    private void initializeTitle(IEditorInput input) {
        Image oldImage = this.fTitleImage;
        this.fTitleImage = null;
        String title = "";
        if (input != null) {
            IEditorRegistry editorRegistry = this.getEditorSite().getPage().getWorkbenchWindow().getWorkbench().getEditorRegistry();
            IEditorDescriptor editorDesc = editorRegistry.findEditor(this.getSite().getId());
            ImageDescriptor imageDesc = editorDesc != null ? editorDesc.getImageDescriptor() : null;
            this.fTitleImage = imageDesc != null ? imageDesc.createImage() : null;
            title = input.getName();
        }
        this.setTitleImage(this.fTitleImage);
        this.setTitle(title);
        this.firePropertyChange(257);
        if (oldImage != null && !oldImage.isDisposed()) {
            oldImage.dispose();
        }
    }

    protected void setDocumentProvider(IEditorInput input) {
    }

    private void updateDocumentProvider(IEditorInput input) {
        IDocumentProviderExtension2 extension;
        IProgressMonitor rememberedProgressMonitor = null;
        IDocumentProvider provider = this.getDocumentProvider();
        if (provider != null) {
            provider.removeElementStateListener(this.fElementStateListener);
            if (provider instanceof IDocumentProviderExtension2) {
                extension = (IDocumentProviderExtension2)((Object)provider);
                rememberedProgressMonitor = extension.getProgressMonitor();
                extension.setProgressMonitor(null);
            }
        }
        this.setDocumentProvider(input);
        provider = this.getDocumentProvider();
        if (provider != null) {
            provider.addElementStateListener(this.fElementStateListener);
            if (provider instanceof IDocumentProviderExtension2) {
                extension = (IDocumentProviderExtension2)((Object)provider);
                extension.setProgressMonitor(rememberedProgressMonitor);
            }
        }
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        if (input == null) {
            this.close(this.isSaveOnCloseNeeded());
        } else {
            IEditorInput oldInput = this.getEditorInput();
            if (oldInput != null) {
                this.getDocumentProvider().disconnect(oldInput);
            }
            super.setInput(input);
            this.updateDocumentProvider(input);
            IDocumentProvider provider = this.getDocumentProvider();
            if (provider == null) {
                Status s = new Status(4, "org.eclipse.ui", 0, EditorMessages.getString("Editor.error.no_provider"), null);
                throw new CoreException((IStatus)s);
            }
            provider.connect(input);
            this.initializeTitle(input);
            if (this.fSourceViewer != null) {
                this.initializeSourceViewer(input);
            }
            if (this.fIsOverwriting) {
                this.toggleOverwriteMode();
            }
            this.setInsertMode((ITextEditorExtension3.InsertMode)this.getLegalInsertModes().get(0));
            this.updateCaret();
            this.updateStatusField("ElementState");
            if (this.fSelectionListener != null) {
                this.fSelectionListener.setDocument(this.getDocumentProvider().getDocument(input));
            }
        }
    }

    public final void setInput(IEditorInput input) {
        try {
            this.doSetInput(input);
        }
        catch (CoreException x) {
            String title = EditorMessages.getString("Editor.error.setinput.title");
            String msg = EditorMessages.getString("Editor.error.setinput.message");
            Shell shell = this.getSite().getShell();
            ErrorDialog.openError((Shell)shell, (String)title, (String)msg, (IStatus)x.getStatus());
        }
    }

    public void close(final boolean save) {
        this.enableSanityChecking(false);
        Display display = this.getSite().getShell().getDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                if (AbstractTextEditor.this.fSourceViewer != null) {
                    AbstractTextEditor.this.getSite().getPage().closeEditor((IEditorPart)AbstractTextEditor.this, save);
                }
            }
        });
    }

    public void dispose() {
        if (this.fActivationListener != null) {
            IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
            window.getPartService().removePartListener((IPartListener)this.fActivationListener);
            Shell shell = window.getShell();
            if (shell != null && !shell.isDisposed()) {
                shell.removeShellListener((ShellListener)this.fActivationListener);
            }
            this.fActivationListener = null;
        }
        if (this.fTitleImage != null) {
            this.fTitleImage.dispose();
            this.fTitleImage = null;
        }
        if (this.fFont != null) {
            this.fFont.dispose();
            this.fFont = null;
        }
        this.disposeNonDefaultCaret();
        this.fInitialCaret = null;
        if (this.fForegroundColor != null) {
            this.fForegroundColor.dispose();
            this.fForegroundColor = null;
        }
        if (this.fBackgroundColor != null) {
            this.fBackgroundColor.dispose();
            this.fBackgroundColor = null;
        }
        if (this.fSelectionForegroundColor != null) {
            this.fSelectionForegroundColor.dispose();
            this.fSelectionForegroundColor = null;
        }
        if (this.fSelectionBackgroundColor != null) {
            this.fSelectionBackgroundColor.dispose();
            this.fSelectionBackgroundColor = null;
        }
        if (this.fFindScopeHighlightColor != null) {
            this.fFindScopeHighlightColor.dispose();
            this.fFindScopeHighlightColor = null;
        }
        if (this.fFontPropertyChangeListener != null) {
            JFaceResources.getFontRegistry().removeListener(this.fFontPropertyChangeListener);
            this.fFontPropertyChangeListener = null;
        }
        if (this.fPropertyChangeListener != null) {
            if (this.fPreferenceStore != null) {
                this.fPreferenceStore.removePropertyChangeListener(this.fPropertyChangeListener);
                this.fPreferenceStore = null;
            }
            this.fPropertyChangeListener = null;
        }
        if (this.fActivationCodeTrigger != null) {
            this.fActivationCodeTrigger.uninstall();
            this.fActivationCodeTrigger = null;
        }
        if (this.fSelectionListener != null) {
            this.fSelectionListener.uninstall(this.getSelectionProvider());
            this.fSelectionListener = null;
        }
        this.disposeDocumentProvider();
        if (this.fSourceViewer != null) {
            if (this.fTextListener != null) {
                this.fSourceViewer.removeTextListener((ITextListener)this.fTextListener);
                this.fSourceViewer.removeTextInputListener((ITextInputListener)this.fTextListener);
                this.fTextListener = null;
            }
            this.fTextInputListener = null;
            this.fSelectionProvider = null;
            this.fSourceViewer = null;
        }
        if (this.fTextContextMenu != null) {
            this.fTextContextMenu.dispose();
            this.fTextContextMenu = null;
        }
        if (this.fRulerContextMenu != null) {
            this.fRulerContextMenu.dispose();
            this.fRulerContextMenu = null;
        }
        if (this.fActions != null) {
            this.fActions.clear();
            this.fActions = null;
        }
        if (this.fSelectionActions != null) {
            this.fSelectionActions.clear();
            this.fSelectionActions = null;
        }
        if (this.fContentActions != null) {
            this.fContentActions.clear();
            this.fContentActions = null;
        }
        if (this.fPropertyActions != null) {
            this.fPropertyActions.clear();
            this.fPropertyActions = null;
        }
        if (this.fStateActions != null) {
            this.fStateActions.clear();
            this.fStateActions = null;
        }
        if (this.fActivationCodes != null) {
            this.fActivationCodes.clear();
            this.fActivationCodes = null;
        }
        if (this.fEditorStatusLine != null) {
            this.fEditorStatusLine = null;
        }
        if (this.fConfiguration != null) {
            this.fConfiguration = null;
        }
        super.setInput(null);
        super.dispose();
    }

    protected void disposeDocumentProvider() {
        IDocumentProvider provider = this.getDocumentProvider();
        if (provider != null) {
            IEditorInput input = this.getEditorInput();
            if (input != null) {
                provider.disconnect(input);
            }
            if (this.fElementStateListener != null) {
                provider.removeElementStateListener(this.fElementStateListener);
                this.fElementStateListener = null;
            }
            this.fExplicitDocumentProvider = null;
        }
    }

    protected boolean affectsTextPresentation(PropertyChangeEvent event) {
        return false;
    }

    private String getSymbolicFontName() {
        if (this.getConfigurationElement() != null) {
            return this.getConfigurationElement().getAttribute("symbolicFontName");
        }
        return null;
    }

    protected final String getFontPropertyPreferenceKey() {
        String symbolicFontName = this.getSymbolicFontName();
        if (symbolicFontName != null) {
            return symbolicFontName;
        }
        return PREFERENCE_FONT;
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        if (this.fSourceViewer == null) {
            return;
        }
        String property = event.getProperty();
        if (this.getFontPropertyPreferenceKey().equals(property)) {
            return;
        }
        if (PREFERENCE_COLOR_FOREGROUND.equals(property) || PREFERENCE_COLOR_FOREGROUND_SYSTEM_DEFAULT.equals(property) || PREFERENCE_COLOR_BACKGROUND.equals(property) || PREFERENCE_COLOR_BACKGROUND_SYSTEM_DEFAULT.equals(property) || PREFERENCE_COLOR_SELECTION_FOREGROUND.equals(property) || PREFERENCE_COLOR_SELECTION_FOREGROUND_SYSTEM_DEFAULT.equals(property) || PREFERENCE_COLOR_SELECTION_BACKGROUND.equals(property) || PREFERENCE_COLOR_SELECTION_BACKGROUND_SYSTEM_DEFAULT.equals(property)) {
            this.initializeViewerColors(this.fSourceViewer);
        } else if (PREFERENCE_COLOR_FIND_SCOPE.equals(property)) {
            this.initializeFindScopeColor(this.fSourceViewer);
        } else if (PREFERENCE_USE_CUSTOM_CARETS.equals(property)) {
            this.updateCaret();
        } else if (PREFERENCE_WIDE_CARET.equals(property)) {
            this.updateCaret();
        }
        if (this.affectsTextPresentation(event)) {
            this.fSourceViewer.invalidateTextPresentation();
        }
    }

    protected IProgressMonitor getProgressMonitor() {
        IProgressMonitor pm = null;
        IStatusLineManager manager = this.getStatusLineManager();
        if (manager != null) {
            pm = manager.getProgressMonitor();
        }
        return pm != null ? pm : new NullProgressMonitor();
    }

    protected void handleEditorInputChanged() {
        block14: {
            Shell shell = this.getSite().getShell();
            IDocumentProvider provider = this.getDocumentProvider();
            if (provider == null) {
                this.close(false);
                return;
            }
            IEditorInput input = this.getEditorInput();
            if (provider.isDeleted(input)) {
                if (this.isSaveAsAllowed()) {
                    String[] buttons;
                    String msg;
                    String title = EditorMessages.getString("Editor.error.activated.deleted.save.title");
                    MessageDialog dialog = new MessageDialog(shell, title, null, msg = EditorMessages.getString("Editor.error.activated.deleted.save.message"), 3, buttons = new String[]{EditorMessages.getString("Editor.error.activated.deleted.save.button.save"), EditorMessages.getString("Editor.error.activated.deleted.save.button.close")}, 0);
                    if (dialog.open() == 0) {
                        IProgressMonitor pm = this.getProgressMonitor();
                        this.performSaveAs(pm);
                        if (pm.isCanceled()) {
                            this.handleEditorInputChanged();
                        }
                    } else {
                        this.close(false);
                    }
                } else {
                    String msg;
                    String title = EditorMessages.getString("Editor.error.activated.deleted.close.title");
                    if (MessageDialog.openConfirm((Shell)shell, (String)title, (String)(msg = EditorMessages.getString("Editor.error.activated.deleted.close.message")))) {
                        this.close(false);
                    }
                }
            } else {
                String msg;
                String title = EditorMessages.getString("Editor.error.activated.outofsync.title");
                if (MessageDialog.openQuestion((Shell)shell, (String)title, (String)(msg = EditorMessages.getString("Editor.error.activated.outofsync.message")))) {
                    try {
                        if (provider instanceof IDocumentProviderExtension) {
                            IDocumentProviderExtension extension = (IDocumentProviderExtension)((Object)provider);
                            extension.synchronize(input);
                        } else {
                            this.doSetInput(input);
                        }
                    }
                    catch (CoreException x) {
                        IStatus status = x.getStatus();
                        if (status != null && status.getSeverity() == 8) break block14;
                        title = EditorMessages.getString("Editor.error.refresh.outofsync.title");
                        msg = EditorMessages.getString("Editor.error.refresh.outofsync.message");
                        ErrorDialog.openError((Shell)shell, (String)title, (String)msg, (IStatus)x.getStatus());
                    }
                }
            }
        }
    }

    public void doSaveAs() {
        this.performSaveAs(this.getProgressMonitor());
    }

    protected void performSaveAs(IProgressMonitor progressMonitor) {
    }

    public void doSave(IProgressMonitor progressMonitor) {
        IDocumentProvider p = this.getDocumentProvider();
        if (p == null) {
            return;
        }
        if (p.isDeleted(this.getEditorInput())) {
            if (this.isSaveAsAllowed()) {
                this.performSaveAs(progressMonitor);
            } else {
                Shell shell = this.getSite().getShell();
                String title = EditorMessages.getString("Editor.error.save.deleted.title");
                String msg = EditorMessages.getString("Editor.error.save.deleted.message");
                MessageDialog.openError((Shell)shell, (String)title, (String)msg);
            }
        } else {
            this.updateState(this.getEditorInput());
            this.validateState(this.getEditorInput());
            this.performSave(false, progressMonitor);
        }
    }

    protected void enableSanityChecking(boolean enable) {
        AbstractTextEditor abstractTextEditor = this;
        synchronized (abstractTextEditor) {
            this.fIsSanityCheckEnabled = enable;
        }
    }

    protected void safelySanityCheckState(IEditorInput input) {
        boolean enabled = false;
        AbstractTextEditor abstractTextEditor = this;
        synchronized (abstractTextEditor) {
            enabled = this.fIsSanityCheckEnabled;
        }
        if (enabled) {
            this.sanityCheckState(input);
        }
    }

    protected void sanityCheckState(IEditorInput input) {
        IDocumentProvider p = this.getDocumentProvider();
        if (p == null) {
            return;
        }
        if (p instanceof IDocumentProviderExtension3) {
            IDocumentProviderExtension3 p3 = (IDocumentProviderExtension3)((Object)p);
            long stamp = p.getModificationStamp(input);
            if (stamp != this.fModificationStamp) {
                this.fModificationStamp = stamp;
                if (!p3.isSynchronized(input)) {
                    this.handleEditorInputChanged();
                }
            }
        } else {
            long stamp;
            if (this.fModificationStamp == -1L) {
                this.fModificationStamp = p.getSynchronizationStamp(input);
            }
            if ((stamp = p.getModificationStamp(input)) != this.fModificationStamp) {
                this.fModificationStamp = stamp;
                if (stamp != p.getSynchronizationStamp(input)) {
                    this.handleEditorInputChanged();
                }
            }
        }
        this.updateState(this.getEditorInput());
        this.updateStatusField("ElementState");
    }

    protected void enableStateValidation(boolean enable) {
        AbstractTextEditor abstractTextEditor = this;
        synchronized (abstractTextEditor) {
            this.fIsStateValidationEnabled = enable;
        }
    }

    protected void validateState(IEditorInput input) {
        IDocumentProvider provider = this.getDocumentProvider();
        if (!(provider instanceof IDocumentProviderExtension)) {
            return;
        }
        IDocumentProviderExtension extension = (IDocumentProviderExtension)((Object)provider);
        try {
            extension.validateState(input, this.getSite().getShell());
        }
        catch (CoreException x) {
            IStatus status = x.getStatus();
            if (status == null || status.getSeverity() != 8) {
                Bundle bundle = Platform.getBundle((String)"org.eclipse.ui");
                ILog log = Platform.getLog((Bundle)bundle);
                log.log(x.getStatus());
                Shell shell = this.getSite().getShell();
                String title = EditorMessages.getString("Editor.error.validateEdit.title");
                String msg = EditorMessages.getString("Editor.error.validateEdit.message");
                ErrorDialog.openError((Shell)shell, (String)title, (String)msg, (IStatus)x.getStatus());
            }
            return;
        }
        if (this.fSourceViewer != null) {
            this.fSourceViewer.setEditable(this.isEditable());
        }
        this.updateStateDependentActions();
    }

    public boolean validateEditorInputState() {
        boolean enabled = false;
        AbstractTextEditor abstractTextEditor = this;
        synchronized (abstractTextEditor) {
            enabled = this.fIsStateValidationEnabled;
        }
        if (enabled) {
            boolean bl;
            ISourceViewer viewer = this.getSourceViewer();
            if (viewer == null) {
                return false;
            }
            this.fTextInputListener.inputChanged = false;
            viewer.addTextInputListener((ITextInputListener)this.fTextInputListener);
            try {
                final IEditorInput input = this.getEditorInput();
                BusyIndicator.showWhile((Display)this.getSite().getShell().getDisplay(), (Runnable)new Runnable(){

                    public void run() {
                        AbstractTextEditor.this.validateState(input);
                    }
                });
                this.sanityCheckState(input);
                bl = !this.isEditorInputReadOnly() && !this.fTextInputListener.inputChanged;
                Object var4_5 = null;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                viewer.removeTextInputListener((ITextInputListener)this.fTextInputListener);
                throw throwable;
            }
            viewer.removeTextInputListener((ITextInputListener)this.fTextInputListener);
            return bl;
        }
        return !this.isEditorInputReadOnly();
    }

    protected void updateState(IEditorInput input) {
        IDocumentProvider provider = this.getDocumentProvider();
        if (provider instanceof IDocumentProviderExtension) {
            IDocumentProviderExtension extension = (IDocumentProviderExtension)((Object)provider);
            try {
                boolean wasReadOnly = this.isEditorInputReadOnly();
                extension.updateStateCache(input);
                if (this.fSourceViewer != null) {
                    this.fSourceViewer.setEditable(this.isEditable());
                }
                if (wasReadOnly != this.isEditorInputReadOnly()) {
                    this.updateStateDependentActions();
                }
            }
            catch (CoreException x) {
                Bundle bundle = Platform.getBundle((String)"org.eclipse.ui");
                ILog log = Platform.getLog((Bundle)bundle);
                log.log(x.getStatus());
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void performSave(boolean overwrite, IProgressMonitor progressMonitor) {
        IDocumentProvider provider = this.getDocumentProvider();
        if (provider == null) {
            return;
        }
        try {
            try {
                provider.aboutToChange(this.getEditorInput());
                IEditorInput input = this.getEditorInput();
                provider.saveDocument(progressMonitor, input, this.getDocumentProvider().getDocument(input), overwrite);
                this.editorSaved();
            }
            catch (CoreException x) {
                IStatus status = x.getStatus();
                if (status == null || status.getSeverity() != 8) {
                    this.handleExceptionOnSave(x, progressMonitor);
                }
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            provider.changed(this.getEditorInput());
            throw throwable;
        }
        {
            Object var6_9 = null;
            provider.changed(this.getEditorInput());
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void handleExceptionOnSave(CoreException exception, IProgressMonitor progressMonitor) {
        try {
            block10: {
                String title;
                Shell shell;
                block9: {
                    String msg;
                    ++this.fErrorCorrectionOnSave;
                    shell = this.getSite().getShell();
                    boolean isSynchronized = false;
                    IDocumentProvider p = this.getDocumentProvider();
                    if (p instanceof IDocumentProviderExtension3) {
                        IDocumentProviderExtension3 p3 = (IDocumentProviderExtension3)((Object)p);
                        isSynchronized = p3.isSynchronized(this.getEditorInput());
                    } else {
                        long synchStamp;
                        long modifiedStamp = p.getModificationStamp(this.getEditorInput());
                        boolean bl = isSynchronized = modifiedStamp == (synchStamp = p.getSynchronizationStamp(this.getEditorInput()));
                    }
                    if (this.fErrorCorrectionOnSave != 1 || isSynchronized) break block9;
                    title = EditorMessages.getString("Editor.error.save.outofsync.title");
                    if (MessageDialog.openQuestion((Shell)shell, (String)title, (String)(msg = EditorMessages.getString("Editor.error.save.outofsync.message")))) {
                        this.performSave(true, progressMonitor);
                        break block10;
                    } else if (progressMonitor != null) {
                        progressMonitor.setCanceled(true);
                    }
                    break block10;
                }
                title = EditorMessages.getString("Editor.error.save.title");
                String msg = EditorMessages.getString("Editor.error.save.message");
                ErrorDialog.openError((Shell)shell, (String)title, (String)msg, (IStatus)exception.getStatus());
                if (progressMonitor != null) {
                    progressMonitor.setCanceled(true);
                }
            }
            Object var10_13 = null;
            --this.fErrorCorrectionOnSave;
            return;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            --this.fErrorCorrectionOnSave;
            throw throwable;
        }
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        IDocumentProvider p = this.getDocumentProvider();
        return p == null ? false : p.mustSaveDocument(this.getEditorInput());
    }

    public boolean isDirty() {
        IDocumentProvider p = this.getDocumentProvider();
        return p == null ? false : p.canSaveDocument(this.getEditorInput());
    }

    public void doRevertToSaved() {
        IDocumentProvider p = this.getDocumentProvider();
        if (p == null) {
            return;
        }
        this.performRevert();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void performRevert() {
        IDocumentProvider provider = this.getDocumentProvider();
        if (provider == null) {
            return;
        }
        try {
            try {
                provider.aboutToChange(this.getEditorInput());
                provider.resetDocument(this.getEditorInput());
                this.editorSaved();
            }
            catch (CoreException x) {
                IStatus status = x.getStatus();
                if (status == null || status.getSeverity() != 8) {
                    Shell shell = this.getSite().getShell();
                    String title = EditorMessages.getString("Editor.error.revert.title");
                    String msg = EditorMessages.getString("Editor.error.revert.message");
                    ErrorDialog.openError((Shell)shell, (String)title, (String)msg, (IStatus)x.getStatus());
                }
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            provider.changed(this.getEditorInput());
            throw throwable;
        }
        {
            Object var7_9 = null;
            provider.changed(this.getEditorInput());
            return;
        }
    }

    protected void handleElementContentReplaced() {
    }

    public void setAction(String actionID, IAction action) {
        Assert.isNotNull((Object)actionID);
        if (action == null) {
            action = (IAction)this.fActions.remove(actionID);
            if (action != null) {
                this.fActivationCodeTrigger.unregisterActionFromKeyActivation(action);
            }
        } else {
            this.fActions.put(actionID, action);
            this.fActivationCodeTrigger.registerActionForKeyActivation(action);
        }
    }

    public void setActionActivationCode(String actionID, char activationCharacter, int activationKeyCode, int activationStateMask) {
        Assert.isNotNull((Object)actionID);
        ActionActivationCode found = this.findActionActivationCode(actionID);
        if (found == null) {
            found = new ActionActivationCode(actionID);
            this.fActivationCodes.add(found);
        }
        found.fCharacter = activationCharacter;
        found.fKeyCode = activationKeyCode;
        found.fStateMask = activationStateMask;
    }

    private ActionActivationCode findActionActivationCode(String actionID) {
        int size = this.fActivationCodes.size();
        int i = 0;
        while (i < size) {
            ActionActivationCode code = (ActionActivationCode)this.fActivationCodes.get(i);
            if (actionID.equals(code.fActionId)) {
                return code;
            }
            ++i;
        }
        return null;
    }

    public void removeActionActivationCode(String actionID) {
        Assert.isNotNull((Object)actionID);
        ActionActivationCode code = this.findActionActivationCode(actionID);
        if (code != null) {
            this.fActivationCodes.remove(code);
        }
    }

    public IAction getAction(String actionID) {
        Assert.isNotNull((Object)actionID);
        IAction action = (IAction)this.fActions.get(actionID);
        if (action == null && (action = this.findContributedAction(actionID)) != null) {
            this.setAction(actionID, action);
        }
        return action;
    }

    private IAction findContributedAction(String actionID) {
        Object element;
        ArrayList<IConfigurationElement> actions = new ArrayList<IConfigurationElement>();
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.ui", "editorActions");
        int i = 0;
        while (i < elements.length) {
            element = elements[i];
            if (TAG_CONTRIBUTION_TYPE.equals(element.getName()) && this.getSite().getId().equals(element.getAttribute("targetID"))) {
                IConfigurationElement[] children = element.getChildren("action");
                int j = 0;
                while (j < children.length) {
                    IConfigurationElement child = children[j];
                    if (actionID.equals(child.getAttribute("actionID"))) {
                        actions.add(child);
                    }
                    ++j;
                }
            }
            ++i;
        }
        int actionSize = actions.size();
        if (actionSize > 0) {
            if (actionSize > 1) {
                Object[] actionArray = actions.toArray(new IConfigurationElement[actionSize]);
                ConfigurationElementSorter sorter = new ConfigurationElementSorter(){

                    public IConfigurationElement getConfigurationElement(Object object) {
                        return (IConfigurationElement)object;
                    }
                };
                sorter.sort(actionArray);
                element = actionArray[0];
            } else {
                element = (IConfigurationElement)actions.get(0);
            }
            String defId = element.getAttribute("definitionId");
            return new EditorPluginAction(element, (IEditorPart)this, defId, 0);
        }
        return null;
    }

    private void updateAction(String actionId) {
        IAction action;
        Assert.isNotNull((Object)actionId);
        if (this.fActions != null && (action = (IAction)this.fActions.get(actionId)) instanceof IUpdate) {
            ((IUpdate)action).update();
        }
    }

    public void markAsSelectionDependentAction(String actionId, boolean mark) {
        Assert.isNotNull((Object)actionId);
        if (mark) {
            if (!this.fSelectionActions.contains(actionId)) {
                this.fSelectionActions.add(actionId);
            }
        } else {
            this.fSelectionActions.remove(actionId);
        }
    }

    public void markAsContentDependentAction(String actionId, boolean mark) {
        Assert.isNotNull((Object)actionId);
        if (mark) {
            if (!this.fContentActions.contains(actionId)) {
                this.fContentActions.add(actionId);
            }
        } else {
            this.fContentActions.remove(actionId);
        }
    }

    public void markAsPropertyDependentAction(String actionId, boolean mark) {
        Assert.isNotNull((Object)actionId);
        if (mark) {
            if (!this.fPropertyActions.contains(actionId)) {
                this.fPropertyActions.add(actionId);
            }
        } else {
            this.fPropertyActions.remove(actionId);
        }
    }

    public void markAsStateDependentAction(String actionId, boolean mark) {
        Assert.isNotNull((Object)actionId);
        if (mark) {
            if (!this.fStateActions.contains(actionId)) {
                this.fStateActions.add(actionId);
            }
        } else {
            this.fStateActions.remove(actionId);
        }
    }

    protected void updateSelectionDependentActions() {
        if (this.fSelectionActions != null) {
            Iterator e = this.fSelectionActions.iterator();
            while (e.hasNext()) {
                this.updateAction((String)e.next());
            }
        }
    }

    protected void updateContentDependentActions() {
        if (this.fContentActions != null) {
            Iterator e = this.fContentActions.iterator();
            while (e.hasNext()) {
                this.updateAction((String)e.next());
            }
        }
    }

    protected void updatePropertyDependentActions() {
        if (this.fPropertyActions != null) {
            Iterator e = this.fPropertyActions.iterator();
            while (e.hasNext()) {
                this.updateAction((String)e.next());
            }
        }
    }

    protected void updateStateDependentActions() {
        if (this.fStateActions != null) {
            Iterator e = this.fStateActions.iterator();
            while (e.hasNext()) {
                this.updateAction((String)e.next());
            }
        }
    }

    protected void createNavigationActions() {
        Action action;
        StyledText textWidget = this.getSourceViewer().getTextWidget();
        int i = 0;
        while (i < ACTION_MAP.length) {
            IdMapEntry entry = ACTION_MAP[i];
            action = new TextNavigationAction(textWidget, entry.getAction());
            action.setActionDefinitionId(entry.getActionId());
            this.setAction(entry.getActionId(), (IAction)action);
            ++i;
        }
        action = new ToggleOverwriteModeAction(EditorMessages.getResourceBundle(), "Editor.ToggleOverwriteMode.");
        action.setActionDefinitionId("org.eclipse.ui.edit.text.toggleOverwrite");
        this.setAction("org.eclipse.ui.edit.text.toggleOverwrite", (IAction)action);
        textWidget.setKeyBinding(0x1000009, 0);
        action = new ScrollLinesAction(-1);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.scroll.lineUp");
        this.setAction("org.eclipse.ui.edit.text.scroll.lineUp", (IAction)action);
        action = new ScrollLinesAction(1);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.scroll.lineDown");
        this.setAction("org.eclipse.ui.edit.text.scroll.lineDown", (IAction)action);
        action = new LineEndAction(textWidget, false);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.goto.lineEnd");
        this.setAction("org.eclipse.ui.edit.text.goto.lineEnd", (IAction)action);
        action = new LineStartAction(textWidget, false);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.goto.lineStart");
        this.setAction("org.eclipse.ui.edit.text.goto.lineStart", (IAction)action);
        action = new LineEndAction(textWidget, true);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.select.lineEnd");
        this.setAction("org.eclipse.ui.edit.text.select.lineEnd", (IAction)action);
        action = new LineStartAction(textWidget, true);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.select.lineStart");
        this.setAction("org.eclipse.ui.edit.text.select.lineStart", (IAction)action);
        this.setActionActivationCode("org.eclipse.ui.edit.text.goto.lineEnd", '\u0000', 0x1000008, 0);
        this.setActionActivationCode("org.eclipse.ui.edit.text.goto.lineStart", '\u0000', 0x1000007, 0);
        this.setActionActivationCode("org.eclipse.ui.edit.text.select.lineEnd", '\u0000', 0x1000008, 131072);
        this.setActionActivationCode("org.eclipse.ui.edit.text.select.lineStart", '\u0000', 0x1000007, 131072);
        textWidget.setKeyBinding(127, 0);
    }

    private void createAccessibilityActions() {
        ShowRulerContextMenuAction action = new ShowRulerContextMenuAction();
        action.setActionDefinitionId("org.eclipse.ui.edit.text.showRulerContextMenu");
        this.setAction("org.eclipse.ui.edit.text.showRulerContextMenu", (IAction)action);
    }

    protected void createActions() {
        ResourceAction action = new TextOperationAction(EditorMessages.getResourceBundle(), "Editor.Undo.", this, 1);
        action.setHelpContextId(IAbstractTextEditorHelpContextIds.UNDO_ACTION);
        action.setActionDefinitionId("org.eclipse.ui.edit.undo");
        this.setAction(ITextEditorActionConstants.UNDO, (IAction)action);
        action = new TextOperationAction(EditorMessages.getResourceBundle(), "Editor.Redo.", this, 2);
        action.setHelpContextId(IAbstractTextEditorHelpContextIds.REDO_ACTION);
        action.setActionDefinitionId("org.eclipse.ui.edit.redo");
        this.setAction(ITextEditorActionConstants.REDO, (IAction)action);
        action = new TextOperationAction(EditorMessages.getResourceBundle(), "Editor.Cut.", this, 3);
        action.setHelpContextId(IAbstractTextEditorHelpContextIds.CUT_ACTION);
        action.setActionDefinitionId("org.eclipse.ui.edit.cut");
        this.setAction(ITextEditorActionConstants.CUT, (IAction)action);
        action = new TextOperationAction(EditorMessages.getResourceBundle(), "Editor.Copy.", this, 4, true);
        action.setHelpContextId(IAbstractTextEditorHelpContextIds.COPY_ACTION);
        action.setActionDefinitionId("org.eclipse.ui.edit.copy");
        this.setAction(ITextEditorActionConstants.COPY, (IAction)action);
        action = new TextOperationAction(EditorMessages.getResourceBundle(), "Editor.Paste.", this, 5);
        action.setHelpContextId(IAbstractTextEditorHelpContextIds.PASTE_ACTION);
        action.setActionDefinitionId("org.eclipse.ui.edit.paste");
        this.setAction(ITextEditorActionConstants.PASTE, (IAction)action);
        action = new TextOperationAction(EditorMessages.getResourceBundle(), "Editor.Delete.", this, 6);
        action.setHelpContextId(IAbstractTextEditorHelpContextIds.DELETE_ACTION);
        action.setActionDefinitionId("org.eclipse.ui.edit.delete");
        this.setAction(ITextEditorActionConstants.DELETE, (IAction)action);
        action = new DeleteLineAction(EditorMessages.getResourceBundle(), "Editor.DeleteLine.", this, 0, false);
        action.setHelpContextId("org.eclipse.ui.DeleteLine_action_context");
        action.setActionDefinitionId("org.eclipse.ui.edit.text.delete.line");
        this.setAction("DeleteLine", (IAction)action);
        action = new DeleteLineAction(EditorMessages.getResourceBundle(), "Editor.CutLine.", this, 0, true);
        action.setHelpContextId("org.eclipse.ui.CutLine_action_context");
        action.setActionDefinitionId("org.eclipse.ui.edit.text.cut.line");
        this.setAction("CutLine", (IAction)action);
        action = new DeleteLineAction(EditorMessages.getResourceBundle(), "Editor.DeleteLineToBeginning.", this, 1, false);
        action.setHelpContextId("org.eclipse.ui.DeleteLineToBeginning_action_context");
        action.setActionDefinitionId("org.eclipse.ui.edit.text.delete.line.to.beginning");
        this.setAction("DeleteLineToBeginning", (IAction)action);
        action = new DeleteLineAction(EditorMessages.getResourceBundle(), "Editor.CutLineToBeginning.", this, 1, true);
        action.setHelpContextId("org.eclipse.ui.CutLineToBeginning_action_context");
        action.setActionDefinitionId("org.eclipse.ui.edit.text.cut.line.to.beginning");
        this.setAction("CutLineToBeginning", (IAction)action);
        action = new DeleteLineAction(EditorMessages.getResourceBundle(), "Editor.DeleteLineToEnd.", this, 2, false);
        action.setHelpContextId("org.eclipse.ui.DeleteLineToEnd_action_context");
        action.setActionDefinitionId("org.eclipse.ui.edit.text.delete.line.to.end");
        this.setAction("DeleteLineToEnd", (IAction)action);
        action = new DeleteLineAction(EditorMessages.getResourceBundle(), "Editor.CutLineToEnd.", this, 2, true);
        action.setHelpContextId("org.eclipse.ui.CutLineToEnd_action_context");
        action.setActionDefinitionId("org.eclipse.ui.edit.text.cut.line.to.end");
        this.setAction("CutLineToEnd", (IAction)action);
        action = new MarkAction(EditorMessages.getResourceBundle(), "Editor.SetMark.", this, 0);
        action.setHelpContextId("org.eclipse.ui.SetMark_action_context");
        action.setActionDefinitionId("org.eclipse.ui.edit.text.set.mark");
        this.setAction("SetMark", (IAction)action);
        action = new MarkAction(EditorMessages.getResourceBundle(), "Editor.ClearMark.", this, 1);
        action.setHelpContextId("org.eclipse.ui.ClearMark_action_context");
        action.setActionDefinitionId("org.eclipse.ui.edit.text.clear.mark");
        this.setAction("ClearMark", (IAction)action);
        action = new MarkAction(EditorMessages.getResourceBundle(), "Editor.SwapMark.", this, 2);
        action.setHelpContextId("org.eclipse.ui.SwapMark_action_context");
        action.setActionDefinitionId("org.eclipse.ui.edit.text.swap.mark");
        this.setAction("SwapMark", (IAction)action);
        action = new TextOperationAction(EditorMessages.getResourceBundle(), "Editor.SelectAll.", this, 7, true);
        action.setHelpContextId(IAbstractTextEditorHelpContextIds.SELECT_ALL_ACTION);
        action.setActionDefinitionId("org.eclipse.ui.edit.selectAll");
        this.setAction(ITextEditorActionConstants.SELECT_ALL, (IAction)action);
        action = new ShiftAction(EditorMessages.getResourceBundle(), "Editor.ShiftRight.", this, 8);
        action.setHelpContextId("org.eclipse.ui.ShiftRight_action_context");
        action.setActionDefinitionId("org.eclipse.ui.edit.text.shiftRight");
        this.setAction("ShiftRight", (IAction)action);
        action = new ShiftAction(EditorMessages.getResourceBundle(), "Editor.ShiftRight.", this, 8){

            public void update() {
                this.updateForTab();
            }
        };
        this.setAction("ShiftRightTab", (IAction)action);
        action = new ShiftAction(EditorMessages.getResourceBundle(), "Editor.ShiftLeft.", this, 9);
        action.setHelpContextId("org.eclipse.ui.ShiftLeft_action_context");
        action.setActionDefinitionId("org.eclipse.ui.edit.text.shiftLeft");
        this.setAction("ShiftLeft", (IAction)action);
        action = new TextOperationAction(EditorMessages.getResourceBundle(), "Editor.Print.", this, 10, true);
        action.setHelpContextId(IAbstractTextEditorHelpContextIds.PRINT_ACTION);
        action.setActionDefinitionId("org.eclipse.ui.file.print");
        this.setAction(ITextEditorActionConstants.PRINT, (IAction)action);
        action = new FindReplaceAction(EditorMessages.getResourceBundle(), "Editor.FindReplace.", (IWorkbenchPart)this);
        action.setHelpContextId(IAbstractTextEditorHelpContextIds.FIND_ACTION);
        action.setActionDefinitionId("org.eclipse.ui.edit.findReplace");
        this.setAction(ITextEditorActionConstants.FIND, (IAction)action);
        action = new FindNextAction(EditorMessages.getResourceBundle(), "Editor.FindNext.", (IWorkbenchPart)this, true);
        action.setHelpContextId("org.eclipse.ui.FindNext_action_context");
        action.setActionDefinitionId("org.eclipse.ui.edit.findNext");
        this.setAction("FindNext", (IAction)action);
        action = new FindNextAction(EditorMessages.getResourceBundle(), "Editor.FindPrevious.", (IWorkbenchPart)this, false);
        action.setHelpContextId("org.eclipse.ui.FindPrevious_action_context");
        action.setActionDefinitionId("org.eclipse.ui.edit.findPrevious");
        this.setAction("FindPrevious", (IAction)action);
        action = new IncrementalFindAction(EditorMessages.getResourceBundle(), "Editor.FindIncremental.", (IWorkbenchPart)this, true);
        action.setHelpContextId("org.eclipse.ui.FindIncremental_action_context");
        action.setActionDefinitionId("org.eclipse.ui.edit.findIncremental");
        this.setAction("FindIncremental", (IAction)action);
        action = new IncrementalFindAction(EditorMessages.getResourceBundle(), "Editor.FindIncrementalReverse.", (IWorkbenchPart)this, false);
        action.setHelpContextId("org.eclipse.ui.FindIncrementalReverse_action_context");
        action.setActionDefinitionId("org.eclipse.ui.edit.findIncrementalReverse");
        this.setAction("FindIncrementalReverse", (IAction)action);
        action = new SaveAction(EditorMessages.getResourceBundle(), "Editor.Save.", this);
        action.setHelpContextId(IAbstractTextEditorHelpContextIds.SAVE_ACTION);
        this.setAction(ITextEditorActionConstants.SAVE, (IAction)action);
        action = new RevertToSavedAction(EditorMessages.getResourceBundle(), "Editor.Revert.", this);
        action.setHelpContextId(IAbstractTextEditorHelpContextIds.REVERT_TO_SAVED_ACTION);
        action.setActionDefinitionId("org.eclipse.ui.edit.revertToSaved");
        this.setAction(ITextEditorActionConstants.REVERT_TO_SAVED, (IAction)action);
        action = new GotoLineAction(EditorMessages.getResourceBundle(), "Editor.GotoLine.", this);
        action.setHelpContextId("org.eclipse.ui.GotoLine_action_context");
        action.setActionDefinitionId("org.eclipse.ui.edit.text.goto.line");
        this.setAction("GotoLine", (IAction)action);
        action = new MoveLinesAction(EditorMessages.getResourceBundle(), "Editor.MoveLinesUp.", this, true, false);
        action.setHelpContextId("org.eclipse.ui.move_lines_action_context");
        action.setActionDefinitionId("org.eclipse.ui.edit.text.moveLineUp");
        this.setAction("MoveLineUp", (IAction)action);
        action = new MoveLinesAction(EditorMessages.getResourceBundle(), "Editor.MoveLinesDown.", this, false, false);
        action.setHelpContextId("org.eclipse.ui.move_lines_action_context");
        action.setActionDefinitionId("org.eclipse.ui.edit.text.moveLineDown");
        this.setAction("MoveLineDown", (IAction)action);
        action = new MoveLinesAction(EditorMessages.getResourceBundle(), "Editor.CopyLineUp.", this, true, true);
        action.setHelpContextId("org.eclipse.ui.copy_lines_action_context");
        action.setActionDefinitionId("org.eclipse.ui.edit.text.copyLineUp");
        this.setAction("CopyLineUp", (IAction)action);
        action = new MoveLinesAction(EditorMessages.getResourceBundle(), "Editor.CopyLineDown.", this, false, true);
        action.setHelpContextId("org.eclipse.ui.copy_lines_action_context");
        action.setActionDefinitionId("org.eclipse.ui.edit.text.copyLineDown");
        this.setAction("CopyLineDown", (IAction)action);
        action = new CaseAction(EditorMessages.getResourceBundle(), "Editor.UpperCase.", this, true);
        action.setHelpContextId("org.eclipse.ui.upper_case_action_context");
        action.setActionDefinitionId("org.eclipse.ui.edit.text.upperCase");
        this.setAction("UpperCase", (IAction)action);
        action = new CaseAction(EditorMessages.getResourceBundle(), "Editor.LowerCase.", this, false);
        action.setHelpContextId("org.eclipse.ui.lower_case_action_context");
        action.setActionDefinitionId("org.eclipse.ui.edit.text.lowerCase");
        this.setAction("LowerCase", (IAction)action);
        action = new InsertLineAction(EditorMessages.getResourceBundle(), "Editor.SmartEnter.", (ITextEditor)this, false);
        action.setHelpContextId("org.eclipse.ui.smart_enter_action_context");
        action.setActionDefinitionId("org.eclipse.ui.edit.text.smartEnter");
        this.setAction("SmartEnter", (IAction)action);
        action = new InsertLineAction(EditorMessages.getResourceBundle(), "Editor.SmartEnterInverse.", (ITextEditor)this, true);
        action.setHelpContextId("org.eclipse.ui.smart_enter_action_context");
        action.setActionDefinitionId("org.eclipse.ui.edit.text.smartEnterInverse");
        this.setAction("SmartEnterInverse", (IAction)action);
        action = new ToggleInsertModeAction(EditorMessages.getResourceBundle(), "Editor.ToggleInsertMode.");
        action.setHelpContextId("org.eclipse.ui.toggle_insert_mode_action_context");
        action.setActionDefinitionId("org.eclipse.ui.edit.text.toggleInsertMode");
        this.setAction("TOGGLE_INSERT_MODE", (IAction)action);
        this.markAsContentDependentAction(ITextEditorActionConstants.UNDO, true);
        this.markAsContentDependentAction(ITextEditorActionConstants.REDO, true);
        this.markAsContentDependentAction(ITextEditorActionConstants.FIND, true);
        this.markAsContentDependentAction("FindNext", true);
        this.markAsContentDependentAction("FindPrevious", true);
        this.markAsContentDependentAction("FindIncremental", true);
        this.markAsContentDependentAction("FindIncrementalReverse", true);
        this.markAsSelectionDependentAction(ITextEditorActionConstants.CUT, true);
        this.markAsSelectionDependentAction(ITextEditorActionConstants.COPY, true);
        this.markAsSelectionDependentAction(ITextEditorActionConstants.PASTE, true);
        this.markAsSelectionDependentAction(ITextEditorActionConstants.DELETE, true);
        this.markAsSelectionDependentAction("ShiftRight", true);
        this.markAsSelectionDependentAction("ShiftRightTab", true);
        this.markAsSelectionDependentAction("UpperCase", true);
        this.markAsSelectionDependentAction("LowerCase", true);
        this.markAsPropertyDependentAction(ITextEditorActionConstants.UNDO, true);
        this.markAsPropertyDependentAction(ITextEditorActionConstants.REDO, true);
        this.markAsPropertyDependentAction(ITextEditorActionConstants.REVERT_TO_SAVED, true);
        this.markAsStateDependentAction(ITextEditorActionConstants.UNDO, true);
        this.markAsStateDependentAction(ITextEditorActionConstants.REDO, true);
        this.markAsStateDependentAction(ITextEditorActionConstants.CUT, true);
        this.markAsStateDependentAction(ITextEditorActionConstants.PASTE, true);
        this.markAsStateDependentAction(ITextEditorActionConstants.DELETE, true);
        this.markAsStateDependentAction("ShiftRight", true);
        this.markAsStateDependentAction("ShiftRightTab", true);
        this.markAsStateDependentAction("ShiftLeft", true);
        this.markAsStateDependentAction(ITextEditorActionConstants.FIND, true);
        this.markAsStateDependentAction("DeleteLine", true);
        this.markAsStateDependentAction("DeleteLineToBeginning", true);
        this.markAsStateDependentAction("DeleteLineToEnd", true);
        this.markAsStateDependentAction("MoveLineUp", true);
        this.markAsStateDependentAction("MoveLineDown", true);
        this.markAsStateDependentAction("CutLine", true);
        this.markAsStateDependentAction("CutLineToBeginning", true);
        this.markAsStateDependentAction("CutLineToEnd", true);
        this.setActionActivationCode("ShiftRightTab", '\t', -1, 0);
        this.setActionActivationCode("ShiftLeft", '\t', -1, 131072);
    }

    protected final void addAction(IMenuManager menu, String actionId) {
        IAction action = this.getAction(actionId);
        if (action != null) {
            if (action instanceof IUpdate) {
                ((IUpdate)action).update();
            }
            menu.add(action);
        }
    }

    protected final void addAction(IMenuManager menu, String group, String actionId) {
        IAction action = this.getAction(actionId);
        if (action != null) {
            IMenuManager subMenu;
            if (action instanceof IUpdate) {
                ((IUpdate)action).update();
            }
            if ((subMenu = menu.findMenuUsingPath(group)) != null) {
                subMenu.add(action);
            } else {
                menu.appendToGroup(group, action);
            }
        }
    }

    protected final void addGroup(IMenuManager menu, String existingGroup, String newGroup) {
        IMenuManager subMenu = menu.findMenuUsingPath(existingGroup);
        if (subMenu != null) {
            subMenu.add((IContributionItem)new Separator(newGroup));
        } else {
            menu.appendToGroup(existingGroup, (IContributionItem)new Separator(newGroup));
        }
    }

    protected void rulerContextMenuAboutToShow(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("group.rest"));
        menu.add((IContributionItem)new Separator("additions"));
        Iterator i = this.fRulerContextMenuListeners.iterator();
        while (i.hasNext()) {
            ((IMenuListener)i.next()).menuAboutToShow(menu);
        }
        this.addAction(menu, "ManageBookmarks");
        this.addAction(menu, "ManageTasks");
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("group.undo"));
        menu.add((IContributionItem)new Separator("group.copy"));
        menu.add((IContributionItem)new Separator("group.print"));
        menu.add((IContributionItem)new Separator("group.edit"));
        menu.add((IContributionItem)new Separator("group.find"));
        menu.add((IContributionItem)new Separator("group.add"));
        menu.add((IContributionItem)new Separator("group.rest"));
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator("group.save"));
        if (this.isEditable()) {
            this.addAction(menu, "group.undo", ITextEditorActionConstants.UNDO);
            this.addAction(menu, "group.undo", ITextEditorActionConstants.REVERT_TO_SAVED);
            this.addAction(menu, "group.copy", ITextEditorActionConstants.CUT);
            this.addAction(menu, "group.copy", ITextEditorActionConstants.COPY);
            this.addAction(menu, "group.copy", ITextEditorActionConstants.PASTE);
            this.addAction(menu, "group.save", ITextEditorActionConstants.SAVE);
        } else {
            this.addAction(menu, "group.copy", ITextEditorActionConstants.COPY);
        }
    }

    private IStatusLineManager getStatusLineManager() {
        IEditorActionBarContributor contributor = this.getEditorSite().getActionBarContributor();
        if (!(contributor instanceof EditorActionBarContributor)) {
            return null;
        }
        IActionBars actionBars = ((EditorActionBarContributor)contributor).getActionBars();
        if (actionBars == null) {
            return null;
        }
        return actionBars.getStatusLineManager();
    }

    public Object getAdapter(Class required) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.texteditor.IEditorStatusLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(required)) {
            if (this.fEditorStatusLine == null) {
                IStatusLineManager statusLineManager = this.getStatusLineManager();
                ISelectionProvider selectionProvider = this.getSelectionProvider();
                if (statusLineManager != null && selectionProvider != null) {
                    this.fEditorStatusLine = new EditorStatusLine(statusLineManager, selectionProvider);
                }
            }
            return this.fEditorStatusLine;
        }
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.eclipse.jface.text.source.IVerticalRulerInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz2.equals(required) && this.fVerticalRuler != null) {
            return this.fVerticalRuler;
        }
        Class<?> clazz3 = class$3;
        if (clazz3 == null) {
            try {
                clazz3 = class$3 = Class.forName("org.eclipse.jface.text.IMarkRegionTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz3.equals(required)) {
            IStatusLineManager manager;
            if (this.fMarkRegionTarget == null && (manager = this.getStatusLineManager()) != null) {
                this.fMarkRegionTarget = this.fSourceViewer == null ? null : new MarkRegionTarget((ITextViewer)this.fSourceViewer, manager);
            }
            return this.fMarkRegionTarget;
        }
        Class<?> clazz4 = class$4;
        if (clazz4 == null) {
            try {
                clazz4 = class$4 = Class.forName("org.eclipse.ui.texteditor.DeleteLineTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz4.equals(required)) {
            if (this.fDeleteLineTarget == null) {
                this.fDeleteLineTarget = new DeleteLineTarget((ITextViewer)this.fSourceViewer);
            }
            return this.fDeleteLineTarget;
        }
        Class<?> clazz5 = class$5;
        if (clazz5 == null) {
            try {
                clazz5 = class$5 = Class.forName("org.eclipse.ui.texteditor.IncrementalFindTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz5.equals(required)) {
            IStatusLineManager manager;
            if (this.fIncrementalFindTarget == null && (manager = this.getStatusLineManager()) != null) {
                this.fIncrementalFindTarget = this.fSourceViewer == null ? null : new IncrementalFindTarget((ITextViewer)this.fSourceViewer, manager);
            }
            return this.fIncrementalFindTarget;
        }
        Class<?> clazz6 = class$6;
        if (clazz6 == null) {
            try {
                clazz6 = class$6 = Class.forName("org.eclipse.jface.text.IFindReplaceTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz6.equals(required)) {
            if (this.fFindReplaceTarget == null) {
                IFindReplaceTarget target;
                IFindReplaceTarget iFindReplaceTarget = target = this.fSourceViewer == null ? null : this.fSourceViewer.getFindReplaceTarget();
                if (target != null) {
                    this.fFindReplaceTarget = new FindReplaceTarget(this, target);
                    if (this.fFindScopeHighlightColor != null) {
                        this.fFindReplaceTarget.setScopeHighlightColor(this.fFindScopeHighlightColor);
                    }
                }
            }
            return this.fFindReplaceTarget;
        }
        Class<?> clazz7 = class$7;
        if (clazz7 == null) {
            try {
                clazz7 = class$7 = Class.forName("org.eclipse.jface.text.ITextOperationTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz7.equals(required)) {
            return this.fSourceViewer == null ? null : this.fSourceViewer.getTextOperationTarget();
        }
        Class<?> clazz8 = class$8;
        if (clazz8 == null) {
            try {
                clazz8 = class$8 = Class.forName("org.eclipse.jface.text.IRewriteTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz8.equals(required)) {
            if (this.fSourceViewer instanceof ITextViewerExtension) {
                ITextViewerExtension extension = (ITextViewerExtension)this.fSourceViewer;
                return extension.getRewriteTarget();
            }
            return null;
        }
        Class<?> clazz9 = class$9;
        if (clazz9 == null) {
            try {
                clazz9 = class$9 = Class.forName("org.eclipse.swt.widgets.Control");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz9.equals(required)) {
            return this.fSourceViewer != null ? this.fSourceViewer.getTextWidget() : null;
        }
        return super.getAdapter(required);
    }

    public void setFocus() {
        if (this.fSourceViewer != null && this.fSourceViewer.getTextWidget() != null) {
            this.fSourceViewer.getTextWidget().setFocus();
        }
    }

    public boolean showsHighlightRangeOnly() {
        return this.fShowHighlightRangeOnly;
    }

    public void showHighlightRangeOnly(boolean showHighlightRangeOnly) {
        this.fShowHighlightRangeOnly = showHighlightRangeOnly;
    }

    public void setHighlightRange(int offset, int length, boolean moveCursor) {
        if (this.fSourceViewer == null) {
            return;
        }
        if (this.fShowHighlightRangeOnly) {
            if (moveCursor) {
                this.fSourceViewer.setVisibleRegion(offset, length);
            }
        } else {
            IRegion rangeIndication = this.fSourceViewer.getRangeIndication();
            if (rangeIndication == null || offset != rangeIndication.getOffset() || length != rangeIndication.getLength()) {
                this.fSourceViewer.setRangeIndication(offset, length, moveCursor);
            }
        }
    }

    public IRegion getHighlightRange() {
        if (this.fSourceViewer == null) {
            return null;
        }
        if (this.fShowHighlightRangeOnly) {
            return AbstractTextEditor.getCoverage(this.fSourceViewer);
        }
        return this.fSourceViewer.getRangeIndication();
    }

    public void resetHighlightRange() {
        if (this.fSourceViewer == null) {
            return;
        }
        if (this.fShowHighlightRangeOnly) {
            this.fSourceViewer.resetVisibleRegion();
        } else {
            this.fSourceViewer.removeRangeIndication();
        }
    }

    protected void adjustHighlightRange(int offset, int length) {
        if (this.fSourceViewer == null) {
            return;
        }
        if (this.fSourceViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)this.fSourceViewer;
            extension.exposeModelRange((IRegion)new Region(offset, length));
        } else if (!AbstractTextEditor.isVisible(this.fSourceViewer, offset, length)) {
            this.fSourceViewer.resetVisibleRegion();
        }
    }

    public void selectAndReveal(int start, int length) {
        this.selectAndReveal(start, length, start, length);
    }

    protected void selectAndReveal(int selectionStart, int selectionLength, int revealStart, int revealLength) {
        TextSelection textSelection;
        if (this.fSourceViewer == null) {
            return;
        }
        ISelection selection = this.getSelectionProvider().getSelection();
        if (selection instanceof TextSelection && ((textSelection = (TextSelection)selection).getOffset() != 0 || textSelection.getLength() != 0)) {
            this.markInNavigationHistory();
        }
        StyledText widget = this.fSourceViewer.getTextWidget();
        widget.setRedraw(false);
        this.adjustHighlightRange(revealStart, revealLength);
        this.fSourceViewer.revealRange(revealStart, revealLength);
        this.fSourceViewer.setSelectedRange(selectionStart, selectionLength);
        this.markInNavigationHistory();
        widget.setRedraw(true);
    }

    public INavigationLocation createEmptyNavigationLocation() {
        return new TextSelectionNavigationLocation(this, false);
    }

    public INavigationLocation createNavigationLocation() {
        return new TextSelectionNavigationLocation(this, true);
    }

    protected void markInNavigationHistory() {
        IWorkbenchPage page = this.getEditorSite().getPage();
        page.getNavigationHistory().markLocation((IEditorPart)this);
    }

    protected void editorSaved() {
        IWorkbenchPage page = this.getEditorSite().getPage();
        INavigationLocation[] locations = page.getNavigationHistory().getLocations();
        IEditorInput input = this.getEditorInput();
        int i = 0;
        while (i < locations.length) {
            if (locations[i] instanceof TextSelectionNavigationLocation && input.equals(locations[i].getInput())) {
                TextSelectionNavigationLocation location = (TextSelectionNavigationLocation)locations[i];
                location.partSaved(this);
            }
            ++i;
        }
    }

    protected void firePropertyChange(int property) {
        super.firePropertyChange(property);
        this.updatePropertyDependentActions();
    }

    public void setStatusField(IStatusField field, String category) {
        Assert.isNotNull((Object)category);
        if (field != null) {
            if (this.fStatusFields == null) {
                this.fStatusFields = new HashMap(3);
            }
            this.fStatusFields.put(category, field);
            this.updateStatusField(category);
        } else if (this.fStatusFields != null) {
            this.fStatusFields.remove(category);
        }
        if (this.fIncrementalFindTarget != null && "findField".equals(category)) {
            this.fIncrementalFindTarget.setStatusField(field);
        }
    }

    protected IStatusField getStatusField(String category) {
        if (category != null && this.fStatusFields != null) {
            return (IStatusField)this.fStatusFields.get(category);
        }
        return null;
    }

    protected boolean isInInsertMode() {
        return !this.fIsOverwriting;
    }

    public ITextEditorExtension3.InsertMode getInsertMode() {
        return this.fInsertMode;
    }

    public void setInsertMode(ITextEditorExtension3.InsertMode newMode) {
        List legalModes = this.getLegalInsertModes();
        if (!legalModes.contains(newMode)) {
            throw new IllegalArgumentException();
        }
        this.fInsertMode = newMode;
        this.handleInsertModeChanged();
    }

    protected List getLegalInsertModes() {
        if (this.fLegalInsertModes == null) {
            this.fLegalInsertModes = new ArrayList();
            this.fLegalInsertModes.add(ITextEditorExtension3.SMART_INSERT);
            this.fLegalInsertModes.add(ITextEditorExtension3.INSERT);
        }
        return this.fLegalInsertModes;
    }

    private void switchToNextInsertMode() {
        ITextEditorExtension3.InsertMode mode = this.getInsertMode();
        List legalModes = this.getLegalInsertModes();
        int i = 0;
        while (i < legalModes.size()) {
            if (legalModes.get(i) == mode) break;
            ++i;
        }
        i = (i + 1) % legalModes.size();
        ITextEditorExtension3.InsertMode newMode = (ITextEditorExtension3.InsertMode)legalModes.get(i);
        this.setInsertMode(newMode);
    }

    private void toggleOverwriteMode() {
        if (this.fIsOverwriteModeEnabled) {
            this.fIsOverwriting = !this.fIsOverwriting;
            this.fSourceViewer.getTextWidget().invokeAction(0x1000009);
            this.handleInsertModeChanged();
        }
    }

    protected void configureInsertMode(ITextEditorExtension3.InsertMode mode, boolean legal) {
        List legalModes = this.getLegalInsertModes();
        if (legal) {
            if (!legalModes.contains(mode)) {
                legalModes.add(mode);
            }
        } else if (legalModes.size() > 1) {
            if (this.getInsertMode() == mode) {
                this.switchToNextInsertMode();
            }
            legalModes.remove(mode);
        }
    }

    protected void enableOverwriteMode(boolean enable) {
        if (this.fIsOverwriting && !enable) {
            this.toggleOverwriteMode();
        }
        this.fIsOverwriteModeEnabled = enable;
    }

    private Caret createOverwriteCaret(StyledText styledText) {
        Caret caret = new Caret((Canvas)styledText, 0);
        GC gc = new GC((Drawable)styledText);
        Point charSize = gc.stringExtent("a");
        caret.setSize(charSize.x, styledText.getLineHeight());
        gc.dispose();
        return caret;
    }

    private Caret createInsertCaret(StyledText styledText) {
        Caret caret = new Caret((Canvas)styledText, 0);
        caret.setSize(this.getCaretWidthPreference(), styledText.getLineHeight());
        return caret;
    }

    private Image createRawInsertModeCaretImage(StyledText styledText) {
        PaletteData caretPalette = new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)});
        int width = this.getCaretWidthPreference();
        int widthOffset = width - 1;
        ImageData imageData = new ImageData(4 + widthOffset, styledText.getLineHeight(), 1, caretPalette);
        Display display = styledText.getDisplay();
        Image bracketImage = new Image((Device)display, imageData);
        GC gc = new GC((Drawable)bracketImage);
        gc.setForeground(display.getSystemColor(1));
        gc.setLineWidth(1);
        int height = imageData.height / 3;
        int i = 0;
        while (i < width) {
            gc.drawLine(i, 0, i, height - 1);
            gc.drawLine(i, imageData.height - height, i, imageData.height - 1);
            ++i;
        }
        gc.dispose();
        return bracketImage;
    }

    private Caret createRawInsertModeCaret(StyledText styledText) {
        if (!this.getLegalInsertModes().contains(ITextEditorExtension3.SMART_INSERT)) {
            return this.createInsertCaret(styledText);
        }
        Caret caret = new Caret((Canvas)styledText, 0);
        Image image = this.createRawInsertModeCaretImage(styledText);
        if (image != null) {
            caret.setImage(image);
        } else {
            caret.setSize(this.getCaretWidthPreference(), styledText.getLineHeight());
        }
        return caret;
    }

    private int getCaretWidthPreference() {
        if (this.getPreferenceStore() != null && this.getPreferenceStore().getBoolean(PREFERENCE_WIDE_CARET)) {
            return 2;
        }
        return 1;
    }

    private void updateCaret() {
        if (this.getSourceViewer() == null) {
            return;
        }
        StyledText styledText = this.getSourceViewer().getTextWidget();
        ITextEditorExtension3.InsertMode mode = this.getInsertMode();
        styledText.setCaret(null);
        this.disposeNonDefaultCaret();
        if (this.getPreferenceStore() == null || !this.getPreferenceStore().getBoolean(PREFERENCE_USE_CUSTOM_CARETS)) {
            Assert.isTrue((this.fNonDefaultCaret == null ? 1 : 0) != 0);
        } else if (this.fIsOverwriting) {
            this.fNonDefaultCaret = this.createOverwriteCaret(styledText);
        } else if (ITextEditorExtension3.SMART_INSERT == mode) {
            this.fNonDefaultCaret = this.createInsertCaret(styledText);
        } else if (ITextEditorExtension3.INSERT == mode) {
            this.fNonDefaultCaret = this.createRawInsertModeCaret(styledText);
        }
        if (this.fNonDefaultCaret != null) {
            styledText.setCaret(this.fNonDefaultCaret);
            this.fNonDefaultCaretImage = this.fNonDefaultCaret.getImage();
        } else if (this.fInitialCaret != styledText.getCaret()) {
            styledText.setCaret(this.fInitialCaret);
        }
    }

    private void disposeNonDefaultCaret() {
        if (this.fNonDefaultCaretImage != null) {
            this.fNonDefaultCaretImage.dispose();
            this.fNonDefaultCaretImage = null;
        }
        if (this.fNonDefaultCaret != null) {
            this.fNonDefaultCaret.dispose();
            this.fNonDefaultCaret = null;
        }
    }

    protected void handleInsertModeChanged() {
        this.updateInsertModeAction();
        this.updateCaret();
        this.updateStatusField("InputMode");
    }

    private void updateInsertModeAction() {
        if (this.getSite() == null) {
            return;
        }
        IAction action = this.getAction("TOGGLE_INSERT_MODE");
        if (action != null) {
            action.setEnabled(!this.fIsOverwriting);
            action.setChecked(this.fInsertMode == ITextEditorExtension3.SMART_INSERT);
        }
    }

    protected void handleCursorPositionChanged() {
        this.updateStatusField("InputPosition");
    }

    protected void updateStatusField(String category) {
        if (category == null) {
            return;
        }
        IStatusField field = this.getStatusField(category);
        if (field != null) {
            String text = null;
            if ("InputPosition".equals(category)) {
                text = this.getCursorPosition();
            } else if ("ElementState".equals(category)) {
                text = this.isEditorInputReadOnly() ? this.fReadOnlyLabel : this.fWritableLabel;
            } else if ("InputMode".equals(category)) {
                ITextEditorExtension3.InsertMode mode = this.getInsertMode();
                if (this.fIsOverwriting) {
                    text = this.fOverwriteModeLabel;
                } else if (ITextEditorExtension3.INSERT == mode) {
                    text = this.fInsertModeLabel;
                } else if (ITextEditorExtension3.SMART_INSERT == mode) {
                    text = this.fSmartInsertModeLabel;
                }
            }
            field.setText(text == null ? this.fErrorLabel : text);
        }
    }

    protected void updateStatusFields() {
        if (this.fStatusFields != null) {
            Iterator e = this.fStatusFields.keySet().iterator();
            while (e.hasNext()) {
                this.updateStatusField((String)e.next());
            }
        }
    }

    protected String getCursorPosition() {
        if (this.fSourceViewer == null) {
            return this.fErrorLabel;
        }
        StyledText styledText = this.fSourceViewer.getTextWidget();
        int caret = AbstractTextEditor.widgetOffset2ModelOffset(this.fSourceViewer, styledText.getCaretOffset());
        IDocument document = this.fSourceViewer.getDocument();
        if (document == null) {
            return this.fErrorLabel;
        }
        try {
            int line = document.getLineOfOffset(caret);
            int lineOffset = document.getLineOffset(line);
            int tabWidth = styledText.getTabs();
            int column = 0;
            int i = lineOffset;
            while (i < caret) {
                column = '\t' == document.getChar(i) ? (column += tabWidth - (tabWidth == 0 ? 0 : column % tabWidth)) : ++column;
                ++i;
            }
            this.fLineLabel.fValue = line + 1;
            this.fColumnLabel.fValue = column + 1;
            return MessageFormat.format(this.fPositionLabelPattern, this.fPositionLabelPatternArguments);
        }
        catch (BadLocationException badLocationException) {
            return this.fErrorLabel;
        }
    }

    public boolean isEditorInputReadOnly() {
        IDocumentProvider provider = this.getDocumentProvider();
        if (provider instanceof IDocumentProviderExtension) {
            IDocumentProviderExtension extension = (IDocumentProviderExtension)((Object)provider);
            return extension.isReadOnly(this.getEditorInput());
        }
        return true;
    }

    public boolean isEditorInputModifiable() {
        IDocumentProvider provider = this.getDocumentProvider();
        if (provider instanceof IDocumentProviderExtension) {
            IDocumentProviderExtension extension = (IDocumentProviderExtension)((Object)provider);
            return extension.isModifiable(this.getEditorInput());
        }
        return true;
    }

    public void addRulerContextMenuListener(IMenuListener listener) {
        this.fRulerContextMenuListeners.add(listener);
    }

    public void removeRulerContextMenuListener(IMenuListener listener) {
        this.fRulerContextMenuListeners.remove(listener);
    }

    protected boolean canHandleMove(IEditorInput originalElement, IEditorInput movedElement) {
        return true;
    }

    protected static final int widgetOffset2ModelOffset(ISourceViewer viewer, int widgetOffset) {
        if (viewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)viewer;
            return extension.widgetOffset2ModelOffset(widgetOffset);
        }
        return widgetOffset + viewer.getVisibleRegion().getOffset();
    }

    protected static final int modelOffset2WidgetOffset(ISourceViewer viewer, int modelOffset) {
        if (viewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)viewer;
            return extension.modelOffset2WidgetOffset(modelOffset);
        }
        return modelOffset - viewer.getVisibleRegion().getOffset();
    }

    protected static final IRegion getCoverage(ISourceViewer viewer) {
        if (viewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)viewer;
            return extension.getModelCoverage();
        }
        return viewer.getVisibleRegion();
    }

    protected static final boolean isVisible(ISourceViewer viewer, int offset, int length) {
        if (viewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)viewer;
            IRegion overlap = extension.modelRange2WidgetRange((IRegion)new Region(offset, length));
            return overlap != null;
        }
        return viewer.overlapsWithVisibleRegion(offset, length);
    }

    public void showChangeInformation(boolean show) {
    }

    public boolean isChangeInformationShowing() {
        return false;
    }

    private static class TextInputListener
    implements ITextInputListener {
        public boolean inputChanged;

        TextInputListener() {
        }

        public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
        }

        public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
            this.inputChanged = true;
        }
    }

    class ElementStateListener
    implements IElementStateListener,
    IElementStateListenerExtension {
        private Validator fValidator;
        private Display fDisplay;

        ElementStateListener() {
        }

        public void elementStateValidationChanged(Object element, boolean isStateValidated) {
            if (element != null && element.equals(AbstractTextEditor.this.getEditorInput())) {
                Runnable r = new Runnable(this, isStateValidated){
                    final /* synthetic */ ElementStateListener this$1;
                    private final /* synthetic */ boolean val$isStateValidated;
                    {
                        this.this$1 = elementStateListener;
                        this.val$isStateValidated = bl;
                    }

                    public void run() {
                        StyledText textWidget;
                        ISourceViewer viewer;
                        ElementStateListener.access$2(this.this$1).enableSanityChecking(true);
                        if (this.val$isStateValidated && ElementStateListener.access$0(this.this$1) != null) {
                            ISourceViewer viewer2 = ElementStateListener.access$2(this.this$1).getSourceViewer();
                            if (viewer2 != null) {
                                StyledText textWidget2 = viewer2.getTextWidget();
                                if (textWidget2 != null && !textWidget2.isDisposed()) {
                                    textWidget2.removeVerifyListener((VerifyListener)ElementStateListener.access$0(this.this$1));
                                }
                                ElementStateListener.access$1(this.this$1, null);
                                ElementStateListener.access$2(this.this$1).enableStateValidation(false);
                            }
                        } else if (!this.val$isStateValidated && ElementStateListener.access$0(this.this$1) == null && (viewer = ElementStateListener.access$2(this.this$1).getSourceViewer()) != null && (textWidget = viewer.getTextWidget()) != null && !textWidget.isDisposed()) {
                            ElementStateListener.access$1(this.this$1, this.this$1.new Validator());
                            ElementStateListener.access$2(this.this$1).enableStateValidation(true);
                            textWidget.addVerifyListener((VerifyListener)ElementStateListener.access$0(this.this$1));
                        }
                    }
                };
                this.execute(r);
            }
        }

        public void elementDirtyStateChanged(Object element, boolean isDirty) {
            if (element != null && element.equals(AbstractTextEditor.this.getEditorInput())) {
                Runnable r = new Runnable(this){
                    final /* synthetic */ ElementStateListener this$1;
                    {
                        this.this$1 = elementStateListener;
                    }

                    public void run() {
                        ElementStateListener.access$2(this.this$1).enableSanityChecking(true);
                        ElementStateListener.access$2(this.this$1).firePropertyChange(257);
                    }
                };
                this.execute(r);
            }
        }

        public void elementContentAboutToBeReplaced(Object element) {
            if (element != null && element.equals(AbstractTextEditor.this.getEditorInput())) {
                Runnable r = new Runnable(this){
                    final /* synthetic */ ElementStateListener this$1;
                    {
                        this.this$1 = elementStateListener;
                    }

                    public void run() {
                        ElementStateListener.access$2(this.this$1).enableSanityChecking(true);
                        ElementStateListener.access$2(this.this$1).rememberSelection();
                        ElementStateListener.access$2(this.this$1).resetHighlightRange();
                    }
                };
                this.execute(r);
            }
        }

        public void elementContentReplaced(Object element) {
            if (element != null && element.equals(AbstractTextEditor.this.getEditorInput())) {
                Runnable r = new Runnable(this){
                    final /* synthetic */ ElementStateListener this$1;
                    {
                        this.this$1 = elementStateListener;
                    }

                    public void run() {
                        ElementStateListener.access$2(this.this$1).enableSanityChecking(true);
                        ElementStateListener.access$2(this.this$1).firePropertyChange(257);
                        ElementStateListener.access$2(this.this$1).restoreSelection();
                        ElementStateListener.access$2(this.this$1).handleElementContentReplaced();
                    }
                };
                this.execute(r);
            }
        }

        public void elementDeleted(Object deletedElement) {
            if (deletedElement != null && deletedElement.equals(AbstractTextEditor.this.getEditorInput())) {
                Runnable r = new Runnable(this){
                    final /* synthetic */ ElementStateListener this$1;
                    {
                        this.this$1 = elementStateListener;
                    }

                    public void run() {
                        ElementStateListener.access$2(this.this$1).enableSanityChecking(true);
                        ElementStateListener.access$2(this.this$1).close(false);
                    }
                };
                this.execute(r);
            }
        }

        public void elementMoved(Object originalElement, Object movedElement) {
            if (originalElement != null && originalElement.equals(AbstractTextEditor.this.getEditorInput())) {
                Runnable r = new Runnable(this, originalElement, movedElement){
                    final /* synthetic */ ElementStateListener this$1;
                    private final /* synthetic */ Object val$originalElement;
                    private final /* synthetic */ Object val$movedElement;
                    {
                        this.this$1 = elementStateListener;
                        this.val$originalElement = object;
                        this.val$movedElement = object2;
                    }

                    public void run() {
                        ElementStateListener.access$2(this.this$1).enableSanityChecking(true);
                        if (!ElementStateListener.access$2(this.this$1).canHandleMove((IEditorInput)this.val$originalElement, (IEditorInput)this.val$movedElement)) {
                            ElementStateListener.access$2(this.this$1).close(true);
                            return;
                        }
                        if (this.val$movedElement == null || this.val$movedElement instanceof IEditorInput) {
                            ElementStateListener.access$2(this.this$1).rememberSelection();
                            IDocumentProvider d = ElementStateListener.access$2(this.this$1).getDocumentProvider();
                            IDocument changed = null;
                            String previousContent = null;
                            if (ElementStateListener.access$2(this.this$1).isDirty() && (changed = d.getDocument(ElementStateListener.access$2(this.this$1).getEditorInput())) != null) {
                                previousContent = changed.get();
                            }
                            ElementStateListener.access$2(this.this$1).setInput((IEditorInput)this.val$movedElement);
                            if (changed != null) {
                                d.getDocument(ElementStateListener.access$2(this.this$1).getEditorInput()).set(previousContent);
                                ElementStateListener.access$2(this.this$1).validateState(ElementStateListener.access$2(this.this$1).getEditorInput());
                                ElementStateListener.access$2(this.this$1).updateStatusField("ElementState");
                            }
                            ElementStateListener.access$2(this.this$1).restoreSelection();
                        }
                    }
                };
                this.execute(r);
            }
        }

        public void elementStateChanging(Object element) {
            if (element != null && element.equals(AbstractTextEditor.this.getEditorInput())) {
                AbstractTextEditor.this.enableSanityChecking(false);
            }
        }

        public void elementStateChangeFailed(Object element) {
            if (element != null && element.equals(AbstractTextEditor.this.getEditorInput())) {
                AbstractTextEditor.this.enableSanityChecking(true);
            }
        }

        private void execute(Runnable runnable) {
            if (Display.getCurrent() != null) {
                runnable.run();
            } else {
                if (this.fDisplay == null) {
                    this.fDisplay = AbstractTextEditor.this.getSite().getShell().getDisplay();
                }
                this.fDisplay.asyncExec(runnable);
            }
        }

        static /* synthetic */ Validator access$0(ElementStateListener elementStateListener) {
            return elementStateListener.fValidator;
        }

        static /* synthetic */ void access$1(ElementStateListener elementStateListener, Validator validator) {
            elementStateListener.fValidator = validator;
        }

        static /* synthetic */ AbstractTextEditor access$2(ElementStateListener elementStateListener) {
            return elementStateListener.AbstractTextEditor.this;
        }

        class Validator
        implements VerifyListener {
            Validator() {
            }

            /*
             * Exception decompiling
             */
            public void verifyText(VerifyEvent e) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 104->108)] java.lang.Throwable
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        }
    }

    class TextListener
    implements ITextListener,
    ITextInputListener {
        private Runnable fRunnable = new Runnable(this){
            final /* synthetic */ TextListener this$1;
            {
                this.this$1 = textListener;
            }

            public void run() {
                TextListener.access$0(this.this$1, false);
                if (AbstractTextEditor.access$0(TextListener.access$5(this.this$1)) != null) {
                    TextListener.access$5(this.this$1).updateContentDependentActions();
                    if (TextListener.access$5(this.this$1).isDirty() && TextListener.access$1(this.this$1)) {
                        TextListener.access$2(this.this$1, false);
                        ISelection sel = TextListener.access$5(this.this$1).getSelectionProvider().getSelection();
                        IEditorInput input = TextListener.access$5(this.this$1).getEditorInput();
                        IDocument document = TextListener.access$5(this.this$1).getDocumentProvider().getDocument(input);
                        if (TextListener.access$3(this.this$1) != null) {
                            document.removePosition(TextListener.access$3(this.this$1));
                            TextListener.access$4(this.this$1, null);
                        }
                        if (sel instanceof ITextSelection && !sel.isEmpty()) {
                            ITextSelection s = (ITextSelection)sel;
                            TextListener.access$4(this.this$1, new Position(s.getOffset(), s.getLength()));
                            try {
                                document.addPosition(TextListener.access$3(this.this$1));
                            }
                            catch (BadLocationException badLocationException) {
                                TextListener.access$4(this.this$1, null);
                            }
                        }
                        TextEditorPlugin.getDefault().setLastEditPosition(new EditPosition(input, TextListener.access$5(this.this$1).getEditorSite().getId(), TextListener.access$5(this.this$1).getSelectionProvider().getSelection(), TextListener.access$3(this.this$1)));
                    }
                }
            }
        };
        private Display fDisplay;
        private Position fLocalLastEditPosition;
        private boolean fIsRunnablePosted = false;
        private boolean fUpdateLastEditPosition = false;

        TextListener() {
        }

        public void textChanged(TextEvent event) {
            if (this.fDisplay == null) {
                this.fDisplay = AbstractTextEditor.this.getSite().getShell().getDisplay();
            }
            if (event.getDocumentEvent() != null) {
                this.fUpdateLastEditPosition = true;
            }
            if (!this.fIsRunnablePosted) {
                this.fIsRunnablePosted = true;
                this.fDisplay.asyncExec(this.fRunnable);
            }
        }

        public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
            if (oldInput != null && this.fLocalLastEditPosition != null) {
                oldInput.removePosition(this.fLocalLastEditPosition);
                this.fLocalLastEditPosition = null;
            }
        }

        public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
        }

        static /* synthetic */ void access$0(TextListener textListener, boolean bl) {
            textListener.fIsRunnablePosted = bl;
        }

        static /* synthetic */ boolean access$1(TextListener textListener) {
            return textListener.fUpdateLastEditPosition;
        }

        static /* synthetic */ void access$2(TextListener textListener, boolean bl) {
            textListener.fUpdateLastEditPosition = bl;
        }

        static /* synthetic */ Position access$3(TextListener textListener) {
            return textListener.fLocalLastEditPosition;
        }

        static /* synthetic */ void access$4(TextListener textListener, Position position) {
            textListener.fLocalLastEditPosition = position;
        }

        static /* synthetic */ AbstractTextEditor access$5(TextListener textListener) {
            return textListener.AbstractTextEditor.this;
        }
    }

    class PropertyChangeListener
    implements IPropertyChangeListener {
        PropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            AbstractTextEditor.this.handlePreferenceStoreChanged(event);
        }
    }

    class FontPropertyChangeListener
    implements IPropertyChangeListener {
        FontPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (AbstractTextEditor.this.fSourceViewer == null) {
                return;
            }
            String property = event.getProperty();
            if (AbstractTextEditor.this.getFontPropertyPreferenceKey().equals(property)) {
                AbstractTextEditor.this.initializeViewerFont(AbstractTextEditor.this.fSourceViewer);
                AbstractTextEditor.this.updateCaret();
            }
        }
    }

    class ActivationCodeTrigger
    implements VerifyKeyListener {
        private boolean fIsInstalled = false;
        private IKeyBindingService fKeyBindingService;

        ActivationCodeTrigger() {
        }

        public void verifyKey(VerifyEvent event) {
            ActionActivationCode code = null;
            int size = AbstractTextEditor.this.fActivationCodes.size();
            int i = 0;
            while (i < size) {
                IAction action;
                code = (ActionActivationCode)AbstractTextEditor.this.fActivationCodes.get(i);
                if (code.matches(event) && (action = AbstractTextEditor.this.getAction(code.fActionId)) != null) {
                    if (action instanceof IUpdate) {
                        ((IUpdate)action).update();
                    }
                    if (!action.isEnabled() && action instanceof IReadOnlyDependent) {
                        IReadOnlyDependent dependent = (IReadOnlyDependent)action;
                        boolean writable = dependent.isEnabled(true);
                        if (writable) {
                            event.doit = false;
                            return;
                        }
                    } else if (action.isEnabled()) {
                        event.doit = false;
                        action.run();
                        return;
                    }
                }
                ++i;
            }
        }

        public void install() {
            if (!this.fIsInstalled) {
                if (AbstractTextEditor.this.fSourceViewer instanceof ITextViewerExtension) {
                    ITextViewerExtension e = (ITextViewerExtension)AbstractTextEditor.this.fSourceViewer;
                    e.prependVerifyKeyListener((VerifyKeyListener)this);
                } else {
                    StyledText text = AbstractTextEditor.this.fSourceViewer.getTextWidget();
                    text.addVerifyKeyListener((VerifyKeyListener)this);
                }
                this.fKeyBindingService = AbstractTextEditor.this.getEditorSite().getKeyBindingService();
                this.fIsInstalled = true;
            }
        }

        public void uninstall() {
            if (this.fIsInstalled) {
                StyledText text;
                if (AbstractTextEditor.this.fSourceViewer instanceof ITextViewerExtension) {
                    ITextViewerExtension e = (ITextViewerExtension)AbstractTextEditor.this.fSourceViewer;
                    e.removeVerifyKeyListener((VerifyKeyListener)this);
                } else if (AbstractTextEditor.this.fSourceViewer != null && (text = AbstractTextEditor.this.fSourceViewer.getTextWidget()) != null && !text.isDisposed()) {
                    text.removeVerifyKeyListener((VerifyKeyListener)AbstractTextEditor.this.fActivationCodeTrigger);
                }
                this.fIsInstalled = false;
                this.fKeyBindingService = null;
            }
        }

        public void registerActionForKeyActivation(IAction action) {
            if (action.getActionDefinitionId() != null) {
                this.fKeyBindingService.registerAction(action);
            }
        }

        public void unregisterActionFromKeyActivation(IAction action) {
            if (action.getActionDefinitionId() != null) {
                this.fKeyBindingService.unregisterAction(action);
            }
        }

        public void setScopes(String[] keyBindingScopes) {
            if (keyBindingScopes != null && keyBindingScopes.length > 0) {
                this.fKeyBindingService.setScopes(keyBindingScopes);
            }
        }
    }

    static class ActionActivationCode {
        public String fActionId;
        public char fCharacter;
        public int fKeyCode = -1;
        public int fStateMask = -1;

        public ActionActivationCode(String actionId) {
            this.fActionId = actionId;
        }

        public boolean matches(VerifyEvent event) {
            return !(event.character != this.fCharacter || this.fKeyCode != -1 && event.keyCode != this.fKeyCode || this.fStateMask != -1 && event.stateMask != this.fStateMask);
        }
    }

    class ActivationListener
    extends ShellAdapter
    implements IPartListener {
        private IWorkbenchPart fActivePart;
        private boolean fIsHandlingActivation = false;

        ActivationListener() {
        }

        public void partActivated(IWorkbenchPart part) {
            this.fActivePart = part;
            this.handleActivation();
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
            this.fActivePart = null;
        }

        public void partOpened(IWorkbenchPart part) {
        }

        public void shellActivated(ShellEvent e) {
            e.widget.getDisplay().asyncExec(new Runnable(this){
                final /* synthetic */ ActivationListener this$1;
                {
                    this.this$1 = activationListener;
                }

                public void run() {
                    ActivationListener.access$0(this.this$1);
                }
            });
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void handleActivation() {
            if (this.fIsHandlingActivation) {
                return;
            }
            if (this.fActivePart != AbstractTextEditor.this) return;
            this.fIsHandlingActivation = true;
            try {
                AbstractTextEditor.this.safelySanityCheckState(AbstractTextEditor.this.getEditorInput());
            }
            catch (Throwable throwable) {
                Object var1_2 = null;
                this.fIsHandlingActivation = false;
                throw throwable;
            }
            {
                Object var1_3 = null;
                this.fIsHandlingActivation = false;
                return;
            }
        }

        static /* synthetic */ void access$0(ActivationListener activationListener) {
            activationListener.handleActivation();
        }
    }

    interface ICursorListener
    extends MouseListener,
    KeyListener {
    }

    static class IdMapEntry {
        private String fActionId;
        private int fAction;

        public IdMapEntry(String actionId, int action) {
            this.fActionId = actionId;
            this.fAction = action;
        }

        public String getActionId() {
            return this.fActionId;
        }

        public int getAction() {
            return this.fAction;
        }
    }

    class ScrollLinesAction
    extends Action {
        private int fScrollIncrement;

        public ScrollLinesAction(int scrollIncrement) {
            this.fScrollIncrement = scrollIncrement;
        }

        public void run() {
            ISourceViewer viewer = AbstractTextEditor.this.getSourceViewer();
            if (viewer instanceof ITextViewerExtension5) {
                ITextViewerExtension5 extension = (ITextViewerExtension5)viewer;
                StyledText textWidget = viewer.getTextWidget();
                int topIndex = textWidget.getTopIndex();
                int newTopIndex = Math.max(0, topIndex + this.fScrollIncrement);
                viewer.setTopIndex(extension.widgetLine2ModelLine(newTopIndex));
            } else {
                int topIndex = viewer.getTopIndex();
                int newTopIndex = Math.max(0, topIndex + this.fScrollIncrement);
                viewer.setTopIndex(newTopIndex);
            }
        }
    }

    class ToggleInsertModeAction
    extends ResourceAction {
        public ToggleInsertModeAction(ResourceBundle bundle, String prefix) {
            super(bundle, prefix, 2);
        }

        public void run() {
            AbstractTextEditor.this.switchToNextInsertMode();
        }

        public boolean isChecked() {
            return AbstractTextEditor.this.fInsertMode == ITextEditorExtension3.SMART_INSERT;
        }
    }

    class ToggleOverwriteModeAction
    extends ResourceAction {
        public ToggleOverwriteModeAction(ResourceBundle bundle, String prefix) {
            super(bundle, prefix);
        }

        public void run() {
            AbstractTextEditor.this.toggleOverwriteMode();
        }
    }

    class LineEndAction
    extends TextNavigationAction {
        private boolean fDoSelect;

        public LineEndAction(StyledText textWidget, boolean doSelect) {
            super(textWidget, 0x1000008);
            this.fDoSelect = doSelect;
        }

        public void run() {
            int lineLength;
            StyledText st;
            boolean isSmartHomeEndEnabled = false;
            IPreferenceStore store = AbstractTextEditor.this.getPreferenceStore();
            if (store != null) {
                isSmartHomeEndEnabled = store.getBoolean(AbstractTextEditor.PREFERENCE_NAVIGATION_SMART_HOME_END);
            }
            if ((st = AbstractTextEditor.this.getSourceViewer().getTextWidget()) == null || st.isDisposed()) {
                return;
            }
            int caretOffset = st.getCaretOffset();
            int lineNumber = st.getLineAtOffset(caretOffset);
            int lineOffset = st.getOffsetAtLine(lineNumber);
            try {
                int caretOffsetInDocument = AbstractTextEditor.widgetOffset2ModelOffset(AbstractTextEditor.this.getSourceViewer(), caretOffset);
                lineLength = AbstractTextEditor.this.getSourceViewer().getDocument().getLineInformationOfOffset(caretOffsetInDocument).getLength();
            }
            catch (BadLocationException badLocationException) {
                return;
            }
            int lineEndOffset = lineOffset + lineLength;
            int delta = lineEndOffset - st.getCharCount();
            if (delta > 0) {
                lineEndOffset -= delta;
                lineLength -= delta;
            }
            String line = "";
            if (lineLength > 0) {
                line = st.getText(lineOffset, lineEndOffset - 1);
            }
            int i = lineLength - 1;
            while (i > -1 && Character.isWhitespace(line.charAt(i))) {
                --i;
            }
            ++i;
            Point oldSelection = st.getSelection();
            int newCaretOffset = -1;
            if (isSmartHomeEndEnabled) {
                newCaretOffset = caretOffset - lineOffset == i ? lineEndOffset : lineOffset + i;
            } else if (caretOffset < lineEndOffset) {
                newCaretOffset = lineEndOffset;
            }
            if (newCaretOffset == -1) {
                newCaretOffset = caretOffset;
            } else {
                st.setCaretOffset(newCaretOffset);
            }
            st.setCaretOffset(newCaretOffset);
            if (this.fDoSelect) {
                if (caretOffset < oldSelection.y) {
                    st.setSelection(oldSelection.y, newCaretOffset);
                } else {
                    st.setSelection(oldSelection.x, newCaretOffset);
                }
            } else {
                st.setSelection(newCaretOffset);
            }
            this.fireSelectionChanged(oldSelection);
        }
    }

    protected class LineStartAction
    extends TextNavigationAction {
        private final boolean fDoSelect;

        public LineStartAction(StyledText textWidget, boolean doSelect) {
            super(textWidget, 0x1000007);
            this.fDoSelect = doSelect;
        }

        protected int getLineStartPosition(IDocument document, String line, int length, int offset) {
            int index = 0;
            while (index < length && Character.isWhitespace(line.charAt(index))) {
                ++index;
            }
            return index;
        }

        public void run() {
            int lineLength;
            int caretOffsetInDocument;
            StyledText st;
            boolean isSmartHomeEndEnabled = false;
            IPreferenceStore store = AbstractTextEditor.this.getPreferenceStore();
            if (store != null) {
                isSmartHomeEndEnabled = store.getBoolean(AbstractTextEditor.PREFERENCE_NAVIGATION_SMART_HOME_END);
            }
            if ((st = AbstractTextEditor.this.getSourceViewer().getTextWidget()) == null || st.isDisposed()) {
                return;
            }
            int caretOffset = st.getCaretOffset();
            int lineNumber = st.getLineAtOffset(caretOffset);
            int lineOffset = st.getOffsetAtLine(lineNumber);
            IDocument document = AbstractTextEditor.this.getSourceViewer().getDocument();
            try {
                caretOffsetInDocument = AbstractTextEditor.widgetOffset2ModelOffset(AbstractTextEditor.this.getSourceViewer(), caretOffset);
                lineLength = document.getLineInformationOfOffset(caretOffsetInDocument).getLength();
            }
            catch (BadLocationException badLocationException) {
                return;
            }
            String line = "";
            if (lineLength > 0) {
                int end = lineOffset + lineLength - 1;
                end = Math.min(end, st.getCharCount() - 1);
                line = st.getText(lineOffset, end);
            }
            int index = this.getLineStartPosition(document, line, lineLength, caretOffsetInDocument);
            Point oldSelection = st.getSelection();
            int newCaretOffset = -1;
            if (isSmartHomeEndEnabled) {
                newCaretOffset = caretOffset - lineOffset == index ? lineOffset : lineOffset + index;
            } else if (caretOffset > lineOffset) {
                newCaretOffset = lineOffset;
            }
            if (newCaretOffset == -1) {
                newCaretOffset = caretOffset;
            } else {
                st.setCaretOffset(newCaretOffset);
            }
            if (this.fDoSelect) {
                if (caretOffset < oldSelection.y) {
                    st.setSelection(oldSelection.y, newCaretOffset);
                } else {
                    st.setSelection(oldSelection.x, newCaretOffset);
                }
            } else {
                st.setSelection(newCaretOffset);
            }
            this.fireSelectionChanged(oldSelection);
        }
    }

    class ShowRulerContextMenuAction
    extends Action {
        ShowRulerContextMenuAction() {
        }

        public void run() {
            if (AbstractTextEditor.this.fSourceViewer == null) {
                return;
            }
            StyledText text = AbstractTextEditor.this.fSourceViewer.getTextWidget();
            if (text == null || text.isDisposed()) {
                return;
            }
            Point location = text.getLocationAtOffset(text.getCaretOffset());
            location.x = 0;
            if (AbstractTextEditor.this.fVerticalRuler instanceof IVerticalRulerExtension) {
                ((IVerticalRulerExtension)AbstractTextEditor.this.fVerticalRuler).setLocationOfLastMouseButtonActivity(location.x, location.y);
            }
            location = text.toDisplay(location);
            AbstractTextEditor.this.fRulerContextMenu.setLocation(location.x, location.y);
            AbstractTextEditor.this.fRulerContextMenu.setVisible(true);
        }
    }

    class SelectionProvider
    implements IPostSelectionProvider,
    ISelectionValidator {
        SelectionProvider() {
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            if (AbstractTextEditor.this.fSourceViewer != null) {
                AbstractTextEditor.this.fSourceViewer.getSelectionProvider().addSelectionChangedListener(listener);
            }
        }

        public ISelection getSelection() {
            return AbstractTextEditor.this.doGetSelection();
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            if (AbstractTextEditor.this.fSourceViewer != null) {
                AbstractTextEditor.this.fSourceViewer.getSelectionProvider().removeSelectionChangedListener(listener);
            }
        }

        public void setSelection(ISelection selection) {
            AbstractTextEditor.this.doSetSelection(selection);
        }

        public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
            if (AbstractTextEditor.this.fSourceViewer != null && AbstractTextEditor.this.fSourceViewer.getSelectionProvider() instanceof IPostSelectionProvider) {
                IPostSelectionProvider provider = (IPostSelectionProvider)AbstractTextEditor.this.fSourceViewer.getSelectionProvider();
                provider.addPostSelectionChangedListener(listener);
            }
        }

        public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
            if (AbstractTextEditor.this.fSourceViewer != null && AbstractTextEditor.this.fSourceViewer.getSelectionProvider() instanceof IPostSelectionProvider) {
                IPostSelectionProvider provider = (IPostSelectionProvider)AbstractTextEditor.this.fSourceViewer.getSelectionProvider();
                provider.removePostSelectionChangedListener(listener);
            }
        }

        public boolean isValid(ISelection postSelection) {
            return AbstractTextEditor.this.fSelectionListener != null && AbstractTextEditor.this.fSelectionListener.isValid(postSelection);
        }
    }

    protected abstract class AbstractSelectionChangedListener
    implements ISelectionChangedListener {
        protected AbstractSelectionChangedListener() {
        }

        public void install(ISelectionProvider selectionProvider) {
            if (selectionProvider == null) {
                return;
            }
            if (selectionProvider instanceof IPostSelectionProvider) {
                IPostSelectionProvider provider = (IPostSelectionProvider)selectionProvider;
                provider.addPostSelectionChangedListener((ISelectionChangedListener)this);
            } else {
                selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            }
        }

        public void uninstall(ISelectionProvider selectionProvider) {
            if (selectionProvider == null) {
                return;
            }
            if (selectionProvider instanceof IPostSelectionProvider) {
                IPostSelectionProvider provider = (IPostSelectionProvider)selectionProvider;
                provider.removePostSelectionChangedListener((ISelectionChangedListener)this);
            } else {
                selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
            }
        }
    }

    private class SelectionListener
    extends AbstractSelectionChangedListener
    implements IDocumentListener {
        private IDocument fDocument;
        private final Object INVALID_SELECTION;
        private Object fPostSelection;

        SelectionListener() {
            this.fPostSelection = this.INVALID_SELECTION = new Object();
        }

        public synchronized void selectionChanged(SelectionChangedEvent event) {
            this.fPostSelection = event.getSelection();
        }

        public synchronized void documentAboutToBeChanged(DocumentEvent event) {
            this.fPostSelection = this.INVALID_SELECTION;
        }

        public void documentChanged(DocumentEvent event) {
        }

        public synchronized boolean isValid(ISelection selection) {
            return this.fPostSelection != this.INVALID_SELECTION && this.fPostSelection == selection;
        }

        public void setDocument(IDocument document) {
            if (this.fDocument != null) {
                this.fDocument.removeDocumentListener((IDocumentListener)this);
            }
            this.fDocument = document;
            if (this.fDocument != null) {
                this.fDocument.addDocumentListener((IDocumentListener)this);
            }
        }

        public void install(ISelectionProvider selectionProvider) {
            super.install(selectionProvider);
            if (selectionProvider != null) {
                selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            }
        }

        public void uninstall(ISelectionProvider selectionProvider) {
            if (selectionProvider != null) {
                selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
            }
            if (this.fDocument != null) {
                this.fDocument.removeDocumentListener((IDocumentListener)this);
                this.fDocument = null;
            }
            super.uninstall(selectionProvider);
        }
    }

    private static class PositionLabelValue {
        public int fValue;

        PositionLabelValue() {
        }

        public String toString() {
            return String.valueOf(this.fValue);
        }
    }
}

