/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.tools;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.wizards.tools.UpdateBuildpathWizard;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class UpdateClasspathAction
implements IViewActionDelegate {
    private ISelection fSelection;
    private static final String KEY_TITLE = "Actions.classpath.title";
    private static final String KEY_MESSAGE = "Actions.classpath.message";
    private static final String KEY_UPDATE = "Actions.classpath.update";

    public void run(IAction action) {
        if (this.fSelection instanceof IStructuredSelection) {
            Object[] elems = ((IStructuredSelection)this.fSelection).toArray();
            ArrayList<IPluginModelBase> models = new ArrayList<IPluginModelBase>(elems.length);
            PluginModelManager manager = PDECore.getDefault().getModelManager();
            int i = 0;
            while (i < elems.length) {
                IPluginModelBase model;
                Object elem = elems[i];
                IProject project = null;
                if (elem instanceof IFile) {
                    IFile file = (IFile)elem;
                    project = file.getProject();
                } else if (elem instanceof IProject) {
                    project = (IProject)elem;
                } else if (elem instanceof IJavaProject) {
                    project = ((IJavaProject)elem).getProject();
                }
                if (project != null && WorkspaceModelManager.isJavaPluginProject((IProject)project) && (model = manager.findModel(project)) != null) {
                    models.add(model);
                }
                ++i;
            }
            IPluginModelBase[] modelArray = models.toArray(new IPluginModelBase[models.size()]);
            UpdateBuildpathWizard wizard = new UpdateBuildpathWizard(modelArray);
            final WizardDialog dialog = new WizardDialog(PDEPlugin.getActiveWorkbenchShell(), (IWizard)wizard);
            BusyIndicator.showWhile((Display)PDEPlugin.getActiveWorkbenchShell().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    dialog.open();
                }
            });
        }
    }

    public static void run(boolean fork, IRunnableContext context, final IPluginModelBase[] models) {
        try {
            context.run(fork, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        IWorkspaceRunnable runnable = new IWorkspaceRunnable(this, models){
                            final /* synthetic */ 2 this$1;
                            private final /* synthetic */ IPluginModelBase[] val$models;
                            {
                                this.this$1 = var1_1;
                                this.val$models = iPluginModelBaseArray;
                            }

                            public void run(IProgressMonitor monitor) throws CoreException {
                                UpdateClasspathAction.doUpdateClasspath(monitor, this.val$models);
                            }
                        };
                        PDEPlugin.getWorkspace().run(runnable, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (OperationCanceledException e) {
                        throw new InterruptedException(e.getMessage());
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        catch (InvocationTargetException e) {
            String title = PDEPlugin.getResourceString(KEY_TITLE);
            String message = PDEPlugin.getResourceString(KEY_MESSAGE);
            PDEPlugin.logException(e, title, message);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void doUpdateClasspath(IProgressMonitor monitor, IPluginModelBase[] models) throws CoreException {
        monitor.beginTask(PDEPlugin.getResourceString(KEY_UPDATE), models.length);
        try {
            int i = 0;
            while (i < models.length) {
                block7: {
                    IPluginModelBase model;
                    block6: {
                        model = models[i];
                        monitor.subTask(models[i].getPluginBase().getId());
                        IProject project = model.getUnderlyingResource().getProject();
                        if (project.hasNature("org.eclipse.jdt.core.javanature")) break block6;
                        monitor.worked(1);
                        break block7;
                    }
                    ClasspathUtilCore.setClasspath((IPluginModelBase)model, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    if (monitor.isCanceled()) break;
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        monitor.done();
    }

    public void init(IViewPart view) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fSelection = selection;
    }
}

