/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.schema;

import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.internal.core.ischema.IDocumentSection;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.ischema.ISchemaAttribute;
import org.eclipse.pde.internal.core.ischema.ISchemaComplexType;
import org.eclipse.pde.internal.core.ischema.ISchemaElement;
import org.eclipse.pde.internal.core.ischema.ISchemaObject;
import org.eclipse.pde.internal.core.ischema.ISchemaType;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.FormOutlinePage;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.schema.SchemaDocPage;
import org.eclipse.pde.internal.ui.editor.schema.SchemaFormPage;
import org.eclipse.swt.graphics.Image;

public class SchemaFormOutlinePage
extends FormOutlinePage {
    private Object[] topics;

    public Object[] getChildren(Object parent) {
        ISchema schema = (ISchema)this.editor.getAggregateModel();
        if (schema.isValid()) {
            if (parent instanceof SchemaFormPage) {
                return this.getMarkup();
            }
            if (parent instanceof ISchemaElement) {
                return this.getAttributes((ISchemaElement)parent);
            }
            if (parent instanceof SchemaDocPage) {
                return this.getTopics();
            }
        }
        return super.getChildren(parent);
    }

    public SchemaFormOutlinePage(PDEFormEditor editor) {
        super(editor);
    }

    protected Object[] createTopics() {
        ISchema schema = (ISchema)this.editor.getAggregateModel();
        IDocumentSection[] sections = schema.getDocumentSections();
        Object[] result = new Object[sections.length + 1];
        result[0] = schema;
        int i = 1;
        while (i <= sections.length) {
            result[i] = sections[i - 1];
            ++i;
        }
        return result;
    }

    Object[] getAttributes(ISchemaElement element) {
        ISchemaType type = element.getType();
        if (type instanceof ISchemaComplexType) {
            return ((ISchemaComplexType)type).getAttributes();
        }
        return new Object[0];
    }

    Object[] getMarkup() {
        ISchema schema = (ISchema)this.editor.getAggregateModel();
        return schema.getElements();
    }

    String getObjectLabel(Object obj) {
        if (obj instanceof ISchema) {
            return PDEPlugin.getResourceString("SchemaEditor.topic.overview");
        }
        if (obj instanceof IDocumentSection) {
            IDocumentSection section = (IDocumentSection)obj;
            String sectionId = section.getSectionId();
            if (sectionId.equals("examples")) {
                return PDEPlugin.getResourceString("SchemaEditor.topic.examples");
            }
            if (sectionId.equals("since")) {
                return PDEPlugin.getResourceString("SchemaEditor.topic.since");
            }
            if (sectionId.equals("implementation")) {
                return PDEPlugin.getResourceString("SchemaEditor.topic.implementation");
            }
            if (sectionId.equals("apiInfo")) {
                return PDEPlugin.getResourceString("SchemaEditor.topic.api");
            }
            if (sectionId.equals("copyright")) {
                return PDEPlugin.getResourceString("SchemaEditor.topic.copyright");
            }
        }
        return null;
    }

    Object[] getTopics() {
        if (this.topics == null) {
            this.topics = this.createTopics();
        }
        return this.topics;
    }

    protected String getParentPageId(Object item) {
        if (item instanceof ISchemaElement || item instanceof ISchemaAttribute) {
            return "form";
        }
        if (item instanceof IDocumentSection || item instanceof ISchema) {
            return "doc";
        }
        return super.getParentPageId(item);
    }

    public void modelChanged(IModelChangedEvent event) {
        if (event.getChangeType() == 99) {
            this.topics = null;
            this.treeViewer.refresh();
            return;
        }
        Object object = event.getChangedObjects()[0];
        if (event.getChangeType() == 3) {
            this.treeViewer.update(object, null);
        } else {
            ISchemaObject parent = null;
            if (object instanceof ISchemaObject) {
                parent = ((ISchemaObject)object).getParent();
            }
            if (parent != null) {
                boolean cfr_ignored_0 = parent instanceof ISchema;
                this.treeViewer.refresh((Object)parent);
                this.treeViewer.expandToLevel((Object)parent, 2);
            } else {
                this.treeViewer.refresh();
                this.treeViewer.expandAll();
            }
        }
    }

    class OutlineLabelProvider
    extends FormOutlinePage.BasicLabelProvider {
        OutlineLabelProvider() {
        }

        public String getText(Object obj) {
            String label = SchemaFormOutlinePage.this.getObjectLabel(obj);
            if (label != null) {
                return label;
            }
            return super.getText(obj);
        }

        public Image getImage(Object obj) {
            Image image = PDEPlugin.getDefault().getLabelProvider().getImage(obj);
            if (image != null) {
                return image;
            }
            return super.getImage(obj);
        }
    }
}

