/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.SystemFileEditorInput;
import org.eclipse.pde.internal.ui.editor.context.XMLInputContext;
import org.eclipse.pde.internal.ui.model.AbstractEditingModel;
import org.eclipse.pde.internal.ui.model.IDocumentNode;
import org.eclipse.pde.internal.ui.model.plugin.FragmentModel;
import org.eclipse.pde.internal.ui.model.plugin.PluginBaseNode;
import org.eclipse.pde.internal.ui.model.plugin.PluginModel;
import org.eclipse.pde.internal.ui.model.plugin.PluginModelBase;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;

public class PluginInputContext
extends XMLInputContext {
    public static final String CONTEXT_ID = "plugin-context";
    private boolean fIsFragment;
    static /* synthetic */ Class class$0;

    public PluginInputContext(PDEFormEditor editor, IEditorInput input, boolean primary, boolean isFragment) {
        super(editor, input, primary);
        this.fIsFragment = isFragment;
        this.create();
    }

    protected IBaseModel createModel(IEditorInput input) throws CoreException {
        PluginModelBase model = null;
        if (input instanceof IStorageEditorInput) {
            boolean isReconciling = input instanceof IFileEditorInput;
            IDocument document = this.getDocumentProvider().getDocument((Object)input);
            model = this.fIsFragment ? new FragmentModel(document, isReconciling) : new PluginModel(document, isReconciling);
            if (input instanceof IFileEditorInput) {
                IFile file = ((IFileEditorInput)input).getFile();
                model.setUnderlyingResource((IResource)file);
                model.setCharset(file.getCharset());
            } else if (input instanceof SystemFileEditorInput) {
                SystemFileEditorInput systemFileEditorInput = (SystemFileEditorInput)input;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.io.File");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                File file = (File)systemFileEditorInput.getAdapter(clazz);
                model.setInstallLocation(file.getParent());
                model.setCharset(this.getDefaultCharset());
            } else {
                model.setCharset(this.getDefaultCharset());
            }
            model.load();
        }
        return model;
    }

    public String getId() {
        return CONTEXT_ID;
    }

    public boolean isFragment() {
        return this.fIsFragment;
    }

    protected void reorderInsertEdits(ArrayList ops) {
        HashMap map = this.getOperationTable();
        Iterator iter = map.keySet().iterator();
        TextEdit runtimeInsert = null;
        TextEdit requiresInsert = null;
        ArrayList<TextEdit> extensionPointInserts = new ArrayList<TextEdit>();
        ArrayList<TextEdit> extensionInserts = new ArrayList<TextEdit>();
        while (iter.hasNext()) {
            TextEdit edit;
            IDocumentNode node;
            Object object = iter.next();
            if (!(object instanceof IDocumentNode) || !((node = (IDocumentNode)object).getParentNode() instanceof PluginBaseNode) || !((edit = (TextEdit)map.get(node)) instanceof InsertEdit)) continue;
            if (node.getXMLTagName().equals("runtime")) {
                runtimeInsert = edit;
                continue;
            }
            if (node.getXMLTagName().equals("requires")) {
                requiresInsert = edit;
                continue;
            }
            if (node.getXMLTagName().equals("extension")) {
                extensionInserts.add(edit);
                continue;
            }
            if (!node.getXMLTagName().equals("extension-point")) continue;
            extensionPointInserts.add(edit);
        }
        int i = 0;
        while (i < ops.size()) {
            TextEdit edit = (TextEdit)ops.get(i);
            if (edit instanceof InsertEdit && extensionPointInserts.contains(edit)) {
                ops.remove(edit);
                ops.add(0, edit);
            }
            ++i;
        }
        if (requiresInsert != null) {
            ops.remove(requiresInsert);
            ops.add(0, requiresInsert);
        }
        if (runtimeInsert != null) {
            ops.remove(runtimeInsert);
            ops.add(0, runtimeInsert);
        }
    }

    public void doRevert() {
        this.fEditOperations.clear();
        this.fOperationTable.clear();
        this.fMoveOperations.clear();
        AbstractEditingModel model = (AbstractEditingModel)this.getModel();
        model.reconciled(model.getDocument());
    }
}

