/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.feature;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.IModelProviderEvent;
import org.eclipse.pde.core.IModelProviderListener;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.core.feature.FeatureData;
import org.eclipse.pde.internal.core.feature.FeaturePlugin;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureData;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeatureObject;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.ModelDataTransfer;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PropertiesAction;
import org.eclipse.pde.internal.ui.editor.TableSection;
import org.eclipse.pde.internal.ui.editor.feature.FeatureAdvancedPage;
import org.eclipse.pde.internal.ui.editor.feature.OpenReferenceAction;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.parts.EditableTablePart;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.ResourceSelectionDialog;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class DataSection
extends TableSection
implements IModelProviderListener {
    private static final String SECTION_TITLE = "FeatureEditor.DataSection.title";
    private static final String SECTION_DESC = "FeatureEditor.DataSection.desc";
    private static final String KEY_NEW = "FeatureEditor.DataSection.new";
    private static final String POPUP_NEW = "Menus.new.label";
    private static final String POPUP_DELETE = "Actions.delete.label";
    private PropertiesAction propertiesAction;
    private TableViewer dataViewer;
    private Action newAction;
    private Action openAction;
    private Action deleteAction;

    public DataSection(FeatureAdvancedPage page, Composite parent) {
        super((PDEFormPage)page, parent, 128, new String[]{PDEPlugin.getResourceString(KEY_NEW)});
        this.getSection().setText(PDEPlugin.getResourceString(SECTION_TITLE));
        this.getSection().setDescription(PDEPlugin.getResourceString(SECTION_DESC));
        this.getTablePart().setEditable(false);
    }

    public void commit(boolean onSave) {
        super.commit(onSave);
    }

    public void createClient(Section section, FormToolkit toolkit) {
        Composite container = this.createClientContainer((Composite)section, 2, toolkit);
        GridLayout layout = (GridLayout)container.getLayout();
        layout.verticalSpacing = 9;
        this.createViewerPartControl(container, 2, 2, toolkit);
        EditableTablePart tablePart = this.getTablePart();
        this.dataViewer = tablePart.getTableViewer();
        this.dataViewer.setContentProvider((IContentProvider)new PluginContentProvider());
        this.dataViewer.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        toolkit.paintBordersFor(container);
        this.makeActions();
        section.setClient((Control)container);
        this.initialize();
    }

    protected void handleDoubleClick(IStructuredSelection selection) {
        this.openAction.run();
    }

    protected void buttonSelected(int index) {
        if (index == 0) {
            this.handleNew();
        }
    }

    public void dispose() {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        WorkspaceModelManager mng = PDECore.getDefault().getWorkspaceModelManager();
        mng.removeModelProviderListener((IModelProviderListener)this);
        super.dispose();
    }

    public boolean setFormInput(Object object) {
        if (object instanceof IFeatureData) {
            this.dataViewer.setSelection((ISelection)new StructuredSelection(object), true);
            return true;
        }
        return false;
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.openAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.newAction);
        manager.add((IAction)this.deleteAction);
        manager.add((IContributionItem)new Separator());
        this.getPage().getPDEEditor().getContributor().contextMenuAboutToShow(manager);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.propertiesAction);
    }

    private void handleNew() {
        final IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        IResource resource = model.getUnderlyingResource();
        final IContainer folder = resource.getParent();
        BusyIndicator.showWhile((Display)this.dataViewer.getTable().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                ResourceSelectionDialog dialog = new ResourceSelectionDialog(DataSection.this.dataViewer.getTable().getShell(), (IAdaptable)folder, null);
                dialog.open();
                Object[] result = dialog.getResult();
                DataSection.this.processNewResult(model, folder, result);
            }
        });
    }

    private void processNewResult(IFeatureModel model, IContainer folder, Object[] result) {
        if (result == null || result.length == 0) {
            return;
        }
        IPath folderPath = folder.getProjectRelativePath();
        ArrayList<IPath> entries = new ArrayList<IPath>();
        int i = 0;
        while (i < result.length) {
            Object item = result[i];
            if (item instanceof IFile) {
                IFile file = (IFile)item;
                IPath filePath = file.getProjectRelativePath();
                int matching = filePath.matchingFirstSegments(folderPath);
                IPath relativePath = filePath.removeFirstSegments(matching);
                entries.add(relativePath);
            }
            ++i;
        }
        if (entries.size() > 0) {
            try {
                IFeatureData[] array = new IFeatureData[entries.size()];
                int i2 = 0;
                while (i2 < array.length) {
                    IFeatureData data = model.getFactory().createData();
                    IPath path = (IPath)entries.get(i2);
                    data.setId(path.toString());
                    array[i2] = data;
                    ++i2;
                }
                model.getFeature().addData(array);
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
        }
    }

    private void handleSelectAll() {
        IStructuredContentProvider provider = (IStructuredContentProvider)this.dataViewer.getContentProvider();
        Object[] elements = provider.getElements(this.dataViewer.getInput());
        StructuredSelection ssel = new StructuredSelection(elements);
        this.dataViewer.setSelection((ISelection)ssel);
    }

    private void handleDelete() {
        IStructuredSelection ssel = (IStructuredSelection)this.dataViewer.getSelection();
        if (ssel.isEmpty()) {
            return;
        }
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        IFeature feature = model.getFeature();
        try {
            IFeatureData[] removed = new IFeatureData[ssel.size()];
            int i = 0;
            Iterator iter = ssel.iterator();
            while (iter.hasNext()) {
                IFeatureData iobj = (IFeatureData)iter.next();
                removed[i++] = iobj;
            }
            feature.removeData(removed);
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    public boolean doGlobalAction(String actionId) {
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            BusyIndicator.showWhile((Display)this.dataViewer.getTable().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    DataSection.this.handleDelete();
                }
            });
            return true;
        }
        if (actionId.equals(ActionFactory.SELECT_ALL.getId())) {
            BusyIndicator.showWhile((Display)this.dataViewer.getTable().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    DataSection.this.handleSelectAll();
                }
            });
            return true;
        }
        if (actionId.equals(ActionFactory.CUT.getId())) {
            this.handleDelete();
            return false;
        }
        if (actionId.equals(ActionFactory.PASTE.getId())) {
            this.doPaste();
            return true;
        }
        return false;
    }

    protected void selectionChanged(IStructuredSelection selection) {
        this.getPage().getPDEEditor().setSelection((ISelection)selection);
    }

    public void initialize() {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        this.refresh();
        this.getTablePart().setButtonEnabled(0, model.isEditable());
        model.addModelChangedListener((IModelChangedListener)this);
        WorkspaceModelManager mng = PDECore.getDefault().getWorkspaceModelManager();
        mng.addModelProviderListener((IModelProviderListener)this);
    }

    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99) {
            this.markStale();
            return;
        }
        Object obj = e.getChangedObjects()[0];
        if (obj instanceof IFeatureData && !(obj instanceof IFeaturePlugin)) {
            if (e.getChangeType() == 3) {
                this.dataViewer.update(obj, null);
            } else if (e.getChangeType() == 1) {
                this.dataViewer.add(e.getChangedObjects());
            } else if (e.getChangeType() == 2) {
                this.dataViewer.remove(e.getChangedObjects());
            }
        }
    }

    private void makeActions() {
        IModel model = (IModel)this.getPage().getModel();
        this.newAction = new Action(){

            public void run() {
                DataSection.this.handleNew();
            }
        };
        this.newAction.setText(PDEPlugin.getResourceString(POPUP_NEW));
        this.newAction.setEnabled(model.isEditable());
        this.deleteAction = new Action(){

            public void run() {
                BusyIndicator.showWhile((Display)DataSection.this.dataViewer.getTable().getDisplay(), (Runnable)new Runnable(this){
                    final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        DataSection.access$2(5.access$0(this.this$1));
                    }
                });
            }

            static /* synthetic */ DataSection access$0(5 var0) {
                return var0.DataSection.this;
            }
        };
        this.deleteAction.setEnabled(model.isEditable());
        this.deleteAction.setText(PDEPlugin.getResourceString(POPUP_DELETE));
        this.openAction = new OpenReferenceAction((ISelectionProvider)this.dataViewer);
        this.propertiesAction = new PropertiesAction(this.getPage().getPDEEditor());
    }

    public void modelsChanged(IModelProviderEvent event) {
        this.markStale();
    }

    public void setFocus() {
        if (this.dataViewer != null) {
            this.dataViewer.getTable().setFocus();
        }
    }

    public void refresh() {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        IFeature feature = model.getFeature();
        this.dataViewer.setInput((Object)feature);
        super.refresh();
    }

    protected boolean canPaste(Object target, Object[] objects) {
        int i = 0;
        while (i < objects.length) {
            if (objects[i] instanceof FeaturePlugin || !(objects[i] instanceof FeatureData)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void doPaste() {
        ModelDataTransfer modelTransfer;
        Clipboard clipboard = this.getPage().getPDEEditor().getClipboard();
        Object[] objects = (Object[])clipboard.getContents((Transfer)(modelTransfer = ModelDataTransfer.getInstance()));
        if (objects != null) {
            this.doPaste(null, objects);
        }
    }

    protected void doPaste(Object target, Object[] objects) {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        IFeature feature = model.getFeature();
        FeatureData[] fData = new FeatureData[objects.length];
        try {
            int i = 0;
            while (i < objects.length) {
                if (objects[i] instanceof FeatureData && !(objects[i] instanceof FeaturePlugin)) {
                    FeatureData fd = (FeatureData)objects[i];
                    fd.setModel(model);
                    fd.setParent((IFeatureObject)feature);
                    fData[i] = fd;
                }
                ++i;
            }
            feature.addData((IFeatureData[])fData);
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    class PluginContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        PluginContentProvider() {
        }

        public Object[] getElements(Object parent) {
            if (parent instanceof IFeature) {
                return ((IFeature)parent).getData();
            }
            return new Object[0];
        }
    }
}

