/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.plugin;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.pde.core.IEditableModel;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.internal.core.NLResourceHelper;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelProvider;
import org.eclipse.pde.internal.core.plugin.AbstractExtensionsModel;
import org.eclipse.pde.internal.core.plugin.Extensions;

public class WorkspaceExtensionsModel
extends AbstractExtensionsModel
implements IEditableModel,
IBundlePluginModelProvider {
    private IFile file;
    private boolean dirty;
    private boolean editable = true;
    private transient IBundlePluginModelBase fBundleModel;

    protected NLResourceHelper createNLResourceHelper() {
        String name = this.file.getName().equals("plugin.xml") ? "plugin" : "fragment";
        NLResourceHelper helper = new NLResourceHelper(name, this.getNLLookupLocations());
        return helper;
    }

    public URL getNLLookupLocation() {
        IPath path = this.file.getLocation().removeLastSegments(1);
        String installLocation = path.toOSString();
        if (!installLocation.startsWith("file:")) {
            installLocation = "file:" + installLocation;
        }
        try {
            URL url = new URL(String.valueOf(installLocation) + "/");
            return url;
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public WorkspaceExtensionsModel(IFile file) {
        this.setFile(file);
    }

    public void fireModelChanged(IModelChangedEvent event) {
        this.dirty = true;
        super.fireModelChanged(event);
    }

    public String getContents() {
        StringWriter swriter = new StringWriter();
        PrintWriter writer = new PrintWriter(swriter);
        this.save(writer);
        writer.flush();
        try {
            swriter.close();
        }
        catch (IOException iOException) {}
        return swriter.toString();
    }

    public IFile getFile() {
        return this.file;
    }

    public String getInstallLocation() {
        return this.file.getParent().getLocation().toOSString();
    }

    public IResource getUnderlyingResource() {
        return this.file;
    }

    public boolean isInSync() {
        if (this.file == null) {
            return true;
        }
        IPath path = this.file.getLocation();
        if (path == null) {
            return false;
        }
        return super.isInSync(path.toFile());
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void dispose() {
        super.dispose();
    }

    public void load() {
        if (this.file == null) {
            return;
        }
        if (this.file.exists()) {
            InputStream stream = null;
            boolean outOfSync = false;
            try {
                stream = this.file.getContents(false);
            }
            catch (CoreException coreException) {
                outOfSync = true;
            }
            if (outOfSync) {
                try {
                    stream = this.file.getContents(true);
                }
                catch (CoreException coreException) {
                    return;
                }
            }
            try {
                this.load(stream, outOfSync);
                stream.close();
            }
            catch (CoreException coreException) {
            }
            catch (IOException e) {
                PDECore.logException(e);
            }
        } else {
            this.getExtensions(true);
            this.loaded = true;
        }
    }

    protected void updateTimeStamp() {
        this.updateTimeStamp(this.file.getLocation().toFile());
    }

    public void save() {
        if (this.file == null) {
            return;
        }
        try {
            String contents = this.getContents();
            ByteArrayInputStream stream = new ByteArrayInputStream(contents.getBytes("UTF8"));
            if (this.file.exists()) {
                this.file.setContents((InputStream)stream, false, false, null);
            } else {
                this.file.create((InputStream)stream, false, null);
            }
            stream.close();
        }
        catch (CoreException e) {
            PDECore.logException(e);
        }
        catch (IOException iOException) {}
    }

    public void save(PrintWriter writer) {
        if (this.isLoaded()) {
            this.extensions.write("", writer);
        }
        this.dirty = false;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public void setEditable(boolean newEditable) {
        this.editable = newEditable;
    }

    public void setFile(IFile newFile) {
        this.file = newFile;
    }

    protected Extensions createExtensions() {
        Extensions extensions = super.createExtensions();
        extensions.setIsFragment(this.file.getName().equals("fragment.xml"));
        return extensions;
    }

    public String toString() {
        return this.file.getName();
    }

    public void setBundleModel(IBundlePluginModelBase model) {
        this.fBundleModel = model;
    }

    public IBundlePluginModelBase getBundlePluginModel() {
        return this.fBundleModel;
    }
}

