/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.util.Hashtable;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class XMLDefaultHandler
extends DefaultHandler
implements LexicalHandler {
    private Document fDocument;
    private Locator fLocator;
    private Hashtable fLineTable;
    private Element fRootElement;
    private Stack fElementStack = new Stack();

    public XMLDefaultHandler() {
        this.fLineTable = new Hashtable();
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        Element element = this.fDocument.createElement(qName);
        int i = 0;
        while (i < attributes.getLength()) {
            element.setAttribute(attributes.getQName(i), attributes.getValue(i));
            ++i;
        }
        Integer lineNumber = new Integer(this.fLocator.getLineNumber());
        Integer[] range = new Integer[]{lineNumber, new Integer(-1)};
        this.fLineTable.put(element, range);
        if (this.fRootElement == null) {
            this.fRootElement = element;
        } else {
            ((Element)this.fElementStack.peek()).appendChild(element);
        }
        this.fElementStack.push(element);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        Integer[] range = (Integer[])this.fLineTable.get(this.fElementStack.pop());
        range[1] = new Integer(this.fLocator.getLineNumber());
    }

    public void setDocumentLocator(Locator locator) {
        this.fLocator = locator;
    }

    public void startDocument() throws SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            this.fDocument = factory.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {}
    }

    public void endDocument() throws SAXException {
        this.fDocument.appendChild(this.fRootElement);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.fDocument.appendChild(this.fDocument.createProcessingInstruction(target, data));
    }

    public void characters(char[] characters, int start, int length) throws SAXException {
        StringBuffer buff = new StringBuffer();
        int i = 0;
        while (i < length) {
            buff.append(characters[start + i]);
            ++i;
        }
        Text text = this.fDocument.createTextNode(buff.toString());
        if (this.fRootElement == null) {
            this.fDocument.appendChild(text);
        } else {
            ((Element)this.fElementStack.peek()).appendChild(text);
        }
    }

    public Node getDocumentElement() {
        this.fDocument.getDocumentElement().normalize();
        return this.fDocument.getDocumentElement();
    }

    public Document getDocument() {
        this.fDocument.getDocumentElement().normalize();
        return this.fDocument;
    }

    public Hashtable getLineTable() {
        return this.fLineTable;
    }

    public void endCDATA() throws SAXException {
    }

    public void endDTD() throws SAXException {
    }

    public void startCDATA() throws SAXException {
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < length) {
            buffer.append(ch[start + i]);
            ++i;
        }
        Comment comment = this.fDocument.createComment(buffer.toString());
        if (this.fRootElement == null || this.fElementStack.isEmpty()) {
            this.fDocument.appendChild(comment);
        } else {
            ((Element)this.fElementStack.peek()).appendChild(comment);
        }
    }

    public void endEntity(String name) throws SAXException {
    }

    public void startEntity(String name) throws SAXException {
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }
}

