/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.wizards.datatransfer;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.FileSystemElement;
import org.eclipse.ui.wizards.datatransfer.DataTransferMessages;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.eclipse.ui.wizards.datatransfer.WizardFileSystemImportPage1;
import org.eclipse.ui.wizards.datatransfer.ZipFileStructureProvider;

class WizardZipFileImportPage1
extends WizardFileSystemImportPage1
implements ISelectionChangedListener,
Listener {
    private ZipFileStructureProvider providerCache;
    private static final String FILE_IMPORT_MASK = "*.jar;*.zip";
    private static final String STORE_SOURCE_NAMES_ID = "WizardZipFileImportPage1.STORE_SOURCE_NAMES_ID";
    private static final String STORE_IMPORT_ALL_RESOURCES_ID = "WizardZipFileImportPage1.STORE_IMPORT_ALL_ENTRIES_ID";
    private static final String STORE_OVERWRITE_EXISTING_RESOURCES_ID = "WizardZipFileImportPage1.STORE_OVERWRITE_EXISTING_RESOURCES_ID";
    private static final String STORE_SELECTED_TYPES_ID = "WizardZipFileImportPage1.STORE_SELECTED_TYPES_ID";

    public WizardZipFileImportPage1(IWorkbench aWorkbench, IStructuredSelection selection) {
        super("zipFileImportPage1", aWorkbench, selection);
        this.setTitle(DataTransferMessages.getString("ZipExport.exportTitle"));
        this.setDescription(DataTransferMessages.getString("ZipImport.description"));
    }

    public boolean cancel() {
        this.clearProviderCache();
        return true;
    }

    protected void clearProviderCache() {
        if (this.providerCache != null) {
            this.closeZipFile(this.providerCache.getZipFile());
            this.providerCache = null;
        }
    }

    protected boolean closeZipFile(ZipFile file) {
        try {
            file.close();
        }
        catch (IOException iOException) {
            this.displayErrorDialog(DataTransferMessages.format("ZipImport.couldNotClose", new Object[]{file.getName()}));
            return false;
        }
        return true;
    }

    protected void createOptionsGroup(Composite parent) {
        Composite optionsGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        optionsGroup.setLayout((Layout)layout);
        optionsGroup.setLayoutData((Object)new GridData(768));
        this.overwriteExistingResourcesCheckbox = new Button(optionsGroup, 32);
        this.overwriteExistingResourcesCheckbox.setText(DataTransferMessages.getString("FileImport.overwriteExisting"));
    }

    protected void displaySelectedCount(int selectedEntryCount) {
        if (selectedEntryCount == 1) {
            this.detailsDescriptionLabel.setText(DataTransferMessages.getString("ImportPage.oneSelected"));
        } else {
            this.detailsDescriptionLabel.setText(DataTransferMessages.format("ZipImport.entriesSelected", new Object[]{String.valueOf(selectedEntryCount)}));
        }
    }

    protected boolean ensureSourceIsValid() {
        ZipFile specifiedFile = this.getSpecifiedSourceFile();
        if (specifiedFile == null) {
            return false;
        }
        return this.closeZipFile(specifiedFile);
    }

    public boolean finish() {
        if (!super.finish()) {
            return false;
        }
        this.clearProviderCache();
        return true;
    }

    protected FileSystemElement getFileSystemTree() {
        if (this.getRoot() != null) {
            return this.getRoot();
        }
        ZipFile sourceFile = this.getSpecifiedSourceFile();
        if (sourceFile == null) {
            return null;
        }
        ZipFileStructureProvider provider = this.getStructureProvider(sourceFile);
        return this.selectFiles(provider.getRoot(), provider);
    }

    protected String getSourceLabel() {
        return DataTransferMessages.getString("ZipExport.destinationLabel");
    }

    protected ZipFile getSpecifiedSourceFile() {
        try {
            return new ZipFile(this.sourceNameField.getText());
        }
        catch (ZipException zipException) {
            this.displayErrorDialog(DataTransferMessages.getString("ZipImport.badFormat"));
        }
        catch (IOException iOException) {
            this.displayErrorDialog(DataTransferMessages.getString("ZipImport.couldNotRead"));
        }
        this.sourceNameField.setFocus();
        return null;
    }

    protected ZipFileStructureProvider getStructureProvider(ZipFile targetZip) {
        if (this.providerCache == null) {
            this.providerCache = new ZipFileStructureProvider(targetZip);
        } else if (!this.providerCache.getZipFile().getName().equals(targetZip.getName())) {
            this.clearProviderCache();
            this.providerCache = new ZipFileStructureProvider(targetZip);
        } else if (!this.providerCache.getZipFile().equals(targetZip)) {
            this.closeZipFile(targetZip);
        }
        return this.providerCache;
    }

    protected void handleSourceBrowseButtonPressed() {
        String selectedFile = this.queryZipFileToImport();
        if (selectedFile != null && !selectedFile.equals(this.sourceNameField.getText())) {
            this.resetSelection();
            this.sourceNameField.setText(selectedFile);
        }
    }

    protected boolean importAllResources() {
        ZipFileStructureProvider structureProvider = this.getStructureProvider(this.getSpecifiedSourceFile());
        return this.executeImportOperation(new ImportOperation(this.getContainerFullPath(), structureProvider.getRoot(), structureProvider, this));
    }

    protected boolean importResources(List fileSystemObjects) {
        ZipFileStructureProvider structureProvider = this.getStructureProvider(this.getSpecifiedSourceFile());
        return this.executeImportOperation(new ImportOperation(this.getContainerFullPath(), structureProvider.getRoot(), structureProvider, this, fileSystemObjects));
    }

    protected void initializeOperation(ImportOperation op) {
        op.setOverwriteResources(this.overwriteExistingResourcesCheckbox.getSelection());
    }

    protected String queryZipFileToImport() {
        FileDialog dialog = new FileDialog(this.sourceNameField.getShell(), 4096);
        dialog.setFilterExtensions(new String[]{FILE_IMPORT_MASK});
        String currentSourceString = this.sourceNameField.getText();
        int lastSeparatorIndex = currentSourceString.lastIndexOf(File.separator);
        if (lastSeparatorIndex != -1) {
            dialog.setFilterPath(currentSourceString.substring(0, lastSeparatorIndex));
        }
        return dialog.open();
    }

    protected void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] sourceNames = settings.getArray(STORE_SOURCE_NAMES_ID);
            if (sourceNames == null) {
                return;
            }
            if (settings.getBoolean(STORE_IMPORT_ALL_RESOURCES_ID)) {
                this.importAllResourcesRadio.setSelection(true);
                this.importTypedResourcesRadio.setSelection(false);
            } else {
                this.importTypedResourcesRadio.setSelection(true);
                this.importAllResourcesRadio.setSelection(false);
            }
            this.sourceNameField.setText(sourceNames[0]);
            int i = 0;
            while (i < sourceNames.length) {
                this.sourceNameField.add(sourceNames[i]);
                ++i;
            }
            String[] selectedTypes = settings.getArray(STORE_SELECTED_TYPES_ID);
            if (selectedTypes.length > 0) {
                this.typesToImportField.setText(selectedTypes[0]);
            }
            int i2 = 0;
            while (i2 < selectedTypes.length) {
                this.typesToImportField.add(selectedTypes[i2]);
                ++i2;
            }
            this.overwriteExistingResourcesCheckbox.setSelection(settings.getBoolean(STORE_OVERWRITE_EXISTING_RESOURCES_ID));
        }
    }

    protected void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] sourceNames = settings.getArray(STORE_SOURCE_NAMES_ID);
            if (sourceNames == null) {
                sourceNames = new String[]{};
            }
            sourceNames = this.addToHistory(sourceNames, this.sourceNameField.getText());
            settings.put(STORE_SOURCE_NAMES_ID, sourceNames);
            String[] selectedTypesNames = settings.getArray(STORE_SELECTED_TYPES_ID);
            if (selectedTypesNames == null) {
                selectedTypesNames = new String[]{};
            }
            if (this.importTypedResourcesRadio.getSelection()) {
                selectedTypesNames = this.addToHistory(selectedTypesNames, this.typesToImportField.getText());
            }
            settings.put(STORE_SELECTED_TYPES_ID, selectedTypesNames);
            settings.put(STORE_IMPORT_ALL_RESOURCES_ID, this.importAllResourcesRadio.getSelection());
            settings.put(STORE_OVERWRITE_EXISTING_RESOURCES_ID, this.overwriteExistingResourcesCheckbox.getSelection());
        }
    }
}

