/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate2;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.NewWizardMenu;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

public class NewWizardDropDownAction
extends Action
implements ActionFactory.IWorkbenchAction,
IMenuCreator,
IWorkbenchWindowPulldownDelegate2 {
    private IWorkbenchWindow workbenchWindow;
    private IAction newWizardAction;
    private MenuManager dropDownMenuMgr;

    public NewWizardDropDownAction(IWorkbenchWindow window, IAction newWizardAction) {
        super(IDEWorkbenchMessages.getString("NewWizardDropDown.text"));
        if (window == null) {
            throw new IllegalArgumentException();
        }
        this.workbenchWindow = window;
        this.newWizardAction = newWizardAction;
        this.setToolTipText(newWizardAction.getToolTipText());
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_NEW_WIZARD"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_NEW_WIZARD_DISABLED"));
        this.setMenuCreator(this);
    }

    protected void createDropDownMenuMgr() {
        if (this.dropDownMenuMgr == null) {
            this.dropDownMenuMgr = new MenuManager();
            this.dropDownMenuMgr.add((IContributionItem)new NewWizardMenu(this.workbenchWindow));
        }
    }

    public void dispose() {
        if (this.workbenchWindow == null) {
            return;
        }
        if (this.dropDownMenuMgr != null) {
            this.dropDownMenuMgr.dispose();
            this.dropDownMenuMgr = null;
        }
        this.workbenchWindow = null;
    }

    public Menu getMenu(Control parent) {
        this.createDropDownMenuMgr();
        return this.dropDownMenuMgr.createContextMenu(parent);
    }

    public Menu getMenu(Menu parent) {
        this.createDropDownMenuMgr();
        Menu menu = new Menu(parent);
        IContributionItem[] items = this.dropDownMenuMgr.getItems();
        int i = 0;
        while (i < items.length) {
            IContributionItem item;
            IContributionItem newItem = item = items[i];
            if (item instanceof ActionContributionItem) {
                newItem = new ActionContributionItem(((ActionContributionItem)item).getAction());
            }
            newItem.fill(menu, -1);
            ++i;
        }
        return menu;
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run() {
        if (this.workbenchWindow == null) {
            return;
        }
        this.newWizardAction.run();
    }

    public void run(IAction action) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

