/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.presentations;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.Geometry;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.dnd.DragUtil;
import org.eclipse.ui.internal.presentations.BasicStackList;
import org.eclipse.ui.internal.presentations.PaneFolder;
import org.eclipse.ui.internal.presentations.PaneFolderButtonListener;
import org.eclipse.ui.internal.presentations.SystemMenuClose;
import org.eclipse.ui.internal.presentations.SystemMenuMaximize;
import org.eclipse.ui.internal.presentations.SystemMenuMinimize;
import org.eclipse.ui.internal.presentations.SystemMenuMove;
import org.eclipse.ui.internal.presentations.SystemMenuRestore;
import org.eclipse.ui.internal.presentations.UpdatingActionContributionItem;
import org.eclipse.ui.presentations.IPartMenu;
import org.eclipse.ui.presentations.IPresentablePart;
import org.eclipse.ui.presentations.IPresentationSerializer;
import org.eclipse.ui.presentations.IStackPresentationSite;
import org.eclipse.ui.presentations.PresentationUtil;
import org.eclipse.ui.presentations.StackDropResult;
import org.eclipse.ui.presentations.StackPresentation;
import org.eclipse.ui.themes.ITheme;

public class DefaultPartPresentation
extends StackPresentation {
    private PaneFolder tabFolder;
    private IPresentablePart current;
    private int activeState = 0;
    private MenuManager systemMenuManager = new MenuManager();
    private Label titleLabel;
    private Listener dragListener;
    private List activationList = new ArrayList(10);
    private boolean activationListChange = true;
    private int dragStart = -1;
    private static final String TAB_DATA;
    private PaneFolderButtonListener buttonListener = new PaneFolderButtonListener(){

        public void stateButtonPressed(int buttonId) {
            DefaultPartPresentation.this.getSite().setState(buttonId);
        }

        public void closeButtonPressed(CTabItem item) {
            IPresentablePart part = DefaultPartPresentation.this.getPartForTab(item);
            DefaultPartPresentation.this.getSite().close(new IPresentablePart[]{part});
        }

        public void showList(CTabFolderEvent event) {
            event.doit = false;
            DefaultPartPresentation.this.showPartList();
        }
    };
    private MouseListener mouseListener = new MouseAdapter(){

        public void mouseDown(MouseEvent e) {
            if (e.widget instanceof Control) {
                CTabItem oldItem;
                Control ctrl = (Control)e.widget;
                Point globalPos = ctrl.toDisplay(new Point(e.x, e.y));
                CTabItem newItem = DefaultPartPresentation.this.tabFolder.getItem(DefaultPartPresentation.this.tabFolder.getControl().toControl(globalPos));
                if (newItem != null && newItem != (oldItem = DefaultPartPresentation.this.tabFolder.getSelection())) {
                    return;
                }
                if (DefaultPartPresentation.this.current != null) {
                    DefaultPartPresentation.this.current.setFocus();
                }
            }
        }

        public void mouseDoubleClick(MouseEvent e) {
            if (DefaultPartPresentation.this.getSite().getState() == 1) {
                DefaultPartPresentation.this.getSite().setState(2);
            } else {
                DefaultPartPresentation.this.getSite().setState(1);
            }
        }
    };
    private Listener menuListener = new Listener(){

        public void handleEvent(Event event) {
            Point pos = new Point(event.x, event.y);
            DefaultPartPresentation.this.showSystemMenu(pos);
        }
    };
    private Listener selectionListener = new Listener(){

        public void handleEvent(Event e) {
            if (DefaultPartPresentation.this.ignoreSelectionChanges) {
                return;
            }
            IPresentablePart item = DefaultPartPresentation.this.getPartForTab((CTabItem)e.item);
            if (item != null) {
                DefaultPartPresentation.this.setSelection((CTabItem)e.item);
            }
        }
    };
    private IPropertyListener childPropertyChangeListener = new IPropertyListener(){

        public void propertyChanged(Object source, int property) {
            if (DefaultPartPresentation.this.isDisposed()) {
                return;
            }
            if (source instanceof IPresentablePart) {
                IPresentablePart part = (IPresentablePart)source;
                DefaultPartPresentation.this.childPropertyChanged(part, property);
            }
        }
    };
    private DisposeListener tabDisposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            if (e.widget instanceof CTabItem) {
                CTabItem item = (CTabItem)e.widget;
                IPresentablePart part = DefaultPartPresentation.this.getPartForTab(item);
                part.removePropertyListener(DefaultPartPresentation.this.childPropertyChangeListener);
            }
        }
    };
    private DisposeListener folderDisposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            DefaultPartPresentation.this.widgetDisposed();
        }
    };
    private ToolBar viewToolBar;
    private boolean shellActive = true;
    private boolean ignoreSelectionChanges = false;
    private ShellListener shellListener = new ShellAdapter(){

        public void shellActivated(ShellEvent e) {
            DefaultPartPresentation.this.shellActive = true;
            DefaultPartPresentation.this.updateGradient();
        }

        public void shellDeactivated(ShellEvent e) {
            DefaultPartPresentation.this.shellActive = false;
            DefaultPartPresentation.this.updateGradient();
        }
    };
    private IPropertyChangeListener themeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (DefaultPartPresentation.this.isDisposed()) {
                return;
            }
            String property = event.getProperty();
            if (property.equals("CHANGE_CURRENT_THEME")) {
                DefaultPartPresentation.this.updateGradient();
                DefaultPartPresentation.this.setTitleAttributes();
            } else if (property.equals("org.eclipse.ui.workbench.INACTIVE_TAB_BG_START") || property.equals("org.eclipse.ui.workbench.INACTIVE_TAB_BG_END") || property.equals("org.eclipse.ui.workbench.INACTIVE_TAB_TEXT_COLOR") || property.equals("org.eclipse.ui.workbench.ACTIVE_TAB_TEXT_COLOR") || property.equals("org.eclipse.ui.workbench.ACTIVE_TAB_BG_START") || property.equals("org.eclipse.ui.workbench.ACTIVE_TAB_BG_END") || property.equals("org.eclipse.ui.workbench.TAB_TEXT_FONT")) {
                DefaultPartPresentation.this.updateGradient();
            } else if (property.equals("org.eclipse.ui.workbench.VIEW_MESSAGE_TEXT_FONT")) {
                DefaultPartPresentation.this.setTitleAttributes();
            }
        }
    };
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.internal.presentations.DefaultPartPresentation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TAB_DATA = String.valueOf(clazz.getName()) + ".partId";
    }

    public DefaultPartPresentation(PaneFolder control, IStackPresentationSite stackSite) {
        super(stackSite);
        this.shellActive = control.getControl().getShell().equals(control.getControl().getDisplay().getActiveShell());
        this.tabFolder = control;
        this.tabFolder.getControl().addDisposeListener(this.folderDisposeListener);
        this.tabFolder.setMinimizeVisible(stackSite.supportsState(0));
        this.tabFolder.setMaximizeVisible(stackSite.supportsState(1));
        this.tabFolder.getControl().getShell().addShellListener(this.shellListener);
        this.titleLabel = new Label(this.tabFolder.getControl(), 0);
        this.titleLabel.setVisible(false);
        this.titleLabel.moveAbove(null);
        PlatformUI.getWorkbench().getThemeManager().addPropertyChangeListener(this.themeListener);
        this.viewToolBar = new ToolBar(control.getControl(), 0x800000);
        this.viewToolBar.moveAbove(null);
        ToolItem pullDownButton = new ToolItem(this.viewToolBar, 8);
        Image hoverImage = WorkbenchImages.getImage("IMG_LCL_VIEW_MENU_HOVER");
        pullDownButton.setDisabledImage(hoverImage);
        pullDownButton.setImage(hoverImage);
        pullDownButton.setToolTipText(WorkbenchMessages.getString("Menu"));
        pullDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DefaultPartPresentation.this.showPaneMenu();
            }
        });
        this.tabFolder.getControl().addListener(13, this.selectionListener);
        this.tabFolder.getControl().addMouseListener(this.mouseListener);
        this.tabFolder.getControl().addListener(35, this.menuListener);
        this.tabFolder.addButtonListener(this.buttonListener);
        this.dragListener = new Listener(){

            public void handleEvent(Event event) {
                Point localPos = new Point(event.x, event.y);
                if ((DefaultPartPresentation.this.tabFolder.getControl().getStyle() & 0x80) != 0 ? localPos.y > DefaultPartPresentation.this.tabFolder.getTabHeight() : localPos.y < ((DefaultPartPresentation)DefaultPartPresentation.this).tabFolder.getControl().getBounds().height - DefaultPartPresentation.this.tabFolder.getTabHeight()) {
                    return;
                }
                CTabItem tabUnderPointer = DefaultPartPresentation.this.tabFolder.getItem(localPos);
                if (tabUnderPointer == null) {
                    DefaultPartPresentation.this.getSite().dragStart(DefaultPartPresentation.this.tabFolder.getControl().toDisplay(localPos), false);
                    return;
                }
                IPresentablePart part = DefaultPartPresentation.this.getPartForTab(tabUnderPointer);
                if (DefaultPartPresentation.this.getSite().isPartMoveable(part)) {
                    DefaultPartPresentation.this.dragStart = DefaultPartPresentation.this.tabFolder.indexOf(tabUnderPointer);
                    DefaultPartPresentation.this.getSite().dragStart(part, DefaultPartPresentation.this.tabFolder.getControl().toDisplay(localPos), false);
                    DefaultPartPresentation.this.dragStart = -1;
                }
            }
        };
        PresentationUtil.addDragListener((Control)this.tabFolder.getControl(), this.dragListener);
        this.titleLabel.addMouseListener(this.mouseListener);
        this.systemMenuManager.add((IContributionItem)new GroupMarker("misc"));
        this.systemMenuManager.add((IContributionItem)new GroupMarker("restore"));
        this.systemMenuManager.add((IContributionItem)new UpdatingActionContributionItem(new SystemMenuRestore(this.getSite())));
        this.systemMenuManager.add((IContributionItem)new SystemMenuMove(this.getSite(), this.getPaneName()));
        this.systemMenuManager.add((IContributionItem)new GroupMarker("size"));
        this.systemMenuManager.add((IContributionItem)new GroupMarker("state"));
        this.systemMenuManager.add((IContributionItem)new UpdatingActionContributionItem(new SystemMenuMinimize(this.getSite())));
        this.systemMenuManager.add((IContributionItem)new UpdatingActionContributionItem(new SystemMenuMaximize(this.getSite())));
        this.systemMenuManager.add((IContributionItem)new Separator("close"));
        this.systemMenuManager.add((IContributionItem)new UpdatingActionContributionItem(new SystemMenuClose(this.getSite())));
        this.getSite().addSystemActions((IMenuManager)this.systemMenuManager);
    }

    public void restoreState(IPresentationSerializer serializer, IMemento savedState) {
        IMemento[] parts = savedState.getChildren("part");
        int idx = 0;
        while (idx < parts.length) {
            IPresentablePart part;
            String id = parts[idx].getString("id");
            if (id != null && (part = serializer.getPart(id)) != null) {
                this.addPart(part, this.tabFolder.getItemCount());
            }
            ++idx;
        }
    }

    public void saveState(IPresentationSerializer context, IMemento memento) {
        super.saveState(context, memento);
        List parts = this.getPresentableParts();
        Iterator iter = parts.iterator();
        while (iter.hasNext()) {
            IPresentablePart next = (IPresentablePart)iter.next();
            IMemento childMem = memento.createChild("part");
            childMem.putString("id", context.getId(next));
        }
    }

    public void init() {
        this.updateGradient();
        this.setTitleAttributes();
    }

    protected void setTitleAttributes() {
        Assert.isTrue((!this.isDisposed() ? 1 : 0) != 0);
        ITheme theme = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
        Font messageFont = theme.getFontRegistry().get("org.eclipse.ui.workbench.VIEW_MESSAGE_TEXT_FONT");
        if (!messageFont.equals((Object)this.titleLabel.getFont())) {
            this.titleLabel.setFont(messageFont);
            this.setControlSize();
        }
    }

    protected final void setInactiveTabColors() {
        Assert.isTrue((!this.isDisposed() ? 1 : 0) != 0);
        ITheme theme = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
        ColorRegistry colorRegistry = theme.getColorRegistry();
        this.drawGradient(colorRegistry.get("org.eclipse.ui.workbench.INACTIVE_TAB_TEXT_COLOR"), new Color[]{colorRegistry.get("org.eclipse.ui.workbench.INACTIVE_TAB_BG_START"), colorRegistry.get("org.eclipse.ui.workbench.INACTIVE_TAB_BG_END")}, new int[]{theme.getInt("org.eclipse.ui.workbench.INACTIVE_TAB_PERCENT")}, theme.getBoolean("org.eclipse.ui.workbench.INACTIVE_TAB_VERTICAL"));
    }

    protected final void setActiveTabColors() {
        Assert.isTrue((!this.isDisposed() ? 1 : 0) != 0);
        ITheme theme = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
        ColorRegistry colorRegistry = theme.getColorRegistry();
        if (this.isShellActive()) {
            this.drawGradient(colorRegistry.get("org.eclipse.ui.workbench.ACTIVE_TAB_TEXT_COLOR"), new Color[]{colorRegistry.get("org.eclipse.ui.workbench.ACTIVE_TAB_BG_START"), colorRegistry.get("org.eclipse.ui.workbench.ACTIVE_TAB_BG_END")}, new int[]{theme.getInt("org.eclipse.ui.workbench.ACTIVE_TAB_PERCENT")}, theme.getBoolean("org.eclipse.ui.workbench.ACTIVE_TAB_VERTICAL"));
        } else {
            this.drawGradient(colorRegistry.get("org.eclipse.ui.workbench.ACTIVE_NOFOCUS_TAB_TEXT_COLOR"), new Color[]{colorRegistry.get("org.eclipse.ui.workbench.ACTIVE_NOFOCUS_TAB_BG_START"), colorRegistry.get("org.eclipse.ui.workbench.ACTIVE_NOFOCUS_TAB_BG_END")}, new int[]{theme.getInt("org.eclipse.ui.workbench.ACTIVE_NOFOCUS_TAB_PERCENT")}, theme.getBoolean("org.eclipse.ui.workbench.ACTIVE_NOFOCUS_TAB_VERTICAL"));
        }
    }

    protected void updateGradient() {
        Assert.isTrue((!this.isDisposed() ? 1 : 0) != 0);
    }

    protected int computeTabHeight() {
        Assert.isTrue((!this.isDisposed() ? 1 : 0) != 0);
        GC gc = new GC((Drawable)this.tabFolder.getControl());
        int tabHeight = Math.max(this.viewToolBar.computeSize((int)-1, (int)-1).y, gc.getFontMetrics().getHeight());
        gc.dispose();
        return tabHeight;
    }

    protected String getPaneName() {
        return WorkbenchMessages.getString("DefaultPartPresentation.PaneName");
    }

    public void showPaneMenu() {
        Assert.isTrue((!this.isDisposed() ? 1 : 0) != 0);
        IPartMenu menu = this.getPartMenu();
        if (menu != null) {
            Rectangle bounds = DragUtil.getDisplayBounds((Control)this.viewToolBar);
            menu.showMenu(new Point(bounds.x, bounds.y + bounds.height));
        }
    }

    protected IPresentablePart getCurrent() {
        Assert.isTrue((!this.isDisposed() ? 1 : 0) != 0);
        return this.current;
    }

    protected final int indexOf(IPresentablePart part) {
        Assert.isTrue((!this.isDisposed() ? 1 : 0) != 0);
        if (part == null) {
            return this.tabFolder.getItemCount();
        }
        CTabItem[] items = this.tabFolder.getItems();
        int idx = 0;
        while (idx < items.length) {
            IPresentablePart tabPart = this.getPartForTab(items[idx]);
            if (part == tabPart) {
                return idx;
            }
            ++idx;
        }
        return items.length;
    }

    protected final CTabItem getTab(IPresentablePart part) {
        Assert.isTrue((!this.isDisposed() ? 1 : 0) != 0);
        CTabItem[] items = this.tabFolder.getItems();
        int idx = this.indexOf(part);
        if (idx < items.length) {
            return items[idx];
        }
        return null;
    }

    protected void childPropertyChanged(IPresentablePart part, int property) {
        CTabItem tab = this.getTab(part);
        if (tab == null) {
            return;
        }
        this.initTab(tab, part);
        switch (property) {
            case 146: {
                break;
            }
            case 148: {
                FontRegistry registry = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getFontRegistry();
                if (this.getCurrent() == part) break;
                tab.setFont(registry.getBold("org.eclipse.ui.workbench.TAB_TEXT_FONT"));
                break;
            }
            case 1: 
            case 147: 
            case 261: 
            case 770: {
                if (this.getCurrent() != part) break;
                this.setControlSize();
            }
        }
    }

    protected final IPresentablePart getPartForTab(CTabItem item) {
        Assert.isTrue((!this.isDisposed() ? 1 : 0) != 0);
        IPresentablePart part = (IPresentablePart)item.getData(TAB_DATA);
        return part;
    }

    protected PaneFolder getTabFolder() {
        Assert.isTrue((!this.isDisposed() ? 1 : 0) != 0);
        return this.tabFolder;
    }

    public boolean isDisposed() {
        return this.tabFolder == null || this.tabFolder.isDisposed();
    }

    public void drawGradient(Color fgColor, Color[] bgColors, int[] percentages, boolean vertical) {
        Assert.isTrue((!this.isDisposed() ? 1 : 0) != 0);
        this.tabFolder.setSelectionForeground(fgColor);
        this.tabFolder.setSelectionBackground(bgColors, percentages, vertical);
    }

    public boolean isActive() {
        Assert.isTrue((!this.isDisposed() ? 1 : 0) != 0);
        return this.activeState == 1;
    }

    public int getActive() {
        Assert.isTrue((!this.isDisposed() ? 1 : 0) != 0);
        return this.activeState;
    }

    protected String getCurrentTitle() {
        Assert.isTrue((!this.isDisposed() ? 1 : 0) != 0);
        if (this.current == null) {
            return "";
        }
        String result = this.current.getTitleStatus();
        return result;
    }

    protected void layout(boolean changed) {
        Assert.isTrue((!this.isDisposed() ? 1 : 0) != 0);
        if (changed) {
            String currentTitle = this.getCurrentTitle();
            if (!currentTitle.equals("")) {
                this.tabFolder.setTopLeft((Control)this.titleLabel);
                this.titleLabel.setText(currentTitle);
                this.titleLabel.setVisible(true);
            } else {
                this.tabFolder.setTopLeft(null);
                this.titleLabel.setVisible(false);
            }
            Control currentToolbar = this.getCurrentToolbar();
            this.tabFolder.setTopCenter(currentToolbar);
            IPartMenu partMenu = this.getPartMenu();
            if (partMenu != null) {
                this.tabFolder.setTopRight((Control)this.viewToolBar);
                this.viewToolBar.setVisible(true);
            } else {
                this.tabFolder.setTopRight(null);
                this.viewToolBar.setVisible(false);
            }
        }
        this.tabFolder.layout(changed);
        if (this.current != null) {
            Rectangle clientArea = this.tabFolder.getClientArea();
            Rectangle bounds = this.tabFolder.getControl().getBounds();
            clientArea.x += bounds.x;
            clientArea.y += bounds.y;
            this.current.setBounds(clientArea);
        }
    }

    protected void setControlSize() {
        Assert.isTrue((!this.isDisposed() ? 1 : 0) != 0);
        this.layout(true);
    }

    protected IPartMenu getPartMenu() {
        Assert.isTrue((!this.isDisposed() ? 1 : 0) != 0);
        IPresentablePart part = this.getCurrentPart();
        if (part == null) {
            return null;
        }
        return part.getMenu();
    }

    public final void dispose() {
        if (this.isDisposed()) {
            return;
        }
        this.tabFolder.getControl().dispose();
    }

    protected void widgetDisposed() {
        this.tabFolder.getControl().getShell().removeShellListener(this.shellListener);
        PresentationUtil.removeDragListener((Control)this.tabFolder.getControl(), this.dragListener);
        this.systemMenuManager.dispose();
        this.systemMenuManager.removeAll();
        this.tabFolder.getControl().removeDisposeListener(this.folderDisposeListener);
        this.tabFolder = null;
        this.titleLabel.dispose();
        this.titleLabel = null;
        this.viewToolBar.dispose();
        PlatformUI.getWorkbench().getThemeManager().removePropertyChangeListener(this.themeListener);
        this.activationList = null;
    }

    public void setActive(int newState) {
        Assert.isTrue((!this.isDisposed() ? 1 : 0) != 0);
        this.activeState = newState;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CTabItem createPartTab(IPresentablePart part, int tabIndex) {
        CTabItem tabItem;
        Assert.isTrue((!this.isDisposed() ? 1 : 0) != 0);
        tabIndex = Math.min(tabIndex, this.tabFolder.getItemCount());
        int style = 0;
        if (this.getSite().isCloseable(part)) {
            style |= 0x40;
        }
        this.ignoreSelectionChanges = true;
        try {
            tabItem = this.tabFolder.createItem(style, tabIndex);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.ignoreSelectionChanges = false;
            throw throwable;
        }
        {
            Object var5_7 = null;
            this.ignoreSelectionChanges = false;
        }
        tabItem.setData(TAB_DATA, (Object)part);
        part.addPropertyListener(this.childPropertyChangeListener);
        tabItem.addDisposeListener(this.tabDisposeListener);
        this.initTab(tabItem, part);
        return tabItem;
    }

    protected void initTab(CTabItem tabItem, IPresentablePart part) {
        Assert.isTrue((!this.isDisposed() ? 1 : 0) != 0);
        tabItem.setText(part.getName());
        tabItem.setImage(part.getTitleImage());
        String toolTipText = part.getTitleToolTip();
        if (!toolTipText.equals("")) {
            tabItem.setToolTipText(toolTipText);
        }
        FontRegistry registry = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getFontRegistry();
        if (part.isBusy()) {
            tabItem.setFont(registry.getItalic("org.eclipse.ui.workbench.TAB_TEXT_FONT"));
        } else {
            tabItem.setFont(null);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addPart(IPresentablePart newPart, Object cookie) {
        int idx;
        List lruList = null;
        if (cookie instanceof Integer) {
            int idx2 = (Integer)cookie;
            this.addPart(newPart, idx2);
            return;
        }
        if (cookie != null && cookie instanceof List) {
            List list = (List)cookie;
            lruList = (List)list.get(0);
            idx = (Integer)list.get(1);
        } else {
            idx = this.getItemInsertionIndex();
            lruList = this.getVisibleItemsLRUList();
        }
        this.addPart(newPart, idx);
        if (this.tabFolder.getItemCount() <= 1) return;
        CTabItem myItem = this.getTab(newPart);
        if (myItem == null) {
            return;
        }
        while (!myItem.isShowing()) {
            IPresentablePart lruPart = null;
            CTabItem lruItem = null;
            int i = 0;
            while (i < lruList.size()) {
                lruItem = (CTabItem)lruList.get(i);
                if (!myItem.equals(lruItem)) {
                    lruItem = (CTabItem)lruList.remove(i);
                    break;
                }
                ++i;
            }
            if (myItem.equals(lruItem)) return;
            if (lruItem == null) {
                return;
            }
            lruPart = this.getPartForTab(lruItem);
            try {
                this.activationListChange = false;
                this.removePart(lruPart);
                this.addPart(lruPart, --idx + 1);
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                this.activationListChange = true;
                throw throwable;
            }
            {
                Object var8_9 = null;
                this.activationListChange = true;
                continue;
            }
            break;
        }
        return;
    }

    private List getVisibleItemsLRUList() {
        ArrayList<CTabItem> lruList = new ArrayList<CTabItem>(10);
        int i = 0;
        while (i < this.tabFolder.getItemCount()) {
            CTabItem item = this.tabFolder.getItem(i);
            if (item.isShowing()) {
                int lruListSize = lruList.size();
                if (lruListSize == 0) {
                    lruList.add(item);
                } else {
                    int j = 0;
                    j = 0;
                    while (j < lruListSize) {
                        if (this.activationList.indexOf(this.getPartForTab(item)) < this.activationList.indexOf(this.getPartForTab((CTabItem)lruList.get(j)))) break;
                        ++j;
                    }
                    lruList.add(j, item);
                }
            }
            ++i;
        }
        return lruList;
    }

    private int getItemInsertionIndex() {
        int idx = this.tabFolder.getItemCount();
        if (!this.tabFolder.getControl().isVisible() || this.tabFolder.getControl().getBounds().width <= 1) {
            return idx;
        }
        int i = 0;
        while (i < idx) {
            CTabItem item = this.tabFolder.getItem(i);
            if (!item.isShowing() && item.getBounds().x >= 0) {
                return i;
            }
            ++i;
        }
        return idx;
    }

    public void addPart(IPresentablePart newPart, int index) {
        if (this.getTab(newPart) != null) {
            return;
        }
        this.createPartTab(newPart, index);
        this.setControlSize();
        if (this.activationListChange) {
            this.activationList.add(newPart);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removePart(IPresentablePart oldPart) {
        CTabItem item;
        if (this.current == oldPart) {
            this.current = null;
            this.tabFolder.setTopLeft(null);
            this.tabFolder.setTopCenter(null);
            this.tabFolder.setTopRight(null);
        }
        if ((item = this.getTab(oldPart)) == null) {
            return;
        }
        oldPart.setVisible(false);
        if (this.activationListChange) {
            this.activationList.remove(oldPart);
        }
        this.ignoreSelectionChanges = true;
        try {
            item.dispose();
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.ignoreSelectionChanges = false;
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.ignoreSelectionChanges = false;
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void selectPart(IPresentablePart toSelect) {
        Assert.isTrue((!this.isDisposed() ? 1 : 0) != 0);
        if (toSelect == this.current) {
            return;
        }
        IPresentablePart oldPart = this.current;
        this.current = toSelect;
        if (this.current != null) {
            CTabItem item = this.getTab(toSelect);
            if (item != null && this.isVisibleTabs() && !item.isShowing() && this.tabFolder.getItemCount() > 1) {
                try {
                    this.activationListChange = false;
                    List lruList = this.getVisibleItemsLRUList();
                    int idx = this.getItemInsertionIndex();
                    if (item.getBounds().x < 0) {
                        --idx;
                    }
                    this.removePart(toSelect);
                    ArrayList<Object> cookie = new ArrayList<Object>(2);
                    cookie.add(lruList);
                    cookie.add(new Integer(idx));
                    this.addPart(toSelect, cookie);
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    this.activationListChange = true;
                    throw throwable;
                }
                {
                    Object var7_9 = null;
                    this.activationListChange = true;
                }
            }
            this.current = toSelect;
            this.tabFolder.setSelection(this.indexOf(this.current));
            this.current.setVisible(true);
            if (this.isDisposed()) {
                return;
            }
            if (this.getTab(toSelect) == null) {
                this.selectPart(oldPart);
                return;
            }
            this.setControlSize();
            if (this.activationListChange) {
                this.activationList.remove(toSelect);
                this.activationList.add(toSelect);
            }
        }
        if (oldPart != null) {
            oldPart.setVisible(false);
        }
    }

    private boolean isVisibleTabs() {
        boolean result = false;
        int i = 0;
        while (i < this.tabFolder.getItemCount()) {
            CTabItem item = this.tabFolder.getItem(i);
            if (item.isShowing()) {
                result = true;
                break;
            }
            ++i;
        }
        return result;
    }

    public IPresentablePart getCurrentPart() {
        Assert.isTrue((!this.isDisposed() ? 1 : 0) != 0);
        return this.current;
    }

    public void setBounds(Rectangle bounds) {
        Assert.isTrue((!this.isDisposed() ? 1 : 0) != 0);
        this.tabFolder.aboutToResize();
        this.tabFolder.getControl().setBounds(bounds);
        this.layout(false);
    }

    public Point computeMinimumSize() {
        return this.tabFolder.computeMinimumSize();
    }

    public void setVisible(boolean isVisible) {
        Assert.isTrue((!this.isDisposed() ? 1 : 0) != 0);
        if (this.current != null) {
            this.current.setVisible(isVisible);
        }
        this.tabFolder.getControl().setVisible(isVisible);
    }

    public void setState(int state) {
        Assert.isTrue((!this.isDisposed() ? 1 : 0) != 0);
        this.tabFolder.setState(state);
    }

    public IMenuManager getSystemMenuManager() {
        Assert.isTrue((!this.isDisposed() ? 1 : 0) != 0);
        return this.systemMenuManager;
    }

    protected void showSystemMenu(Point point) {
        Assert.isTrue((!this.isDisposed() ? 1 : 0) != 0);
        Menu aMenu = this.systemMenuManager.createContextMenu((Control)this.tabFolder.getControl().getParent());
        this.systemMenuManager.update(true);
        aMenu.setLocation(point.x, point.y);
        aMenu.setVisible(true);
    }

    public Control getControl() {
        Assert.isTrue((!this.isDisposed() ? 1 : 0) != 0);
        return this.tabFolder.getControl();
    }

    public StackDropResult dragOver(Control currentControl, Point location) {
        Assert.isTrue((!this.isDisposed() ? 1 : 0) != 0);
        Point localPos = this.tabFolder.getControl().toControl(location);
        CTabItem tabUnderPointer = this.tabFolder.getItem(localPos);
        if (tabUnderPointer == null) {
            Rectangle titleArea = this.tabFolder.getTitleArea();
            if (titleArea.contains(localPos)) {
                int dragOverIndex = this.tabFolder.getItemCount();
                CTabItem lastTab = this.tabFolder.getItem(dragOverIndex - 1);
                if (!lastTab.isShowing()) {
                    return null;
                }
                if (this.dragStart >= 0) {
                    return new StackDropResult(Geometry.toDisplay((Control)this.tabFolder.getControl(), (Rectangle)lastTab.getBounds()), new Integer(--dragOverIndex));
                }
                Rectangle dropRectangle = Geometry.toDisplay((Control)this.tabFolder.getControl(), (Rectangle)titleArea);
                dropRectangle.width = 3 * dropRectangle.height;
                return new StackDropResult(dropRectangle, new Integer(dragOverIndex));
            }
            return null;
        }
        if (!tabUnderPointer.isShowing()) {
            return null;
        }
        return new StackDropResult(Geometry.toDisplay((Control)this.tabFolder.getControl(), (Rectangle)tabUnderPointer.getBounds()), new Integer(this.tabFolder.indexOf(tabUnderPointer)));
    }

    protected Control getCurrentToolbar() {
        Assert.isTrue((!this.isDisposed() ? 1 : 0) != 0);
        IPresentablePart part = this.getCurrentPart();
        if (part == null) {
            return null;
        }
        return part.getToolBar();
    }

    public void showSystemMenu() {
        Assert.isTrue((!this.isDisposed() ? 1 : 0) != 0);
        IPresentablePart part = this.getCurrentPart();
        if (part != null) {
            Rectangle bounds = DragUtil.getDisplayBounds((Control)this.tabFolder.getControl());
            int idx = this.tabFolder.getSelectionIndex();
            if (idx > -1) {
                CTabItem item = this.tabFolder.getItem(idx);
                Rectangle itemBounds = item.getBounds();
                bounds.x += itemBounds.x;
                bounds.y += itemBounds.y;
            }
            Point location = new Point(bounds.x, bounds.y + this.tabFolder.getTabHeight());
            this.showSystemMenu(location);
        }
    }

    public Control[] getTabList(IPresentablePart part) {
        Assert.isTrue((!this.isDisposed() ? 1 : 0) != 0);
        ArrayList<Object> list = new ArrayList<Object>();
        if (this.tabFolder.getTabPosition() == 1024) {
            if (part.getToolBar() != null) {
                list.add(part.getToolBar());
            }
            if (part.getControl() != null) {
                list.add(part.getControl());
            }
            if (this.getTabFolder() != null) {
                list.add(this.getTabFolder().getControl());
            }
        } else {
            if (this.getTabFolder() != null) {
                list.add(this.getTabFolder().getControl());
            }
            if (part.getToolBar() != null) {
                list.add(part.getToolBar());
            }
            if (part.getControl() != null) {
                list.add(part.getControl());
            }
        }
        return list.toArray(new Control[list.size()]);
    }

    protected void showList(Shell parentShell, int x, int y) {
        Assert.isTrue((!this.isDisposed() ? 1 : 0) != 0);
        PaneFolder tabFolder = this.getTabFolder();
        int shellStyle = 16408;
        int tableStyle = 768;
        final BasicStackList editorList = new BasicStackList(tabFolder.getControl().getShell(), shellStyle, tableStyle);
        editorList.setInput(this);
        Point size = editorList.computeSizeHint();
        Monitor mon = this.getTabFolder().getControl().getMonitor();
        Rectangle bounds = mon.getClientArea();
        if (x + size.x > bounds.x + bounds.width) {
            x = bounds.x + bounds.width - size.x;
        }
        if (y + size.y > bounds.y + bounds.height) {
            y = bounds.y + bounds.height - size.y;
        }
        editorList.setLocation(new Point(x, y));
        editorList.setVisible(true);
        editorList.setFocus();
        editorList.getTableViewer().getTable().getShell().addListener(27, new Listener(){

            public void handleEvent(Event event) {
                editorList.setVisible(false);
            }
        });
    }

    public void showPartList() {
        Assert.isTrue((!this.isDisposed() ? 1 : 0) != 0);
        PaneFolder tabFolder = this.getTabFolder();
        Shell shell = tabFolder.getControl().getShell();
        int numItems = tabFolder.getItemCount();
        CTabItem item = null;
        CTabItem tempItem = null;
        int i = 0;
        while (i < numItems) {
            tempItem = tabFolder.getItem(i);
            if (tempItem.isShowing()) {
                item = tempItem;
            }
            ++i;
        }
        if (item == null) {
            return;
        }
        Rectangle itemBounds = item.getBounds();
        int x = itemBounds.x + itemBounds.width;
        int y = itemBounds.y + itemBounds.height;
        Point location = item.getDisplay().map((Control)tabFolder.getControl(), null, x, y);
        this.showList(shell, location.x, location.y);
    }

    void setSelection(CTabItem tabItem) {
        this.getSite().selectPart(this.getPartForTab(tabItem));
    }

    void close(IPresentablePart[] presentablePart) {
        this.getSite().close(presentablePart);
    }

    List getPresentableParts() {
        Assert.isTrue((!this.isDisposed() ? 1 : 0) != 0);
        CTabItem[] items = this.tabFolder.getItems();
        ArrayList<IPresentablePart> result = new ArrayList<IPresentablePart>(items.length);
        int idx = 0;
        while (idx < this.tabFolder.getItemCount()) {
            result.add(this.getPartForTab(items[idx]));
            ++idx;
        }
        return result;
    }

    Image getLabelImage(IPresentablePart presentablePart) {
        return presentablePart.getTitleImage();
    }

    String getLabelText(IPresentablePart presentablePart, boolean includePath) {
        String title = presentablePart.getName();
        return title;
    }

    protected boolean isShellActive() {
        Assert.isTrue((!this.isDisposed() ? 1 : 0) != 0);
        return this.shellActive;
    }
}

