/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.CBanner;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.internal.PerspectiveBarContributionItem;
import org.eclipse.ui.internal.PerspectiveBarManager;
import org.eclipse.ui.internal.PerspectiveBarNewContributionItem;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.layout.CacheWrapper;
import org.eclipse.ui.internal.layout.CellLayout;
import org.eclipse.ui.internal.layout.LayoutUtil;
import org.eclipse.ui.internal.layout.Row;
import org.eclipse.ui.internal.util.PrefUtil;

public class PerspectiveSwitcher {
    private WorkbenchWindow window;
    private CBanner topBar;
    private int style;
    private Composite parent;
    private Composite trimControl;
    private Label trimSeparator;
    private GridData trimLayoutData;
    private boolean trimVisible = false;
    private int trimOldLength = 0;
    private PerspectiveBarManager perspectiveBar;
    private CoolBar perspectiveCoolBar;
    private CacheWrapper perspectiveCoolBarWrapper;
    private CoolItem coolItem;
    private CacheWrapper toolbarWrapper;
    private Menu popupMenu;
    private Menu genericMenu;
    private static final int INITIAL = -1;
    private static final int TOP_RIGHT = 1;
    private static final int TOP_LEFT = 2;
    private static final int LEFT = 3;
    private static final int DEFAULT_RIGHT_X = 160;
    private int currentLocation = -1;
    private static final int SEPARATOR_LENGTH = 20;
    private IPreferenceStore apiPreferenceStore = PrefUtil.getAPIPreferenceStore();
    private IPropertyChangeListener propertyChangeListener;
    private Listener popupListener = new Listener(){

        public void handleEvent(Event event) {
            if (event.type == 35) {
                PerspectiveSwitcher.this.showPerspectiveBarPopup(new Point(event.x, event.y));
            }
        }
    };
    private DisposeListener toolBarListener;

    public PerspectiveSwitcher(WorkbenchWindow window, CBanner topBar, int style) {
        this.window = window;
        this.topBar = topBar;
        this.style = style;
        this.setPropertyChangeListener();
        this.toolBarListener = new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                PerspectiveSwitcher.this.dispose();
            }
        };
    }

    private static int convertLocation(String preference) {
        if ("topRight".equals(preference)) {
            return 1;
        }
        if ("topLeft".equals(preference)) {
            return 2;
        }
        if ("left".equals(preference)) {
            return 3;
        }
        return 1;
    }

    public void createControl(Composite parent) {
        Assert.isTrue((this.parent == null ? 1 : 0) != 0);
        this.parent = parent;
        this.setPerspectiveBarLocation(PrefUtil.getAPIPreferenceStore().getString("DOCK_PERSPECTIVE_BAR"));
    }

    public void addPerspectiveShortcut(IPerspectiveDescriptor perspective, WorkbenchPage workbenchPage) {
        if (this.perspectiveBar == null) {
            return;
        }
        PerspectiveBarContributionItem item = new PerspectiveBarContributionItem(perspective, workbenchPage);
        this.perspectiveBar.addItem(item);
        this.setCoolItemSize(this.coolItem);
        if (this.perspectiveBar != null) {
            this.perspectiveBar.update(true);
        }
    }

    public IContributionItem findPerspectiveShortcut(IPerspectiveDescriptor perspective, WorkbenchPage page) {
        if (this.perspectiveBar == null) {
            return null;
        }
        IContributionItem[] items = this.perspectiveBar.getItems();
        int length = items.length;
        int i = 0;
        while (i < length) {
            IContributionItem item = items[i];
            if (item instanceof PerspectiveBarContributionItem && ((PerspectiveBarContributionItem)item).handles(perspective, page)) {
                return item;
            }
            ++i;
        }
        return null;
    }

    public void removePerspectiveShortcut(IPerspectiveDescriptor perspective, WorkbenchPage page) {
        if (this.perspectiveBar == null) {
            return;
        }
        IContributionItem item = this.findPerspectiveShortcut(perspective, page);
        if (item != null) {
            if (item instanceof PerspectiveBarContributionItem) {
                this.perspectiveBar.removeItem((PerspectiveBarContributionItem)item);
            }
            item.dispose();
            this.perspectiveBar.update(false);
            this.setCoolItemSize(this.coolItem);
        }
    }

    public void setPerspectiveBarLocation(String preference) {
        if (this.parent == null) {
            return;
        }
        int newLocation = PerspectiveSwitcher.convertLocation(preference);
        if (newLocation == this.currentLocation) {
            return;
        }
        this.createControlForLocation(newLocation);
        this.currentLocation = newLocation;
        this.showPerspectiveBar();
        if (newLocation == 2 || newLocation == 1) {
            this.updatePerspectiveBar();
            this.setCoolItemSize(this.coolItem);
        }
    }

    private void showPerspectiveBar() {
        switch (this.currentLocation) {
            case 2: {
                this.topBar.setRight(null);
                this.topBar.setBottom((Control)this.perspectiveCoolBarWrapper.getControl());
                break;
            }
            case 1: {
                this.topBar.setBottom(null);
                this.topBar.setRight((Control)this.perspectiveCoolBarWrapper.getControl());
                this.topBar.setRightWidth(160);
                break;
            }
            case 3: {
                this.topBar.setBottom(null);
                this.topBar.setRight(null);
                LayoutUtil.resize((Control)this.topBar);
                this.window.addPerspectiveBarToTrim((Control)this.trimControl, 16384);
                break;
            }
            default: {
                return;
            }
        }
        LayoutUtil.resize((Control)this.perspectiveBar.getControl());
    }

    public void update(boolean force) {
        if (this.perspectiveBar == null) {
            return;
        }
        this.perspectiveBar.update(force);
        if (this.currentLocation == 3) {
            boolean shouldExpand;
            ToolItem[] items = this.perspectiveBar.getControl().getItems();
            boolean bl = shouldExpand = items.length > 0;
            if (shouldExpand != this.trimVisible) {
                this.perspectiveBar.getControl().setVisible(true);
                this.trimVisible = shouldExpand;
            }
            if (items.length != this.trimOldLength) {
                LayoutUtil.resize((Control)this.trimControl);
                this.trimOldLength = items.length;
            }
        }
    }

    public void selectPerspectiveShortcut(IPerspectiveDescriptor perspective, WorkbenchPage page, boolean selected) {
        IContributionItem item = this.findPerspectiveShortcut(perspective, page);
        if (item != null && item instanceof PerspectiveBarContributionItem) {
            if (selected) {
                PerspectiveBarContributionItem contribItem = (PerspectiveBarContributionItem)item;
                this.perspectiveBar.select(contribItem);
            }
            ((PerspectiveBarContributionItem)item).setSelection(selected);
        }
    }

    public void updatePerspectiveShortcut(IPerspectiveDescriptor oldDesc, IPerspectiveDescriptor newDesc, WorkbenchPage page) {
        IContributionItem item = this.findPerspectiveShortcut(oldDesc, page);
        if (item != null && item instanceof PerspectiveBarContributionItem) {
            ((PerspectiveBarContributionItem)item).update(newDesc);
        }
    }

    public PerspectiveBarManager getPerspectiveBar() {
        return this.perspectiveBar;
    }

    public void dispose() {
        if (this.propertyChangeListener != null) {
            this.apiPreferenceStore.removePropertyChangeListener(this.propertyChangeListener);
            this.propertyChangeListener = null;
        }
        this.toolBarListener = null;
    }

    private void disposeChildControls() {
        if (this.trimControl != null) {
            this.trimControl.dispose();
            this.trimControl = null;
        }
        if (this.trimSeparator != null) {
            this.trimSeparator.dispose();
            this.trimSeparator = null;
        }
        if (this.perspectiveCoolBar != null) {
            this.perspectiveCoolBar.dispose();
            this.perspectiveCoolBar = null;
        }
        if (this.toolbarWrapper != null) {
            this.toolbarWrapper.dispose();
            this.toolbarWrapper = null;
        }
        if (this.perspectiveBar != null) {
            this.perspectiveBar.dispose();
            this.perspectiveBar = null;
        }
        this.perspectiveCoolBarWrapper = null;
    }

    private void createControlForLocation(int newLocation) {
        if (this.perspectiveBar != null && this.perspectiveBar.getControl() != null && !this.perspectiveBar.getControl().isDisposed()) {
            if (newLocation == 3 && this.currentLocation == 3) {
                return;
            }
            if (!(newLocation != 2 && newLocation != 1 || this.currentLocation != 2 && this.currentLocation != 1)) {
                return;
            }
        }
        if (this.perspectiveBar != null) {
            this.perspectiveBar.getControl().removeDisposeListener(this.toolBarListener);
        }
        this.disposeChildControls();
        if (newLocation == 3) {
            this.createControlForLeft();
        } else {
            this.createControlForTop();
        }
        this.perspectiveBar.getControl().addDisposeListener(this.toolBarListener);
    }

    private void setPropertyChangeListener() {
        this.propertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("SHOW_TEXT_ON_PERSPECTIVE_BAR".equals(propertyChangeEvent.getProperty())) {
                    if (PerspectiveSwitcher.this.perspectiveBar == null) {
                        return;
                    }
                    IContributionItem[] items = PerspectiveSwitcher.this.perspectiveBar.getItems();
                    int i = 0;
                    while (i < items.length) {
                        items[i].update();
                        ++i;
                    }
                    PerspectiveSwitcher.this.perspectiveBar.update(true);
                    PerspectiveSwitcher.this.setCoolItemSize(PerspectiveSwitcher.this.coolItem);
                }
            }
        };
        this.apiPreferenceStore.addPropertyChangeListener(this.propertyChangeListener);
    }

    private void createControlForLeft() {
        this.trimControl = new Composite(this.parent, 0);
        this.trimControl.setLayout((Layout)new CellLayout(1).setMargins(0, 0).setSpacing(3, 3).setDefaultRow(Row.fixed()).setDefaultColumn(Row.growing()));
        this.perspectiveBar = this.createBarManager(512);
        this.perspectiveBar.createControl(this.trimControl);
        this.perspectiveBar.getControl().addListener(35, this.popupListener);
        this.trimSeparator = new Label(this.trimControl, 258);
        GridData sepData = new GridData(66);
        sepData.widthHint = 20;
        this.trimSeparator.setLayoutData((Object)sepData);
        this.trimLayoutData = new GridData(1808);
        this.trimVisible = false;
        this.perspectiveBar.getControl().setLayoutData((Object)this.trimLayoutData);
    }

    private void createControlForTop() {
        this.perspectiveBar = this.createBarManager(256);
        this.perspectiveCoolBarWrapper = new CacheWrapper((Composite)this.topBar);
        this.perspectiveCoolBar = new CoolBar(this.perspectiveCoolBarWrapper.getControl(), 0x800000);
        this.coolItem = new CoolItem(this.perspectiveCoolBar, 4);
        this.toolbarWrapper = new CacheWrapper((Composite)this.perspectiveCoolBar);
        this.perspectiveBar.createControl(this.toolbarWrapper.getControl());
        this.coolItem.setControl((Control)this.toolbarWrapper.getControl());
        this.perspectiveCoolBar.setLocked(true);
        this.perspectiveBar.setParent(this.perspectiveCoolBar);
        this.perspectiveBar.update(true);
        this.perspectiveCoolBar.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                PerspectiveSwitcher.this.setCoolItemSize(PerspectiveSwitcher.this.coolItem);
            }
        });
        this.coolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.detail == 4 && PerspectiveSwitcher.this.perspectiveBar != null) {
                    PerspectiveSwitcher.this.perspectiveBar.handleChevron(e);
                }
            }
        });
        this.coolItem.setMinimumSize(0, 0);
        this.perspectiveBar.getControl().addListener(35, this.popupListener);
    }

    private void setCoolItemSize(CoolItem coolItem) {
        int rows;
        if (this.currentLocation == 3) {
            return;
        }
        ToolBar toolbar = this.perspectiveBar.getControl();
        if (toolbar == null) {
            return;
        }
        Rectangle area = this.perspectiveCoolBar.getClientArea();
        int rowHeight = toolbar.getItem((int)0).getBounds().height;
        int i = 1;
        while (i < this.perspectiveBar.getControl().getItemCount()) {
            rowHeight = Math.max(rowHeight, this.perspectiveBar.getControl().getItem((int)i).getBounds().height);
            ++i;
        }
        area.height = this.topBar.getLeft().getBounds().height;
        int n = rows = rowHeight <= 0 ? 1 : (int)Math.max(1.0, Math.floor(area.height / rowHeight));
        if (rows == 1 || (toolbar.getStyle() & 0x40) == 0 || this.currentLocation == 2) {
            Point p = toolbar.computeSize(-1, -1);
            coolItem.setSize(coolItem.computeSize(p.x, p.y));
            return;
        }
        Point offset = coolItem.computeSize(0, 0);
        Point wrappedSize = toolbar.computeSize(area.width - offset.x, -1);
        int h = rows * rowHeight;
        int w = wrappedSize.y <= h ? wrappedSize.x : wrappedSize.x + 1;
        coolItem.setSize(coolItem.computeSize(w, h));
    }

    private void showPerspectiveBarPopup(Point pt) {
        if (this.perspectiveBar == null) {
            return;
        }
        ToolBar toolBar = this.perspectiveBar.getControl();
        ToolItem toolItem = toolBar.getItem(toolBar.toControl(pt));
        Object data = null;
        if (toolItem != null) {
            data = toolItem.getData();
        }
        if (toolItem == null || !(data instanceof PerspectiveBarContributionItem)) {
            if (this.genericMenu == null) {
                Menu menu = new Menu((Control)toolBar);
                this.addDockOnSubMenu(menu);
                this.addShowTextItem(menu);
                this.genericMenu = menu;
            }
            this.genericMenu.getItem(1).setSelection(PrefUtil.getAPIPreferenceStore().getBoolean("SHOW_TEXT_ON_PERSPECTIVE_BAR"));
            this.updateLocationItems(this.genericMenu.getItem(0).getMenu(), this.currentLocation);
            this.genericMenu.setLocation(pt.x, pt.y);
            this.genericMenu.setVisible(true);
            return;
        }
        if (data == null || !(data instanceof PerspectiveBarContributionItem)) {
            return;
        }
        if (this.popupMenu == null) {
            Menu menu = new Menu((Control)toolBar);
            MenuItem menuItem = new MenuItem(menu, 0);
            menuItem.setText(WorkbenchMessages.getString("WorkbenchWindow.close"));
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ToolItem perspectiveToolItem = (ToolItem)PerspectiveSwitcher.this.popupMenu.getData();
                    if (perspectiveToolItem != null && !perspectiveToolItem.isDisposed()) {
                        PerspectiveBarContributionItem item = (PerspectiveBarContributionItem)((Object)perspectiveToolItem.getData());
                        item.getPage().closePerspective(item.getPerspective(), true);
                    }
                }
            });
            menuItem = new MenuItem(menu, 0);
            menuItem.setText(WorkbenchMessages.getString("WorkbenchWindow.closeAll"));
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ToolItem perspectiveToolItem = (ToolItem)PerspectiveSwitcher.this.popupMenu.getData();
                    if (perspectiveToolItem != null && !perspectiveToolItem.isDisposed()) {
                        PerspectiveBarContributionItem item = (PerspectiveBarContributionItem)((Object)perspectiveToolItem.getData());
                        item.getPage().closeAllPerspectives();
                    }
                }
            });
            new MenuItem(menu, 2);
            this.addDockOnSubMenu(menu);
            this.addShowTextItem(menu);
            this.popupMenu = menu;
        }
        this.popupMenu.setData((Object)toolItem);
        this.popupMenu.getItem(4).setSelection(PrefUtil.getAPIPreferenceStore().getBoolean("SHOW_TEXT_ON_PERSPECTIVE_BAR"));
        this.updateLocationItems(this.popupMenu.getItem(3).getMenu(), this.currentLocation);
        this.popupMenu.setLocation(pt.x, pt.y);
        this.popupMenu.setVisible(true);
    }

    private PerspectiveBarManager createBarManager(int direction) {
        PerspectiveBarManager barManager = new PerspectiveBarManager(this.style | direction);
        barManager.add((IContributionItem)new PerspectiveBarNewContributionItem(this.window));
        WorkbenchPage page = (WorkbenchPage)this.window.getActivePage();
        if (page != null) {
            IPerspectiveDescriptor[] perspectives = page.getOpenedPerspectives();
            int i = 0;
            while (i < perspectives.length) {
                barManager.add((IContributionItem)new PerspectiveBarContributionItem(perspectives[i], page));
                ++i;
            }
        }
        return barManager;
    }

    private void updateLocationItems(Menu parent, int newLocation) {
        MenuItem topRight = parent.getItem(0);
        MenuItem topLeft = parent.getItem(1);
        MenuItem left = parent.getItem(2);
        if (newLocation == 3) {
            left.setSelection(true);
            topRight.setSelection(false);
            topLeft.setSelection(false);
        } else if (newLocation == 2) {
            topLeft.setSelection(true);
            left.setSelection(false);
            topRight.setSelection(false);
        } else {
            topRight.setSelection(true);
            left.setSelection(false);
            topLeft.setSelection(false);
        }
    }

    private void addDockOnSubMenu(Menu menu) {
        MenuItem item = new MenuItem(menu, 64);
        item.setText(WorkbenchMessages.getString("PerspectiveSwitcher.dockOn"));
        final Menu subMenu = new Menu(item);
        MenuItem menuItemTopRight = new MenuItem(subMenu, 16);
        menuItemTopRight.setText(WorkbenchMessages.getString("PerspectiveSwitcher.topRight"));
        final MenuItem menuItemTopLeft = new MenuItem(subMenu, 16);
        menuItemTopLeft.setText(WorkbenchMessages.getString("PerspectiveSwitcher.topLeft"));
        final MenuItem menuItemLeft = new MenuItem(subMenu, 16);
        menuItemLeft.setText(WorkbenchMessages.getString("PerspectiveSwitcher.left"));
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MenuItem item = (MenuItem)e.widget;
                String pref = null;
                if (item.equals(menuItemLeft)) {
                    PerspectiveSwitcher.this.updateLocationItems(subMenu, 3);
                    pref = "left";
                } else if (item.equals(menuItemTopLeft)) {
                    PerspectiveSwitcher.this.updateLocationItems(subMenu, 2);
                    pref = "topLeft";
                } else {
                    PerspectiveSwitcher.this.updateLocationItems(subMenu, 1);
                    pref = "topRight";
                }
                IPreferenceStore apiStore = PrefUtil.getAPIPreferenceStore();
                apiStore.setValue("DOCK_PERSPECTIVE_BAR", pref);
            }
        };
        menuItemTopRight.addSelectionListener((SelectionListener)listener);
        menuItemTopLeft.addSelectionListener((SelectionListener)listener);
        menuItemLeft.addSelectionListener((SelectionListener)listener);
        item.setMenu(subMenu);
    }

    private void addShowTextItem(Menu menu) {
        final MenuItem showtextMenuItem = new MenuItem(menu, 32);
        showtextMenuItem.setText(WorkbenchMessages.getString("PerspectiveBar.showText"));
        showtextMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PerspectiveSwitcher.this.perspectiveBar == null) {
                    return;
                }
                boolean preference = showtextMenuItem.getSelection();
                PrefUtil.getAPIPreferenceStore().setValue("SHOW_TEXT_ON_PERSPECTIVE_BAR", preference);
                PerspectiveSwitcher.this.setCoolItemSize(PerspectiveSwitcher.this.coolItem);
                PerspectiveSwitcher.this.updatePerspectiveBar();
            }
        });
    }

    public void saveState(IMemento persBarMem) {
        IMemento childMem = persBarMem.createChild("itemSize");
        int x = this.currentLocation == 1 && this.topBar != null ? this.topBar.getRightWidth() : 160;
        childMem.putString("x", Integer.toString(x));
    }

    public void restoreState(IMemento memento) {
        if (memento == null) {
            return;
        }
        IMemento attributes = memento.getChild("perspectiveBar");
        IMemento size = null;
        if (attributes != null) {
            size = attributes.getChild("itemSize");
        }
        if (size != null && this.currentLocation == 1 && this.topBar != null) {
            Integer x = size.getInteger("x");
            if (x != null) {
                this.topBar.setRightWidth(x.intValue());
            } else {
                this.topBar.setRightWidth(160);
            }
        }
    }

    void updatePerspectiveBar() {
        IContributionItem[] items = this.perspectiveBar.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].update();
            ++i;
        }
        this.perspectiveBar.arrangeToolbar();
        this.perspectiveBar.getControl().redraw();
    }
}

