/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl.util;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.intro.impl.IntroPlugin;
import org.eclipse.ui.internal.intro.impl.util.DialogUtil;
import org.eclipse.ui.internal.intro.impl.util.Log;

public class Util {
    public static void handleException(String errorId, Exception e) {
        Util.handleException(errorId, e, null);
    }

    public static void handleException(String errorId, Exception e, Object[] variables) {
        String msg = null;
        msg = variables != null ? IntroPlugin.getFormattedString(errorId, variables) : (errorId == null ? e.getMessage() : IntroPlugin.getString(errorId));
        Log.error(msg, e);
    }

    public static void handleExceptionWithPopUp(Shell parent, String errorId, Exception e) {
        if (e instanceof CoreException) {
            if (parent == null) {
                parent = DialogUtil.getActiveShell();
            }
            DialogUtil.displayCoreErrorDialog(parent, errorId, (CoreException)e);
            return;
        }
        if (errorId == null) {
            errorId = e.getMessage();
        }
        if (parent == null) {
            parent = DialogUtil.getActiveShell();
        }
        DialogUtil.displayErrorMessage(parent, errorId, e);
    }

    public static Listener addDebugListener(Control control) {
        Listener listener = new Listener(){

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 13: {
                        System.out.println("Selection EVENT: " + e.toString());
                        break;
                    }
                    case 12: {
                        System.out.println("Dispose EVENT: " + e.toString());
                        break;
                    }
                    case 9: {
                        System.out.println("Paint EVENT: " + e.toString());
                        break;
                    }
                    case 11: {
                        System.out.println("Resize EVENT: " + e.toString());
                        break;
                    }
                    case 8: {
                        System.out.println("MouseDoubleClick EVENT: " + e.toString());
                        break;
                    }
                    case 3: {
                        System.out.println("MouseDown EVENT: " + e.toString());
                        break;
                    }
                    case 4: {
                        System.out.println("MouseUp EVENT: " + e.toString());
                        break;
                    }
                    case 5: {
                        System.out.println("MouseMove EVENT: " + e.toString());
                        break;
                    }
                    case 6: {
                        System.out.println("MouseEnter EVENT: " + e.toString());
                        break;
                    }
                    case 7: {
                        System.out.println("MouseExit EVENT: " + e.toString());
                        break;
                    }
                    case 32: {
                        System.out.println("MouseHover EVENT: " + e.toString());
                        break;
                    }
                    case 15: {
                        System.out.println("FocusIn EVENT: " + e.toString());
                        break;
                    }
                    case 16: {
                        System.out.println("FocusOut EVENT: " + e.toString());
                        break;
                    }
                    case 1: {
                        System.out.println("KeyDown EVENT: " + e.toString());
                        break;
                    }
                    case 2: {
                        System.out.println("KeyUp EVENT: " + e.toString());
                        break;
                    }
                    case 31: {
                        System.out.println("Traverse EVENT: " + e.toString());
                        break;
                    }
                    case 22: {
                        System.out.println("Show EVENT: " + e.toString());
                        break;
                    }
                    case 23: {
                        System.out.println("Hide EVENT: " + e.toString());
                        break;
                    }
                    default: {
                        System.out.println(e.toString());
                    }
                }
            }
        };
        int[] allEvents = new int[]{13, 12, 9, 11, 8, 3, 4, 6, 7, 32, 15, 16, 1, 2, 31, 22, 23};
        int i = 0;
        while (i < allEvents.length) {
            control.addListener(allEvents[i], listener);
            ++i;
        }
        return listener;
    }

    public static void sleep(int delay) {
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException interruptedException) {}
    }

    public static void highlight(Control control, int color) {
        control.setBackground(control.getDisplay().getSystemColor(color));
    }

    public static void highlightFocusControl() {
        Control control = Display.getCurrent().getFocusControl();
        if (control != null) {
            control.setBackground(Display.getCurrent().getSystemColor(4));
        }
    }

    public static boolean openBrowser(String href) {
        if (href.startsWith("file:")) {
            href = href.substring(5);
            while (href.startsWith("/")) {
                href = href.substring(1);
            }
            href = "file:///" + href;
        }
        final String localHref = href;
        final Display display = Display.getCurrent();
        String platform = SWT.getPlatform();
        if ("win32".equals(platform)) {
            return Program.launch((String)localHref);
        }
        if ("carbon".equals(platform)) {
            try {
                Process process = Runtime.getRuntime().exec("/usr/bin/open " + localHref);
                if (process == null) {
                    return false;
                }
                return process.exitValue() == 0;
            }
            catch (IOException e) {
                Util.openBrowserError(display, e);
                return false;
            }
        }
        final boolean[] result = new boolean[1];
        Thread launcher = new Thread("Intro browser Launcher"){

            public void run() {
                try {
                    Process process = this.doOpenBrowser(localHref, true);
                    if (process == null) {
                        process = this.doOpenBrowser(localHref, false);
                    }
                    if (process == null) {
                        result[0] = false;
                    }
                    result[0] = process.exitValue() == 0;
                }
                catch (Exception e) {
                    Util.openBrowserError(display, e);
                    result[0] = false;
                }
            }

            private Process doOpenBrowser(String href, boolean remote) throws Exception {
                int exitCode;
                Process p = null;
                String webBrowser = "netscape";
                String cmd = this.createCommand(webBrowser, href, remote);
                try {
                    p = Runtime.getRuntime().exec(cmd);
                }
                catch (IOException iOException) {
                    p = null;
                }
                if (p != null && remote && (exitCode = p.waitFor()) == 0) {
                    return p;
                }
                webBrowser = "mozilla";
                cmd = this.createCommand(webBrowser, href, remote);
                try {
                    p = Runtime.getRuntime().exec(cmd);
                }
                catch (IOException iOException) {
                    p = null;
                }
                if (p != null && remote && (exitCode = p.waitFor()) == 0) {
                    return p;
                }
                return null;
            }

            private String createCommand(String browser, String href, boolean remote) {
                StringBuffer cmd = new StringBuffer(browser);
                if (remote) {
                    cmd.append(" -remote openURL(");
                    cmd.append(href);
                    cmd.append(")");
                } else {
                    cmd.append(" ");
                    cmd.append(href);
                }
                return cmd.toString();
            }
        };
        launcher.start();
        return result[0];
    }

    private static void openBrowserError(final Display display, final Exception e) {
        display.asyncExec(new Runnable(){

            public void run() {
                DialogUtil.displayErrorMessage(display.getActiveShell(), IntroPlugin.getString("OpenBroswer.failedToLaunch"), e);
            }
        });
    }
}

