/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.wizards;

import java.util.ArrayList;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.update.internal.operations.DuplicateConflictsValidator;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.UpdateUIImages;
import org.eclipse.update.internal.ui.parts.DefaultContentProvider;

public class DuplicateConflictsDialog
extends MessageDialog {
    private TreeViewer treeViewer;
    private ArrayList conflicts;

    public DuplicateConflictsDialog(Shell shell, ArrayList conflicts) {
        super(shell, UpdateUI.getString("DuplicateConflictsDialog.title"), null, UpdateUI.getString("DuplicateConflictsDialog.message"), 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
        this.conflicts = conflicts;
        UpdateUI.getDefault().getLabelProvider().connect((Object)this);
    }

    public boolean close() {
        UpdateUI.getDefault().getLabelProvider().disconnect((Object)this);
        return super.close();
    }

    protected Control createCustomArea(Composite parent) {
        Composite client = new Composite(parent, 0);
        client.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        client.setLayout((Layout)layout);
        Label label = new Label(client, 0);
        label.setText(UpdateUI.getString("DuplicateConflictsDialog.treeLabel"));
        this.treeViewer = new TreeViewer(client, 2052);
        GridData gd = new GridData(1808);
        gd.heightHint = 200;
        gd.widthHint = 300;
        this.treeViewer.getTree().setLayoutData((Object)gd);
        this.treeViewer.setContentProvider((IContentProvider)new ConflictContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ConflictLabelProvider());
        this.treeViewer.setAutoExpandLevel(10);
        this.treeViewer.setSorter(new ViewerSorter(){});
        this.treeViewer.setInput((Object)this.conflicts);
        return client;
    }

    class ConflictContentProvider
    extends DefaultContentProvider
    implements ITreeContentProvider,
    IStructuredContentProvider {
        ConflictContentProvider() {
        }

        public Object[] getElements(Object input) {
            return this.getChildren(input);
        }

        public Object getParent(Object child) {
            return null;
        }

        public boolean hasChildren(Object parent) {
            return parent instanceof ArrayList;
        }

        public Object[] getChildren(Object parent) {
            if (parent instanceof ArrayList) {
                return ((ArrayList)parent).toArray();
            }
            return new Object[0];
        }
    }

    class ConflictLabelProvider
    extends LabelProvider {
        ConflictLabelProvider() {
        }

        public String getText(Object obj) {
            if (obj instanceof ArrayList) {
                ArrayList list = (ArrayList)obj;
                int i = 0;
                while (i < list.size()) {
                    DuplicateConflictsValidator.IdEntry entry = (DuplicateConflictsValidator.IdEntry)list.get(i);
                    if (entry.isInstallCandidate()) {
                        return entry.getFeature().getLabel();
                    }
                    ++i;
                }
            }
            return super.getText(obj);
        }

        public Image getImage(Object obj) {
            int flags = 0;
            if (obj instanceof ArrayList) {
                flags = 2;
            }
            if (obj instanceof DuplicateConflictsValidator.IdEntry || obj instanceof ArrayList) {
                return UpdateUI.getDefault().getLabelProvider().get(UpdateUIImages.DESC_FEATURE_OBJ, flags);
            }
            return null;
        }
    }
}

