import QtQuick
import QtQuick.Studio.DesignEffects
import DesignEffectsDemo

Item {
    id: root
    width: 468
    height: 30
    property real blurFactor: 1
    property color acronym: themeEngine.acronym
    property color surfaceText: themeEngine.surfaceText
    property bool effectsOn: true
    property alias dark: themeEngine.dark

    ThemeEngine {
        id: themeEngine
        dark: false
    }

    Text {
        id: sTo
        x: 6
        y: 5
        color: root.acronym
        text: qsTr("S")
        font.pixelSize: 18
        verticalAlignment: Text.AlignTop
        font.styleName: "Regular"
        font.family: "Victor Mono"
        DesignEffect {
            id: designEffectSto1
            visible: root.effectsOn
            layerBlurRadius: 1.5 * root.blurFactor

            effects: [
                DesignDropShadow {
                    id: designDropShadowSto1
                    blur: 1 * root.blurFactor
                    offsetX: 0
                    offsetY: 0
                    color: root.acronym
                }
            ]
        }
    }

    Text {
        id: sTo1
        x: 17
        y: 5
        color: root.surfaceText
        text: qsTr("INGLE")
        font.pixelSize: 18
        verticalAlignment: Text.AlignTop
        font.styleName: "Light"
        font.family: "Victor Mono"
        DesignEffect {
            id: designEffectSto2
            visible: root.effectsOn
            layerBlurRadius: 1.5 * root.blurFactor

            effects: [
                DesignDropShadow {
                    id: designDropShadowSto2
                    blur: 1 * root.blurFactor
                    offsetX: 0
                    offsetY: 0
                    color: root.surfaceText
                }
            ]
        }
    }

    Text {
        id: sTo2
        x: 80
        y: 5
        color: root.acronym
        text: qsTr("T")
        font.pixelSize: 18
        verticalAlignment: Text.AlignTop
        font.styleName: "Regular"
        font.family: "Victor Mono"
        DesignEffect {
            id: designEffectSto3
            visible: root.effectsOn
            layerBlurRadius: 1.5 * root.blurFactor

            effects: [
                DesignDropShadow {
                    id: designDropShadowSto3
                    blur: 1 * root.blurFactor
                    offsetX: 0
                    offsetY: 0
                    color: root.acronym
                }
            ]
        }
    }

    Text {
        id: sTo3
        x: 91
        y: 5
        color: root.surfaceText
        text: qsTr("OGGLE")
        font.pixelSize: 18
        verticalAlignment: Text.AlignTop
        font.styleName: "Light"
        font.family: "Victor Mono"
        DesignEffect {
            id: designEffectSto4
            visible: root.effectsOn
            layerBlurRadius: 1.5 * root.blurFactor

            effects: [
                DesignDropShadow {
                    id: designDropShadowSto4
                    blur: 1 * root.blurFactor
                    offsetX: 0
                    offsetY: 0
                    color: root.surfaceText
                }
            ]
        }
    }

    Text {
        id: sTo4
        x: 156
        y: 5
        color: root.acronym
        text: qsTr("O")
        font.pixelSize: 18
        verticalAlignment: Text.AlignTop
        font.styleName: "Regular"
        font.family: "Victor Mono"
        DesignEffect {
            id: designEffectSto5
            visible: root.effectsOn
            layerBlurRadius: 1.5 * root.blurFactor

            effects: [
                DesignDropShadow {
                    id: designDropShadowSto5
                    blur: 1 * root.blurFactor
                    offsetX: 0
                    offsetY: 0
                    color: root.acronym
                }
            ]
        }
    }

    Text {
        id: sTo5
        x: 167
        y: 5
        color: root.surfaceText
        text: qsTr("PERATION")
        font.pixelSize: 18
        verticalAlignment: Text.AlignTop
        font.styleName: "Light"
        font.family: "Victor Mono"
        DesignEffect {
            id: designEffectSto6
            visible: root.effectsOn
            layerBlurRadius: 1.5 * root.blurFactor

            effects: [
                DesignDropShadow {
                    id: designDropShadowSto6
                    blur: 1 * root.blurFactor
                    offsetX: 0
                    offsetY: 0
                    color: root.surfaceText
                }
            ]
        }
    }

    Text {
        id: sTo6
        x: 264
        y: 5
        color: root.acronym
        text: qsTr("I")
        font.pixelSize: 18
        verticalAlignment: Text.AlignTop
        font.styleName: "Regular"
        font.family: "Victor Mono"
        DesignEffect {
            id: designEffectSto7
            visible: root.effectsOn
            layerBlurRadius: 1.5 * root.blurFactor

            effects: [
                DesignDropShadow {
                    id: designDropShadowSto7
                    blur: 1 * root.blurFactor
                    offsetX: 0
                    offsetY: 0
                    color: root.acronym
                }
            ]
        }
    }

    Text {
        id: sTo7
        x: 275
        y: 5
        color: root.surfaceText
        text: qsTr("NTEGER")
        font.pixelSize: 18
        verticalAlignment: Text.AlignTop
        font.styleName: "Light"
        font.family: "Victor Mono"
        DesignEffect {
            id: designEffectSto8
            visible: root.effectsOn
            layerBlurRadius: 1.5 * root.blurFactor

            effects: [
                DesignDropShadow {
                    id: designDropShadowSto8
                    blur: 1 * root.blurFactor
                    offsetX: 0
                    offsetY: 0
                    color: root.surfaceText
                }
            ]
        }
    }

    Text {
        id: sTo8
        x: 347
        y: 5
        color: root.acronym
        text: qsTr("C")
        font.pixelSize: 18
        verticalAlignment: Text.AlignTop
        font.styleName: "Regular"
        font.family: "Victor Mono"
        DesignEffect {
            id: designEffectSto9
            visible: root.effectsOn
            layerBlurRadius: 1.5 * root.blurFactor

            effects: [
                DesignDropShadow {
                    id: designDropShadowSto9
                    blur: 1 * root.blurFactor
                    offsetX: 0
                    offsetY: 0
                    color: root.acronym
                }
            ]
        }
    }

    Text {
        id: sTo9
        x: 358
        y: 5
        color: root.surfaceText
        text: qsTr("ALCULATOR")
        font.pixelSize: 18
        verticalAlignment: Text.AlignTop
        font.styleName: "Light"
        font.family: "Victor Mono"
        DesignEffect {
            id: designEffectSto10
            visible: root.effectsOn
            layerBlurRadius: 1.5 * root.blurFactor

            effects: [
                DesignDropShadow {
                    id: designDropShadowSto10
                    blur: 1 * root.blurFactor
                    offsetX: 0
                    offsetY: 0
                    color: root.surfaceText
                }
            ]
        }
    }
}
